// services/network/public/mojom/cookie_encryption_provider.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  Encryptor as osCryptAsync_mojom_Encryptor,
  EncryptorSpec as osCryptAsync_mojom_EncryptorSpec
} from '../../../../components/os_crypt/async/common/encryptor.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class CookieEncryptionProviderPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.CookieEncryptionProvider', scope);
  }
}

/** @interface */
export class CookieEncryptionProviderInterface {
  
  /**
   * @return {!Promise<{
        encryptor: !osCryptAsync_mojom_Encryptor,
   *  }>}
   */

  getEncryptor() {}
}

/**
 * @implements { CookieEncryptionProviderInterface }
 */
export class CookieEncryptionProviderRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!CookieEncryptionProviderPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          CookieEncryptionProviderPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!CookieEncryptionProviderPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        encryptor: !osCryptAsync_mojom_Encryptor,
   *  }>}
   */

  getEncryptor() {
    return this.proxy.sendMessage(
        0,
        CookieEncryptionProvider_GetEncryptor_ParamsSpec.$,
        CookieEncryptionProvider_GetEncryptor_ResponseParamsSpec.$,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the CookieEncryptionProvider
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class CookieEncryptionProviderReceiver {
  /**
   * @param {!CookieEncryptionProviderInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!CookieEncryptionProviderRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        CookieEncryptionProviderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!CookieEncryptionProviderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        CookieEncryptionProvider_GetEncryptor_ParamsSpec.$,
        CookieEncryptionProvider_GetEncryptor_ResponseParamsSpec.$,
        impl.getEncryptor.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class CookieEncryptionProvider {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.CookieEncryptionProvider";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!CookieEncryptionProviderRemote}
   */
  static getRemote() {
    let remote = new CookieEncryptionProviderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the CookieEncryptionProvider
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class CookieEncryptionProviderCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      CookieEncryptionProviderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!CookieEncryptionProviderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getEncryptor =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        CookieEncryptionProvider_GetEncryptor_ParamsSpec.$,
        CookieEncryptionProvider_GetEncryptor_ResponseParamsSpec.$,
        this.getEncryptor.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CookieEncryptionProvider_GetEncryptor_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CookieEncryptionProvider_GetEncryptor_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    CookieEncryptionProvider_GetEncryptor_ParamsSpec.$,
    'CookieEncryptionProvider_GetEncryptor_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class CookieEncryptionProvider_GetEncryptor_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    CookieEncryptionProvider_GetEncryptor_ResponseParamsSpec.$,
    'CookieEncryptionProvider_GetEncryptor_ResponseParams',
    [
      mojo.internal.StructField(
        'encryptor', 0,
        0,
        osCryptAsync_mojom_EncryptorSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CookieEncryptionProvider_GetEncryptor_ResponseParams {
  constructor() {
    /** @type { !osCryptAsync_mojom_Encryptor } */
    this.encryptor;
  }
}

