// services/network/public/mojom/cookie_access_observer.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  Origin as url_mojom_Origin,
  OriginSpec as url_mojom_OriginSpec
} from '../../../../url/mojom/origin.mojom.m.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../url/mojom/url.mojom.m.js';

import {
  CookieOrLineWithAccessResult as network_mojom_CookieOrLineWithAccessResult,
  CookieOrLineWithAccessResultSpec as network_mojom_CookieOrLineWithAccessResultSpec
} from './cookie_manager.mojom.m.js';

import {
  CookieSettingOverrides as network_mojom_CookieSettingOverrides,
  CookieSettingOverridesSpec as network_mojom_CookieSettingOverridesSpec
} from './cookie_setting_overrides.mojom.m.js';

import {
  SiteForCookies as network_mojom_SiteForCookies,
  SiteForCookiesSpec as network_mojom_SiteForCookiesSpec
} from './site_for_cookies.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class CookieAccessObserverPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.CookieAccessObserver', scope);
  }
}

/** @interface */
export class CookieAccessObserverInterface {
  
  /**
   * @param { !Array<!CookieAccessDetails> } details
   */

  onCookiesAccessed(details) {}
  
  /**
   * @param { !CookieAccessObserverPendingReceiver } listener
   */

  clone(listener) {}
}

/**
 * @implements { CookieAccessObserverInterface }
 */
export class CookieAccessObserverRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!CookieAccessObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          CookieAccessObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!CookieAccessObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Array<!CookieAccessDetails> } details
   */

  onCookiesAccessed(
      details) {
    this.proxy.sendMessage(
        0,
        CookieAccessObserver_OnCookiesAccessed_ParamsSpec.$,
        null,
        [
          details
        ],
        false);
  }

  
  /**
   * @param { !CookieAccessObserverPendingReceiver } listener
   */

  clone(
      listener) {
    this.proxy.sendMessage(
        1,
        CookieAccessObserver_Clone_ParamsSpec.$,
        null,
        [
          listener
        ],
        false);
  }
}

/**
 * An object which receives request messages for the CookieAccessObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class CookieAccessObserverReceiver {
  /**
   * @param {!CookieAccessObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!CookieAccessObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        CookieAccessObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!CookieAccessObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        CookieAccessObserver_OnCookiesAccessed_ParamsSpec.$,
        null,
        impl.onCookiesAccessed.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        CookieAccessObserver_Clone_ParamsSpec.$,
        null,
        impl.clone.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class CookieAccessObserver {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.CookieAccessObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!CookieAccessObserverRemote}
   */
  static getRemote() {
    let remote = new CookieAccessObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the CookieAccessObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class CookieAccessObserverCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      CookieAccessObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!CookieAccessObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onCookiesAccessed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        CookieAccessObserver_OnCookiesAccessed_ParamsSpec.$,
        null,
        this.onCookiesAccessed.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clone =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        CookieAccessObserver_Clone_ParamsSpec.$,
        null,
        this.clone.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CookieAccessDetailsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CookieAccessObserver_OnCookiesAccessed_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CookieAccessObserver_Clone_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };



/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const CookieAccessDetails_TypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const CookieAccessDetails_Type = {
  
  kRead: 0,
  kChange: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};


mojo.internal.Struct(
    CookieAccessDetailsSpec.$,
    'CookieAccessDetails',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        CookieAccessDetails_TypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'url', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'frameOrigin', 16,
        0,
        url_mojom_OriginSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'topFrameOrigin', 24,
        0,
        url_mojom_OriginSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'siteForCookies', 32,
        0,
        network_mojom_SiteForCookiesSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'cookieList', 40,
        0,
        mojo.internal.Array(network_mojom_CookieOrLineWithAccessResultSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'devtoolsRequestId', 48,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isAdTagged', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'cookieSettingOverrides', 56,
        0,
        network_mojom_CookieSettingOverridesSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 72],]);



/**
 * @record
 */
export class CookieAccessDetails {
  constructor() {
    /** @type { !CookieAccessDetails_Type } */
    this.type;
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { (url_mojom_Origin|undefined) } */
    this.frameOrigin;
    /** @type { !url_mojom_Origin } */
    this.topFrameOrigin;
    /** @type { !network_mojom_SiteForCookies } */
    this.siteForCookies;
    /** @type { !Array<!network_mojom_CookieOrLineWithAccessResult> } */
    this.cookieList;
    /** @type { (string|undefined) } */
    this.devtoolsRequestId;
    /** @type { !boolean } */
    this.isAdTagged;
    /** @type { !network_mojom_CookieSettingOverrides } */
    this.cookieSettingOverrides;
  }
}



mojo.internal.Struct(
    CookieAccessObserver_OnCookiesAccessed_ParamsSpec.$,
    'CookieAccessObserver_OnCookiesAccessed_Params',
    [
      mojo.internal.StructField(
        'details', 0,
        0,
        mojo.internal.Array(CookieAccessDetailsSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CookieAccessObserver_OnCookiesAccessed_Params {
  constructor() {
    /** @type { !Array<!CookieAccessDetails> } */
    this.details;
  }
}



mojo.internal.Struct(
    CookieAccessObserver_Clone_ParamsSpec.$,
    'CookieAccessObserver_Clone_Params',
    [
      mojo.internal.StructField(
        'listener', 0,
        0,
        mojo.internal.InterfaceRequest(CookieAccessObserverPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CookieAccessObserver_Clone_Params {
  constructor() {
    /** @type { !CookieAccessObserverPendingReceiver } */
    this.listener;
  }
}

