// services/network/public/mojom/cookie_access_observer.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_COOKIE_ACCESS_OBSERVER_MOJOM_SEND_VALIDATION_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_COOKIE_ACCESS_OBSERVER_MOJOM_SEND_VALIDATION_H_

#include "services/network/public/mojom/cookie_access_observer.mojom-shared-internal.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "services/network/public/mojom/site_for_cookies.mojom-shared.h"
#include "services/network/public/mojom/cookie_manager.mojom-shared.h"
#include "services/network/public/mojom/cookie_setting_overrides.mojom-shared.h"

#include "services/network/public/mojom/cookie_access_observer.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::CookieAccessDetailsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::CookieAccessDetailsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::CookieAccessDetails_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::network::mojom::CookieAccessDetails_Type>(
        Traits::type(input),
        &fragment->type);

      decltype(Traits::url(input)) in_url = Traits::url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->url)::BaseType> url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_url,
        url_fragment);

      fragment->url.Set(
          url_fragment.is_null() ? nullptr : url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in CookieAccessDetails struct");

      decltype(Traits::frame_origin(input)) in_frame_origin = Traits::frame_origin(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->frame_origin)::BaseType> frame_origin_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::OriginDataView, send_validation>(
        in_frame_origin,
        frame_origin_fragment);

      fragment->frame_origin.Set(
          frame_origin_fragment.is_null() ? nullptr : frame_origin_fragment.data());

      decltype(Traits::top_frame_origin(input)) in_top_frame_origin = Traits::top_frame_origin(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->top_frame_origin)::BaseType> top_frame_origin_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::OriginDataView, send_validation>(
        in_top_frame_origin,
        top_frame_origin_fragment);

      fragment->top_frame_origin.Set(
          top_frame_origin_fragment.is_null() ? nullptr : top_frame_origin_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->top_frame_origin.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null top_frame_origin in CookieAccessDetails struct");

      decltype(Traits::site_for_cookies(input)) in_site_for_cookies = Traits::site_for_cookies(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->site_for_cookies)::BaseType> site_for_cookies_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::SiteForCookiesDataView, send_validation>(
        in_site_for_cookies,
        site_for_cookies_fragment);

      fragment->site_for_cookies.Set(
          site_for_cookies_fragment.is_null() ? nullptr : site_for_cookies_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->site_for_cookies.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null site_for_cookies in CookieAccessDetails struct");

      decltype(Traits::cookie_list(input)) in_cookie_list = Traits::cookie_list(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->cookie_list)::BaseType>
          cookie_list_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& cookie_list_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::CookieOrLineWithAccessResultDataView>, send_validation>(
        in_cookie_list,
        cookie_list_fragment,
        &cookie_list_validate_params);

      fragment->cookie_list.Set(
          cookie_list_fragment.is_null() ? nullptr : cookie_list_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->cookie_list.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null cookie_list in CookieAccessDetails struct");

      decltype(Traits::devtools_request_id(input)) in_devtools_request_id = Traits::devtools_request_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->devtools_request_id)::BaseType> devtools_request_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_devtools_request_id,
        devtools_request_id_fragment);

      fragment->devtools_request_id.Set(
          devtools_request_id_fragment.is_null() ? nullptr : devtools_request_id_fragment.data());

      fragment->is_ad_tagged = Traits::is_ad_tagged(input);

      decltype(Traits::cookie_setting_overrides(input)) in_cookie_setting_overrides = Traits::cookie_setting_overrides(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->cookie_setting_overrides)::BaseType> cookie_setting_overrides_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::CookieSettingOverridesDataView, send_validation>(
        in_cookie_setting_overrides,
        cookie_setting_overrides_fragment);

      fragment->cookie_setting_overrides.Set(
          cookie_setting_overrides_fragment.is_null() ? nullptr : cookie_setting_overrides_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->cookie_setting_overrides.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null cookie_setting_overrides in CookieAccessDetails struct");
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_COOKIE_ACCESS_OBSERVER_MOJOM_SEND_VALIDATION_H_