// services/network/public/mojom/cookie_access_observer.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_COOKIE_ACCESS_OBSERVER_MOJOM_DATA_VIEW_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_COOKIE_ACCESS_OBSERVER_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "services/network/public/mojom/cookie_access_observer.mojom-shared-internal.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "services/network/public/mojom/site_for_cookies.mojom-shared.h"
#include "services/network/public/mojom/cookie_manager.mojom-shared.h"
#include "services/network/public/mojom/cookie_setting_overrides.mojom-shared.h"


namespace network::mojom {
class CookieAccessDetailsDataView;



}  // network::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::CookieAccessDetailsDataView> {
  using Data = ::network::mojom::internal::CookieAccessDetails_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {


enum class CookieAccessDetails_Type : int32_t {
  
  kRead = 0,
  
  kChange = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, CookieAccessDetails_Type value);
inline bool IsKnownEnumValue(CookieAccessDetails_Type value) {
  return internal::CookieAccessDetails_Type_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class CookieAccessObserverInterfaceBase {};

using CookieAccessObserverPtrDataView =
    mojo::InterfacePtrDataView<CookieAccessObserverInterfaceBase>;
using CookieAccessObserverRequestDataView =
    mojo::InterfaceRequestDataView<CookieAccessObserverInterfaceBase>;
using CookieAccessObserverAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<CookieAccessObserverInterfaceBase>;
using CookieAccessObserverAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<CookieAccessObserverInterfaceBase>;


class CookieAccessDetailsDataView {
 public:
  CookieAccessDetailsDataView() = default;

  CookieAccessDetailsDataView(
      internal::CookieAccessDetails_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::network::mojom::CookieAccessDetails_Type>(
        data_value, output);
  }
  CookieAccessDetails_Type type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::CookieAccessDetails_Type>(data_->type));
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetFrameOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFrameOrigin(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::OriginDataView, UserType>(),
    "Attempting to read the optional `frame_origin` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFrameOrigin` instead "
    "of `ReadFrameOrigin if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->frame_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetTopFrameOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTopFrameOrigin(UserType* output) {
    
    auto* pointer = data_->top_frame_origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  inline void GetSiteForCookiesDataView(
      ::network::mojom::SiteForCookiesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSiteForCookies(UserType* output) {
    
    auto* pointer = data_->site_for_cookies.Get();
    return mojo::internal::Deserialize<::network::mojom::SiteForCookiesDataView>(
        pointer, output, message_);
  }
  inline void GetCookieListDataView(
      mojo::ArrayDataView<::network::mojom::CookieOrLineWithAccessResultDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCookieList(UserType* output) {
    
    auto* pointer = data_->cookie_list.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::CookieOrLineWithAccessResultDataView>>(
        pointer, output, message_);
  }
  inline void GetDevtoolsRequestIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDevtoolsRequestId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `devtools_request_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDevtoolsRequestId` instead "
    "of `ReadDevtoolsRequestId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->devtools_request_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool is_ad_tagged() const {
    return data_->is_ad_tagged;
  }
  inline void GetCookieSettingOverridesDataView(
      ::network::mojom::CookieSettingOverridesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCookieSettingOverrides(UserType* output) {
    
    auto* pointer = data_->cookie_setting_overrides.Get();
    return mojo::internal::Deserialize<::network::mojom::CookieSettingOverridesDataView>(
        pointer, output, message_);
  }
 private:
  internal::CookieAccessDetails_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // network::mojom

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_COOKIE_ACCESS_OBSERVER_MOJOM_DATA_VIEW_H_