// services/network/public/mojom/content_security_policy.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_CONTENT_SECURITY_POLICY_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_CONTENT_SECURITY_POLICY_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/content_security_policy.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/content_security_policy.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/content_security_policy.mojom-forward.h"  // IWYU pragma: export
#include "url/mojom/origin.mojom.h"
#include "url/mojom/url.mojom.h"
#include "services/network/public/mojom/integrity_algorithm.mojom-forward.h"
#include "services/network/public/mojom/integrity_metadata.mojom.h"
#include "services/network/public/mojom/source_location.mojom.h"
#include "services/network/public/mojom/web_sandbox_flags.mojom-forward.h"
#include <string>
#include <vector>








namespace network::mojom {





class  ContentSecurityPolicyHeader {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ContentSecurityPolicyHeader, T>::value>;
  using DataView = ContentSecurityPolicyHeaderDataView;
  using Data_ = internal::ContentSecurityPolicyHeader_Data;

  template <typename... Args>
  static ContentSecurityPolicyHeaderPtr New(Args&&... args) {
    return ContentSecurityPolicyHeaderPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ContentSecurityPolicyHeaderPtr From(const U& u) {
    return mojo::TypeConverter<ContentSecurityPolicyHeaderPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ContentSecurityPolicyHeader>::Convert(*this);
  }


  ContentSecurityPolicyHeader();

  ContentSecurityPolicyHeader(
      const std::string& header_value,
      ContentSecurityPolicyType type,
      ContentSecurityPolicySource source);


  ~ContentSecurityPolicyHeader();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ContentSecurityPolicyHeaderPtr>
  ContentSecurityPolicyHeaderPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ContentSecurityPolicyHeader::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ContentSecurityPolicyHeader::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ContentSecurityPolicyHeader::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ContentSecurityPolicyHeader::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ContentSecurityPolicyHeader::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ContentSecurityPolicyHeader::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ContentSecurityPolicyHeader_UnserializedMessageContext<
            UserType, ContentSecurityPolicyHeader::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ContentSecurityPolicyHeader::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ContentSecurityPolicyHeader::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ContentSecurityPolicyHeader_UnserializedMessageContext<
            UserType, ContentSecurityPolicyHeader::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ContentSecurityPolicyHeader::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string header_value;
  
  ContentSecurityPolicyType type;
  
  ContentSecurityPolicySource source;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ContentSecurityPolicyHeader::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ContentSecurityPolicyHeader::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ContentSecurityPolicyHeader::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ContentSecurityPolicyHeader::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}










class  AllowCSPFromHeaderValue {
 public:
  using DataView = AllowCSPFromHeaderValueDataView;
  using Data_ = internal::AllowCSPFromHeaderValue_Data;
  using Tag = Data_::AllowCSPFromHeaderValue_Tag;

  template <typename... Args>
  static AllowCSPFromHeaderValuePtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |allow_star|.
  static AllowCSPFromHeaderValuePtr NewAllowStar(
      bool value);
  // Construct an instance holding |origin|.
  static AllowCSPFromHeaderValuePtr NewOrigin(
      const ::url::Origin& value);
  // Construct an instance holding |error_message|.
  static AllowCSPFromHeaderValuePtr NewErrorMessage(
      const std::string& value);

  template <typename U>
  static AllowCSPFromHeaderValuePtr From(const U& u) {
    return mojo::TypeConverter<AllowCSPFromHeaderValuePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AllowCSPFromHeaderValue>::Convert(*this);
  }
  ~AllowCSPFromHeaderValue();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  AllowCSPFromHeaderValue(const AllowCSPFromHeaderValue& other) = delete;
  AllowCSPFromHeaderValue& operator=(const AllowCSPFromHeaderValue& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = AllowCSPFromHeaderValuePtr>
  AllowCSPFromHeaderValuePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, AllowCSPFromHeaderValue>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, AllowCSPFromHeaderValue>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_allow_star() const { return tag_ == Tag::kAllowStar; }
  bool get_allow_star() const {
    CHECK(tag_ == Tag::kAllowStar);
    return data_.allow_star;
  }
  void set_allow_star(bool allow_star);

  bool is_origin() const { return tag_ == Tag::kOrigin; }
  const ::url::Origin& get_origin() const {
    CHECK(tag_ == Tag::kOrigin);
    return data_.origin;
  }
  ::url::Origin& get_origin() {
    CHECK(tag_ == Tag::kOrigin);
    return data_.origin;
  }
  void set_origin(const ::url::Origin& origin);

  bool is_error_message() const { return tag_ == Tag::kErrorMessage; }
  const std::string& get_error_message() const {
    CHECK(tag_ == Tag::kErrorMessage);
    return data_.error_message;
  }
  std::string& get_error_message() {
    CHECK(tag_ == Tag::kErrorMessage);
    return data_.error_message;
  }
  void set_error_message(const std::string& error_message);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AllowCSPFromHeaderValue::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<AllowCSPFromHeaderValue::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kAllowStar)>,
        bool value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kOrigin)>,
        const ::url::Origin& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kErrorMessage)>,
        const std::string& value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    bool allow_star;
    ::url::Origin origin;
    std::string error_message;
  };

  AllowCSPFromHeaderValue(
      std::in_place_index_t<static_cast<size_t>(Tag::kAllowStar)>,
      bool value);
  AllowCSPFromHeaderValue(
      std::in_place_index_t<static_cast<size_t>(Tag::kOrigin)>,
      const ::url::Origin& value);
  AllowCSPFromHeaderValue(
      std::in_place_index_t<static_cast<size_t>(Tag::kErrorMessage)>,
      const std::string& value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};






class  CSPSource {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CSPSource, T>::value>;
  using DataView = CSPSourceDataView;
  using Data_ = internal::CSPSource_Data;

  template <typename... Args>
  static CSPSourcePtr New(Args&&... args) {
    return CSPSourcePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CSPSourcePtr From(const U& u) {
    return mojo::TypeConverter<CSPSourcePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CSPSource>::Convert(*this);
  }


  CSPSource();

  CSPSource(
      const std::string& scheme,
      const std::string& host,
      int32_t port,
      const std::string& path,
      bool is_host_wildcard,
      bool is_port_wildcard);


  ~CSPSource();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CSPSourcePtr>
  CSPSourcePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CSPSource::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CSPSource::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CSPSource::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CSPSource::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CSPSource::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CSPSource::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CSPSource_UnserializedMessageContext<
            UserType, CSPSource::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CSPSource::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CSPSource::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CSPSource_UnserializedMessageContext<
            UserType, CSPSource::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CSPSource::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string scheme;
  
  std::string host;
  
  int32_t port;
  
  std::string path;
  
  bool is_host_wildcard;
  
  bool is_port_wildcard;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CSPSource::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CSPSource::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CSPSource::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CSPSource::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  CSPSourceList {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CSPSourceList, T>::value>;
  using DataView = CSPSourceListDataView;
  using Data_ = internal::CSPSourceList_Data;

  template <typename... Args>
  static CSPSourceListPtr New(Args&&... args) {
    return CSPSourceListPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CSPSourceListPtr From(const U& u) {
    return mojo::TypeConverter<CSPSourceListPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CSPSourceList>::Convert(*this);
  }


  CSPSourceList();

  CSPSourceList(
      std::vector<CSPSourcePtr> sources,
      std::vector<std::string> nonces,
      std::vector<::network::IntegrityMetadata> hashes,
      std::vector<::network::IntegrityMetadata> url_hashes,
      std::vector<::network::IntegrityMetadata> eval_hashes,
      bool allow_self,
      bool allow_star,
      bool allow_inline,
      bool allow_inline_speculation_rules,
      bool allow_eval,
      bool allow_wasm_eval,
      bool allow_wasm_unsafe_eval,
      bool allow_dynamic,
      bool allow_dynamic_url,
      bool allow_unsafe_hashes,
      bool report_sample,
      std::optional<::network::mojom::IntegrityAlgorithm> report_hash_algorithm);

CSPSourceList(const CSPSourceList&) = delete;
CSPSourceList& operator=(const CSPSourceList&) = delete;

  ~CSPSourceList();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CSPSourceListPtr>
  CSPSourceListPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CSPSourceList::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CSPSourceList::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CSPSourceList::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CSPSourceList::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CSPSourceList::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CSPSourceList::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CSPSourceList_UnserializedMessageContext<
            UserType, CSPSourceList::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CSPSourceList::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CSPSourceList::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CSPSourceList_UnserializedMessageContext<
            UserType, CSPSourceList::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CSPSourceList::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<CSPSourcePtr> sources;
  
  std::vector<std::string> nonces;
  
  std::vector<::network::IntegrityMetadata> hashes;
  
  std::vector<::network::IntegrityMetadata> url_hashes;
  
  std::vector<::network::IntegrityMetadata> eval_hashes;
  
  bool allow_self;
  
  bool allow_star;
  
  bool allow_inline;
  
  bool allow_inline_speculation_rules;
  
  bool allow_eval;
  
  bool allow_wasm_eval;
  
  bool allow_wasm_unsafe_eval;
  
  bool allow_dynamic;
  
  bool allow_dynamic_url;
  
  bool allow_unsafe_hashes;
  
  bool report_sample;
  
  std::optional<::network::mojom::IntegrityAlgorithm> report_hash_algorithm;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CSPSourceList::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CSPSourceList::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CSPSourceList::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CSPSourceList::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  CSPTrustedTypes {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CSPTrustedTypes, T>::value>;
  using DataView = CSPTrustedTypesDataView;
  using Data_ = internal::CSPTrustedTypes_Data;

  template <typename... Args>
  static CSPTrustedTypesPtr New(Args&&... args) {
    return CSPTrustedTypesPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CSPTrustedTypesPtr From(const U& u) {
    return mojo::TypeConverter<CSPTrustedTypesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CSPTrustedTypes>::Convert(*this);
  }


  CSPTrustedTypes();

  CSPTrustedTypes(
      std::vector<std::string> list,
      bool allow_any,
      bool allow_duplicates);


  ~CSPTrustedTypes();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CSPTrustedTypesPtr>
  CSPTrustedTypesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CSPTrustedTypes::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CSPTrustedTypes::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CSPTrustedTypes::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CSPTrustedTypes::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CSPTrustedTypes::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CSPTrustedTypes::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CSPTrustedTypes_UnserializedMessageContext<
            UserType, CSPTrustedTypes::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CSPTrustedTypes::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CSPTrustedTypes::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CSPTrustedTypes_UnserializedMessageContext<
            UserType, CSPTrustedTypes::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CSPTrustedTypes::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<std::string> list;
  
  bool allow_any;
  
  bool allow_duplicates;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CSPTrustedTypes::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CSPTrustedTypes::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CSPTrustedTypes::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CSPTrustedTypes::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ContentSecurityPolicy {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ContentSecurityPolicy, T>::value>;
  using DataView = ContentSecurityPolicyDataView;
  using Data_ = internal::ContentSecurityPolicy_Data;

  template <typename... Args>
  static ContentSecurityPolicyPtr New(Args&&... args) {
    return ContentSecurityPolicyPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ContentSecurityPolicyPtr From(const U& u) {
    return mojo::TypeConverter<ContentSecurityPolicyPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ContentSecurityPolicy>::Convert(*this);
  }


  ContentSecurityPolicy();

  ContentSecurityPolicy(
      CSPSourcePtr self_origin,
      const base::flat_map<CSPDirectiveName, std::string>& raw_directives,
      base::flat_map<CSPDirectiveName, CSPSourceListPtr> directives,
      bool upgrade_insecure_requests,
      bool treat_as_public_address,
      bool block_all_mixed_content,
      ::network::mojom::WebSandboxFlags sandbox,
      ContentSecurityPolicyHeaderPtr header,
      bool use_reporting_api,
      std::vector<std::string> report_endpoints,
      CSPRequireTrustedTypesFor require_trusted_types_for,
      CSPTrustedTypesPtr trusted_types,
      std::vector<std::string> parsing_errors);

ContentSecurityPolicy(const ContentSecurityPolicy&) = delete;
ContentSecurityPolicy& operator=(const ContentSecurityPolicy&) = delete;

  ~ContentSecurityPolicy();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ContentSecurityPolicyPtr>
  ContentSecurityPolicyPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ContentSecurityPolicy::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ContentSecurityPolicy::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ContentSecurityPolicy::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ContentSecurityPolicy::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ContentSecurityPolicy::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ContentSecurityPolicy::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ContentSecurityPolicy_UnserializedMessageContext<
            UserType, ContentSecurityPolicy::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ContentSecurityPolicy::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ContentSecurityPolicy::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ContentSecurityPolicy_UnserializedMessageContext<
            UserType, ContentSecurityPolicy::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ContentSecurityPolicy::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  CSPSourcePtr self_origin;
  
  base::flat_map<CSPDirectiveName, std::string> raw_directives;
  
  base::flat_map<CSPDirectiveName, CSPSourceListPtr> directives;
  
  bool upgrade_insecure_requests;
  
  bool treat_as_public_address;
  
  bool block_all_mixed_content;
  
  ::network::mojom::WebSandboxFlags sandbox;
  
  ContentSecurityPolicyHeaderPtr header;
  
  bool use_reporting_api;
  
  std::vector<std::string> report_endpoints;
  
  CSPRequireTrustedTypesFor require_trusted_types_for;
  
  CSPTrustedTypesPtr trusted_types;
  
  std::vector<std::string> parsing_errors;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ContentSecurityPolicy::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ContentSecurityPolicy::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ContentSecurityPolicy::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ContentSecurityPolicy::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  CSPViolation {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CSPViolation, T>::value>;
  using DataView = CSPViolationDataView;
  using Data_ = internal::CSPViolation_Data;

  template <typename... Args>
  static CSPViolationPtr New(Args&&... args) {
    return CSPViolationPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CSPViolationPtr From(const U& u) {
    return mojo::TypeConverter<CSPViolationPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CSPViolation>::Convert(*this);
  }


  CSPViolation();

  CSPViolation(
      const std::string& directive,
      const std::string& effective_directive,
      const std::string& console_message,
      const ::GURL& blocked_url,
      std::vector<std::string> report_endpoints,
      bool use_reporting_api,
      const std::string& header,
      ContentSecurityPolicyType type,
      ::network::mojom::SourceLocationPtr source_location);

CSPViolation(const CSPViolation&) = delete;
CSPViolation& operator=(const CSPViolation&) = delete;

  ~CSPViolation();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CSPViolationPtr>
  CSPViolationPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CSPViolation::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CSPViolation::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CSPViolation::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CSPViolation::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CSPViolation::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CSPViolation::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CSPViolation_UnserializedMessageContext<
            UserType, CSPViolation::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CSPViolation::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CSPViolation::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CSPViolation_UnserializedMessageContext<
            UserType, CSPViolation::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CSPViolation::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string directive;
  
  std::string effective_directive;
  
  std::string console_message;
  
  ::GURL blocked_url;
  
  std::vector<std::string> report_endpoints;
  
  bool use_reporting_api;
  
  std::string header;
  
  ContentSecurityPolicyType type;
  
  ::network::mojom::SourceLocationPtr source_location;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CSPViolation::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CSPViolation::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CSPViolation::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CSPViolation::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
AllowCSPFromHeaderValuePtr AllowCSPFromHeaderValue::Clone() const {
  switch (tag_) {
    case Tag::kAllowStar:
      return NewAllowStar(
          mojo::Clone(data_.allow_star));
    case Tag::kOrigin:
      return NewOrigin(
          mojo::Clone(data_.origin));
    case Tag::kErrorMessage:
      return NewErrorMessage(
          mojo::Clone(data_.error_message));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, AllowCSPFromHeaderValue>::value>::type*>
bool AllowCSPFromHeaderValue::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kAllowStar:
      return mojo::Equals(data_.allow_star, other.data_.allow_star);
    case Tag::kOrigin:
      return mojo::Equals(data_.origin, other.data_.origin);
    case Tag::kErrorMessage:
      return mojo::Equals(data_.error_message, other.data_.error_message);
  }

  return false;
}
template <typename StructPtrType>
ContentSecurityPolicyHeaderPtr ContentSecurityPolicyHeader::Clone() const {
  return New(
      mojo::Clone(header_value),
      mojo::Clone(type),
      mojo::Clone(source)
  );
}

template <typename T, ContentSecurityPolicyHeader::EnableIfSame<T>*>
bool ContentSecurityPolicyHeader::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->header_value, other_struct.header_value))
    return false;
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->source, other_struct.source))
    return false;
  return true;
}

template <typename T, ContentSecurityPolicyHeader::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.header_value < rhs.header_value)
    return true;
  if (rhs.header_value < lhs.header_value)
    return false;
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.source < rhs.source)
    return true;
  if (rhs.source < lhs.source)
    return false;
  return false;
}
template <typename StructPtrType>
CSPSourcePtr CSPSource::Clone() const {
  return New(
      mojo::Clone(scheme),
      mojo::Clone(host),
      mojo::Clone(port),
      mojo::Clone(path),
      mojo::Clone(is_host_wildcard),
      mojo::Clone(is_port_wildcard)
  );
}

template <typename T, CSPSource::EnableIfSame<T>*>
bool CSPSource::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->scheme, other_struct.scheme))
    return false;
  if (!mojo::Equals(this->host, other_struct.host))
    return false;
  if (!mojo::Equals(this->port, other_struct.port))
    return false;
  if (!mojo::Equals(this->path, other_struct.path))
    return false;
  if (!mojo::Equals(this->is_host_wildcard, other_struct.is_host_wildcard))
    return false;
  if (!mojo::Equals(this->is_port_wildcard, other_struct.is_port_wildcard))
    return false;
  return true;
}

template <typename T, CSPSource::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.scheme < rhs.scheme)
    return true;
  if (rhs.scheme < lhs.scheme)
    return false;
  if (lhs.host < rhs.host)
    return true;
  if (rhs.host < lhs.host)
    return false;
  if (lhs.port < rhs.port)
    return true;
  if (rhs.port < lhs.port)
    return false;
  if (lhs.path < rhs.path)
    return true;
  if (rhs.path < lhs.path)
    return false;
  if (lhs.is_host_wildcard < rhs.is_host_wildcard)
    return true;
  if (rhs.is_host_wildcard < lhs.is_host_wildcard)
    return false;
  if (lhs.is_port_wildcard < rhs.is_port_wildcard)
    return true;
  if (rhs.is_port_wildcard < lhs.is_port_wildcard)
    return false;
  return false;
}
template <typename StructPtrType>
CSPSourceListPtr CSPSourceList::Clone() const {
  return New(
      mojo::Clone(sources),
      mojo::Clone(nonces),
      mojo::Clone(hashes),
      mojo::Clone(url_hashes),
      mojo::Clone(eval_hashes),
      mojo::Clone(allow_self),
      mojo::Clone(allow_star),
      mojo::Clone(allow_inline),
      mojo::Clone(allow_inline_speculation_rules),
      mojo::Clone(allow_eval),
      mojo::Clone(allow_wasm_eval),
      mojo::Clone(allow_wasm_unsafe_eval),
      mojo::Clone(allow_dynamic),
      mojo::Clone(allow_dynamic_url),
      mojo::Clone(allow_unsafe_hashes),
      mojo::Clone(report_sample),
      mojo::Clone(report_hash_algorithm)
  );
}

template <typename T, CSPSourceList::EnableIfSame<T>*>
bool CSPSourceList::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->sources, other_struct.sources))
    return false;
  if (!mojo::Equals(this->nonces, other_struct.nonces))
    return false;
  if (!mojo::Equals(this->hashes, other_struct.hashes))
    return false;
  if (!mojo::Equals(this->url_hashes, other_struct.url_hashes))
    return false;
  if (!mojo::Equals(this->eval_hashes, other_struct.eval_hashes))
    return false;
  if (!mojo::Equals(this->allow_self, other_struct.allow_self))
    return false;
  if (!mojo::Equals(this->allow_star, other_struct.allow_star))
    return false;
  if (!mojo::Equals(this->allow_inline, other_struct.allow_inline))
    return false;
  if (!mojo::Equals(this->allow_inline_speculation_rules, other_struct.allow_inline_speculation_rules))
    return false;
  if (!mojo::Equals(this->allow_eval, other_struct.allow_eval))
    return false;
  if (!mojo::Equals(this->allow_wasm_eval, other_struct.allow_wasm_eval))
    return false;
  if (!mojo::Equals(this->allow_wasm_unsafe_eval, other_struct.allow_wasm_unsafe_eval))
    return false;
  if (!mojo::Equals(this->allow_dynamic, other_struct.allow_dynamic))
    return false;
  if (!mojo::Equals(this->allow_dynamic_url, other_struct.allow_dynamic_url))
    return false;
  if (!mojo::Equals(this->allow_unsafe_hashes, other_struct.allow_unsafe_hashes))
    return false;
  if (!mojo::Equals(this->report_sample, other_struct.report_sample))
    return false;
  if (!mojo::Equals(this->report_hash_algorithm, other_struct.report_hash_algorithm))
    return false;
  return true;
}

template <typename T, CSPSourceList::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.sources < rhs.sources)
    return true;
  if (rhs.sources < lhs.sources)
    return false;
  if (lhs.nonces < rhs.nonces)
    return true;
  if (rhs.nonces < lhs.nonces)
    return false;
  if (lhs.hashes < rhs.hashes)
    return true;
  if (rhs.hashes < lhs.hashes)
    return false;
  if (lhs.url_hashes < rhs.url_hashes)
    return true;
  if (rhs.url_hashes < lhs.url_hashes)
    return false;
  if (lhs.eval_hashes < rhs.eval_hashes)
    return true;
  if (rhs.eval_hashes < lhs.eval_hashes)
    return false;
  if (lhs.allow_self < rhs.allow_self)
    return true;
  if (rhs.allow_self < lhs.allow_self)
    return false;
  if (lhs.allow_star < rhs.allow_star)
    return true;
  if (rhs.allow_star < lhs.allow_star)
    return false;
  if (lhs.allow_inline < rhs.allow_inline)
    return true;
  if (rhs.allow_inline < lhs.allow_inline)
    return false;
  if (lhs.allow_inline_speculation_rules < rhs.allow_inline_speculation_rules)
    return true;
  if (rhs.allow_inline_speculation_rules < lhs.allow_inline_speculation_rules)
    return false;
  if (lhs.allow_eval < rhs.allow_eval)
    return true;
  if (rhs.allow_eval < lhs.allow_eval)
    return false;
  if (lhs.allow_wasm_eval < rhs.allow_wasm_eval)
    return true;
  if (rhs.allow_wasm_eval < lhs.allow_wasm_eval)
    return false;
  if (lhs.allow_wasm_unsafe_eval < rhs.allow_wasm_unsafe_eval)
    return true;
  if (rhs.allow_wasm_unsafe_eval < lhs.allow_wasm_unsafe_eval)
    return false;
  if (lhs.allow_dynamic < rhs.allow_dynamic)
    return true;
  if (rhs.allow_dynamic < lhs.allow_dynamic)
    return false;
  if (lhs.allow_dynamic_url < rhs.allow_dynamic_url)
    return true;
  if (rhs.allow_dynamic_url < lhs.allow_dynamic_url)
    return false;
  if (lhs.allow_unsafe_hashes < rhs.allow_unsafe_hashes)
    return true;
  if (rhs.allow_unsafe_hashes < lhs.allow_unsafe_hashes)
    return false;
  if (lhs.report_sample < rhs.report_sample)
    return true;
  if (rhs.report_sample < lhs.report_sample)
    return false;
  if (lhs.report_hash_algorithm < rhs.report_hash_algorithm)
    return true;
  if (rhs.report_hash_algorithm < lhs.report_hash_algorithm)
    return false;
  return false;
}
template <typename StructPtrType>
CSPTrustedTypesPtr CSPTrustedTypes::Clone() const {
  return New(
      mojo::Clone(list),
      mojo::Clone(allow_any),
      mojo::Clone(allow_duplicates)
  );
}

template <typename T, CSPTrustedTypes::EnableIfSame<T>*>
bool CSPTrustedTypes::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->list, other_struct.list))
    return false;
  if (!mojo::Equals(this->allow_any, other_struct.allow_any))
    return false;
  if (!mojo::Equals(this->allow_duplicates, other_struct.allow_duplicates))
    return false;
  return true;
}

template <typename T, CSPTrustedTypes::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.list < rhs.list)
    return true;
  if (rhs.list < lhs.list)
    return false;
  if (lhs.allow_any < rhs.allow_any)
    return true;
  if (rhs.allow_any < lhs.allow_any)
    return false;
  if (lhs.allow_duplicates < rhs.allow_duplicates)
    return true;
  if (rhs.allow_duplicates < lhs.allow_duplicates)
    return false;
  return false;
}
template <typename StructPtrType>
ContentSecurityPolicyPtr ContentSecurityPolicy::Clone() const {
  return New(
      mojo::Clone(self_origin),
      mojo::Clone(raw_directives),
      mojo::Clone(directives),
      mojo::Clone(upgrade_insecure_requests),
      mojo::Clone(treat_as_public_address),
      mojo::Clone(block_all_mixed_content),
      mojo::Clone(sandbox),
      mojo::Clone(header),
      mojo::Clone(use_reporting_api),
      mojo::Clone(report_endpoints),
      mojo::Clone(require_trusted_types_for),
      mojo::Clone(trusted_types),
      mojo::Clone(parsing_errors)
  );
}

template <typename T, ContentSecurityPolicy::EnableIfSame<T>*>
bool ContentSecurityPolicy::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->self_origin, other_struct.self_origin))
    return false;
  if (!mojo::Equals(this->raw_directives, other_struct.raw_directives))
    return false;
  if (!mojo::Equals(this->directives, other_struct.directives))
    return false;
  if (!mojo::Equals(this->upgrade_insecure_requests, other_struct.upgrade_insecure_requests))
    return false;
  if (!mojo::Equals(this->treat_as_public_address, other_struct.treat_as_public_address))
    return false;
  if (!mojo::Equals(this->block_all_mixed_content, other_struct.block_all_mixed_content))
    return false;
  if (!mojo::Equals(this->sandbox, other_struct.sandbox))
    return false;
  if (!mojo::Equals(this->header, other_struct.header))
    return false;
  if (!mojo::Equals(this->use_reporting_api, other_struct.use_reporting_api))
    return false;
  if (!mojo::Equals(this->report_endpoints, other_struct.report_endpoints))
    return false;
  if (!mojo::Equals(this->require_trusted_types_for, other_struct.require_trusted_types_for))
    return false;
  if (!mojo::Equals(this->trusted_types, other_struct.trusted_types))
    return false;
  if (!mojo::Equals(this->parsing_errors, other_struct.parsing_errors))
    return false;
  return true;
}

template <typename T, ContentSecurityPolicy::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.self_origin < rhs.self_origin)
    return true;
  if (rhs.self_origin < lhs.self_origin)
    return false;
  if (lhs.raw_directives < rhs.raw_directives)
    return true;
  if (rhs.raw_directives < lhs.raw_directives)
    return false;
  if (lhs.directives < rhs.directives)
    return true;
  if (rhs.directives < lhs.directives)
    return false;
  if (lhs.upgrade_insecure_requests < rhs.upgrade_insecure_requests)
    return true;
  if (rhs.upgrade_insecure_requests < lhs.upgrade_insecure_requests)
    return false;
  if (lhs.treat_as_public_address < rhs.treat_as_public_address)
    return true;
  if (rhs.treat_as_public_address < lhs.treat_as_public_address)
    return false;
  if (lhs.block_all_mixed_content < rhs.block_all_mixed_content)
    return true;
  if (rhs.block_all_mixed_content < lhs.block_all_mixed_content)
    return false;
  if (lhs.sandbox < rhs.sandbox)
    return true;
  if (rhs.sandbox < lhs.sandbox)
    return false;
  if (lhs.header < rhs.header)
    return true;
  if (rhs.header < lhs.header)
    return false;
  if (lhs.use_reporting_api < rhs.use_reporting_api)
    return true;
  if (rhs.use_reporting_api < lhs.use_reporting_api)
    return false;
  if (lhs.report_endpoints < rhs.report_endpoints)
    return true;
  if (rhs.report_endpoints < lhs.report_endpoints)
    return false;
  if (lhs.require_trusted_types_for < rhs.require_trusted_types_for)
    return true;
  if (rhs.require_trusted_types_for < lhs.require_trusted_types_for)
    return false;
  if (lhs.trusted_types < rhs.trusted_types)
    return true;
  if (rhs.trusted_types < lhs.trusted_types)
    return false;
  if (lhs.parsing_errors < rhs.parsing_errors)
    return true;
  if (rhs.parsing_errors < lhs.parsing_errors)
    return false;
  return false;
}
template <typename StructPtrType>
CSPViolationPtr CSPViolation::Clone() const {
  return New(
      mojo::Clone(directive),
      mojo::Clone(effective_directive),
      mojo::Clone(console_message),
      mojo::Clone(blocked_url),
      mojo::Clone(report_endpoints),
      mojo::Clone(use_reporting_api),
      mojo::Clone(header),
      mojo::Clone(type),
      mojo::Clone(source_location)
  );
}

template <typename T, CSPViolation::EnableIfSame<T>*>
bool CSPViolation::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->directive, other_struct.directive))
    return false;
  if (!mojo::Equals(this->effective_directive, other_struct.effective_directive))
    return false;
  if (!mojo::Equals(this->console_message, other_struct.console_message))
    return false;
  if (!mojo::Equals(this->blocked_url, other_struct.blocked_url))
    return false;
  if (!mojo::Equals(this->report_endpoints, other_struct.report_endpoints))
    return false;
  if (!mojo::Equals(this->use_reporting_api, other_struct.use_reporting_api))
    return false;
  if (!mojo::Equals(this->header, other_struct.header))
    return false;
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->source_location, other_struct.source_location))
    return false;
  return true;
}

template <typename T, CSPViolation::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.directive < rhs.directive)
    return true;
  if (rhs.directive < lhs.directive)
    return false;
  if (lhs.effective_directive < rhs.effective_directive)
    return true;
  if (rhs.effective_directive < lhs.effective_directive)
    return false;
  if (lhs.console_message < rhs.console_message)
    return true;
  if (rhs.console_message < lhs.console_message)
    return false;
  if (lhs.blocked_url < rhs.blocked_url)
    return true;
  if (rhs.blocked_url < lhs.blocked_url)
    return false;
  if (lhs.report_endpoints < rhs.report_endpoints)
    return true;
  if (rhs.report_endpoints < lhs.report_endpoints)
    return false;
  if (lhs.use_reporting_api < rhs.use_reporting_api)
    return true;
  if (rhs.use_reporting_api < lhs.use_reporting_api)
    return false;
  if (lhs.header < rhs.header)
    return true;
  if (rhs.header < lhs.header)
    return false;
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.source_location < rhs.source_location)
    return true;
  if (rhs.source_location < lhs.source_location)
    return false;
  return false;
}


}  // network::mojom

namespace mojo {


template <>
struct  StructTraits<::network::mojom::ContentSecurityPolicyHeader::DataView,
                                         ::network::mojom::ContentSecurityPolicyHeaderPtr> {
  static bool IsNull(const ::network::mojom::ContentSecurityPolicyHeaderPtr& input) { return !input; }
  static void SetToNull(::network::mojom::ContentSecurityPolicyHeaderPtr* output) { output->reset(); }

  static const decltype(::network::mojom::ContentSecurityPolicyHeader::header_value)& header_value(
      const ::network::mojom::ContentSecurityPolicyHeaderPtr& input) {
    return input->header_value;
  }

  static decltype(::network::mojom::ContentSecurityPolicyHeader::type) type(
      const ::network::mojom::ContentSecurityPolicyHeaderPtr& input) {
    return input->type;
  }

  static decltype(::network::mojom::ContentSecurityPolicyHeader::source) source(
      const ::network::mojom::ContentSecurityPolicyHeaderPtr& input) {
    return input->source;
  }

  static bool Read(::network::mojom::ContentSecurityPolicyHeader::DataView input, ::network::mojom::ContentSecurityPolicyHeaderPtr* output);
};


template <>
struct  StructTraits<::network::mojom::CSPSource::DataView,
                                         ::network::mojom::CSPSourcePtr> {
  static bool IsNull(const ::network::mojom::CSPSourcePtr& input) { return !input; }
  static void SetToNull(::network::mojom::CSPSourcePtr* output) { output->reset(); }

  static const decltype(::network::mojom::CSPSource::scheme)& scheme(
      const ::network::mojom::CSPSourcePtr& input) {
    return input->scheme;
  }

  static const decltype(::network::mojom::CSPSource::host)& host(
      const ::network::mojom::CSPSourcePtr& input) {
    return input->host;
  }

  static decltype(::network::mojom::CSPSource::port) port(
      const ::network::mojom::CSPSourcePtr& input) {
    return input->port;
  }

  static const decltype(::network::mojom::CSPSource::path)& path(
      const ::network::mojom::CSPSourcePtr& input) {
    return input->path;
  }

  static decltype(::network::mojom::CSPSource::is_host_wildcard) is_host_wildcard(
      const ::network::mojom::CSPSourcePtr& input) {
    return input->is_host_wildcard;
  }

  static decltype(::network::mojom::CSPSource::is_port_wildcard) is_port_wildcard(
      const ::network::mojom::CSPSourcePtr& input) {
    return input->is_port_wildcard;
  }

  static bool Read(::network::mojom::CSPSource::DataView input, ::network::mojom::CSPSourcePtr* output);
};


template <>
struct  StructTraits<::network::mojom::CSPSourceList::DataView,
                                         ::network::mojom::CSPSourceListPtr> {
  static bool IsNull(const ::network::mojom::CSPSourceListPtr& input) { return !input; }
  static void SetToNull(::network::mojom::CSPSourceListPtr* output) { output->reset(); }

  static const decltype(::network::mojom::CSPSourceList::sources)& sources(
      const ::network::mojom::CSPSourceListPtr& input) {
    return input->sources;
  }

  static const decltype(::network::mojom::CSPSourceList::nonces)& nonces(
      const ::network::mojom::CSPSourceListPtr& input) {
    return input->nonces;
  }

  static const decltype(::network::mojom::CSPSourceList::hashes)& hashes(
      const ::network::mojom::CSPSourceListPtr& input) {
    return input->hashes;
  }

  static const decltype(::network::mojom::CSPSourceList::url_hashes)& url_hashes(
      const ::network::mojom::CSPSourceListPtr& input) {
    return input->url_hashes;
  }

  static const decltype(::network::mojom::CSPSourceList::eval_hashes)& eval_hashes(
      const ::network::mojom::CSPSourceListPtr& input) {
    return input->eval_hashes;
  }

  static decltype(::network::mojom::CSPSourceList::allow_self) allow_self(
      const ::network::mojom::CSPSourceListPtr& input) {
    return input->allow_self;
  }

  static decltype(::network::mojom::CSPSourceList::allow_star) allow_star(
      const ::network::mojom::CSPSourceListPtr& input) {
    return input->allow_star;
  }

  static decltype(::network::mojom::CSPSourceList::allow_inline) allow_inline(
      const ::network::mojom::CSPSourceListPtr& input) {
    return input->allow_inline;
  }

  static decltype(::network::mojom::CSPSourceList::allow_inline_speculation_rules) allow_inline_speculation_rules(
      const ::network::mojom::CSPSourceListPtr& input) {
    return input->allow_inline_speculation_rules;
  }

  static decltype(::network::mojom::CSPSourceList::allow_eval) allow_eval(
      const ::network::mojom::CSPSourceListPtr& input) {
    return input->allow_eval;
  }

  static decltype(::network::mojom::CSPSourceList::allow_wasm_eval) allow_wasm_eval(
      const ::network::mojom::CSPSourceListPtr& input) {
    return input->allow_wasm_eval;
  }

  static decltype(::network::mojom::CSPSourceList::allow_wasm_unsafe_eval) allow_wasm_unsafe_eval(
      const ::network::mojom::CSPSourceListPtr& input) {
    return input->allow_wasm_unsafe_eval;
  }

  static decltype(::network::mojom::CSPSourceList::allow_dynamic) allow_dynamic(
      const ::network::mojom::CSPSourceListPtr& input) {
    return input->allow_dynamic;
  }

  static decltype(::network::mojom::CSPSourceList::allow_dynamic_url) allow_dynamic_url(
      const ::network::mojom::CSPSourceListPtr& input) {
    return input->allow_dynamic_url;
  }

  static decltype(::network::mojom::CSPSourceList::allow_unsafe_hashes) allow_unsafe_hashes(
      const ::network::mojom::CSPSourceListPtr& input) {
    return input->allow_unsafe_hashes;
  }

  static decltype(::network::mojom::CSPSourceList::report_sample) report_sample(
      const ::network::mojom::CSPSourceListPtr& input) {
    return input->report_sample;
  }

  static decltype(::network::mojom::CSPSourceList::report_hash_algorithm) report_hash_algorithm(
      const ::network::mojom::CSPSourceListPtr& input) {
    return input->report_hash_algorithm;
  }

  static bool Read(::network::mojom::CSPSourceList::DataView input, ::network::mojom::CSPSourceListPtr* output);
};


template <>
struct  StructTraits<::network::mojom::CSPTrustedTypes::DataView,
                                         ::network::mojom::CSPTrustedTypesPtr> {
  static bool IsNull(const ::network::mojom::CSPTrustedTypesPtr& input) { return !input; }
  static void SetToNull(::network::mojom::CSPTrustedTypesPtr* output) { output->reset(); }

  static const decltype(::network::mojom::CSPTrustedTypes::list)& list(
      const ::network::mojom::CSPTrustedTypesPtr& input) {
    return input->list;
  }

  static decltype(::network::mojom::CSPTrustedTypes::allow_any) allow_any(
      const ::network::mojom::CSPTrustedTypesPtr& input) {
    return input->allow_any;
  }

  static decltype(::network::mojom::CSPTrustedTypes::allow_duplicates) allow_duplicates(
      const ::network::mojom::CSPTrustedTypesPtr& input) {
    return input->allow_duplicates;
  }

  static bool Read(::network::mojom::CSPTrustedTypes::DataView input, ::network::mojom::CSPTrustedTypesPtr* output);
};


template <>
struct  StructTraits<::network::mojom::ContentSecurityPolicy::DataView,
                                         ::network::mojom::ContentSecurityPolicyPtr> {
  static bool IsNull(const ::network::mojom::ContentSecurityPolicyPtr& input) { return !input; }
  static void SetToNull(::network::mojom::ContentSecurityPolicyPtr* output) { output->reset(); }

  static const decltype(::network::mojom::ContentSecurityPolicy::self_origin)& self_origin(
      const ::network::mojom::ContentSecurityPolicyPtr& input) {
    return input->self_origin;
  }

  static const decltype(::network::mojom::ContentSecurityPolicy::raw_directives)& raw_directives(
      const ::network::mojom::ContentSecurityPolicyPtr& input) {
    return input->raw_directives;
  }

  static const decltype(::network::mojom::ContentSecurityPolicy::directives)& directives(
      const ::network::mojom::ContentSecurityPolicyPtr& input) {
    return input->directives;
  }

  static decltype(::network::mojom::ContentSecurityPolicy::upgrade_insecure_requests) upgrade_insecure_requests(
      const ::network::mojom::ContentSecurityPolicyPtr& input) {
    return input->upgrade_insecure_requests;
  }

  static decltype(::network::mojom::ContentSecurityPolicy::treat_as_public_address) treat_as_public_address(
      const ::network::mojom::ContentSecurityPolicyPtr& input) {
    return input->treat_as_public_address;
  }

  static decltype(::network::mojom::ContentSecurityPolicy::block_all_mixed_content) block_all_mixed_content(
      const ::network::mojom::ContentSecurityPolicyPtr& input) {
    return input->block_all_mixed_content;
  }

  static decltype(::network::mojom::ContentSecurityPolicy::sandbox) sandbox(
      const ::network::mojom::ContentSecurityPolicyPtr& input) {
    return input->sandbox;
  }

  static const decltype(::network::mojom::ContentSecurityPolicy::header)& header(
      const ::network::mojom::ContentSecurityPolicyPtr& input) {
    return input->header;
  }

  static decltype(::network::mojom::ContentSecurityPolicy::use_reporting_api) use_reporting_api(
      const ::network::mojom::ContentSecurityPolicyPtr& input) {
    return input->use_reporting_api;
  }

  static const decltype(::network::mojom::ContentSecurityPolicy::report_endpoints)& report_endpoints(
      const ::network::mojom::ContentSecurityPolicyPtr& input) {
    return input->report_endpoints;
  }

  static decltype(::network::mojom::ContentSecurityPolicy::require_trusted_types_for) require_trusted_types_for(
      const ::network::mojom::ContentSecurityPolicyPtr& input) {
    return input->require_trusted_types_for;
  }

  static const decltype(::network::mojom::ContentSecurityPolicy::trusted_types)& trusted_types(
      const ::network::mojom::ContentSecurityPolicyPtr& input) {
    return input->trusted_types;
  }

  static const decltype(::network::mojom::ContentSecurityPolicy::parsing_errors)& parsing_errors(
      const ::network::mojom::ContentSecurityPolicyPtr& input) {
    return input->parsing_errors;
  }

  static bool Read(::network::mojom::ContentSecurityPolicy::DataView input, ::network::mojom::ContentSecurityPolicyPtr* output);
};


template <>
struct  StructTraits<::network::mojom::CSPViolation::DataView,
                                         ::network::mojom::CSPViolationPtr> {
  static bool IsNull(const ::network::mojom::CSPViolationPtr& input) { return !input; }
  static void SetToNull(::network::mojom::CSPViolationPtr* output) { output->reset(); }

  static const decltype(::network::mojom::CSPViolation::directive)& directive(
      const ::network::mojom::CSPViolationPtr& input) {
    return input->directive;
  }

  static const decltype(::network::mojom::CSPViolation::effective_directive)& effective_directive(
      const ::network::mojom::CSPViolationPtr& input) {
    return input->effective_directive;
  }

  static const decltype(::network::mojom::CSPViolation::console_message)& console_message(
      const ::network::mojom::CSPViolationPtr& input) {
    return input->console_message;
  }

  static const decltype(::network::mojom::CSPViolation::blocked_url)& blocked_url(
      const ::network::mojom::CSPViolationPtr& input) {
    return input->blocked_url;
  }

  static const decltype(::network::mojom::CSPViolation::report_endpoints)& report_endpoints(
      const ::network::mojom::CSPViolationPtr& input) {
    return input->report_endpoints;
  }

  static decltype(::network::mojom::CSPViolation::use_reporting_api) use_reporting_api(
      const ::network::mojom::CSPViolationPtr& input) {
    return input->use_reporting_api;
  }

  static const decltype(::network::mojom::CSPViolation::header)& header(
      const ::network::mojom::CSPViolationPtr& input) {
    return input->header;
  }

  static decltype(::network::mojom::CSPViolation::type) type(
      const ::network::mojom::CSPViolationPtr& input) {
    return input->type;
  }

  static const decltype(::network::mojom::CSPViolation::source_location)& source_location(
      const ::network::mojom::CSPViolationPtr& input) {
    return input->source_location;
  }

  static bool Read(::network::mojom::CSPViolation::DataView input, ::network::mojom::CSPViolationPtr* output);
};


template <>
struct  UnionTraits<::network::mojom::AllowCSPFromHeaderValue::DataView,
                                        ::network::mojom::AllowCSPFromHeaderValuePtr> {
  static bool IsNull(const ::network::mojom::AllowCSPFromHeaderValuePtr& input) { return !input; }
  static void SetToNull(::network::mojom::AllowCSPFromHeaderValuePtr* output) { output->reset(); }

  static ::network::mojom::AllowCSPFromHeaderValue::Tag GetTag(const ::network::mojom::AllowCSPFromHeaderValuePtr& input) {
    return input->which();
  }

  static  bool allow_star(const ::network::mojom::AllowCSPFromHeaderValuePtr& input) {
    return input->get_allow_star();
  }

  static const ::url::Origin& origin(const ::network::mojom::AllowCSPFromHeaderValuePtr& input) {
    return input->get_origin();
  }

  static const std::string& error_message(const ::network::mojom::AllowCSPFromHeaderValuePtr& input) {
    return input->get_error_message();
  }

  static bool Read(::network::mojom::AllowCSPFromHeaderValue::DataView input, ::network::mojom::AllowCSPFromHeaderValuePtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_CONTENT_SECURITY_POLICY_MOJOM_H_