// services/network/public/mojom/content_security_policy.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_CONTENT_SECURITY_POLICY_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_CONTENT_SECURITY_POLICY_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/content_security_policy.mojom-shared-internal.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "services/network/public/mojom/integrity_algorithm.mojom-shared.h"
#include "services/network/public/mojom/integrity_metadata.mojom-shared.h"
#include "services/network/public/mojom/source_location.mojom-shared.h"
#include "services/network/public/mojom/web_sandbox_flags.mojom-shared.h"




#include "services/network/public/mojom/content_security_policy.mojom-data-view.h"




namespace std {

template <>
struct hash<::network::mojom::ContentSecurityPolicyType>
    : public mojo::internal::EnumHashImpl<::network::mojom::ContentSecurityPolicyType> {};

template <>
struct hash<::network::mojom::ContentSecurityPolicySource>
    : public mojo::internal::EnumHashImpl<::network::mojom::ContentSecurityPolicySource> {};

template <>
struct hash<::network::mojom::CSPDisposition>
    : public mojo::internal::EnumHashImpl<::network::mojom::CSPDisposition> {};

template <>
struct hash<::network::mojom::CSPDirectiveName>
    : public mojo::internal::EnumHashImpl<::network::mojom::CSPDirectiveName> {};

template <>
struct hash<::network::mojom::CSPRequireTrustedTypesFor>
    : public mojo::internal::EnumHashImpl<::network::mojom::CSPRequireTrustedTypesFor> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::ContentSecurityPolicyType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::ContentSecurityPolicyType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::ContentSecurityPolicyType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::ContentSecurityPolicySource, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::ContentSecurityPolicySource, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::ContentSecurityPolicySource>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CSPDisposition, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::CSPDisposition, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::CSPDisposition>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CSPDirectiveName, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::CSPDirectiveName, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::CSPDirectiveName>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CSPRequireTrustedTypesFor, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::CSPRequireTrustedTypesFor, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::CSPRequireTrustedTypesFor>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::ContentSecurityPolicyHeaderDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::ContentSecurityPolicyHeaderDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::ContentSecurityPolicyHeader_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::header_value(input)) in_header_value = Traits::header_value(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->header_value)::BaseType> header_value_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_header_value,
      header_value_fragment);

    fragment->header_value.Set(
        header_value_fragment.is_null() ? nullptr : header_value_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->header_value.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null header_value in ContentSecurityPolicyHeader struct");

    
    mojo::internal::Serialize<::network::mojom::ContentSecurityPolicyType>(
      Traits::type(input),
      &fragment->type);

    
    mojo::internal::Serialize<::network::mojom::ContentSecurityPolicySource>(
      Traits::source(input),
      &fragment->source);
  }

  static bool Deserialize(::network::mojom::internal::ContentSecurityPolicyHeader_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::ContentSecurityPolicyHeaderDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CSPSourceDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::CSPSourceDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::CSPSource_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::scheme(input)) in_scheme = Traits::scheme(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->scheme)::BaseType> scheme_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_scheme,
      scheme_fragment);

    fragment->scheme.Set(
        scheme_fragment.is_null() ? nullptr : scheme_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->scheme.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null scheme in CSPSource struct");

    decltype(Traits::host(input)) in_host = Traits::host(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->host)::BaseType> host_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_host,
      host_fragment);

    fragment->host.Set(
        host_fragment.is_null() ? nullptr : host_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->host.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null host in CSPSource struct");

    fragment->port = Traits::port(input);

    decltype(Traits::path(input)) in_path = Traits::path(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->path)::BaseType> path_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_path,
      path_fragment);

    fragment->path.Set(
        path_fragment.is_null() ? nullptr : path_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->path.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null path in CSPSource struct");

    fragment->is_host_wildcard = Traits::is_host_wildcard(input);

    fragment->is_port_wildcard = Traits::is_port_wildcard(input);
  }

  static bool Deserialize(::network::mojom::internal::CSPSource_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::CSPSourceDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CSPSourceListDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::CSPSourceListDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::CSPSourceList_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::sources(input)) in_sources = Traits::sources(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->sources)::BaseType>
        sources_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& sources_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::CSPSourceDataView>>(
      in_sources,
      sources_fragment,
      &sources_validate_params);

    fragment->sources.Set(
        sources_fragment.is_null() ? nullptr : sources_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->sources.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null sources in CSPSourceList struct");

    decltype(Traits::nonces(input)) in_nonces = Traits::nonces(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->nonces)::BaseType>
        nonces_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& nonces_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_nonces,
      nonces_fragment,
      &nonces_validate_params);

    fragment->nonces.Set(
        nonces_fragment.is_null() ? nullptr : nonces_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->nonces.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null nonces in CSPSourceList struct");

    decltype(Traits::hashes(input)) in_hashes = Traits::hashes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->hashes)::BaseType>
        hashes_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& hashes_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::IntegrityMetadataDataView>>(
      in_hashes,
      hashes_fragment,
      &hashes_validate_params);

    fragment->hashes.Set(
        hashes_fragment.is_null() ? nullptr : hashes_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->hashes.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null hashes in CSPSourceList struct");

    decltype(Traits::url_hashes(input)) in_url_hashes = Traits::url_hashes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url_hashes)::BaseType>
        url_hashes_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& url_hashes_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::IntegrityMetadataDataView>>(
      in_url_hashes,
      url_hashes_fragment,
      &url_hashes_validate_params);

    fragment->url_hashes.Set(
        url_hashes_fragment.is_null() ? nullptr : url_hashes_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url_hashes.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url_hashes in CSPSourceList struct");

    decltype(Traits::eval_hashes(input)) in_eval_hashes = Traits::eval_hashes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->eval_hashes)::BaseType>
        eval_hashes_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& eval_hashes_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::IntegrityMetadataDataView>>(
      in_eval_hashes,
      eval_hashes_fragment,
      &eval_hashes_validate_params);

    fragment->eval_hashes.Set(
        eval_hashes_fragment.is_null() ? nullptr : eval_hashes_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->eval_hashes.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null eval_hashes in CSPSourceList struct");

    fragment->allow_self = Traits::allow_self(input);

    fragment->allow_star = Traits::allow_star(input);

    fragment->allow_inline = Traits::allow_inline(input);

    fragment->allow_inline_speculation_rules = Traits::allow_inline_speculation_rules(input);

    fragment->allow_eval = Traits::allow_eval(input);

    fragment->allow_wasm_eval = Traits::allow_wasm_eval(input);

    fragment->allow_wasm_unsafe_eval = Traits::allow_wasm_unsafe_eval(input);

    fragment->allow_dynamic = Traits::allow_dynamic(input);

    fragment->allow_dynamic_url = Traits::allow_dynamic_url(input);

    fragment->allow_unsafe_hashes = Traits::allow_unsafe_hashes(input);

    fragment->report_sample = Traits::report_sample(input);
    fragment->report_hash_algorithm_$flag = Traits::report_hash_algorithm(input).has_value();
    if (Traits::report_hash_algorithm(input).has_value()) {
      
      mojo::internal::Serialize<::network::mojom::IntegrityAlgorithm>(
        Traits::report_hash_algorithm(input).value(),
        &fragment->report_hash_algorithm_$value);
    } else {
      fragment->report_hash_algorithm_$value =
          static_cast<int32_t>(::network::mojom::IntegrityAlgorithm::kMinValue);
    }
  }

  static bool Deserialize(::network::mojom::internal::CSPSourceList_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::CSPSourceListDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CSPTrustedTypesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::CSPTrustedTypesDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::CSPTrustedTypes_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::list(input)) in_list = Traits::list(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->list)::BaseType>
        list_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& list_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_list,
      list_fragment,
      &list_validate_params);

    fragment->list.Set(
        list_fragment.is_null() ? nullptr : list_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->list.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null list in CSPTrustedTypes struct");

    fragment->allow_any = Traits::allow_any(input);

    fragment->allow_duplicates = Traits::allow_duplicates(input);
  }

  static bool Deserialize(::network::mojom::internal::CSPTrustedTypes_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::CSPTrustedTypesDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::ContentSecurityPolicyDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::ContentSecurityPolicyDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::ContentSecurityPolicy_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::self_origin(input)) in_self_origin = Traits::self_origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->self_origin)::BaseType> self_origin_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::CSPSourceDataView>(
      in_self_origin,
      self_origin_fragment);

    fragment->self_origin.Set(
        self_origin_fragment.is_null() ? nullptr : self_origin_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->self_origin.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null self_origin in ContentSecurityPolicy struct");

    decltype(Traits::raw_directives(input)) in_raw_directives = Traits::raw_directives(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->raw_directives)::BaseType>
        raw_directives_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& raw_directives_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayOfEnumsValidator<0, false, ::network::mojom::internal::CSPDirectiveName_Data::Validate>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<::network::mojom::CSPDirectiveName, mojo::StringDataView>>(
      in_raw_directives,
      raw_directives_fragment,
      &raw_directives_validate_params);

    fragment->raw_directives.Set(
        raw_directives_fragment.is_null() ? nullptr : raw_directives_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->raw_directives.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null raw_directives in ContentSecurityPolicy struct");

    decltype(Traits::directives(input)) in_directives = Traits::directives(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->directives)::BaseType>
        directives_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& directives_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayOfEnumsValidator<0, false, ::network::mojom::internal::CSPDirectiveName_Data::Validate>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<::network::mojom::CSPDirectiveName, ::network::mojom::CSPSourceListDataView>>(
      in_directives,
      directives_fragment,
      &directives_validate_params);

    fragment->directives.Set(
        directives_fragment.is_null() ? nullptr : directives_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->directives.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null directives in ContentSecurityPolicy struct");

    fragment->upgrade_insecure_requests = Traits::upgrade_insecure_requests(input);

    fragment->treat_as_public_address = Traits::treat_as_public_address(input);

    fragment->block_all_mixed_content = Traits::block_all_mixed_content(input);

    
    mojo::internal::Serialize<::network::mojom::WebSandboxFlags>(
      Traits::sandbox(input),
      &fragment->sandbox);

    decltype(Traits::header(input)) in_header = Traits::header(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->header)::BaseType> header_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::ContentSecurityPolicyHeaderDataView>(
      in_header,
      header_fragment);

    fragment->header.Set(
        header_fragment.is_null() ? nullptr : header_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->header.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null header in ContentSecurityPolicy struct");

    fragment->use_reporting_api = Traits::use_reporting_api(input);

    decltype(Traits::report_endpoints(input)) in_report_endpoints = Traits::report_endpoints(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->report_endpoints)::BaseType>
        report_endpoints_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& report_endpoints_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_report_endpoints,
      report_endpoints_fragment,
      &report_endpoints_validate_params);

    fragment->report_endpoints.Set(
        report_endpoints_fragment.is_null() ? nullptr : report_endpoints_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->report_endpoints.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null report_endpoints in ContentSecurityPolicy struct");

    
    mojo::internal::Serialize<::network::mojom::CSPRequireTrustedTypesFor>(
      Traits::require_trusted_types_for(input),
      &fragment->require_trusted_types_for);

    decltype(Traits::trusted_types(input)) in_trusted_types = Traits::trusted_types(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->trusted_types)::BaseType> trusted_types_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::CSPTrustedTypesDataView>(
      in_trusted_types,
      trusted_types_fragment);

    fragment->trusted_types.Set(
        trusted_types_fragment.is_null() ? nullptr : trusted_types_fragment.data());

    decltype(Traits::parsing_errors(input)) in_parsing_errors = Traits::parsing_errors(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->parsing_errors)::BaseType>
        parsing_errors_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& parsing_errors_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_parsing_errors,
      parsing_errors_fragment,
      &parsing_errors_validate_params);

    fragment->parsing_errors.Set(
        parsing_errors_fragment.is_null() ? nullptr : parsing_errors_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->parsing_errors.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null parsing_errors in ContentSecurityPolicy struct");
  }

  static bool Deserialize(::network::mojom::internal::ContentSecurityPolicy_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::ContentSecurityPolicyDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::CSPViolationDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::CSPViolationDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::CSPViolation_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::directive(input)) in_directive = Traits::directive(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->directive)::BaseType> directive_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_directive,
      directive_fragment);

    fragment->directive.Set(
        directive_fragment.is_null() ? nullptr : directive_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->directive.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null directive in CSPViolation struct");

    decltype(Traits::effective_directive(input)) in_effective_directive = Traits::effective_directive(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->effective_directive)::BaseType> effective_directive_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_effective_directive,
      effective_directive_fragment);

    fragment->effective_directive.Set(
        effective_directive_fragment.is_null() ? nullptr : effective_directive_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->effective_directive.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null effective_directive in CSPViolation struct");

    decltype(Traits::console_message(input)) in_console_message = Traits::console_message(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->console_message)::BaseType> console_message_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_console_message,
      console_message_fragment);

    fragment->console_message.Set(
        console_message_fragment.is_null() ? nullptr : console_message_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->console_message.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null console_message in CSPViolation struct");

    decltype(Traits::blocked_url(input)) in_blocked_url = Traits::blocked_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->blocked_url)::BaseType> blocked_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_blocked_url,
      blocked_url_fragment);

    fragment->blocked_url.Set(
        blocked_url_fragment.is_null() ? nullptr : blocked_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->blocked_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null blocked_url in CSPViolation struct");

    decltype(Traits::report_endpoints(input)) in_report_endpoints = Traits::report_endpoints(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->report_endpoints)::BaseType>
        report_endpoints_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& report_endpoints_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_report_endpoints,
      report_endpoints_fragment,
      &report_endpoints_validate_params);

    fragment->report_endpoints.Set(
        report_endpoints_fragment.is_null() ? nullptr : report_endpoints_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->report_endpoints.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null report_endpoints in CSPViolation struct");

    fragment->use_reporting_api = Traits::use_reporting_api(input);

    decltype(Traits::header(input)) in_header = Traits::header(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->header)::BaseType> header_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_header,
      header_fragment);

    fragment->header.Set(
        header_fragment.is_null() ? nullptr : header_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->header.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null header in CSPViolation struct");

    
    mojo::internal::Serialize<::network::mojom::ContentSecurityPolicyType>(
      Traits::type(input),
      &fragment->type);

    decltype(Traits::source_location(input)) in_source_location = Traits::source_location(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->source_location)::BaseType> source_location_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::SourceLocationDataView>(
      in_source_location,
      source_location_fragment);

    fragment->source_location.Set(
        source_location_fragment.is_null() ? nullptr : source_location_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->source_location.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null source_location in CSPViolation struct");
  }

  static bool Deserialize(::network::mojom::internal::CSPViolation_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::CSPViolationDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::AllowCSPFromHeaderValueDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::network::mojom::AllowCSPFromHeaderValueDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::network::mojom::internal::AllowCSPFromHeaderValue_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::network::mojom::AllowCSPFromHeaderValueDataView::Tag::kAllowStar: {
    decltype(Traits::allow_star(input))
    in_allow_star = Traits::allow_star(input);
    fragment->data.f_allow_star = in_allow_star;
    break;
  }
  case ::network::mojom::AllowCSPFromHeaderValueDataView::Tag::kOrigin: {
    decltype(Traits::origin(input))
    in_origin = Traits::origin(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_origin)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::url::mojom::OriginDataView>(
  in_origin,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null origin in AllowCSPFromHeaderValue union");
    fragment->data.f_origin.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::network::mojom::AllowCSPFromHeaderValueDataView::Tag::kErrorMessage: {
    decltype(Traits::error_message(input))
    in_error_message = Traits::error_message(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_error_message)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<mojo::StringDataView>(
  in_error_message,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null error_message in AllowCSPFromHeaderValue union");
    fragment->data.f_error_message.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::network::mojom::internal::AllowCSPFromHeaderValue_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::AllowCSPFromHeaderValueDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {

inline void ContentSecurityPolicyHeaderDataView::GetHeaderValueDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->header_value.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void CSPSourceDataView::GetSchemeDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->scheme.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void CSPSourceDataView::GetHostDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->host.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void CSPSourceDataView::GetPathDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->path.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void CSPSourceListDataView::GetSourcesDataView(
    mojo::ArrayDataView<CSPSourceDataView>* output) {
  auto pointer = data_->sources.Get();
  *output = mojo::ArrayDataView<CSPSourceDataView>(pointer, message_);
}
inline void CSPSourceListDataView::GetNoncesDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->nonces.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}
inline void CSPSourceListDataView::GetHashesDataView(
    mojo::ArrayDataView<::network::mojom::IntegrityMetadataDataView>* output) {
  auto pointer = data_->hashes.Get();
  *output = mojo::ArrayDataView<::network::mojom::IntegrityMetadataDataView>(pointer, message_);
}
inline void CSPSourceListDataView::GetUrlHashesDataView(
    mojo::ArrayDataView<::network::mojom::IntegrityMetadataDataView>* output) {
  auto pointer = data_->url_hashes.Get();
  *output = mojo::ArrayDataView<::network::mojom::IntegrityMetadataDataView>(pointer, message_);
}
inline void CSPSourceListDataView::GetEvalHashesDataView(
    mojo::ArrayDataView<::network::mojom::IntegrityMetadataDataView>* output) {
  auto pointer = data_->eval_hashes.Get();
  *output = mojo::ArrayDataView<::network::mojom::IntegrityMetadataDataView>(pointer, message_);
}


inline void CSPTrustedTypesDataView::GetListDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->list.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}


inline void ContentSecurityPolicyDataView::GetSelfOriginDataView(
    CSPSourceDataView* output) {
  auto pointer = data_->self_origin.Get();
  *output = CSPSourceDataView(pointer, message_);
}
inline void ContentSecurityPolicyDataView::GetRawDirectivesDataView(
    mojo::MapDataView<CSPDirectiveName, mojo::StringDataView>* output) {
  auto pointer = data_->raw_directives.Get();
  *output = mojo::MapDataView<CSPDirectiveName, mojo::StringDataView>(pointer, message_);
}
inline void ContentSecurityPolicyDataView::GetDirectivesDataView(
    mojo::MapDataView<CSPDirectiveName, CSPSourceListDataView>* output) {
  auto pointer = data_->directives.Get();
  *output = mojo::MapDataView<CSPDirectiveName, CSPSourceListDataView>(pointer, message_);
}
inline void ContentSecurityPolicyDataView::GetHeaderDataView(
    ContentSecurityPolicyHeaderDataView* output) {
  auto pointer = data_->header.Get();
  *output = ContentSecurityPolicyHeaderDataView(pointer, message_);
}
inline void ContentSecurityPolicyDataView::GetReportEndpointsDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->report_endpoints.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}
inline void ContentSecurityPolicyDataView::GetTrustedTypesDataView(
    CSPTrustedTypesDataView* output) {
  auto pointer = data_->trusted_types.Get();
  *output = CSPTrustedTypesDataView(pointer, message_);
}
inline void ContentSecurityPolicyDataView::GetParsingErrorsDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->parsing_errors.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}


inline void CSPViolationDataView::GetDirectiveDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->directive.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void CSPViolationDataView::GetEffectiveDirectiveDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->effective_directive.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void CSPViolationDataView::GetConsoleMessageDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->console_message.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void CSPViolationDataView::GetBlockedUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->blocked_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void CSPViolationDataView::GetReportEndpointsDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->report_endpoints.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}
inline void CSPViolationDataView::GetHeaderDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->header.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void CSPViolationDataView::GetSourceLocationDataView(
    ::network::mojom::SourceLocationDataView* output) {
  auto pointer = data_->source_location.Get();
  *output = ::network::mojom::SourceLocationDataView(pointer, message_);
}


inline void AllowCSPFromHeaderValueDataView::GetOriginDataView(
    ::url::mojom::OriginDataView* output) const {
  CHECK(is_origin());
  *output = ::url::mojom::OriginDataView(data_->data.f_origin.Get(), message_);
}
inline void AllowCSPFromHeaderValueDataView::GetErrorMessageDataView(
    mojo::StringDataView* output) const {
  CHECK(is_error_message());
  *output = mojo::StringDataView(data_->data.f_error_message.Get(), message_);
}


}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::ContentSecurityPolicyType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::ContentSecurityPolicyType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::ContentSecurityPolicySource> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::ContentSecurityPolicySource value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::CSPDisposition> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::CSPDisposition value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::CSPDirectiveName> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::CSPDirectiveName value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::CSPRequireTrustedTypesFor> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::CSPRequireTrustedTypesFor value);
};

} // namespace perfetto

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_CONTENT_SECURITY_POLICY_MOJOM_SHARED_H_