// services/network/public/mojom/content_security_policy.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_CONTENT_SECURITY_POLICY_MOJOM_SHARED_INTERNAL_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_CONTENT_SECURITY_POLICY_MOJOM_SHARED_INTERNAL_H_
#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/message_fragment.h"
#include "mojo/public/c/system/macros.h"
#include "url/mojom/origin.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared-internal.h"
#include "services/network/public/mojom/integrity_algorithm.mojom-shared-internal.h"
#include "services/network/public/mojom/integrity_metadata.mojom-shared-internal.h"
#include "services/network/public/mojom/source_location.mojom-shared-internal.h"
#include "services/network/public/mojom/web_sandbox_flags.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}


namespace network::mojom {
namespace internal {
class ContentSecurityPolicyHeader_Data;
class CSPSource_Data;
class CSPSourceList_Data;
class CSPTrustedTypes_Data;
class ContentSecurityPolicy_Data;
class CSPViolation_Data;
class AllowCSPFromHeaderValue_Data;

struct ContentSecurityPolicyType_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct ContentSecurityPolicySource_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct CSPDisposition_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct CSPDirectiveName_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
      case 3:
      case 4:
      case 5:
      case 6:
      case 7:
      case 8:
      case 9:
      case 10:
      case 11:
      case 12:
      case 13:
      case 14:
      case 15:
      case 16:
      case 17:
      case 18:
      case 19:
      case 20:
      case 21:
      case 22:
      case 23:
      case 24:
      case 25:
      case 26:
      case 27:
      case 28:
      case 29:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

struct CSPRequireTrustedTypesFor_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

#pragma pack(push, 1)


class  AllowCSPFromHeaderValue_Data {
 public:
  // Used to identify Mojom Union Data Classes.
  typedef void MojomUnionDataType;

  AllowCSPFromHeaderValue_Data() = default;
  // Do nothing in the destructor since it won't be called when it is a
  // non-inlined union.
  ~AllowCSPFromHeaderValue_Data() = default;

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context,
                       bool inlined);

  bool is_null() const { return size == 0; }

  void set_null() {
    size = 0U;
    tag = static_cast<AllowCSPFromHeaderValue_Tag>(0);
    data.unknown = 0U;
  }

  // TODO(crbug.com/40731316): SHOUTY_CASE values are being deprecated per C++ code style
  // guidelines (https://google.github.io/styleguide/cppguide.html#Enumerator_Names),
  // please use kCamelCase values instead.  Cleanup NULL_VALUE, BOOL_VALUE, INT_VALUE, etc.
  // generation once codebase is transitioned to kNullValue, kBoolValue, kIntValue, etc.
  enum class AllowCSPFromHeaderValue_Tag : uint32_t {

    
    kAllowStar,
    
    kOrigin,
    
    kErrorMessage,
  };

  // A note on layout:
  // "Each non-static data member is allocated as if it were the sole member of
  // a struct." - Section 9.5.2 ISO/IEC 14882:2011 (The C++ Spec)
  union MOJO_ALIGNAS(8) Union_ {
    Union_() : unknown(0) {}
    uint8_t f_allow_star : 1;
    mojo::internal::Pointer<::url::mojom::internal::Origin_Data> f_origin;
    mojo::internal::Pointer<mojo::internal::String_Data> f_error_message;
    uint64_t unknown;
  };

  uint32_t size;
  AllowCSPFromHeaderValue_Tag tag;
  Union_ data;
};
static_assert(sizeof(AllowCSPFromHeaderValue_Data) == mojo::internal::kUnionDataSize,
              "Bad sizeof(AllowCSPFromHeaderValue_Data)");
class  ContentSecurityPolicyHeader_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> header_value;
  int32_t type;
  int32_t source;

 private:
  friend class mojo::internal::MessageFragment<ContentSecurityPolicyHeader_Data>;

  ContentSecurityPolicyHeader_Data();
  ~ContentSecurityPolicyHeader_Data() = delete;
};
static_assert(sizeof(ContentSecurityPolicyHeader_Data) == 24,
              "Bad sizeof(ContentSecurityPolicyHeader_Data)");
// Used by ContentSecurityPolicyHeader::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct ContentSecurityPolicyHeader_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  ContentSecurityPolicyHeader_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~ContentSecurityPolicyHeader_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<ContentSecurityPolicyHeader_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    ContentSecurityPolicyHeader_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  CSPSource_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> scheme;
  mojo::internal::Pointer<mojo::internal::String_Data> host;
  int32_t port;
  uint8_t is_host_wildcard : 1;
  uint8_t is_port_wildcard : 1;
  uint8_t pad4_[3];
  mojo::internal::Pointer<mojo::internal::String_Data> path;

 private:
  friend class mojo::internal::MessageFragment<CSPSource_Data>;

  CSPSource_Data();
  ~CSPSource_Data() = delete;
};
static_assert(sizeof(CSPSource_Data) == 40,
              "Bad sizeof(CSPSource_Data)");
// Used by CSPSource::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct CSPSource_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  CSPSource_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~CSPSource_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<CSPSource_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    CSPSource_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  CSPSourceList_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::CSPSource_Data>>> sources;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<mojo::internal::String_Data>>> nonces;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::network::mojom::internal::IntegrityMetadata_Data>>> hashes;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::network::mojom::internal::IntegrityMetadata_Data>>> url_hashes;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::network::mojom::internal::IntegrityMetadata_Data>>> eval_hashes;
  uint8_t allow_self : 1;
  uint8_t allow_star : 1;
  uint8_t allow_inline : 1;
  uint8_t allow_inline_speculation_rules : 1;
  uint8_t allow_eval : 1;
  uint8_t allow_wasm_eval : 1;
  uint8_t allow_wasm_unsafe_eval : 1;
  uint8_t allow_dynamic : 1;
  uint8_t allow_dynamic_url : 1;
  uint8_t allow_unsafe_hashes : 1;
  uint8_t report_sample : 1;
  uint8_t report_hash_algorithm_$flag : 1;
  uint8_t pad16_[2];
  int32_t report_hash_algorithm_$value;

 private:
  friend class mojo::internal::MessageFragment<CSPSourceList_Data>;

  CSPSourceList_Data();
  ~CSPSourceList_Data() = delete;
};
static_assert(sizeof(CSPSourceList_Data) == 56,
              "Bad sizeof(CSPSourceList_Data)");
// Used by CSPSourceList::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct CSPSourceList_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  CSPSourceList_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~CSPSourceList_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<CSPSourceList_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    CSPSourceList_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  CSPTrustedTypes_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<mojo::internal::String_Data>>> list;
  uint8_t allow_any : 1;
  uint8_t allow_duplicates : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<CSPTrustedTypes_Data>;

  CSPTrustedTypes_Data();
  ~CSPTrustedTypes_Data() = delete;
};
static_assert(sizeof(CSPTrustedTypes_Data) == 24,
              "Bad sizeof(CSPTrustedTypes_Data)");
// Used by CSPTrustedTypes::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct CSPTrustedTypes_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  CSPTrustedTypes_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~CSPTrustedTypes_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<CSPTrustedTypes_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    CSPTrustedTypes_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  ContentSecurityPolicy_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::CSPSource_Data> self_origin;
  mojo::internal::Pointer<mojo::internal::Map_Data<int32_t, mojo::internal::Pointer<mojo::internal::String_Data>>> raw_directives;
  mojo::internal::Pointer<mojo::internal::Map_Data<int32_t, mojo::internal::Pointer<internal::CSPSourceList_Data>>> directives;
  uint8_t upgrade_insecure_requests : 1;
  uint8_t treat_as_public_address : 1;
  uint8_t block_all_mixed_content : 1;
  uint8_t use_reporting_api : 1;
  uint8_t pad6_[3];
  int32_t sandbox;
  mojo::internal::Pointer<internal::ContentSecurityPolicyHeader_Data> header;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<mojo::internal::String_Data>>> report_endpoints;
  int32_t require_trusted_types_for;
  uint8_t pad10_[4];
  mojo::internal::Pointer<internal::CSPTrustedTypes_Data> trusted_types;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<mojo::internal::String_Data>>> parsing_errors;

 private:
  friend class mojo::internal::MessageFragment<ContentSecurityPolicy_Data>;

  ContentSecurityPolicy_Data();
  ~ContentSecurityPolicy_Data() = delete;
};
static_assert(sizeof(ContentSecurityPolicy_Data) == 80,
              "Bad sizeof(ContentSecurityPolicy_Data)");
// Used by ContentSecurityPolicy::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct ContentSecurityPolicy_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  ContentSecurityPolicy_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~ContentSecurityPolicy_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<ContentSecurityPolicy_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    ContentSecurityPolicy_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  CSPViolation_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> directive;
  mojo::internal::Pointer<mojo::internal::String_Data> effective_directive;
  mojo::internal::Pointer<mojo::internal::String_Data> console_message;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> blocked_url;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<mojo::internal::String_Data>>> report_endpoints;
  uint8_t use_reporting_api : 1;
  uint8_t pad5_[3];
  int32_t type;
  mojo::internal::Pointer<mojo::internal::String_Data> header;
  mojo::internal::Pointer<::network::mojom::internal::SourceLocation_Data> source_location;

 private:
  friend class mojo::internal::MessageFragment<CSPViolation_Data>;

  CSPViolation_Data();
  ~CSPViolation_Data() = delete;
};
static_assert(sizeof(CSPViolation_Data) == 72,
              "Bad sizeof(CSPViolation_Data)");
// Used by CSPViolation::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct CSPViolation_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  CSPViolation_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~CSPViolation_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<CSPViolation_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    CSPViolation_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal

}  // network::mojom

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_CONTENT_SECURITY_POLICY_MOJOM_SHARED_INTERNAL_H_