// services/network/public/mojom/content_security_policy.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('network.mojom');





/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
network.mojom.ContentSecurityPolicyTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
network.mojom.ContentSecurityPolicyType = {
  
  kReport: 0,
  kEnforce: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
network.mojom.ContentSecurityPolicySourceSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
network.mojom.ContentSecurityPolicySource = {
  
  kHTTP: 0,
  kMeta: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
network.mojom.CSPDispositionSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
network.mojom.CSPDisposition = {
  
  CHECK: 0,
  DO_NOT_CHECK: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
network.mojom.CSPDirectiveNameSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
network.mojom.CSPDirectiveName = {
  
  Unknown: 0,
  BaseURI: 1,
  BlockAllMixedContent: 2,
  ChildSrc: 3,
  ConnectSrc: 4,
  DefaultSrc: 5,
  FencedFrameSrc: 6,
  FontSrc: 7,
  FormAction: 8,
  FrameAncestors: 9,
  FrameSrc: 10,
  ImgSrc: 11,
  ManifestSrc: 12,
  MediaSrc: 13,
  ObjectSrc: 14,
  ReportTo: 15,
  ReportURI: 16,
  RequireTrustedTypesFor: 17,
  Sandbox: 18,
  ScriptSrc: 19,
  ScriptSrcV2: 20,
  ScriptSrcAttr: 21,
  ScriptSrcElem: 22,
  StyleSrc: 23,
  StyleSrcAttr: 24,
  StyleSrcElem: 25,
  TreatAsPublicAddress: 26,
  TrustedTypes: 27,
  UpgradeInsecureRequests: 28,
  WorkerSrc: 29,
  MIN_VALUE: 0,
  MAX_VALUE: 29,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
network.mojom.CSPRequireTrustedTypesForSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
network.mojom.CSPRequireTrustedTypesFor = {
  
  None: 0,
  Script: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};




/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.ContentSecurityPolicyHeaderSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.CSPSourceSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.CSPSourceListSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.CSPTrustedTypesSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.ContentSecurityPolicySpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.CSPViolationSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
network.mojom.AllowCSPFromHeaderValueSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    network.mojom.ContentSecurityPolicyHeaderSpec.$,
    'ContentSecurityPolicyHeader',
    [
      mojo.internal.StructField(
        'headerValue', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'type', 8,
        0,
        network.mojom.ContentSecurityPolicyTypeSpec.$,
        network.mojom.ContentSecurityPolicyType.kEnforce,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'source', 12,
        0,
        network.mojom.ContentSecurityPolicySourceSpec.$,
        network.mojom.ContentSecurityPolicySource.kHTTP,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
network.mojom.ContentSecurityPolicyHeader = class {
  constructor() {
    /** @export { !string } */
    this.headerValue;
    /** @export { !network.mojom.ContentSecurityPolicyType } */
    this.type;
    /** @export { !network.mojom.ContentSecurityPolicySource } */
    this.source;
  }
};



mojo.internal.Struct(
    network.mojom.CSPSourceSpec.$,
    'CSPSource',
    [
      mojo.internal.StructField(
        'scheme', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'host', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'port', 16,
        0,
        mojo.internal.Int32,
        -1,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'path', 24,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isHostWildcard', 20,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'isPortWildcard', 20,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
network.mojom.CSPSource = class {
  constructor() {
    /** @export { !string } */
    this.scheme;
    /** @export { !string } */
    this.host;
    /** @export { !number } */
    this.port;
    /** @export { !string } */
    this.path;
    /** @export { !boolean } */
    this.isHostWildcard;
    /** @export { !boolean } */
    this.isPortWildcard;
  }
};



mojo.internal.Struct(
    network.mojom.CSPSourceListSpec.$,
    'CSPSourceList',
    [
      mojo.internal.StructField(
        'sources', 0,
        0,
        mojo.internal.Array(network.mojom.CSPSourceSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'nonces', 8,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hashes', 16,
        0,
        mojo.internal.Array(network.mojom.IntegrityMetadataSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'urlHashes', 24,
        0,
        mojo.internal.Array(network.mojom.IntegrityMetadataSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'evalHashes', 32,
        0,
        mojo.internal.Array(network.mojom.IntegrityMetadataSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'allowSelf', 40,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'allowStar', 40,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'allowInline', 40,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'allowInlineSpeculationRules', 40,
        3,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'allowEval', 40,
        4,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'allowWasmEval', 40,
        5,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'allowWasmUnsafeEval', 40,
        6,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'allowDynamic', 40,
        7,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'allowDynamicUrl', 41,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'allowUnsafeHashes', 41,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'reportSample', 41,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'report_hash_algorithm_$flag', 41,
        3,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: true,
          linkedValueFieldName: "report_hash_algorithm_$value",
          originalFieldName: "reportHashAlgorithm",
        }
      ),
      mojo.internal.StructField(
        'report_hash_algorithm_$value', 44,
        0,
        network.mojom.IntegrityAlgorithmSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
        {
          isPrimary: false,
          originalFieldName: "reportHashAlgorithm",
        }
      ),
    ],
    [[0, 56],]);





/** @record */
network.mojom.CSPSourceList = class {
  constructor() {
    /** @export { !Array<!network.mojom.CSPSource> } */
    this.sources;
    /** @export { !Array<!string> } */
    this.nonces;
    /** @export { !Array<!network.mojom.IntegrityMetadata> } */
    this.hashes;
    /** @export { !Array<!network.mojom.IntegrityMetadata> } */
    this.urlHashes;
    /** @export { !Array<!network.mojom.IntegrityMetadata> } */
    this.evalHashes;
    /** @export { !boolean } */
    this.allowSelf;
    /** @export { !boolean } */
    this.allowStar;
    /** @export { !boolean } */
    this.allowInline;
    /** @export { !boolean } */
    this.allowInlineSpeculationRules;
    /** @export { !boolean } */
    this.allowEval;
    /** @export { !boolean } */
    this.allowWasmEval;
    /** @export { !boolean } */
    this.allowWasmUnsafeEval;
    /** @export { !boolean } */
    this.allowDynamic;
    /** @export { !boolean } */
    this.allowDynamicUrl;
    /** @export { !boolean } */
    this.allowUnsafeHashes;
    /** @export { !boolean } */
    this.reportSample;
    /** @export { (network.mojom.IntegrityAlgorithm|undefined) } */
    this.reportHashAlgorithm;
  }
};



mojo.internal.Struct(
    network.mojom.CSPTrustedTypesSpec.$,
    'CSPTrustedTypes',
    [
      mojo.internal.StructField(
        'list', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'allowAny', 8,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'allowDuplicates', 8,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
network.mojom.CSPTrustedTypes = class {
  constructor() {
    /** @export { !Array<!string> } */
    this.list;
    /** @export { !boolean } */
    this.allowAny;
    /** @export { !boolean } */
    this.allowDuplicates;
  }
};



mojo.internal.Struct(
    network.mojom.ContentSecurityPolicySpec.$,
    'ContentSecurityPolicy',
    [
      mojo.internal.StructField(
        'selfOrigin', 0,
        0,
        network.mojom.CSPSourceSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'rawDirectives', 8,
        0,
        mojo.internal.Map(network.mojom.CSPDirectiveNameSpec.$, mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'directives', 16,
        0,
        mojo.internal.Map(network.mojom.CSPDirectiveNameSpec.$, network.mojom.CSPSourceListSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'upgradeInsecureRequests', 24,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'treatAsPublicAddress', 24,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'blockAllMixedContent', 24,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sandbox', 28,
        0,
        network.mojom.WebSandboxFlagsSpec.$,
        network.mojom.WebSandboxFlags.kNone,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'header', 32,
        0,
        network.mojom.ContentSecurityPolicyHeaderSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'useReportingApi', 24,
        3,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'reportEndpoints', 40,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'requireTrustedTypesFor', 48,
        0,
        network.mojom.CSPRequireTrustedTypesForSpec.$,
        network.mojom.CSPRequireTrustedTypesFor.None,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'trustedTypes', 56,
        0,
        network.mojom.CSPTrustedTypesSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'parsingErrors', 64,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 80],]);





/** @record */
network.mojom.ContentSecurityPolicy = class {
  constructor() {
    /** @export { !network.mojom.CSPSource } */
    this.selfOrigin;
    /** @export { !Object<!network.mojom.CSPDirectiveName, !string> } */
    this.rawDirectives;
    /** @export { !Object<!network.mojom.CSPDirectiveName, !network.mojom.CSPSourceList> } */
    this.directives;
    /** @export { !boolean } */
    this.upgradeInsecureRequests;
    /** @export { !boolean } */
    this.treatAsPublicAddress;
    /** @export { !boolean } */
    this.blockAllMixedContent;
    /** @export { !network.mojom.WebSandboxFlags } */
    this.sandbox;
    /** @export { !network.mojom.ContentSecurityPolicyHeader } */
    this.header;
    /** @export { !boolean } */
    this.useReportingApi;
    /** @export { !Array<!string> } */
    this.reportEndpoints;
    /** @export { !network.mojom.CSPRequireTrustedTypesFor } */
    this.requireTrustedTypesFor;
    /** @export { (network.mojom.CSPTrustedTypes|undefined) } */
    this.trustedTypes;
    /** @export { !Array<!string> } */
    this.parsingErrors;
  }
};



mojo.internal.Struct(
    network.mojom.CSPViolationSpec.$,
    'CSPViolation',
    [
      mojo.internal.StructField(
        'directive', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'effectiveDirective', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'consoleMessage', 16,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'blockedUrl', 24,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'reportEndpoints', 32,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'useReportingApi', 40,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'header', 48,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'type', 44,
        0,
        network.mojom.ContentSecurityPolicyTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sourceLocation', 56,
        0,
        network.mojom.SourceLocationSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 72],]);





/** @record */
network.mojom.CSPViolation = class {
  constructor() {
    /** @export { !string } */
    this.directive;
    /** @export { !string } */
    this.effectiveDirective;
    /** @export { !string } */
    this.consoleMessage;
    /** @export { !url.mojom.Url } */
    this.blockedUrl;
    /** @export { !Array<!string> } */
    this.reportEndpoints;
    /** @export { !boolean } */
    this.useReportingApi;
    /** @export { !string } */
    this.header;
    /** @export { !network.mojom.ContentSecurityPolicyType } */
    this.type;
    /** @export { !network.mojom.SourceLocation } */
    this.sourceLocation;
  }
};



mojo.internal.Union(
    network.mojom.AllowCSPFromHeaderValueSpec.$, 'AllowCSPFromHeaderValue',
    {
      'allowStar': {
        'ordinal': 0,
        'type': mojo.internal.Bool,
      },
      'origin': {
        'ordinal': 1,
        'type': url.mojom.OriginSpec.$,
      },
      'errorMessage': {
        'ordinal': 2,
        'type': mojo.internal.String,
      },
    });

/**
 * @typedef { {
 *   allowStar: (!boolean|undefined),
 *   origin: (!url.mojom.Origin|undefined),
 *   errorMessage: (!string|undefined),
 * } }
 */
network.mojom.AllowCSPFromHeaderValue;
