// services/network/public/mojom/connection_endpoint_metadata.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_CONNECTION_ENDPOINT_METADATA_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_CONNECTION_ENDPOINT_METADATA_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/connection_endpoint_metadata.mojom-shared-internal.h"




#include "services/network/public/mojom/connection_endpoint_metadata.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::ConnectionEndpointMetadataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::ConnectionEndpointMetadataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::ConnectionEndpointMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::supported_protocol_alpns(input)) in_supported_protocol_alpns = Traits::supported_protocol_alpns(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->supported_protocol_alpns)::BaseType>
        supported_protocol_alpns_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& supported_protocol_alpns_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_supported_protocol_alpns,
      supported_protocol_alpns_fragment,
      &supported_protocol_alpns_validate_params);

    fragment->supported_protocol_alpns.Set(
        supported_protocol_alpns_fragment.is_null() ? nullptr : supported_protocol_alpns_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->supported_protocol_alpns.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null supported_protocol_alpns in ConnectionEndpointMetadata struct");

    decltype(Traits::ech_config_list(input)) in_ech_config_list = Traits::ech_config_list(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->ech_config_list)::BaseType>
        ech_config_list_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& ech_config_list_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_ech_config_list,
      ech_config_list_fragment,
      &ech_config_list_validate_params);

    fragment->ech_config_list.Set(
        ech_config_list_fragment.is_null() ? nullptr : ech_config_list_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->ech_config_list.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null ech_config_list in ConnectionEndpointMetadata struct");

    decltype(Traits::target_name(input)) in_target_name = Traits::target_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->target_name)::BaseType> target_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_target_name,
      target_name_fragment);

    fragment->target_name.Set(
        target_name_fragment.is_null() ? nullptr : target_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->target_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null target_name in ConnectionEndpointMetadata struct");

    decltype(Traits::trust_anchor_ids(input)) in_trust_anchor_ids = Traits::trust_anchor_ids(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->trust_anchor_ids)::BaseType>
        trust_anchor_ids_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& trust_anchor_ids_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>>(
      in_trust_anchor_ids,
      trust_anchor_ids_fragment,
      &trust_anchor_ids_validate_params);

    fragment->trust_anchor_ids.Set(
        trust_anchor_ids_fragment.is_null() ? nullptr : trust_anchor_ids_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->trust_anchor_ids.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null trust_anchor_ids in ConnectionEndpointMetadata struct");
  }

  static bool Deserialize(::network::mojom::internal::ConnectionEndpointMetadata_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::ConnectionEndpointMetadataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {

inline void ConnectionEndpointMetadataDataView::GetSupportedProtocolAlpnsDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->supported_protocol_alpns.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}
inline void ConnectionEndpointMetadataDataView::GetEchConfigListDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->ech_config_list.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void ConnectionEndpointMetadataDataView::GetTargetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->target_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ConnectionEndpointMetadataDataView::GetTrustAnchorIdsDataView(
    mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>* output) {
  auto pointer = data_->trust_anchor_ids.Get();
  *output = mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>(pointer, message_);
}



}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_CONNECTION_ENDPOINT_METADATA_MOJOM_SHARED_H_