// services/network/public/mojom/connection_change_observer_client.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/network/public/mojom/connection_change_observer_client.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('network.mojom');


  var NetworkChangeEvent = {};
  NetworkChangeEvent.kSoonToDisconnect = 0;
  NetworkChangeEvent.kDisconnected = 1;
  NetworkChangeEvent.kConnected = 2;
  NetworkChangeEvent.kDefaultNetworkChanged = 3;
  NetworkChangeEvent.MIN_VALUE = 0;
  NetworkChangeEvent.MAX_VALUE = 3;

  NetworkChangeEvent.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  NetworkChangeEvent.toKnownEnumValue = function(value) {
    return value;
  };

  NetworkChangeEvent.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function ConnectionKeepAliveConfig(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ConnectionKeepAliveConfig.prototype.initDefaults_ = function() {
    this.idleTimeoutInSeconds = 0;
    this.pingIntervalInSeconds = 0;
    this.enableConnectionKeepAlive = false;
    this.quicConnectionOptions = "";
  };
  ConnectionKeepAliveConfig.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ConnectionKeepAliveConfig.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;





    // validate ConnectionKeepAliveConfig.quicConnectionOptions
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ConnectionKeepAliveConfig.encodedSize = codec.kStructHeaderSize + 24;

  ConnectionKeepAliveConfig.decode = function(decoder) {
    var packed;
    var val = new ConnectionKeepAliveConfig();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.idleTimeoutInSeconds =
        decoder.decodeStruct(codec.Int32);
    val.pingIntervalInSeconds =
        decoder.decodeStruct(codec.Int32);
    packed = decoder.readUint8();
    val.enableConnectionKeepAlive = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.quicConnectionOptions =
        decoder.decodeStruct(codec.String);
    return val;
  };

  ConnectionKeepAliveConfig.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ConnectionKeepAliveConfig.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.idleTimeoutInSeconds);
    encoder.encodeStruct(codec.Int32, val.pingIntervalInSeconds);
    packed = 0;
    packed |= (val.enableConnectionKeepAlive & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.quicConnectionOptions);
  };
  function ConnectionChangeObserverClient_OnSessionClosed_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ConnectionChangeObserverClient_OnSessionClosed_Params.prototype.initDefaults_ = function() {
  };
  ConnectionChangeObserverClient_OnSessionClosed_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ConnectionChangeObserverClient_OnSessionClosed_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ConnectionChangeObserverClient_OnSessionClosed_Params.encodedSize = codec.kStructHeaderSize + 0;

  ConnectionChangeObserverClient_OnSessionClosed_Params.decode = function(decoder) {
    var packed;
    var val = new ConnectionChangeObserverClient_OnSessionClosed_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  ConnectionChangeObserverClient_OnSessionClosed_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ConnectionChangeObserverClient_OnSessionClosed_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function ConnectionChangeObserverClient_OnNetworkEvent_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ConnectionChangeObserverClient_OnNetworkEvent_Params.prototype.initDefaults_ = function() {
    this.event = 0;
  };
  ConnectionChangeObserverClient_OnNetworkEvent_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ConnectionChangeObserverClient_OnNetworkEvent_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ConnectionChangeObserverClient_OnNetworkEvent_Params.event
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, NetworkChangeEvent);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ConnectionChangeObserverClient_OnNetworkEvent_Params.encodedSize = codec.kStructHeaderSize + 8;

  ConnectionChangeObserverClient_OnNetworkEvent_Params.decode = function(decoder) {
    var packed;
    var val = new ConnectionChangeObserverClient_OnNetworkEvent_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.event =
        decoder.decodeStruct(new codec.Enum(NetworkChangeEvent));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ConnectionChangeObserverClient_OnNetworkEvent_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ConnectionChangeObserverClient_OnNetworkEvent_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.event);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ConnectionChangeObserverClient_OnConnectionFailed_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ConnectionChangeObserverClient_OnConnectionFailed_Params.prototype.initDefaults_ = function() {
  };
  ConnectionChangeObserverClient_OnConnectionFailed_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ConnectionChangeObserverClient_OnConnectionFailed_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ConnectionChangeObserverClient_OnConnectionFailed_Params.encodedSize = codec.kStructHeaderSize + 0;

  ConnectionChangeObserverClient_OnConnectionFailed_Params.decode = function(decoder) {
    var packed;
    var val = new ConnectionChangeObserverClient_OnConnectionFailed_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  ConnectionChangeObserverClient_OnConnectionFailed_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ConnectionChangeObserverClient_OnConnectionFailed_Params.encodedSize);
    encoder.writeUint32(0);
  };
  var kConnectionChangeObserverClient_OnSessionClosed_Name = 0;
  var kConnectionChangeObserverClient_OnNetworkEvent_Name = 1;
  var kConnectionChangeObserverClient_OnConnectionFailed_Name = 2;

  function ConnectionChangeObserverClientPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(ConnectionChangeObserverClient,
                                                   handleOrPtrInfo);
  }

  function ConnectionChangeObserverClientAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        ConnectionChangeObserverClient, associatedInterfacePtrInfo);
  }

  ConnectionChangeObserverClientAssociatedPtr.prototype =
      Object.create(ConnectionChangeObserverClientPtr.prototype);
  ConnectionChangeObserverClientAssociatedPtr.prototype.constructor =
      ConnectionChangeObserverClientAssociatedPtr;

  function ConnectionChangeObserverClientProxy(receiver) {
    this.receiver_ = receiver;
  }
  ConnectionChangeObserverClientPtr.prototype.onSessionClosed = function() {
    return ConnectionChangeObserverClientProxy.prototype.onSessionClosed
        .apply(this.ptr.getProxy(), arguments);
  };

  ConnectionChangeObserverClientProxy.prototype.onSessionClosed = function() {
    var params_ = new ConnectionChangeObserverClient_OnSessionClosed_Params();
    var builder = new codec.MessageV0Builder(
        kConnectionChangeObserverClient_OnSessionClosed_Name,
        codec.align(ConnectionChangeObserverClient_OnSessionClosed_Params.encodedSize));
    builder.encodeStruct(ConnectionChangeObserverClient_OnSessionClosed_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  ConnectionChangeObserverClientPtr.prototype.onNetworkEvent = function() {
    return ConnectionChangeObserverClientProxy.prototype.onNetworkEvent
        .apply(this.ptr.getProxy(), arguments);
  };

  ConnectionChangeObserverClientProxy.prototype.onNetworkEvent = function(event) {
    var params_ = new ConnectionChangeObserverClient_OnNetworkEvent_Params();
    params_.event = event;
    var builder = new codec.MessageV0Builder(
        kConnectionChangeObserverClient_OnNetworkEvent_Name,
        codec.align(ConnectionChangeObserverClient_OnNetworkEvent_Params.encodedSize));
    builder.encodeStruct(ConnectionChangeObserverClient_OnNetworkEvent_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  ConnectionChangeObserverClientPtr.prototype.onConnectionFailed = function() {
    return ConnectionChangeObserverClientProxy.prototype.onConnectionFailed
        .apply(this.ptr.getProxy(), arguments);
  };

  ConnectionChangeObserverClientProxy.prototype.onConnectionFailed = function() {
    var params_ = new ConnectionChangeObserverClient_OnConnectionFailed_Params();
    var builder = new codec.MessageV0Builder(
        kConnectionChangeObserverClient_OnConnectionFailed_Name,
        codec.align(ConnectionChangeObserverClient_OnConnectionFailed_Params.encodedSize));
    builder.encodeStruct(ConnectionChangeObserverClient_OnConnectionFailed_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function ConnectionChangeObserverClientStub(delegate) {
    this.delegate_ = delegate;
  }
  ConnectionChangeObserverClientStub.prototype.onSessionClosed = function() {
    return this.delegate_ && this.delegate_.onSessionClosed && this.delegate_.onSessionClosed();
  }
  ConnectionChangeObserverClientStub.prototype.onNetworkEvent = function(event) {
    return this.delegate_ && this.delegate_.onNetworkEvent && this.delegate_.onNetworkEvent(event);
  }
  ConnectionChangeObserverClientStub.prototype.onConnectionFailed = function() {
    return this.delegate_ && this.delegate_.onConnectionFailed && this.delegate_.onConnectionFailed();
  }

  ConnectionChangeObserverClientStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kConnectionChangeObserverClient_OnSessionClosed_Name:
      var params = reader.decodeStruct(ConnectionChangeObserverClient_OnSessionClosed_Params);
      this.onSessionClosed();
      return true;
    case kConnectionChangeObserverClient_OnNetworkEvent_Name:
      var params = reader.decodeStruct(ConnectionChangeObserverClient_OnNetworkEvent_Params);
      this.onNetworkEvent(params.event);
      return true;
    case kConnectionChangeObserverClient_OnConnectionFailed_Name:
      var params = reader.decodeStruct(ConnectionChangeObserverClient_OnConnectionFailed_Params);
      this.onConnectionFailed();
      return true;
    default:
      return false;
    }
  };

  ConnectionChangeObserverClientStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateConnectionChangeObserverClientRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kConnectionChangeObserverClient_OnSessionClosed_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ConnectionChangeObserverClient_OnSessionClosed_Params;
      break;
      case kConnectionChangeObserverClient_OnNetworkEvent_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ConnectionChangeObserverClient_OnNetworkEvent_Params;
      break;
      case kConnectionChangeObserverClient_OnConnectionFailed_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = ConnectionChangeObserverClient_OnConnectionFailed_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateConnectionChangeObserverClientResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var ConnectionChangeObserverClient = {
    name: 'network.mojom.ConnectionChangeObserverClient',
    kVersion: 0,
    ptrClass: ConnectionChangeObserverClientPtr,
    proxyClass: ConnectionChangeObserverClientProxy,
    stubClass: ConnectionChangeObserverClientStub,
    validateRequest: validateConnectionChangeObserverClientRequest,
    validateResponse: null,
  };
  ConnectionChangeObserverClientStub.prototype.validator = validateConnectionChangeObserverClientRequest;
  ConnectionChangeObserverClientProxy.prototype.validator = null;
  exports.NetworkChangeEvent = NetworkChangeEvent;
  exports.ConnectionKeepAliveConfig = ConnectionKeepAliveConfig;
  exports.ConnectionChangeObserverClient = ConnectionChangeObserverClient;
  exports.ConnectionChangeObserverClientPtr = ConnectionChangeObserverClientPtr;
  exports.ConnectionChangeObserverClientAssociatedPtr = ConnectionChangeObserverClientAssociatedPtr;
})();