// services/network/public/mojom/connection_change_observer_client.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_CONNECTION_CHANGE_OBSERVER_CLIENT_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_CONNECTION_CHANGE_OBSERVER_CLIENT_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/connection_change_observer_client.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "services/network/public/mojom/connection_change_observer_client.mojom-data-view.h"




namespace std {

template <>
struct hash<::network::mojom::NetworkChangeEvent>
    : public mojo::internal::EnumHashImpl<::network::mojom::NetworkChangeEvent> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::NetworkChangeEvent, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::NetworkChangeEvent, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::NetworkChangeEvent>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::ConnectionKeepAliveConfigDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::ConnectionKeepAliveConfigDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::ConnectionKeepAliveConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->idle_timeout_in_seconds = Traits::idle_timeout_in_seconds(input);

    fragment->ping_interval_in_seconds = Traits::ping_interval_in_seconds(input);

    fragment->enable_connection_keep_alive = Traits::enable_connection_keep_alive(input);

    decltype(Traits::quic_connection_options(input)) in_quic_connection_options = Traits::quic_connection_options(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->quic_connection_options)::BaseType> quic_connection_options_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_quic_connection_options,
      quic_connection_options_fragment);

    fragment->quic_connection_options.Set(
        quic_connection_options_fragment.is_null() ? nullptr : quic_connection_options_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->quic_connection_options.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null quic_connection_options in ConnectionKeepAliveConfig struct");
  }

  static bool Deserialize(::network::mojom::internal::ConnectionKeepAliveConfig_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::ConnectionKeepAliveConfigDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {

inline void ConnectionKeepAliveConfigDataView::GetQuicConnectionOptionsDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->quic_connection_options.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::NetworkChangeEvent> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::NetworkChangeEvent value);
};

} // namespace perfetto

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_CONNECTION_CHANGE_OBSERVER_CLIENT_MOJOM_SHARED_H_