// services/network/public/mojom/connection_allowlist.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_CONNECTION_ALLOWLIST_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_CONNECTION_ALLOWLIST_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/connection_allowlist.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/connection_allowlist.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/connection_allowlist.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>




#include "services/network/public/cpp/connection_allowlist_mojom_traits.h"




namespace network::mojom {









class  ConnectionAllowlist {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ConnectionAllowlist, T>::value>;
  using DataView = ConnectionAllowlistDataView;
  using Data_ = internal::ConnectionAllowlist_Data;

  template <typename... Args>
  static ConnectionAllowlistPtr New(Args&&... args) {
    return ConnectionAllowlistPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ConnectionAllowlistPtr From(const U& u) {
    return mojo::TypeConverter<ConnectionAllowlistPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ConnectionAllowlist>::Convert(*this);
  }


  ConnectionAllowlist();

  ConnectionAllowlist(
      std::vector<std::string> allowlist,
      const std::optional<std::string>& reporting_endpoint,
      std::vector<ConnectionAllowlistIssue> issues);


  ~ConnectionAllowlist();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ConnectionAllowlistPtr>
  ConnectionAllowlistPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ConnectionAllowlist::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ConnectionAllowlist::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ConnectionAllowlist::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ConnectionAllowlist::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ConnectionAllowlist::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ConnectionAllowlist::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ConnectionAllowlist_UnserializedMessageContext<
            UserType, ConnectionAllowlist::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ConnectionAllowlist::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ConnectionAllowlist::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ConnectionAllowlist_UnserializedMessageContext<
            UserType, ConnectionAllowlist::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ConnectionAllowlist::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<std::string> allowlist;
  
  std::optional<std::string> reporting_endpoint;
  
  std::vector<ConnectionAllowlistIssue> issues;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ConnectionAllowlist::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ConnectionAllowlist::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ConnectionAllowlist::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ConnectionAllowlist::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ConnectionAllowlists {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ConnectionAllowlists, T>::value>;
  using DataView = ConnectionAllowlistsDataView;
  using Data_ = internal::ConnectionAllowlists_Data;

  template <typename... Args>
  static ConnectionAllowlistsPtr New(Args&&... args) {
    return ConnectionAllowlistsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ConnectionAllowlistsPtr From(const U& u) {
    return mojo::TypeConverter<ConnectionAllowlistsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ConnectionAllowlists>::Convert(*this);
  }


  ConnectionAllowlists();

  ConnectionAllowlists(
      const std::optional<::network::ConnectionAllowlist>& enforced,
      const std::optional<::network::ConnectionAllowlist>& report_only);


  ~ConnectionAllowlists();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ConnectionAllowlistsPtr>
  ConnectionAllowlistsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ConnectionAllowlists::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ConnectionAllowlists::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ConnectionAllowlists::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ConnectionAllowlists::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ConnectionAllowlists::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ConnectionAllowlists::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ConnectionAllowlists_UnserializedMessageContext<
            UserType, ConnectionAllowlists::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ConnectionAllowlists::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ConnectionAllowlists::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ConnectionAllowlists_UnserializedMessageContext<
            UserType, ConnectionAllowlists::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ConnectionAllowlists::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<::network::ConnectionAllowlist> enforced;
  
  std::optional<::network::ConnectionAllowlist> report_only;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ConnectionAllowlists::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ConnectionAllowlists::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ConnectionAllowlists::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ConnectionAllowlists::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ConnectionAllowlistPtr ConnectionAllowlist::Clone() const {
  return New(
      mojo::Clone(allowlist),
      mojo::Clone(reporting_endpoint),
      mojo::Clone(issues)
  );
}

template <typename T, ConnectionAllowlist::EnableIfSame<T>*>
bool ConnectionAllowlist::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->allowlist, other_struct.allowlist))
    return false;
  if (!mojo::Equals(this->reporting_endpoint, other_struct.reporting_endpoint))
    return false;
  if (!mojo::Equals(this->issues, other_struct.issues))
    return false;
  return true;
}

template <typename T, ConnectionAllowlist::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.allowlist < rhs.allowlist)
    return true;
  if (rhs.allowlist < lhs.allowlist)
    return false;
  if (lhs.reporting_endpoint < rhs.reporting_endpoint)
    return true;
  if (rhs.reporting_endpoint < lhs.reporting_endpoint)
    return false;
  if (lhs.issues < rhs.issues)
    return true;
  if (rhs.issues < lhs.issues)
    return false;
  return false;
}
template <typename StructPtrType>
ConnectionAllowlistsPtr ConnectionAllowlists::Clone() const {
  return New(
      mojo::Clone(enforced),
      mojo::Clone(report_only)
  );
}

template <typename T, ConnectionAllowlists::EnableIfSame<T>*>
bool ConnectionAllowlists::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->enforced, other_struct.enforced))
    return false;
  if (!mojo::Equals(this->report_only, other_struct.report_only))
    return false;
  return true;
}

template <typename T, ConnectionAllowlists::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.enforced < rhs.enforced)
    return true;
  if (rhs.enforced < lhs.enforced)
    return false;
  if (lhs.report_only < rhs.report_only)
    return true;
  if (rhs.report_only < lhs.report_only)
    return false;
  return false;
}


}  // network::mojom

namespace mojo {


template <>
struct  StructTraits<::network::mojom::ConnectionAllowlist::DataView,
                                         ::network::mojom::ConnectionAllowlistPtr> {
  static bool IsNull(const ::network::mojom::ConnectionAllowlistPtr& input) { return !input; }
  static void SetToNull(::network::mojom::ConnectionAllowlistPtr* output) { output->reset(); }

  static const decltype(::network::mojom::ConnectionAllowlist::allowlist)& allowlist(
      const ::network::mojom::ConnectionAllowlistPtr& input) {
    return input->allowlist;
  }

  static const decltype(::network::mojom::ConnectionAllowlist::reporting_endpoint)& reporting_endpoint(
      const ::network::mojom::ConnectionAllowlistPtr& input) {
    return input->reporting_endpoint;
  }

  static const decltype(::network::mojom::ConnectionAllowlist::issues)& issues(
      const ::network::mojom::ConnectionAllowlistPtr& input) {
    return input->issues;
  }

  static bool Read(::network::mojom::ConnectionAllowlist::DataView input, ::network::mojom::ConnectionAllowlistPtr* output);
};


template <>
struct  StructTraits<::network::mojom::ConnectionAllowlists::DataView,
                                         ::network::mojom::ConnectionAllowlistsPtr> {
  static bool IsNull(const ::network::mojom::ConnectionAllowlistsPtr& input) { return !input; }
  static void SetToNull(::network::mojom::ConnectionAllowlistsPtr* output) { output->reset(); }

  static const decltype(::network::mojom::ConnectionAllowlists::enforced)& enforced(
      const ::network::mojom::ConnectionAllowlistsPtr& input) {
    return input->enforced;
  }

  static const decltype(::network::mojom::ConnectionAllowlists::report_only)& report_only(
      const ::network::mojom::ConnectionAllowlistsPtr& input) {
    return input->report_only;
  }

  static bool Read(::network::mojom::ConnectionAllowlists::DataView input, ::network::mojom::ConnectionAllowlistsPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_CONNECTION_ALLOWLIST_MOJOM_H_