// services/network/public/mojom/connection_allowlist.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/connection_allowlist.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/connection_allowlist.mojom-params-data.h"
#include "services/network/public/mojom/connection_allowlist.mojom-shared-message-ids.h"

#include "services/network/public/mojom/connection_allowlist.mojom-import-headers.h"
#include "services/network/public/mojom/connection_allowlist.mojom-test-utils.h"


namespace network::mojom {
ConnectionAllowlist::ConnectionAllowlist()
    : allowlist(),
      reporting_endpoint(),
      issues() {}

ConnectionAllowlist::ConnectionAllowlist(
    std::vector<std::string> allowlist_in,
    const std::optional<std::string>& reporting_endpoint_in,
    std::vector<ConnectionAllowlistIssue> issues_in)
    : allowlist(std::move(allowlist_in)),
      reporting_endpoint(std::move(reporting_endpoint_in)),
      issues(std::move(issues_in)) {}

ConnectionAllowlist::~ConnectionAllowlist() = default;

void ConnectionAllowlist::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allowlist"), this->allowlist,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reporting_endpoint"), this->reporting_endpoint,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<std::string>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "issues"), this->issues,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<ConnectionAllowlistIssue>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ConnectionAllowlist::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ConnectionAllowlists::ConnectionAllowlists()
    : enforced(),
      report_only() {}

ConnectionAllowlists::ConnectionAllowlists(
    const std::optional<::network::ConnectionAllowlist>& enforced_in,
    const std::optional<::network::ConnectionAllowlist>& report_only_in)
    : enforced(std::move(enforced_in)),
      report_only(std::move(report_only_in)) {}

ConnectionAllowlists::~ConnectionAllowlists() = default;

void ConnectionAllowlists::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enforced"), this->enforced,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::network::ConnectionAllowlist>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "report_only"), this->report_only,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::network::ConnectionAllowlist>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ConnectionAllowlists::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // network::mojom


namespace mojo {


// static
bool StructTraits<::network::mojom::ConnectionAllowlist::DataView, ::network::mojom::ConnectionAllowlistPtr>::Read(
    ::network::mojom::ConnectionAllowlist::DataView input,
    ::network::mojom::ConnectionAllowlistPtr* output) {
  bool success = true;
  ::network::mojom::ConnectionAllowlistPtr result(::network::mojom::ConnectionAllowlist::New());
  
      if (success && !input.ReadAllowlist(&result->allowlist))
        success = false;
      if (success && !input.ReadReportingEndpoint(&result->reporting_endpoint))
        success = false;
      if (success && !input.ReadIssues(&result->issues))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::ConnectionAllowlists::DataView, ::network::mojom::ConnectionAllowlistsPtr>::Read(
    ::network::mojom::ConnectionAllowlists::DataView input,
    ::network::mojom::ConnectionAllowlistsPtr* output) {
  bool success = true;
  ::network::mojom::ConnectionAllowlistsPtr result(::network::mojom::ConnectionAllowlists::New());
  
      if (success && !input.ReadEnforced(&result->enforced))
        success = false;
      if (success && !input.ReadReportOnly(&result->report_only))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace network::mojom {




}  // network::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif