// services/network/public/mojom/connection_allowlist.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_CONNECTION_ALLOWLIST_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_CONNECTION_ALLOWLIST_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/connection_allowlist.mojom-shared-internal.h"




#include "services/network/public/mojom/connection_allowlist.mojom-data-view.h"




namespace std {

template <>
struct hash<::network::mojom::ConnectionAllowlistIssue>
    : public mojo::internal::EnumHashImpl<::network::mojom::ConnectionAllowlistIssue> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::ConnectionAllowlistIssue, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::ConnectionAllowlistIssue, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::ConnectionAllowlistIssue>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::ConnectionAllowlistDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::ConnectionAllowlistDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::ConnectionAllowlist_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::allowlist(input)) in_allowlist = Traits::allowlist(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->allowlist)::BaseType>
        allowlist_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& allowlist_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_allowlist,
      allowlist_fragment,
      &allowlist_validate_params);

    fragment->allowlist.Set(
        allowlist_fragment.is_null() ? nullptr : allowlist_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->allowlist.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null allowlist in ConnectionAllowlist struct");

    decltype(Traits::reporting_endpoint(input)) in_reporting_endpoint = Traits::reporting_endpoint(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->reporting_endpoint)::BaseType> reporting_endpoint_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_reporting_endpoint,
      reporting_endpoint_fragment);

    fragment->reporting_endpoint.Set(
        reporting_endpoint_fragment.is_null() ? nullptr : reporting_endpoint_fragment.data());

    decltype(Traits::issues(input)) in_issues = Traits::issues(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->issues)::BaseType>
        issues_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& issues_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::network::mojom::internal::ConnectionAllowlistIssue_Data::Validate>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::ConnectionAllowlistIssue>>(
      in_issues,
      issues_fragment,
      &issues_validate_params);

    fragment->issues.Set(
        issues_fragment.is_null() ? nullptr : issues_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->issues.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null issues in ConnectionAllowlist struct");
  }

  static bool Deserialize(::network::mojom::internal::ConnectionAllowlist_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::ConnectionAllowlistDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::ConnectionAllowlistsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::ConnectionAllowlistsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::ConnectionAllowlists_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::enforced(input)) in_enforced = Traits::enforced(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->enforced)::BaseType> enforced_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::ConnectionAllowlistDataView>(
      in_enforced,
      enforced_fragment);

    fragment->enforced.Set(
        enforced_fragment.is_null() ? nullptr : enforced_fragment.data());

    decltype(Traits::report_only(input)) in_report_only = Traits::report_only(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->report_only)::BaseType> report_only_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::ConnectionAllowlistDataView>(
      in_report_only,
      report_only_fragment);

    fragment->report_only.Set(
        report_only_fragment.is_null() ? nullptr : report_only_fragment.data());
  }

  static bool Deserialize(::network::mojom::internal::ConnectionAllowlists_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::ConnectionAllowlistsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {

inline void ConnectionAllowlistDataView::GetAllowlistDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->allowlist.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}
inline void ConnectionAllowlistDataView::GetReportingEndpointDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->reporting_endpoint.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ConnectionAllowlistDataView::GetIssuesDataView(
    mojo::ArrayDataView<ConnectionAllowlistIssue>* output) {
  auto pointer = data_->issues.Get();
  *output = mojo::ArrayDataView<ConnectionAllowlistIssue>(pointer, message_);
}


inline void ConnectionAllowlistsDataView::GetEnforcedDataView(
    ConnectionAllowlistDataView* output) {
  auto pointer = data_->enforced.Get();
  *output = ConnectionAllowlistDataView(pointer, message_);
}
inline void ConnectionAllowlistsDataView::GetReportOnlyDataView(
    ConnectionAllowlistDataView* output) {
  auto pointer = data_->report_only.Get();
  *output = ConnectionAllowlistDataView(pointer, message_);
}



}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::ConnectionAllowlistIssue> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::ConnectionAllowlistIssue value);
};

} // namespace perfetto

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_CONNECTION_ALLOWLIST_MOJOM_SHARED_H_