// services/network/public/mojom/client_security_state.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_CLIENT_SECURITY_STATE_MOJOM_SEND_VALIDATION_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_CLIENT_SECURITY_STATE_MOJOM_SEND_VALIDATION_H_

#include "services/network/public/mojom/client_security_state.mojom-shared-internal.h"
#include "services/network/public/mojom/cross_origin_embedder_policy.mojom-shared.h"
#include "services/network/public/mojom/document_isolation_policy.mojom-shared.h"
#include "services/network/public/mojom/ip_address_space.mojom-shared.h"

#include "services/network/public/mojom/client_security_state.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::network::mojom::PrivateNetworkRequestPolicy, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::ClientSecurityStateDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::ClientSecurityStateDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::ClientSecurityState_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::cross_origin_embedder_policy(input)) in_cross_origin_embedder_policy = Traits::cross_origin_embedder_policy(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->cross_origin_embedder_policy)::BaseType> cross_origin_embedder_policy_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::CrossOriginEmbedderPolicyDataView, send_validation>(
        in_cross_origin_embedder_policy,
        cross_origin_embedder_policy_fragment);

      fragment->cross_origin_embedder_policy.Set(
          cross_origin_embedder_policy_fragment.is_null() ? nullptr : cross_origin_embedder_policy_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->cross_origin_embedder_policy.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null cross_origin_embedder_policy in ClientSecurityState struct");

      fragment->is_web_secure_context = Traits::is_web_secure_context(input);

      
      mojo::internal::Serialize<::network::mojom::IPAddressSpace>(
        Traits::ip_address_space(input),
        &fragment->ip_address_space);

      
      mojo::internal::Serialize<::network::mojom::PrivateNetworkRequestPolicy>(
        Traits::private_network_request_policy(input),
        &fragment->private_network_request_policy);

      decltype(Traits::document_isolation_policy(input)) in_document_isolation_policy = Traits::document_isolation_policy(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->document_isolation_policy)::BaseType> document_isolation_policy_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::DocumentIsolationPolicyDataView, send_validation>(
        in_document_isolation_policy,
        document_isolation_policy_fragment);

      fragment->document_isolation_policy.Set(
          document_isolation_policy_fragment.is_null() ? nullptr : document_isolation_policy_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->document_isolation_policy.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null document_isolation_policy in ClientSecurityState struct");
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_CLIENT_SECURITY_STATE_MOJOM_SEND_VALIDATION_H_