// services/network/public/mojom/client_security_state.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_CLIENT_SECURITY_STATE_MOJOM_BLINK_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_CLIENT_SECURITY_STATE_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/client_security_state.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/client_security_state.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/client_security_state.mojom-blink-forward.h"  // IWYU pragma: export
#include "services/network/public/mojom/cross_origin_embedder_policy.mojom-blink.h"
#include "services/network/public/mojom/document_isolation_policy.mojom-blink.h"
#include "services/network/public/mojom/ip_address_space.mojom-blink-forward.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace network::mojom::blink {








class BLINK_PLATFORM_EXPORT ClientSecurityState {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ClientSecurityState, T>::value>;
  using DataView = ClientSecurityStateDataView;
  using Data_ = internal::ClientSecurityState_Data;

  template <typename... Args>
  static ClientSecurityStatePtr New(Args&&... args) {
    return ClientSecurityStatePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ClientSecurityStatePtr From(const U& u) {
    return mojo::TypeConverter<ClientSecurityStatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ClientSecurityState>::Convert(*this);
  }


  ClientSecurityState();

  ClientSecurityState(
      const ::network::CrossOriginEmbedderPolicy& cross_origin_embedder_policy,
      bool is_web_secure_context,
      ::network::mojom::blink::IPAddressSpace ip_address_space,
      PrivateNetworkRequestPolicy private_network_request_policy,
      const ::network::DocumentIsolationPolicy& document_isolation_policy);


  ~ClientSecurityState();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ClientSecurityStatePtr>
  ClientSecurityStatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ClientSecurityState::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ClientSecurityState::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ClientSecurityState::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ClientSecurityState::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ClientSecurityState::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ClientSecurityState::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ClientSecurityState_UnserializedMessageContext<
            UserType, ClientSecurityState::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ClientSecurityState::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ClientSecurityState::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ClientSecurityState_UnserializedMessageContext<
            UserType, ClientSecurityState::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ClientSecurityState::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::network::CrossOriginEmbedderPolicy cross_origin_embedder_policy;
  
  bool is_web_secure_context;
  
  ::network::mojom::blink::IPAddressSpace ip_address_space;
  
  PrivateNetworkRequestPolicy private_network_request_policy;
  
  ::network::DocumentIsolationPolicy document_isolation_policy;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ClientSecurityState::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ClientSecurityState::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ClientSecurityState::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ClientSecurityState::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ClientSecurityStatePtr ClientSecurityState::Clone() const {
  return New(
      mojo::Clone(cross_origin_embedder_policy),
      mojo::Clone(is_web_secure_context),
      mojo::Clone(ip_address_space),
      mojo::Clone(private_network_request_policy),
      mojo::Clone(document_isolation_policy)
  );
}

template <typename T, ClientSecurityState::EnableIfSame<T>*>
bool ClientSecurityState::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->cross_origin_embedder_policy, other_struct.cross_origin_embedder_policy))
    return false;
  if (!mojo::Equals(this->is_web_secure_context, other_struct.is_web_secure_context))
    return false;
  if (!mojo::Equals(this->ip_address_space, other_struct.ip_address_space))
    return false;
  if (!mojo::Equals(this->private_network_request_policy, other_struct.private_network_request_policy))
    return false;
  if (!mojo::Equals(this->document_isolation_policy, other_struct.document_isolation_policy))
    return false;
  return true;
}

template <typename T, ClientSecurityState::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.cross_origin_embedder_policy < rhs.cross_origin_embedder_policy)
    return true;
  if (rhs.cross_origin_embedder_policy < lhs.cross_origin_embedder_policy)
    return false;
  if (lhs.is_web_secure_context < rhs.is_web_secure_context)
    return true;
  if (rhs.is_web_secure_context < lhs.is_web_secure_context)
    return false;
  if (lhs.ip_address_space < rhs.ip_address_space)
    return true;
  if (rhs.ip_address_space < lhs.ip_address_space)
    return false;
  if (lhs.private_network_request_policy < rhs.private_network_request_policy)
    return true;
  if (rhs.private_network_request_policy < lhs.private_network_request_policy)
    return false;
  if (lhs.document_isolation_policy < rhs.document_isolation_policy)
    return true;
  if (rhs.document_isolation_policy < lhs.document_isolation_policy)
    return false;
  return false;
}


}  // network::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::ClientSecurityState::DataView,
                                         ::network::mojom::blink::ClientSecurityStatePtr> {
  static bool IsNull(const ::network::mojom::blink::ClientSecurityStatePtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::ClientSecurityStatePtr* output) { output->reset(); }

  static const decltype(::network::mojom::blink::ClientSecurityState::cross_origin_embedder_policy)& cross_origin_embedder_policy(
      const ::network::mojom::blink::ClientSecurityStatePtr& input) {
    return input->cross_origin_embedder_policy;
  }

  static decltype(::network::mojom::blink::ClientSecurityState::is_web_secure_context) is_web_secure_context(
      const ::network::mojom::blink::ClientSecurityStatePtr& input) {
    return input->is_web_secure_context;
  }

  static decltype(::network::mojom::blink::ClientSecurityState::ip_address_space) ip_address_space(
      const ::network::mojom::blink::ClientSecurityStatePtr& input) {
    return input->ip_address_space;
  }

  static decltype(::network::mojom::blink::ClientSecurityState::private_network_request_policy) private_network_request_policy(
      const ::network::mojom::blink::ClientSecurityStatePtr& input) {
    return input->private_network_request_policy;
  }

  static const decltype(::network::mojom::blink::ClientSecurityState::document_isolation_policy)& document_isolation_policy(
      const ::network::mojom::blink::ClientSecurityStatePtr& input) {
    return input->document_isolation_policy;
  }

  static bool Read(::network::mojom::blink::ClientSecurityState::DataView input, ::network::mojom::blink::ClientSecurityStatePtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_CLIENT_SECURITY_STATE_MOJOM_BLINK_H_