// services/network/public/mojom/cert_verifier_service_updater.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_CERT_VERIFIER_SERVICE_UPDATER_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_CERT_VERIFIER_SERVICE_UPDATER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/cert_verifier_service_updater.mojom-shared-internal.h"
#include "services/network/public/mojom/ct_policy.mojom-shared.h"
#include "services/network/public/mojom/ip_address.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "services/network/public/mojom/cert_verifier_service_updater.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::cert_verifier::mojom::CIDRDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::cert_verifier::mojom::CIDRDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::cert_verifier::mojom::internal::CIDR_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::ip(input)) in_ip = Traits::ip(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->ip)::BaseType> ip_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::IPAddressDataView>(
      in_ip,
      ip_fragment);

    fragment->ip.Set(
        ip_fragment.is_null() ? nullptr : ip_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->ip.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null ip in CIDR struct");

    decltype(Traits::mask(input)) in_mask = Traits::mask(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->mask)::BaseType> mask_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::IPAddressDataView>(
      in_mask,
      mask_fragment);

    fragment->mask.Set(
        mask_fragment.is_null() ? nullptr : mask_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->mask.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null mask in CIDR struct");
  }

  static bool Deserialize(::cert_verifier::mojom::internal::CIDR_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::cert_verifier::mojom::CIDRDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::cert_verifier::mojom::CertWithConstraintsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::cert_verifier::mojom::CertWithConstraintsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::cert_verifier::mojom::internal::CertWithConstraints_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::certificate(input)) in_certificate = Traits::certificate(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->certificate)::BaseType>
        certificate_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& certificate_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_certificate,
      certificate_fragment,
      &certificate_validate_params);

    fragment->certificate.Set(
        certificate_fragment.is_null() ? nullptr : certificate_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->certificate.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null certificate in CertWithConstraints struct");

    decltype(Traits::permitted_dns_names(input)) in_permitted_dns_names = Traits::permitted_dns_names(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->permitted_dns_names)::BaseType>
        permitted_dns_names_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& permitted_dns_names_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_permitted_dns_names,
      permitted_dns_names_fragment,
      &permitted_dns_names_validate_params);

    fragment->permitted_dns_names.Set(
        permitted_dns_names_fragment.is_null() ? nullptr : permitted_dns_names_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->permitted_dns_names.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null permitted_dns_names in CertWithConstraints struct");

    decltype(Traits::permitted_cidrs(input)) in_permitted_cidrs = Traits::permitted_cidrs(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->permitted_cidrs)::BaseType>
        permitted_cidrs_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& permitted_cidrs_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::cert_verifier::mojom::CIDRDataView>>(
      in_permitted_cidrs,
      permitted_cidrs_fragment,
      &permitted_cidrs_validate_params);

    fragment->permitted_cidrs.Set(
        permitted_cidrs_fragment.is_null() ? nullptr : permitted_cidrs_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->permitted_cidrs.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null permitted_cidrs in CertWithConstraints struct");
  }

  static bool Deserialize(::cert_verifier::mojom::internal::CertWithConstraints_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::cert_verifier::mojom::CertWithConstraintsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::cert_verifier::mojom::AdditionalCertificatesDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::cert_verifier::mojom::AdditionalCertificatesDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::cert_verifier::mojom::internal::AdditionalCertificates_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::all_certificates(input)) in_all_certificates = Traits::all_certificates(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->all_certificates)::BaseType>
        all_certificates_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& all_certificates_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>>(
      in_all_certificates,
      all_certificates_fragment,
      &all_certificates_validate_params);

    fragment->all_certificates.Set(
        all_certificates_fragment.is_null() ? nullptr : all_certificates_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->all_certificates.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null all_certificates in AdditionalCertificates struct");

    decltype(Traits::trust_anchors(input)) in_trust_anchors = Traits::trust_anchors(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->trust_anchors)::BaseType>
        trust_anchors_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& trust_anchors_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>>(
      in_trust_anchors,
      trust_anchors_fragment,
      &trust_anchors_validate_params);

    fragment->trust_anchors.Set(
        trust_anchors_fragment.is_null() ? nullptr : trust_anchors_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->trust_anchors.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null trust_anchors in AdditionalCertificates struct");

    decltype(Traits::trust_anchors_with_enforced_constraints(input)) in_trust_anchors_with_enforced_constraints = Traits::trust_anchors_with_enforced_constraints(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->trust_anchors_with_enforced_constraints)::BaseType>
        trust_anchors_with_enforced_constraints_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& trust_anchors_with_enforced_constraints_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>>(
      in_trust_anchors_with_enforced_constraints,
      trust_anchors_with_enforced_constraints_fragment,
      &trust_anchors_with_enforced_constraints_validate_params);

    fragment->trust_anchors_with_enforced_constraints.Set(
        trust_anchors_with_enforced_constraints_fragment.is_null() ? nullptr : trust_anchors_with_enforced_constraints_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->trust_anchors_with_enforced_constraints.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null trust_anchors_with_enforced_constraints in AdditionalCertificates struct");

    decltype(Traits::trust_anchors_with_additional_constraints(input)) in_trust_anchors_with_additional_constraints = Traits::trust_anchors_with_additional_constraints(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->trust_anchors_with_additional_constraints)::BaseType>
        trust_anchors_with_additional_constraints_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& trust_anchors_with_additional_constraints_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::cert_verifier::mojom::CertWithConstraintsDataView>>(
      in_trust_anchors_with_additional_constraints,
      trust_anchors_with_additional_constraints_fragment,
      &trust_anchors_with_additional_constraints_validate_params);

    fragment->trust_anchors_with_additional_constraints.Set(
        trust_anchors_with_additional_constraints_fragment.is_null() ? nullptr : trust_anchors_with_additional_constraints_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->trust_anchors_with_additional_constraints.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null trust_anchors_with_additional_constraints in AdditionalCertificates struct");

    decltype(Traits::trust_anchors_and_leafs(input)) in_trust_anchors_and_leafs = Traits::trust_anchors_and_leafs(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->trust_anchors_and_leafs)::BaseType>
        trust_anchors_and_leafs_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& trust_anchors_and_leafs_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::cert_verifier::mojom::CertWithConstraintsDataView>>(
      in_trust_anchors_and_leafs,
      trust_anchors_and_leafs_fragment,
      &trust_anchors_and_leafs_validate_params);

    fragment->trust_anchors_and_leafs.Set(
        trust_anchors_and_leafs_fragment.is_null() ? nullptr : trust_anchors_and_leafs_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->trust_anchors_and_leafs.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null trust_anchors_and_leafs in AdditionalCertificates struct");

    decltype(Traits::trust_leafs(input)) in_trust_leafs = Traits::trust_leafs(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->trust_leafs)::BaseType>
        trust_leafs_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& trust_leafs_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::cert_verifier::mojom::CertWithConstraintsDataView>>(
      in_trust_leafs,
      trust_leafs_fragment,
      &trust_leafs_validate_params);

    fragment->trust_leafs.Set(
        trust_leafs_fragment.is_null() ? nullptr : trust_leafs_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->trust_leafs.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null trust_leafs in AdditionalCertificates struct");

    decltype(Traits::distrusted_spkis(input)) in_distrusted_spkis = Traits::distrusted_spkis(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->distrusted_spkis)::BaseType>
        distrusted_spkis_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& distrusted_spkis_validate_params =
        mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>>(
      in_distrusted_spkis,
      distrusted_spkis_fragment,
      &distrusted_spkis_validate_params);

    fragment->distrusted_spkis.Set(
        distrusted_spkis_fragment.is_null() ? nullptr : distrusted_spkis_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->distrusted_spkis.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null distrusted_spkis in AdditionalCertificates struct");

    fragment->include_system_trust_store = Traits::include_system_trust_store(input);
  }

  static bool Deserialize(::cert_verifier::mojom::internal::AdditionalCertificates_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::cert_verifier::mojom::AdditionalCertificatesDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace cert_verifier::mojom {

inline void CIDRDataView::GetIpDataView(
    ::network::mojom::IPAddressDataView* output) {
  auto pointer = data_->ip.Get();
  *output = ::network::mojom::IPAddressDataView(pointer, message_);
}
inline void CIDRDataView::GetMaskDataView(
    ::network::mojom::IPAddressDataView* output) {
  auto pointer = data_->mask.Get();
  *output = ::network::mojom::IPAddressDataView(pointer, message_);
}


inline void CertWithConstraintsDataView::GetCertificateDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->certificate.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}
inline void CertWithConstraintsDataView::GetPermittedDnsNamesDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->permitted_dns_names.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, message_);
}
inline void CertWithConstraintsDataView::GetPermittedCidrsDataView(
    mojo::ArrayDataView<CIDRDataView>* output) {
  auto pointer = data_->permitted_cidrs.Get();
  *output = mojo::ArrayDataView<CIDRDataView>(pointer, message_);
}


inline void AdditionalCertificatesDataView::GetAllCertificatesDataView(
    mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>* output) {
  auto pointer = data_->all_certificates.Get();
  *output = mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>(pointer, message_);
}
inline void AdditionalCertificatesDataView::GetTrustAnchorsDataView(
    mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>* output) {
  auto pointer = data_->trust_anchors.Get();
  *output = mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>(pointer, message_);
}
inline void AdditionalCertificatesDataView::GetTrustAnchorsWithEnforcedConstraintsDataView(
    mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>* output) {
  auto pointer = data_->trust_anchors_with_enforced_constraints.Get();
  *output = mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>(pointer, message_);
}
inline void AdditionalCertificatesDataView::GetTrustAnchorsWithAdditionalConstraintsDataView(
    mojo::ArrayDataView<CertWithConstraintsDataView>* output) {
  auto pointer = data_->trust_anchors_with_additional_constraints.Get();
  *output = mojo::ArrayDataView<CertWithConstraintsDataView>(pointer, message_);
}
inline void AdditionalCertificatesDataView::GetTrustAnchorsAndLeafsDataView(
    mojo::ArrayDataView<CertWithConstraintsDataView>* output) {
  auto pointer = data_->trust_anchors_and_leafs.Get();
  *output = mojo::ArrayDataView<CertWithConstraintsDataView>(pointer, message_);
}
inline void AdditionalCertificatesDataView::GetTrustLeafsDataView(
    mojo::ArrayDataView<CertWithConstraintsDataView>* output) {
  auto pointer = data_->trust_leafs.Get();
  *output = mojo::ArrayDataView<CertWithConstraintsDataView>(pointer, message_);
}
inline void AdditionalCertificatesDataView::GetDistrustedSpkisDataView(
    mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>* output) {
  auto pointer = data_->distrusted_spkis.Get();
  *output = mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>(pointer, message_);
}



}  // cert_verifier::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_CERT_VERIFIER_SERVICE_UPDATER_MOJOM_SHARED_H_