// services/network/public/mojom/cert_verifier_service_updater.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_CERT_VERIFIER_SERVICE_UPDATER_MOJOM_DATA_VIEW_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_CERT_VERIFIER_SERVICE_UPDATER_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "services/network/public/mojom/cert_verifier_service_updater.mojom-shared-internal.h"
#include "services/network/public/mojom/ct_policy.mojom-shared.h"
#include "services/network/public/mojom/ip_address.mojom-shared.h"


namespace cert_verifier::mojom {
class CIDRDataView;

class CertWithConstraintsDataView;

class AdditionalCertificatesDataView;



}  // cert_verifier::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::cert_verifier::mojom::CIDRDataView> {
  using Data = ::cert_verifier::mojom::internal::CIDR_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::cert_verifier::mojom::CertWithConstraintsDataView> {
  using Data = ::cert_verifier::mojom::internal::CertWithConstraints_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::cert_verifier::mojom::AdditionalCertificatesDataView> {
  using Data = ::cert_verifier::mojom::internal::AdditionalCertificates_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace cert_verifier::mojom {
// Interface base classes. They are used for type safety check.
class CertVerifierServiceUpdaterInterfaceBase {};

using CertVerifierServiceUpdaterPtrDataView =
    mojo::InterfacePtrDataView<CertVerifierServiceUpdaterInterfaceBase>;
using CertVerifierServiceUpdaterRequestDataView =
    mojo::InterfaceRequestDataView<CertVerifierServiceUpdaterInterfaceBase>;
using CertVerifierServiceUpdaterAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<CertVerifierServiceUpdaterInterfaceBase>;
using CertVerifierServiceUpdaterAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<CertVerifierServiceUpdaterInterfaceBase>;


class CIDRDataView {
 public:
  CIDRDataView() = default;

  CIDRDataView(
      internal::CIDR_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIpDataView(
      ::network::mojom::IPAddressDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIp(UserType* output) {
    
    auto* pointer = data_->ip.Get();
    return mojo::internal::Deserialize<::network::mojom::IPAddressDataView>(
        pointer, output, message_);
  }
  inline void GetMaskDataView(
      ::network::mojom::IPAddressDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMask(UserType* output) {
    
    auto* pointer = data_->mask.Get();
    return mojo::internal::Deserialize<::network::mojom::IPAddressDataView>(
        pointer, output, message_);
  }
 private:
  internal::CIDR_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CertWithConstraintsDataView {
 public:
  CertWithConstraintsDataView() = default;

  CertWithConstraintsDataView(
      internal::CertWithConstraints_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCertificateDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCertificate(UserType* output) {
    
    auto* pointer = data_->certificate.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  inline void GetPermittedDnsNamesDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPermittedDnsNames(UserType* output) {
    
    auto* pointer = data_->permitted_dns_names.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
  inline void GetPermittedCidrsDataView(
      mojo::ArrayDataView<CIDRDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPermittedCidrs(UserType* output) {
    
    auto* pointer = data_->permitted_cidrs.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::cert_verifier::mojom::CIDRDataView>>(
        pointer, output, message_);
  }
 private:
  internal::CertWithConstraints_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class AdditionalCertificatesDataView {
 public:
  AdditionalCertificatesDataView() = default;

  AdditionalCertificatesDataView(
      internal::AdditionalCertificates_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAllCertificatesDataView(
      mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAllCertificates(UserType* output) {
    
    auto* pointer = data_->all_certificates.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>>(
        pointer, output, message_);
  }
  inline void GetTrustAnchorsDataView(
      mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTrustAnchors(UserType* output) {
    
    auto* pointer = data_->trust_anchors.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>>(
        pointer, output, message_);
  }
  inline void GetTrustAnchorsWithEnforcedConstraintsDataView(
      mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTrustAnchorsWithEnforcedConstraints(UserType* output) {
    
    auto* pointer = data_->trust_anchors_with_enforced_constraints.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>>(
        pointer, output, message_);
  }
  inline void GetTrustAnchorsWithAdditionalConstraintsDataView(
      mojo::ArrayDataView<CertWithConstraintsDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTrustAnchorsWithAdditionalConstraints(UserType* output) {
    
    auto* pointer = data_->trust_anchors_with_additional_constraints.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::cert_verifier::mojom::CertWithConstraintsDataView>>(
        pointer, output, message_);
  }
  inline void GetTrustAnchorsAndLeafsDataView(
      mojo::ArrayDataView<CertWithConstraintsDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTrustAnchorsAndLeafs(UserType* output) {
    
    auto* pointer = data_->trust_anchors_and_leafs.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::cert_verifier::mojom::CertWithConstraintsDataView>>(
        pointer, output, message_);
  }
  inline void GetTrustLeafsDataView(
      mojo::ArrayDataView<CertWithConstraintsDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTrustLeafs(UserType* output) {
    
    auto* pointer = data_->trust_leafs.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::cert_verifier::mojom::CertWithConstraintsDataView>>(
        pointer, output, message_);
  }
  inline void GetDistrustedSpkisDataView(
      mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDistrustedSpkis(UserType* output) {
    
    auto* pointer = data_->distrusted_spkis.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>>(
        pointer, output, message_);
  }
  bool include_system_trust_store() const {
    return data_->include_system_trust_store;
  }
 private:
  internal::AdditionalCertificates_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // cert_verifier::mojom

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_CERT_VERIFIER_SERVICE_UPDATER_MOJOM_DATA_VIEW_H_