// services/network/public/mojom/cert_verifier_service_updater.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_CERT_VERIFIER_SERVICE_UPDATER_MOJOM_BLINK_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_CERT_VERIFIER_SERVICE_UPDATER_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/cert_verifier_service_updater.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/cert_verifier_service_updater.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/cert_verifier_service_updater.mojom-blink-forward.h"  // IWYU pragma: export
#include "services/network/public/mojom/ct_policy.mojom-blink-forward.h"
#include "services/network/public/mojom/ip_address.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace cert_verifier::mojom::blink {

class CertVerifierServiceUpdaterProxy;

template <typename ImplRefTraits>
class CertVerifierServiceUpdaterStub;

class CertVerifierServiceUpdaterRequestValidator;
class CertVerifierServiceUpdaterResponseValidator;


class BLINK_PLATFORM_EXPORT CertVerifierServiceUpdater
    : public CertVerifierServiceUpdaterInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "cert_verifier.mojom.CertVerifierServiceUpdater";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = CertVerifierServiceUpdaterInterfaceBase;
  using Proxy_ = CertVerifierServiceUpdaterProxy;

  template <typename ImplRefTraits>
  using Stub_ = CertVerifierServiceUpdaterStub<ImplRefTraits>;

  using RequestValidator_ = CertVerifierServiceUpdaterRequestValidator;
  using ResponseValidator_ = CertVerifierServiceUpdaterResponseValidator;
  enum MethodMinVersions : uint32_t {
    kUpdateAdditionalCertificatesMinVersion = 0,
    kWaitUntilNextUpdateForTestingMinVersion = 0,
    kSetCTPolicyMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct UpdateAdditionalCertificates_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct WaitUntilNextUpdateForTesting_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetCTPolicy_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~CertVerifierServiceUpdater() = default;

  virtual void UpdateAdditionalCertificates(AdditionalCertificatesPtr certificates) = 0;

  using WaitUntilNextUpdateForTestingCallback = base::OnceCallback<void()>;
  using WaitUntilNextUpdateForTestingMojoCallback = base::OnceCallback<void()>;

  virtual void WaitUntilNextUpdateForTesting(WaitUntilNextUpdateForTestingCallback callback) = 0;

  virtual void SetCTPolicy(::network::mojom::blink::CTPolicyPtr ct_policy) = 0;
};



class BLINK_PLATFORM_EXPORT CertVerifierServiceUpdaterProxy
    : public CertVerifierServiceUpdater {
 public:
  using InterfaceType = CertVerifierServiceUpdater;

  explicit CertVerifierServiceUpdaterProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void UpdateAdditionalCertificates(AdditionalCertificatesPtr certificates) final;
  
  void WaitUntilNextUpdateForTesting(WaitUntilNextUpdateForTestingCallback callback) final;
  
  void SetCTPolicy(::network::mojom::blink::CTPolicyPtr ct_policy) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_PLATFORM_EXPORT CertVerifierServiceUpdaterStubDispatch {
 public:
  static bool Accept(CertVerifierServiceUpdater* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CertVerifierServiceUpdater* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CertVerifierServiceUpdater>>
class CertVerifierServiceUpdaterStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CertVerifierServiceUpdaterStub() = default;
  ~CertVerifierServiceUpdaterStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CertVerifierServiceUpdaterStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CertVerifierServiceUpdaterStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT CertVerifierServiceUpdaterRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT CertVerifierServiceUpdaterResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};










class BLINK_PLATFORM_EXPORT CIDR {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CIDR, T>::value>;
  using DataView = CIDRDataView;
  using Data_ = internal::CIDR_Data;

  template <typename... Args>
  static CIDRPtr New(Args&&... args) {
    return CIDRPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CIDRPtr From(const U& u) {
    return mojo::TypeConverter<CIDRPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CIDR>::Convert(*this);
  }


  CIDR();

  CIDR(
      const ::net::IPAddress& ip,
      const ::net::IPAddress& mask);


  ~CIDR();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CIDRPtr>
  CIDRPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CIDR::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CIDR::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CIDR::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CIDR::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CIDR::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CIDR::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CIDR_UnserializedMessageContext<
            UserType, CIDR::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CIDR::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CIDR::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CIDR_UnserializedMessageContext<
            UserType, CIDR::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CIDR::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::net::IPAddress ip;
  
  ::net::IPAddress mask;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CIDR::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CIDR::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CIDR::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CIDR::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT CertWithConstraints {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CertWithConstraints, T>::value>;
  using DataView = CertWithConstraintsDataView;
  using Data_ = internal::CertWithConstraints_Data;

  template <typename... Args>
  static CertWithConstraintsPtr New(Args&&... args) {
    return CertWithConstraintsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CertWithConstraintsPtr From(const U& u) {
    return mojo::TypeConverter<CertWithConstraintsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CertWithConstraints>::Convert(*this);
  }


  CertWithConstraints();

  CertWithConstraints(
      ::blink::Vector<uint8_t> certificate,
      ::blink::Vector<::blink::String> permitted_dns_names,
      ::blink::Vector<CIDRPtr> permitted_cidrs);

CertWithConstraints(const CertWithConstraints&) = delete;
CertWithConstraints& operator=(const CertWithConstraints&) = delete;

  ~CertWithConstraints();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CertWithConstraintsPtr>
  CertWithConstraintsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CertWithConstraints::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CertWithConstraints::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CertWithConstraints::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CertWithConstraints::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CertWithConstraints::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CertWithConstraints::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CertWithConstraints_UnserializedMessageContext<
            UserType, CertWithConstraints::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CertWithConstraints::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CertWithConstraints::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CertWithConstraints_UnserializedMessageContext<
            UserType, CertWithConstraints::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CertWithConstraints::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::Vector<uint8_t> certificate;
  
  ::blink::Vector<::blink::String> permitted_dns_names;
  
  ::blink::Vector<CIDRPtr> permitted_cidrs;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CertWithConstraints::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CertWithConstraints::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CertWithConstraints::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CertWithConstraints::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT AdditionalCertificates {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AdditionalCertificates, T>::value>;
  using DataView = AdditionalCertificatesDataView;
  using Data_ = internal::AdditionalCertificates_Data;

  template <typename... Args>
  static AdditionalCertificatesPtr New(Args&&... args) {
    return AdditionalCertificatesPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AdditionalCertificatesPtr From(const U& u) {
    return mojo::TypeConverter<AdditionalCertificatesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AdditionalCertificates>::Convert(*this);
  }


  AdditionalCertificates();

  AdditionalCertificates(
      ::blink::Vector<::blink::Vector<uint8_t>> all_certificates,
      ::blink::Vector<::blink::Vector<uint8_t>> trust_anchors,
      ::blink::Vector<::blink::Vector<uint8_t>> trust_anchors_with_enforced_constraints,
      ::blink::Vector<CertWithConstraintsPtr> trust_anchors_with_additional_constraints,
      ::blink::Vector<CertWithConstraintsPtr> trust_anchors_and_leafs,
      ::blink::Vector<CertWithConstraintsPtr> trust_leafs,
      ::blink::Vector<::blink::Vector<uint8_t>> distrusted_spkis,
      bool include_system_trust_store);

AdditionalCertificates(const AdditionalCertificates&) = delete;
AdditionalCertificates& operator=(const AdditionalCertificates&) = delete;

  ~AdditionalCertificates();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AdditionalCertificatesPtr>
  AdditionalCertificatesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AdditionalCertificates::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AdditionalCertificates::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AdditionalCertificates::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AdditionalCertificates::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AdditionalCertificates::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AdditionalCertificates::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AdditionalCertificates_UnserializedMessageContext<
            UserType, AdditionalCertificates::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AdditionalCertificates::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AdditionalCertificates::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AdditionalCertificates_UnserializedMessageContext<
            UserType, AdditionalCertificates::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AdditionalCertificates::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::Vector<::blink::Vector<uint8_t>> all_certificates;
  
  ::blink::Vector<::blink::Vector<uint8_t>> trust_anchors;
  
  ::blink::Vector<::blink::Vector<uint8_t>> trust_anchors_with_enforced_constraints;
  
  ::blink::Vector<CertWithConstraintsPtr> trust_anchors_with_additional_constraints;
  
  ::blink::Vector<CertWithConstraintsPtr> trust_anchors_and_leafs;
  
  ::blink::Vector<CertWithConstraintsPtr> trust_leafs;
  
  ::blink::Vector<::blink::Vector<uint8_t>> distrusted_spkis;
  
  bool include_system_trust_store;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AdditionalCertificates::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AdditionalCertificates::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AdditionalCertificates::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AdditionalCertificates::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
CIDRPtr CIDR::Clone() const {
  return New(
      mojo::Clone(ip),
      mojo::Clone(mask)
  );
}

template <typename T, CIDR::EnableIfSame<T>*>
bool CIDR::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->ip, other_struct.ip))
    return false;
  if (!mojo::Equals(this->mask, other_struct.mask))
    return false;
  return true;
}

template <typename T, CIDR::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.ip < rhs.ip)
    return true;
  if (rhs.ip < lhs.ip)
    return false;
  if (lhs.mask < rhs.mask)
    return true;
  if (rhs.mask < lhs.mask)
    return false;
  return false;
}
template <typename StructPtrType>
CertWithConstraintsPtr CertWithConstraints::Clone() const {
  return New(
      mojo::Clone(certificate),
      mojo::Clone(permitted_dns_names),
      mojo::Clone(permitted_cidrs)
  );
}

template <typename T, CertWithConstraints::EnableIfSame<T>*>
bool CertWithConstraints::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->certificate, other_struct.certificate))
    return false;
  if (!mojo::Equals(this->permitted_dns_names, other_struct.permitted_dns_names))
    return false;
  if (!mojo::Equals(this->permitted_cidrs, other_struct.permitted_cidrs))
    return false;
  return true;
}

template <typename T, CertWithConstraints::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.certificate < rhs.certificate)
    return true;
  if (rhs.certificate < lhs.certificate)
    return false;
  if (lhs.permitted_dns_names < rhs.permitted_dns_names)
    return true;
  if (rhs.permitted_dns_names < lhs.permitted_dns_names)
    return false;
  if (lhs.permitted_cidrs < rhs.permitted_cidrs)
    return true;
  if (rhs.permitted_cidrs < lhs.permitted_cidrs)
    return false;
  return false;
}
template <typename StructPtrType>
AdditionalCertificatesPtr AdditionalCertificates::Clone() const {
  return New(
      mojo::Clone(all_certificates),
      mojo::Clone(trust_anchors),
      mojo::Clone(trust_anchors_with_enforced_constraints),
      mojo::Clone(trust_anchors_with_additional_constraints),
      mojo::Clone(trust_anchors_and_leafs),
      mojo::Clone(trust_leafs),
      mojo::Clone(distrusted_spkis),
      mojo::Clone(include_system_trust_store)
  );
}

template <typename T, AdditionalCertificates::EnableIfSame<T>*>
bool AdditionalCertificates::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->all_certificates, other_struct.all_certificates))
    return false;
  if (!mojo::Equals(this->trust_anchors, other_struct.trust_anchors))
    return false;
  if (!mojo::Equals(this->trust_anchors_with_enforced_constraints, other_struct.trust_anchors_with_enforced_constraints))
    return false;
  if (!mojo::Equals(this->trust_anchors_with_additional_constraints, other_struct.trust_anchors_with_additional_constraints))
    return false;
  if (!mojo::Equals(this->trust_anchors_and_leafs, other_struct.trust_anchors_and_leafs))
    return false;
  if (!mojo::Equals(this->trust_leafs, other_struct.trust_leafs))
    return false;
  if (!mojo::Equals(this->distrusted_spkis, other_struct.distrusted_spkis))
    return false;
  if (!mojo::Equals(this->include_system_trust_store, other_struct.include_system_trust_store))
    return false;
  return true;
}

template <typename T, AdditionalCertificates::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.all_certificates < rhs.all_certificates)
    return true;
  if (rhs.all_certificates < lhs.all_certificates)
    return false;
  if (lhs.trust_anchors < rhs.trust_anchors)
    return true;
  if (rhs.trust_anchors < lhs.trust_anchors)
    return false;
  if (lhs.trust_anchors_with_enforced_constraints < rhs.trust_anchors_with_enforced_constraints)
    return true;
  if (rhs.trust_anchors_with_enforced_constraints < lhs.trust_anchors_with_enforced_constraints)
    return false;
  if (lhs.trust_anchors_with_additional_constraints < rhs.trust_anchors_with_additional_constraints)
    return true;
  if (rhs.trust_anchors_with_additional_constraints < lhs.trust_anchors_with_additional_constraints)
    return false;
  if (lhs.trust_anchors_and_leafs < rhs.trust_anchors_and_leafs)
    return true;
  if (rhs.trust_anchors_and_leafs < lhs.trust_anchors_and_leafs)
    return false;
  if (lhs.trust_leafs < rhs.trust_leafs)
    return true;
  if (rhs.trust_leafs < lhs.trust_leafs)
    return false;
  if (lhs.distrusted_spkis < rhs.distrusted_spkis)
    return true;
  if (rhs.distrusted_spkis < lhs.distrusted_spkis)
    return false;
  if (lhs.include_system_trust_store < rhs.include_system_trust_store)
    return true;
  if (rhs.include_system_trust_store < lhs.include_system_trust_store)
    return false;
  return false;
}


}  // cert_verifier::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::cert_verifier::mojom::blink::CIDR::DataView,
                                         ::cert_verifier::mojom::blink::CIDRPtr> {
  static bool IsNull(const ::cert_verifier::mojom::blink::CIDRPtr& input) { return !input; }
  static void SetToNull(::cert_verifier::mojom::blink::CIDRPtr* output) { output->reset(); }

  static const decltype(::cert_verifier::mojom::blink::CIDR::ip)& ip(
      const ::cert_verifier::mojom::blink::CIDRPtr& input) {
    return input->ip;
  }

  static const decltype(::cert_verifier::mojom::blink::CIDR::mask)& mask(
      const ::cert_verifier::mojom::blink::CIDRPtr& input) {
    return input->mask;
  }

  static bool Read(::cert_verifier::mojom::blink::CIDR::DataView input, ::cert_verifier::mojom::blink::CIDRPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::cert_verifier::mojom::blink::CertWithConstraints::DataView,
                                         ::cert_verifier::mojom::blink::CertWithConstraintsPtr> {
  static bool IsNull(const ::cert_verifier::mojom::blink::CertWithConstraintsPtr& input) { return !input; }
  static void SetToNull(::cert_verifier::mojom::blink::CertWithConstraintsPtr* output) { output->reset(); }

  static const decltype(::cert_verifier::mojom::blink::CertWithConstraints::certificate)& certificate(
      const ::cert_verifier::mojom::blink::CertWithConstraintsPtr& input) {
    return input->certificate;
  }

  static const decltype(::cert_verifier::mojom::blink::CertWithConstraints::permitted_dns_names)& permitted_dns_names(
      const ::cert_verifier::mojom::blink::CertWithConstraintsPtr& input) {
    return input->permitted_dns_names;
  }

  static const decltype(::cert_verifier::mojom::blink::CertWithConstraints::permitted_cidrs)& permitted_cidrs(
      const ::cert_verifier::mojom::blink::CertWithConstraintsPtr& input) {
    return input->permitted_cidrs;
  }

  static bool Read(::cert_verifier::mojom::blink::CertWithConstraints::DataView input, ::cert_verifier::mojom::blink::CertWithConstraintsPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::cert_verifier::mojom::blink::AdditionalCertificates::DataView,
                                         ::cert_verifier::mojom::blink::AdditionalCertificatesPtr> {
  static bool IsNull(const ::cert_verifier::mojom::blink::AdditionalCertificatesPtr& input) { return !input; }
  static void SetToNull(::cert_verifier::mojom::blink::AdditionalCertificatesPtr* output) { output->reset(); }

  static const decltype(::cert_verifier::mojom::blink::AdditionalCertificates::all_certificates)& all_certificates(
      const ::cert_verifier::mojom::blink::AdditionalCertificatesPtr& input) {
    return input->all_certificates;
  }

  static const decltype(::cert_verifier::mojom::blink::AdditionalCertificates::trust_anchors)& trust_anchors(
      const ::cert_verifier::mojom::blink::AdditionalCertificatesPtr& input) {
    return input->trust_anchors;
  }

  static const decltype(::cert_verifier::mojom::blink::AdditionalCertificates::trust_anchors_with_enforced_constraints)& trust_anchors_with_enforced_constraints(
      const ::cert_verifier::mojom::blink::AdditionalCertificatesPtr& input) {
    return input->trust_anchors_with_enforced_constraints;
  }

  static const decltype(::cert_verifier::mojom::blink::AdditionalCertificates::trust_anchors_with_additional_constraints)& trust_anchors_with_additional_constraints(
      const ::cert_verifier::mojom::blink::AdditionalCertificatesPtr& input) {
    return input->trust_anchors_with_additional_constraints;
  }

  static const decltype(::cert_verifier::mojom::blink::AdditionalCertificates::trust_anchors_and_leafs)& trust_anchors_and_leafs(
      const ::cert_verifier::mojom::blink::AdditionalCertificatesPtr& input) {
    return input->trust_anchors_and_leafs;
  }

  static const decltype(::cert_verifier::mojom::blink::AdditionalCertificates::trust_leafs)& trust_leafs(
      const ::cert_verifier::mojom::blink::AdditionalCertificatesPtr& input) {
    return input->trust_leafs;
  }

  static const decltype(::cert_verifier::mojom::blink::AdditionalCertificates::distrusted_spkis)& distrusted_spkis(
      const ::cert_verifier::mojom::blink::AdditionalCertificatesPtr& input) {
    return input->distrusted_spkis;
  }

  static decltype(::cert_verifier::mojom::blink::AdditionalCertificates::include_system_trust_store) include_system_trust_store(
      const ::cert_verifier::mojom::blink::AdditionalCertificatesPtr& input) {
    return input->include_system_trust_store;
  }

  static bool Read(::cert_verifier::mojom::blink::AdditionalCertificates::DataView input, ::cert_verifier::mojom::blink::AdditionalCertificatesPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_CERT_VERIFIER_SERVICE_UPDATER_MOJOM_BLINK_H_