// services/network/public/mojom/cert_verifier_service.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_CERT_VERIFIER_SERVICE_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_CERT_VERIFIER_SERVICE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/cert_verifier_service.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/cert_verifier_service.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/cert_verifier_service.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/byte_string.mojom.h"
#include "mojo/public/mojom/base/time.mojom-forward.h"
#include "services/network/public/mojom/network_param.mojom.h"
#include "services/network/public/mojom/url_loader_factory.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "mojo/public/cpp/bindings/lib/native_enum_serialization.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"
#include "services/network/public/cpp/cert_verifier/cert_verifier_mojom_traits.h"




namespace cert_verifier::mojom {

class URLLoaderFactoryConnectorProxy;

template <typename ImplRefTraits>
class URLLoaderFactoryConnectorStub;

class URLLoaderFactoryConnectorRequestValidator;


class URLLoaderFactoryConnector
    : public URLLoaderFactoryConnectorInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "cert_verifier.mojom.URLLoaderFactoryConnector";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = URLLoaderFactoryConnectorInterfaceBase;
  using Proxy_ = URLLoaderFactoryConnectorProxy;

  template <typename ImplRefTraits>
  using Stub_ = URLLoaderFactoryConnectorStub<ImplRefTraits>;

  using RequestValidator_ = URLLoaderFactoryConnectorRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreateURLLoaderFactoryMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateURLLoaderFactory_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~URLLoaderFactoryConnector() = default;

  virtual void CreateURLLoaderFactory(::mojo::PendingReceiver<::network::mojom::URLLoaderFactory> url_loader_factory) = 0;
};

class CertVerifierServiceProxy;

template <typename ImplRefTraits>
class CertVerifierServiceStub;

class CertVerifierServiceRequestValidator;
class CertVerifierServiceResponseValidator;


class CertVerifierService
    : public CertVerifierServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "cert_verifier.mojom.CertVerifierService";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = CertVerifierServiceInterfaceBase;
  using Proxy_ = CertVerifierServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = CertVerifierServiceStub<ImplRefTraits>;

  using RequestValidator_ = CertVerifierServiceRequestValidator;
  using ResponseValidator_ = CertVerifierServiceResponseValidator;
  enum MethodMinVersions : uint32_t {
    kEnableNetworkAccessMinVersion = 0,
    kVerifyMinVersion = 0,
    kVerify2QwacBindingMinVersion = 0,
    kSetConfigMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct EnableNetworkAccess_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Verify_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Verify2QwacBinding_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetConfig_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~CertVerifierService() = default;

  virtual void EnableNetworkAccess(::mojo::PendingRemote<::network::mojom::URLLoaderFactory> url_loader_factory, ::mojo::PendingRemote<URLLoaderFactoryConnector> reconnector) = 0;

  virtual void Verify(const ::net::CertVerifier::RequestParams& params, const ::net::NetLogSource& net_log_source, ::mojo::PendingRemote<CertVerifierRequest> cert_verifier_request) = 0;

  using Verify2QwacBindingCallback = base::OnceCallback<void(const ::scoped_refptr<::net::X509Certificate>&)>;
  using Verify2QwacBindingMojoCallback = base::OnceCallback<void(const ::scoped_refptr<::net::X509Certificate>&)>;

  virtual void Verify2QwacBinding(const std::string& binding, const std::string& hostname, const ::scoped_refptr<::net::X509Certificate>& tls_certificate, const ::net::NetLogSource& net_log_source, Verify2QwacBindingCallback callback) = 0;

  virtual void SetConfig(const ::net::CertVerifier::Config& config) = 0;
};

class CertVerifierServiceClientProxy;

template <typename ImplRefTraits>
class CertVerifierServiceClientStub;

class CertVerifierServiceClientRequestValidator;


class CertVerifierServiceClient
    : public CertVerifierServiceClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "cert_verifier.mojom.CertVerifierServiceClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = CertVerifierServiceClientInterfaceBase;
  using Proxy_ = CertVerifierServiceClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = CertVerifierServiceClientStub<ImplRefTraits>;

  using RequestValidator_ = CertVerifierServiceClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnCertVerifierChangedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnCertVerifierChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~CertVerifierServiceClient() = default;

  virtual void OnCertVerifierChanged() = 0;
};

class CertVerifierRequestProxy;

template <typename ImplRefTraits>
class CertVerifierRequestStub;

class CertVerifierRequestRequestValidator;


class CertVerifierRequest
    : public CertVerifierRequestInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "cert_verifier.mojom.CertVerifierRequest";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = CertVerifierRequestInterfaceBase;
  using Proxy_ = CertVerifierRequestProxy;

  template <typename ImplRefTraits>
  using Stub_ = CertVerifierRequestStub<ImplRefTraits>;

  using RequestValidator_ = CertVerifierRequestRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCompleteMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Complete_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~CertVerifierRequest() = default;

  virtual void Complete(const ::net::CertVerifyResult& result, int32_t net_error) = 0;
};



class  URLLoaderFactoryConnectorProxy
    : public URLLoaderFactoryConnector {
 public:
  using InterfaceType = URLLoaderFactoryConnector;

  explicit URLLoaderFactoryConnectorProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateURLLoaderFactory(::mojo::PendingReceiver<::network::mojom::URLLoaderFactory> url_loader_factory) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  CertVerifierServiceProxy
    : public CertVerifierService {
 public:
  using InterfaceType = CertVerifierService;

  explicit CertVerifierServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void EnableNetworkAccess(::mojo::PendingRemote<::network::mojom::URLLoaderFactory> url_loader_factory, ::mojo::PendingRemote<URLLoaderFactoryConnector> reconnector) final;
  
  void Verify(const ::net::CertVerifier::RequestParams& params, const ::net::NetLogSource& net_log_source, ::mojo::PendingRemote<CertVerifierRequest> cert_verifier_request) final;
  
  void Verify2QwacBinding(const std::string& binding, const std::string& hostname, const ::scoped_refptr<::net::X509Certificate>& tls_certificate, const ::net::NetLogSource& net_log_source, Verify2QwacBindingCallback callback) final;
  
  void SetConfig(const ::net::CertVerifier::Config& config) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  CertVerifierServiceClientProxy
    : public CertVerifierServiceClient {
 public:
  using InterfaceType = CertVerifierServiceClient;

  explicit CertVerifierServiceClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnCertVerifierChanged() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  CertVerifierRequestProxy
    : public CertVerifierRequest {
 public:
  using InterfaceType = CertVerifierRequest;

  explicit CertVerifierRequestProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Complete(const ::net::CertVerifyResult& result, int32_t net_error) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  URLLoaderFactoryConnectorStubDispatch {
 public:
  static bool Accept(URLLoaderFactoryConnector* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      URLLoaderFactoryConnector* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<URLLoaderFactoryConnector>>
class URLLoaderFactoryConnectorStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  URLLoaderFactoryConnectorStub() = default;
  ~URLLoaderFactoryConnectorStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return URLLoaderFactoryConnectorStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return URLLoaderFactoryConnectorStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  CertVerifierServiceStubDispatch {
 public:
  static bool Accept(CertVerifierService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CertVerifierService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CertVerifierService>>
class CertVerifierServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CertVerifierServiceStub() = default;
  ~CertVerifierServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CertVerifierServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CertVerifierServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  CertVerifierServiceClientStubDispatch {
 public:
  static bool Accept(CertVerifierServiceClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CertVerifierServiceClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CertVerifierServiceClient>>
class CertVerifierServiceClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CertVerifierServiceClientStub() = default;
  ~CertVerifierServiceClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CertVerifierServiceClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CertVerifierServiceClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  CertVerifierRequestStubDispatch {
 public:
  static bool Accept(CertVerifierRequest* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CertVerifierRequest* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CertVerifierRequest>>
class CertVerifierRequestStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CertVerifierRequestStub() = default;
  ~CertVerifierRequestStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CertVerifierRequestStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CertVerifierRequestStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  URLLoaderFactoryConnectorRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  CertVerifierServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  CertVerifierServiceClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  CertVerifierRequestRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  CertVerifierServiceResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};






class  CertVerifierConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CertVerifierConfig, T>::value>;
  using DataView = CertVerifierConfigDataView;
  using Data_ = internal::CertVerifierConfig_Data;

  template <typename... Args>
  static CertVerifierConfigPtr New(Args&&... args) {
    return CertVerifierConfigPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CertVerifierConfigPtr From(const U& u) {
    return mojo::TypeConverter<CertVerifierConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CertVerifierConfig>::Convert(*this);
  }


  CertVerifierConfig();

  CertVerifierConfig(
      bool enable_rev_checking,
      bool require_rev_checking_local_anchors,
      bool enable_sha1_local_anchors);


  ~CertVerifierConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CertVerifierConfigPtr>
  CertVerifierConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CertVerifierConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CertVerifierConfig::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CertVerifierConfig::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CertVerifierConfig::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CertVerifierConfig::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CertVerifierConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CertVerifierConfig_UnserializedMessageContext<
            UserType, CertVerifierConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CertVerifierConfig::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CertVerifierConfig::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CertVerifierConfig_UnserializedMessageContext<
            UserType, CertVerifierConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CertVerifierConfig::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool enable_rev_checking;
  
  bool require_rev_checking_local_anchors;
  
  bool enable_sha1_local_anchors;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CertVerifierConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CertVerifierConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CertVerifierConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CertVerifierConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class  RequestParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<RequestParams, T>::value>;
  using DataView = RequestParamsDataView;
  using Data_ = internal::RequestParams_Data;

  template <typename... Args>
  static RequestParamsPtr New(Args&&... args) {
    return RequestParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RequestParamsPtr From(const U& u) {
    return mojo::TypeConverter<RequestParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RequestParams>::Convert(*this);
  }


  RequestParams();

  RequestParams(
      const ::scoped_refptr<::net::X509Certificate>& certificate,
      const std::string& hostname,
      int32_t flags,
      const std::string& ocsp_response,
      const std::string& sct_list);


  ~RequestParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RequestParamsPtr>
  RequestParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, RequestParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, RequestParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, RequestParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RequestParams::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RequestParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RequestParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::RequestParams_UnserializedMessageContext<
            UserType, RequestParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<RequestParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return RequestParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::RequestParams_UnserializedMessageContext<
            UserType, RequestParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<RequestParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::scoped_refptr<::net::X509Certificate> certificate;
  
  std::string hostname;
  
  int32_t flags;
  
  std::string ocsp_response;
  
  std::string sct_list;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, RequestParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, RequestParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, RequestParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, RequestParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}


template <typename StructPtrType>
RequestParamsPtr RequestParams::Clone() const {
  return New(
      mojo::Clone(certificate),
      mojo::Clone(hostname),
      mojo::Clone(flags),
      mojo::Clone(ocsp_response),
      mojo::Clone(sct_list)
  );
}

template <typename T, RequestParams::EnableIfSame<T>*>
bool RequestParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->certificate, other_struct.certificate))
    return false;
  if (!mojo::Equals(this->hostname, other_struct.hostname))
    return false;
  if (!mojo::Equals(this->flags, other_struct.flags))
    return false;
  if (!mojo::Equals(this->ocsp_response, other_struct.ocsp_response))
    return false;
  if (!mojo::Equals(this->sct_list, other_struct.sct_list))
    return false;
  return true;
}

template <typename T, RequestParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.certificate < rhs.certificate)
    return true;
  if (rhs.certificate < lhs.certificate)
    return false;
  if (lhs.hostname < rhs.hostname)
    return true;
  if (rhs.hostname < lhs.hostname)
    return false;
  if (lhs.flags < rhs.flags)
    return true;
  if (rhs.flags < lhs.flags)
    return false;
  if (lhs.ocsp_response < rhs.ocsp_response)
    return true;
  if (rhs.ocsp_response < lhs.ocsp_response)
    return false;
  if (lhs.sct_list < rhs.sct_list)
    return true;
  if (rhs.sct_list < lhs.sct_list)
    return false;
  return false;
}
template <typename StructPtrType>
CertVerifierConfigPtr CertVerifierConfig::Clone() const {
  return New(
      mojo::Clone(enable_rev_checking),
      mojo::Clone(require_rev_checking_local_anchors),
      mojo::Clone(enable_sha1_local_anchors)
  );
}

template <typename T, CertVerifierConfig::EnableIfSame<T>*>
bool CertVerifierConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->enable_rev_checking, other_struct.enable_rev_checking))
    return false;
  if (!mojo::Equals(this->require_rev_checking_local_anchors, other_struct.require_rev_checking_local_anchors))
    return false;
  if (!mojo::Equals(this->enable_sha1_local_anchors, other_struct.enable_sha1_local_anchors))
    return false;
  return true;
}

template <typename T, CertVerifierConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.enable_rev_checking < rhs.enable_rev_checking)
    return true;
  if (rhs.enable_rev_checking < lhs.enable_rev_checking)
    return false;
  if (lhs.require_rev_checking_local_anchors < rhs.require_rev_checking_local_anchors)
    return true;
  if (rhs.require_rev_checking_local_anchors < lhs.require_rev_checking_local_anchors)
    return false;
  if (lhs.enable_sha1_local_anchors < rhs.enable_sha1_local_anchors)
    return true;
  if (rhs.enable_sha1_local_anchors < lhs.enable_sha1_local_anchors)
    return false;
  return false;
}


}  // cert_verifier::mojom

namespace mojo {


template <>
struct  StructTraits<::cert_verifier::mojom::RequestParams::DataView,
                                         ::cert_verifier::mojom::RequestParamsPtr> {
  static bool IsNull(const ::cert_verifier::mojom::RequestParamsPtr& input) { return !input; }
  static void SetToNull(::cert_verifier::mojom::RequestParamsPtr* output) { output->reset(); }

  static const decltype(::cert_verifier::mojom::RequestParams::certificate)& certificate(
      const ::cert_verifier::mojom::RequestParamsPtr& input) {
    return input->certificate;
  }

  static const decltype(::cert_verifier::mojom::RequestParams::hostname)& hostname(
      const ::cert_verifier::mojom::RequestParamsPtr& input) {
    return input->hostname;
  }

  static decltype(::cert_verifier::mojom::RequestParams::flags) flags(
      const ::cert_verifier::mojom::RequestParamsPtr& input) {
    return input->flags;
  }

  static const decltype(::cert_verifier::mojom::RequestParams::ocsp_response)& ocsp_response(
      const ::cert_verifier::mojom::RequestParamsPtr& input) {
    return input->ocsp_response;
  }

  static const decltype(::cert_verifier::mojom::RequestParams::sct_list)& sct_list(
      const ::cert_verifier::mojom::RequestParamsPtr& input) {
    return input->sct_list;
  }

  static bool Read(::cert_verifier::mojom::RequestParams::DataView input, ::cert_verifier::mojom::RequestParamsPtr* output);
};


template <>
struct  StructTraits<::cert_verifier::mojom::CertVerifierConfig::DataView,
                                         ::cert_verifier::mojom::CertVerifierConfigPtr> {
  static bool IsNull(const ::cert_verifier::mojom::CertVerifierConfigPtr& input) { return !input; }
  static void SetToNull(::cert_verifier::mojom::CertVerifierConfigPtr* output) { output->reset(); }

  static decltype(::cert_verifier::mojom::CertVerifierConfig::enable_rev_checking) enable_rev_checking(
      const ::cert_verifier::mojom::CertVerifierConfigPtr& input) {
    return input->enable_rev_checking;
  }

  static decltype(::cert_verifier::mojom::CertVerifierConfig::require_rev_checking_local_anchors) require_rev_checking_local_anchors(
      const ::cert_verifier::mojom::CertVerifierConfigPtr& input) {
    return input->require_rev_checking_local_anchors;
  }

  static decltype(::cert_verifier::mojom::CertVerifierConfig::enable_sha1_local_anchors) enable_sha1_local_anchors(
      const ::cert_verifier::mojom::CertVerifierConfigPtr& input) {
    return input->enable_sha1_local_anchors;
  }

  static bool Read(::cert_verifier::mojom::CertVerifierConfig::DataView input, ::cert_verifier::mojom::CertVerifierConfigPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_CERT_VERIFIER_SERVICE_MOJOM_H_