// services/network/public/mojom/cert_verifier_service.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_CERT_VERIFIER_SERVICE_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_CERT_VERIFIER_SERVICE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/cert_verifier_service.mojom-shared-internal.h"
#include "mojo/public/mojom/base/byte_string.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/network/public/mojom/network_param.mojom-shared.h"
#include "services/network/public/mojom/url_loader_factory.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"


#include "mojo/public/cpp/bindings/native_enum.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"

#include "services/network/public/mojom/cert_verifier_service.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::cert_verifier::mojom::RequestParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::cert_verifier::mojom::RequestParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::cert_verifier::mojom::internal::RequestParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::certificate(input)) in_certificate = Traits::certificate(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->certificate)::BaseType> certificate_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::X509CertificateDataView>(
      in_certificate,
      certificate_fragment);

    fragment->certificate.Set(
        certificate_fragment.is_null() ? nullptr : certificate_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->certificate.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null certificate in RequestParams struct");

    decltype(Traits::hostname(input)) in_hostname = Traits::hostname(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->hostname)::BaseType> hostname_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_hostname,
      hostname_fragment);

    fragment->hostname.Set(
        hostname_fragment.is_null() ? nullptr : hostname_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->hostname.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null hostname in RequestParams struct");

    fragment->flags = Traits::flags(input);

    decltype(Traits::ocsp_response(input)) in_ocsp_response = Traits::ocsp_response(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->ocsp_response)::BaseType> ocsp_response_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::ByteStringDataView>(
      in_ocsp_response,
      ocsp_response_fragment);

    fragment->ocsp_response.Set(
        ocsp_response_fragment.is_null() ? nullptr : ocsp_response_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->ocsp_response.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null ocsp_response in RequestParams struct");

    decltype(Traits::sct_list(input)) in_sct_list = Traits::sct_list(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->sct_list)::BaseType> sct_list_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::ByteStringDataView>(
      in_sct_list,
      sct_list_fragment);

    fragment->sct_list.Set(
        sct_list_fragment.is_null() ? nullptr : sct_list_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->sct_list.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null sct_list in RequestParams struct");
  }

  static bool Deserialize(::cert_verifier::mojom::internal::RequestParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::cert_verifier::mojom::RequestParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::cert_verifier::mojom::CertVerifierConfigDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::cert_verifier::mojom::CertVerifierConfigDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::cert_verifier::mojom::internal::CertVerifierConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->enable_rev_checking = Traits::enable_rev_checking(input);

    fragment->require_rev_checking_local_anchors = Traits::require_rev_checking_local_anchors(input);

    fragment->enable_sha1_local_anchors = Traits::enable_sha1_local_anchors(input);
  }

  static bool Deserialize(::cert_verifier::mojom::internal::CertVerifierConfig_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::cert_verifier::mojom::CertVerifierConfigDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace cert_verifier::mojom {

inline void RequestParamsDataView::GetCertificateDataView(
    ::network::mojom::X509CertificateDataView* output) {
  auto pointer = data_->certificate.Get();
  *output = ::network::mojom::X509CertificateDataView(pointer, message_);
}
inline void RequestParamsDataView::GetHostnameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->hostname.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void RequestParamsDataView::GetOcspResponseDataView(
    ::mojo_base::mojom::ByteStringDataView* output) {
  auto pointer = data_->ocsp_response.Get();
  *output = ::mojo_base::mojom::ByteStringDataView(pointer, message_);
}
inline void RequestParamsDataView::GetSctListDataView(
    ::mojo_base::mojom::ByteStringDataView* output) {
  auto pointer = data_->sct_list.Get();
  *output = ::mojo_base::mojom::ByteStringDataView(pointer, message_);
}





}  // cert_verifier::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_CERT_VERIFIER_SERVICE_MOJOM_SHARED_H_