// services/network/public/mojom/cert_verifier_service.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_CERT_VERIFIER_SERVICE_MOJOM_SEND_VALIDATION_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_CERT_VERIFIER_SERVICE_MOJOM_SEND_VALIDATION_H_

#include "services/network/public/mojom/cert_verifier_service.mojom-shared-internal.h"
#include "mojo/public/mojom/base/byte_string.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/network/public/mojom/network_param.mojom-shared.h"
#include "services/network/public/mojom/url_loader_factory.mojom-shared.h"

#include "services/network/public/mojom/cert_verifier_service.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::cert_verifier::mojom::RequestParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::cert_verifier::mojom::RequestParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::cert_verifier::mojom::internal::RequestParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::certificate(input)) in_certificate = Traits::certificate(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->certificate)::BaseType> certificate_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::X509CertificateDataView, send_validation>(
        in_certificate,
        certificate_fragment);

      fragment->certificate.Set(
          certificate_fragment.is_null() ? nullptr : certificate_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->certificate.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null certificate in RequestParams struct");

      decltype(Traits::hostname(input)) in_hostname = Traits::hostname(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->hostname)::BaseType> hostname_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_hostname,
        hostname_fragment);

      fragment->hostname.Set(
          hostname_fragment.is_null() ? nullptr : hostname_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->hostname.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null hostname in RequestParams struct");

      fragment->flags = Traits::flags(input);

      decltype(Traits::ocsp_response(input)) in_ocsp_response = Traits::ocsp_response(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->ocsp_response)::BaseType> ocsp_response_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::ByteStringDataView, send_validation>(
        in_ocsp_response,
        ocsp_response_fragment);

      fragment->ocsp_response.Set(
          ocsp_response_fragment.is_null() ? nullptr : ocsp_response_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->ocsp_response.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null ocsp_response in RequestParams struct");

      decltype(Traits::sct_list(input)) in_sct_list = Traits::sct_list(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->sct_list)::BaseType> sct_list_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::ByteStringDataView, send_validation>(
        in_sct_list,
        sct_list_fragment);

      fragment->sct_list.Set(
          sct_list_fragment.is_null() ? nullptr : sct_list_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->sct_list.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null sct_list in RequestParams struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::cert_verifier::mojom::CertVerifierConfigDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::cert_verifier::mojom::CertVerifierConfigDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::cert_verifier::mojom::internal::CertVerifierConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->enable_rev_checking = Traits::enable_rev_checking(input);

      fragment->require_rev_checking_local_anchors = Traits::require_rev_checking_local_anchors(input);

      fragment->enable_sha1_local_anchors = Traits::enable_sha1_local_anchors(input);
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_CERT_VERIFIER_SERVICE_MOJOM_SEND_VALIDATION_H_