// services/network/public/mojom/cache_encryption_provider.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/network/public/mojom/cache_encryption_provider.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('network.mojom');
  var encryptor$ =
      mojo.internal.exposeNamespace('osCryptAsync.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'components/os_crypt/async/common/encryptor.mojom', '../../../../components/os_crypt/async/common/encryptor.mojom.js');
  }



  function CacheEncryptionProvider_GetEncryptor_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CacheEncryptionProvider_GetEncryptor_Params.prototype.initDefaults_ = function() {
  };
  CacheEncryptionProvider_GetEncryptor_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CacheEncryptionProvider_GetEncryptor_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CacheEncryptionProvider_GetEncryptor_Params.encodedSize = codec.kStructHeaderSize + 0;

  CacheEncryptionProvider_GetEncryptor_Params.decode = function(decoder) {
    var packed;
    var val = new CacheEncryptionProvider_GetEncryptor_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  CacheEncryptionProvider_GetEncryptor_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CacheEncryptionProvider_GetEncryptor_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function CacheEncryptionProvider_GetEncryptor_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CacheEncryptionProvider_GetEncryptor_ResponseParams.prototype.initDefaults_ = function() {
    this.encryptor = null;
  };
  CacheEncryptionProvider_GetEncryptor_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CacheEncryptionProvider_GetEncryptor_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CacheEncryptionProvider_GetEncryptor_ResponseParams.encryptor
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, encryptor$.Encryptor, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CacheEncryptionProvider_GetEncryptor_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  CacheEncryptionProvider_GetEncryptor_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new CacheEncryptionProvider_GetEncryptor_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.encryptor =
        decoder.decodeStructPointer(encryptor$.Encryptor);
    return val;
  };

  CacheEncryptionProvider_GetEncryptor_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CacheEncryptionProvider_GetEncryptor_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(encryptor$.Encryptor, val.encryptor);
  };
  var kCacheEncryptionProvider_GetEncryptor_Name = 0;

  function CacheEncryptionProviderPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(CacheEncryptionProvider,
                                                   handleOrPtrInfo);
  }

  function CacheEncryptionProviderAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        CacheEncryptionProvider, associatedInterfacePtrInfo);
  }

  CacheEncryptionProviderAssociatedPtr.prototype =
      Object.create(CacheEncryptionProviderPtr.prototype);
  CacheEncryptionProviderAssociatedPtr.prototype.constructor =
      CacheEncryptionProviderAssociatedPtr;

  function CacheEncryptionProviderProxy(receiver) {
    this.receiver_ = receiver;
  }
  CacheEncryptionProviderPtr.prototype.getEncryptor = function() {
    return CacheEncryptionProviderProxy.prototype.getEncryptor
        .apply(this.ptr.getProxy(), arguments);
  };

  CacheEncryptionProviderProxy.prototype.getEncryptor = function() {
    var params_ = new CacheEncryptionProvider_GetEncryptor_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kCacheEncryptionProvider_GetEncryptor_Name,
          codec.align(CacheEncryptionProvider_GetEncryptor_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(CacheEncryptionProvider_GetEncryptor_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(CacheEncryptionProvider_GetEncryptor_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function CacheEncryptionProviderStub(delegate) {
    this.delegate_ = delegate;
  }
  CacheEncryptionProviderStub.prototype.getEncryptor = function() {
    return this.delegate_ && this.delegate_.getEncryptor && this.delegate_.getEncryptor();
  }

  CacheEncryptionProviderStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  CacheEncryptionProviderStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kCacheEncryptionProvider_GetEncryptor_Name:
      var params = reader.decodeStruct(CacheEncryptionProvider_GetEncryptor_Params);
      this.getEncryptor().then(function(response) {
        var responseParams =
            new CacheEncryptionProvider_GetEncryptor_ResponseParams();
        responseParams.encryptor = response.encryptor;
        var builder = new codec.MessageV1Builder(
            kCacheEncryptionProvider_GetEncryptor_Name,
            codec.align(CacheEncryptionProvider_GetEncryptor_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(CacheEncryptionProvider_GetEncryptor_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateCacheEncryptionProviderRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kCacheEncryptionProvider_GetEncryptor_Name:
        if (message.expectsResponse())
          paramsClass = CacheEncryptionProvider_GetEncryptor_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateCacheEncryptionProviderResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kCacheEncryptionProvider_GetEncryptor_Name:
        if (message.isResponse())
          paramsClass = CacheEncryptionProvider_GetEncryptor_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var CacheEncryptionProvider = {
    name: 'network.mojom.CacheEncryptionProvider',
    kVersion: 0,
    ptrClass: CacheEncryptionProviderPtr,
    proxyClass: CacheEncryptionProviderProxy,
    stubClass: CacheEncryptionProviderStub,
    validateRequest: validateCacheEncryptionProviderRequest,
    validateResponse: validateCacheEncryptionProviderResponse,
  };
  CacheEncryptionProviderStub.prototype.validator = validateCacheEncryptionProviderRequest;
  CacheEncryptionProviderProxy.prototype.validator = validateCacheEncryptionProviderResponse;
  exports.CacheEncryptionProvider = CacheEncryptionProvider;
  exports.CacheEncryptionProviderPtr = CacheEncryptionProviderPtr;
  exports.CacheEncryptionProviderAssociatedPtr = CacheEncryptionProviderAssociatedPtr;
})();