// services/network/public/mojom/cache_encryption_provider.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('network.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
network.mojom.CacheEncryptionProviderPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        network.mojom.CacheEncryptionProvider.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { network.mojom.CacheEncryptionProviderInterface }
 */
network.mojom.CacheEncryptionProviderRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!network.mojom.CacheEncryptionProviderPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          network.mojom.CacheEncryptionProviderPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!network.mojom.CacheEncryptionProviderPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        encryptor: !osCryptAsync.mojom.Encryptor,
   *  }>}
   */

  getEncryptor() {
    return this.proxy.sendMessage(
        0,
        network.mojom.CacheEncryptionProvider_GetEncryptor_ParamsSpec.$,
        network.mojom.CacheEncryptionProvider_GetEncryptor_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the CacheEncryptionProvider
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
network.mojom.CacheEncryptionProviderReceiver = class {
  /**
   * @param {!network.mojom.CacheEncryptionProviderInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!network.mojom.CacheEncryptionProviderRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        network.mojom.CacheEncryptionProviderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.CacheEncryptionProviderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        network.mojom.CacheEncryptionProvider_GetEncryptor_ParamsSpec.$,
        network.mojom.CacheEncryptionProvider_GetEncryptor_ResponseParamsSpec.$,
        impl.getEncryptor.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
network.mojom.CacheEncryptionProvider = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.CacheEncryptionProvider";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!network.mojom.CacheEncryptionProviderRemote}
   * @export
   */
  static getRemote() {
    let remote = new network.mojom.CacheEncryptionProviderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the CacheEncryptionProvider
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
network.mojom.CacheEncryptionProviderCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      network.mojom.CacheEncryptionProviderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!network.mojom.CacheEncryptionProviderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getEncryptor =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        network.mojom.CacheEncryptionProvider_GetEncryptor_ParamsSpec.$,
        network.mojom.CacheEncryptionProvider_GetEncryptor_ResponseParamsSpec.$,
        this.getEncryptor.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.CacheEncryptionProvider_GetEncryptor_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
network.mojom.CacheEncryptionProvider_GetEncryptor_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    network.mojom.CacheEncryptionProvider_GetEncryptor_ParamsSpec.$,
    'CacheEncryptionProvider_GetEncryptor_Params',
    [
    ],
    [[0, 8],]);





/** @record */
network.mojom.CacheEncryptionProvider_GetEncryptor_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    network.mojom.CacheEncryptionProvider_GetEncryptor_ResponseParamsSpec.$,
    'CacheEncryptionProvider_GetEncryptor_ResponseParams',
    [
      mojo.internal.StructField(
        'encryptor', 0,
        0,
        osCryptAsync.mojom.EncryptorSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
network.mojom.CacheEncryptionProvider_GetEncryptor_ResponseParams = class {
  constructor() {
    /** @export { !osCryptAsync.mojom.Encryptor } */
    this.encryptor;
  }
};

