// services/network/public/mojom/attribution.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/attribution.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/attribution.mojom-params-data.h"
namespace network {
namespace mojom {

NOINLINE static const char* AttributionSupportToStringHelper(AttributionSupport value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AttributionSupport::kWeb:
      return "kWeb";
    case AttributionSupport::kWebAndOs:
      return "kWebAndOs";
    case AttributionSupport::kOs:
      return "kOs";
    case AttributionSupport::kNone:
      return "kNone";
    case AttributionSupport::kUnset:
      return "kUnset";
    default:
      return nullptr;
  }
}

std::string AttributionSupportToString(AttributionSupport value) {
  const char *str = AttributionSupportToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AttributionSupport value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AttributionSupport value) {
  return os << AttributionSupportToString(value);
}

NOINLINE static const char* AttributionReportingEligibilityToStringHelper(AttributionReportingEligibility value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AttributionReportingEligibility::kUnset:
      return "kUnset";
    case AttributionReportingEligibility::kEmpty:
      return "kEmpty";
    case AttributionReportingEligibility::kEventSource:
      return "kEventSource";
    case AttributionReportingEligibility::kNavigationSource:
      return "kNavigationSource";
    case AttributionReportingEligibility::kTrigger:
      return "kTrigger";
    case AttributionReportingEligibility::kEventSourceOrTrigger:
      return "kEventSourceOrTrigger";
    default:
      return nullptr;
  }
}

std::string AttributionReportingEligibilityToString(AttributionReportingEligibility value) {
  const char *str = AttributionReportingEligibilityToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AttributionReportingEligibility value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AttributionReportingEligibility value) {
  return os << AttributionReportingEligibilityToString(value);
}

namespace internal {

}  // namespace internal
}  // namespace mojom
}  // namespace network

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::AttributionSupport>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::AttributionSupport value) {
  return std::move(context).WriteString(::network::mojom::AttributionSupportToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::network::mojom::AttributionReportingEligibility>::WriteIntoTrace(
   perfetto::TracedValue context, ::network::mojom::AttributionReportingEligibility value) {
  return std::move(context).WriteString(::network::mojom::AttributionReportingEligibilityToString(value));
}

} // namespace perfetto