// services/network/public/mojom/address_list.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_ADDRESS_LIST_MOJOM_BLINK_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_ADDRESS_LIST_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/address_list.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/address_list.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/address_list.mojom-blink-forward.h"  // IWYU pragma: export
#include "services/network/public/mojom/ip_endpoint.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace network::mojom::blink {








class  AddressList {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AddressList, T>::value>;
  using DataView = AddressListDataView;
  using Data_ = internal::AddressList_Data;

  template <typename... Args>
  static AddressListPtr New(Args&&... args) {
    return AddressListPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AddressListPtr From(const U& u) {
    return mojo::TypeConverter<AddressListPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AddressList>::Convert(*this);
  }


  AddressList();

  AddressList(
      ::blink::Vector<::net::IPEndPoint> addresses,
      ::blink::Vector<::blink::String> dns_aliases);


  ~AddressList();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AddressListPtr>
  AddressListPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AddressList::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AddressList::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AddressList::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AddressList::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AddressList::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AddressList::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AddressList_UnserializedMessageContext<
            UserType, AddressList::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AddressList::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AddressList::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AddressList_UnserializedMessageContext<
            UserType, AddressList::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AddressList::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::Vector<::net::IPEndPoint> addresses;
  
  ::blink::Vector<::blink::String> dns_aliases;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AddressList::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AddressList::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AddressList::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AddressList::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
AddressListPtr AddressList::Clone() const {
  return New(
      mojo::Clone(addresses),
      mojo::Clone(dns_aliases)
  );
}

template <typename T, AddressList::EnableIfSame<T>*>
bool AddressList::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->addresses, other_struct.addresses))
    return false;
  if (!mojo::Equals(this->dns_aliases, other_struct.dns_aliases))
    return false;
  return true;
}

template <typename T, AddressList::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.addresses < rhs.addresses)
    return true;
  if (rhs.addresses < lhs.addresses)
    return false;
  if (lhs.dns_aliases < rhs.dns_aliases)
    return true;
  if (rhs.dns_aliases < lhs.dns_aliases)
    return false;
  return false;
}


}  // network::mojom::blink

namespace mojo {


template <>
struct  StructTraits<::network::mojom::blink::AddressList::DataView,
                                         ::network::mojom::blink::AddressListPtr> {
  static bool IsNull(const ::network::mojom::blink::AddressListPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::AddressListPtr* output) { output->reset(); }

  static const decltype(::network::mojom::blink::AddressList::addresses)& addresses(
      const ::network::mojom::blink::AddressListPtr& input) {
    return input->addresses;
  }

  static const decltype(::network::mojom::blink::AddressList::dns_aliases)& dns_aliases(
      const ::network::mojom::blink::AddressListPtr& input) {
    return input->dns_aliases;
  }

  static bool Read(::network::mojom::blink::AddressList::DataView input, ::network::mojom::blink::AddressListPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_ADDRESS_LIST_MOJOM_BLINK_H_