// services/network/public/mojom/ad_auction.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/network/public/mojom/ad_auction.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('network.mojom');
  var origin$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/origin.mojom', '../../../../url/mojom/origin.mojom.js');
  }



  function AdAuctionEventRecord(values) {
    this.initDefaults_();
    this.initFields_(values);
  }

  AdAuctionEventRecord.Type = {};
  AdAuctionEventRecord.Type.kUninitialized = 0;
  AdAuctionEventRecord.Type.kView = 1;
  AdAuctionEventRecord.Type.kClick = 2;
  AdAuctionEventRecord.Type.MIN_VALUE = 0;
  AdAuctionEventRecord.Type.MAX_VALUE = 2;

  AdAuctionEventRecord.Type.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  AdAuctionEventRecord.Type.toKnownEnumValue = function(value) {
    return value;
  };

  AdAuctionEventRecord.Type.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  AdAuctionEventRecord.prototype.initDefaults_ = function() {
    this.type = 0;
    this.providingOrigin = null;
    this.eligibleOrigins = null;
  };
  AdAuctionEventRecord.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AdAuctionEventRecord.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AdAuctionEventRecord.type
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, AdAuctionEventRecord.Type);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AdAuctionEventRecord.providingOrigin
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, origin$.Origin, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AdAuctionEventRecord.eligibleOrigins
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 8, new codec.PointerTo(origin$.Origin), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AdAuctionEventRecord.encodedSize = codec.kStructHeaderSize + 24;

  AdAuctionEventRecord.decode = function(decoder) {
    var packed;
    var val = new AdAuctionEventRecord();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.type =
        decoder.decodeStruct(new codec.Enum(AdAuctionEventRecord.Type));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.providingOrigin =
        decoder.decodeStructPointer(origin$.Origin);
    val.eligibleOrigins =
        decoder.decodeArrayPointer(new codec.PointerTo(origin$.Origin));
    return val;
  };

  AdAuctionEventRecord.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AdAuctionEventRecord.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.type);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(origin$.Origin, val.providingOrigin);
    encoder.encodeArrayPointer(new codec.PointerTo(origin$.Origin), val.eligibleOrigins);
  };
  exports.AdAuctionEventRecord = AdAuctionEventRecord;
})();