// services/network/public/mojom/ad_auction.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_AD_AUCTION_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_AD_AUCTION_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/ad_auction.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/ad_auction.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/ad_auction.mojom-forward.h"  // IWYU pragma: export
#include "url/mojom/origin.mojom.h"
#include <string>
#include <vector>




#include "services/network/public/cpp/ad_auction/event_record_mojom_traits.h"




namespace network::mojom {








class  AdAuctionEventRecord {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AdAuctionEventRecord, T>::value>;
  using DataView = AdAuctionEventRecordDataView;
  using Data_ = internal::AdAuctionEventRecord_Data;
  using Type = AdAuctionEventRecord_Type;

  template <typename... Args>
  static AdAuctionEventRecordPtr New(Args&&... args) {
    return AdAuctionEventRecordPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AdAuctionEventRecordPtr From(const U& u) {
    return mojo::TypeConverter<AdAuctionEventRecordPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AdAuctionEventRecord>::Convert(*this);
  }


  AdAuctionEventRecord();

  AdAuctionEventRecord(
      AdAuctionEventRecord::Type type,
      const ::url::Origin& providing_origin,
      std::vector<::url::Origin> eligible_origins);


  ~AdAuctionEventRecord();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AdAuctionEventRecordPtr>
  AdAuctionEventRecordPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AdAuctionEventRecord::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AdAuctionEventRecord::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AdAuctionEventRecord::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AdAuctionEventRecord::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AdAuctionEventRecord::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AdAuctionEventRecord::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AdAuctionEventRecord_UnserializedMessageContext<
            UserType, AdAuctionEventRecord::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AdAuctionEventRecord::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AdAuctionEventRecord::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AdAuctionEventRecord_UnserializedMessageContext<
            UserType, AdAuctionEventRecord::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AdAuctionEventRecord::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  AdAuctionEventRecord::Type type;
  
  ::url::Origin providing_origin;
  
  std::vector<::url::Origin> eligible_origins;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AdAuctionEventRecord::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AdAuctionEventRecord::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AdAuctionEventRecord::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AdAuctionEventRecord::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
AdAuctionEventRecordPtr AdAuctionEventRecord::Clone() const {
  return New(
      mojo::Clone(type),
      mojo::Clone(providing_origin),
      mojo::Clone(eligible_origins)
  );
}

template <typename T, AdAuctionEventRecord::EnableIfSame<T>*>
bool AdAuctionEventRecord::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->providing_origin, other_struct.providing_origin))
    return false;
  if (!mojo::Equals(this->eligible_origins, other_struct.eligible_origins))
    return false;
  return true;
}

template <typename T, AdAuctionEventRecord::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.providing_origin < rhs.providing_origin)
    return true;
  if (rhs.providing_origin < lhs.providing_origin)
    return false;
  if (lhs.eligible_origins < rhs.eligible_origins)
    return true;
  if (rhs.eligible_origins < lhs.eligible_origins)
    return false;
  return false;
}


}  // network::mojom

namespace mojo {


template <>
struct  StructTraits<::network::mojom::AdAuctionEventRecord::DataView,
                                         ::network::mojom::AdAuctionEventRecordPtr> {
  static bool IsNull(const ::network::mojom::AdAuctionEventRecordPtr& input) { return !input; }
  static void SetToNull(::network::mojom::AdAuctionEventRecordPtr* output) { output->reset(); }

  static decltype(::network::mojom::AdAuctionEventRecord::type) type(
      const ::network::mojom::AdAuctionEventRecordPtr& input) {
    return input->type;
  }

  static const decltype(::network::mojom::AdAuctionEventRecord::providing_origin)& providing_origin(
      const ::network::mojom::AdAuctionEventRecordPtr& input) {
    return input->providing_origin;
  }

  static const decltype(::network::mojom::AdAuctionEventRecord::eligible_origins)& eligible_origins(
      const ::network::mojom::AdAuctionEventRecordPtr& input) {
    return input->eligible_origins;
  }

  static bool Read(::network::mojom::AdAuctionEventRecord::DataView input, ::network::mojom::AdAuctionEventRecordPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_AD_AUCTION_MOJOM_H_