// services/metrics/public/mojom/ukm_interface.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_METRICS_PUBLIC_MOJOM_UKM_INTERFACE_MOJOM_SHARED_H_
#define SERVICES_METRICS_PUBLIC_MOJOM_UKM_INTERFACE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/metrics/public/mojom/ukm_interface.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "services/metrics/public/mojom/ukm_interface.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ukm::mojom::UkmEntryDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ukm::mojom::UkmEntryDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::ukm::mojom::internal::UkmEntry_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->source_id = Traits::source_id(input);

    fragment->event_hash = Traits::event_hash(input);

    decltype(Traits::metrics(input)) in_metrics = Traits::metrics(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->metrics)::BaseType>
        metrics_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& metrics_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<uint64_t, int64_t>>(
      in_metrics,
      metrics_fragment,
      &metrics_validate_params);

    fragment->metrics.Set(
        metrics_fragment.is_null() ? nullptr : metrics_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->metrics.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null metrics in UkmEntry struct");
  }

  static bool Deserialize(::ukm::mojom::internal::UkmEntry_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::ukm::mojom::UkmEntryDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ukm::mojom::UkmRecorderParametersDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ukm::mojom::UkmRecorderParametersDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::ukm::mojom::internal::UkmRecorderParameters_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->is_enabled = Traits::is_enabled(input);

    decltype(Traits::event_hash_bypass_list(input)) in_event_hash_bypass_list = Traits::event_hash_bypass_list(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->event_hash_bypass_list)::BaseType>
        event_hash_bypass_list_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& event_hash_bypass_list_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint64_t>>(
      in_event_hash_bypass_list,
      event_hash_bypass_list_fragment,
      &event_hash_bypass_list_validate_params);

    fragment->event_hash_bypass_list.Set(
        event_hash_bypass_list_fragment.is_null() ? nullptr : event_hash_bypass_list_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->event_hash_bypass_list.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null event_hash_bypass_list in UkmRecorderParameters struct");
  }

  static bool Deserialize(::ukm::mojom::internal::UkmRecorderParameters_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::ukm::mojom::UkmRecorderParametersDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace ukm::mojom {

inline void UkmEntryDataView::GetMetricsDataView(
    mojo::MapDataView<uint64_t, int64_t>* output) {
  auto pointer = data_->metrics.Get();
  *output = mojo::MapDataView<uint64_t, int64_t>(pointer, message_);
}


inline void UkmRecorderParametersDataView::GetEventHashBypassListDataView(
    mojo::ArrayDataView<uint64_t>* output) {
  auto pointer = data_->event_hash_bypass_list.Get();
  *output = mojo::ArrayDataView<uint64_t>(pointer, message_);
}



}  // ukm::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_METRICS_PUBLIC_MOJOM_UKM_INTERFACE_MOJOM_SHARED_H_