// services/metrics/public/mojom/ukm_interface.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_METRICS_PUBLIC_MOJOM_UKM_INTERFACE_MOJOM_SEND_VALIDATION_H_
#define SERVICES_METRICS_PUBLIC_MOJOM_UKM_INTERFACE_MOJOM_SEND_VALIDATION_H_

#include "services/metrics/public/mojom/ukm_interface.mojom-shared-internal.h"

#include "services/metrics/public/mojom/ukm_interface.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::ukm::mojom::UkmEntryDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ukm::mojom::UkmEntryDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::ukm::mojom::internal::UkmEntry_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->source_id = Traits::source_id(input);

      fragment->event_hash = Traits::event_hash(input);

      decltype(Traits::metrics(input)) in_metrics = Traits::metrics(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->metrics)::BaseType>
          metrics_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& metrics_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, nullptr>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<uint64_t, int64_t>, send_validation>(
        in_metrics,
        metrics_fragment,
        &metrics_validate_params);

      fragment->metrics.Set(
          metrics_fragment.is_null() ? nullptr : metrics_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->metrics.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null metrics in UkmEntry struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::ukm::mojom::UkmRecorderParametersDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ukm::mojom::UkmRecorderParametersDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::ukm::mojom::internal::UkmRecorderParameters_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->is_enabled = Traits::is_enabled(input);

      decltype(Traits::event_hash_bypass_list(input)) in_event_hash_bypass_list = Traits::event_hash_bypass_list(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->event_hash_bypass_list)::BaseType>
          event_hash_bypass_list_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& event_hash_bypass_list_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<uint64_t>, send_validation>(
        in_event_hash_bypass_list,
        event_hash_bypass_list_fragment,
        &event_hash_bypass_list_validate_params);

      fragment->event_hash_bypass_list.Set(
          event_hash_bypass_list_fragment.is_null() ? nullptr : event_hash_bypass_list_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->event_hash_bypass_list.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null event_hash_bypass_list in UkmRecorderParameters struct");
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_METRICS_PUBLIC_MOJOM_UKM_INTERFACE_MOJOM_SEND_VALIDATION_H_