// services/media_session/public/mojom/media_session.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  String16 as mojoBase_mojom_String16,
  String16Spec as mojoBase_mojom_String16Spec
} from '../../../../mojo/public/mojom/base/string16.mojom.m.js';

import {
  TimeDelta as mojoBase_mojom_TimeDelta,
  TimeDeltaSpec as mojoBase_mojom_TimeDeltaSpec,
  TimeTicks as mojoBase_mojom_TimeTicks,
  TimeTicksSpec as mojoBase_mojom_TimeTicksSpec
} from '../../../../mojo/public/mojom/base/time.mojom.m.js';

import {
  Size as gfx_mojom_Size,
  SizeSpec as gfx_mojom_SizeSpec
} from '../../../../ui/gfx/geometry/mojom/geometry.mojom.m.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../url/mojom/url.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const MediaPlaybackStateSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const MediaPlaybackState = {
  
  kPaused: 0,
  kPlaying: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const MediaSessionActionSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const MediaSessionAction = {
  
  kPlay: 0,
  kPause: 1,
  kPreviousTrack: 2,
  kNextTrack: 3,
  kSeekBackward: 4,
  kSeekForward: 5,
  kSkipAd: 6,
  kStop: 7,
  kSeekTo: 8,
  kScrubTo: 9,
  kEnterPictureInPicture: 10,
  kExitPictureInPicture: 11,
  kSwitchAudioDevice: 12,
  kToggleMicrophone: 13,
  kToggleCamera: 14,
  kHangUp: 15,
  kRaise: 16,
  kSetMute: 17,
  kPreviousSlide: 18,
  kNextSlide: 19,
  kEnterAutoPictureInPicture: 20,
  MIN_VALUE: 0,
  MAX_VALUE: 20,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const MediaSessionImageTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const MediaSessionImageType = {
  
  kArtwork: 0,
  kSourceIcon: 1,
  kChapter: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const MediaPictureInPictureStateSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const MediaPictureInPictureState = {
  
  kNotInPictureInPicture: 0,
  kInPictureInPicture: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const MediaAudioVideoStateSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const MediaAudioVideoState = {
  
  kDeprecatedUnknown: 0,
  kAudioOnly: 1,
  kAudioVideo: 2,
  kVideoOnly: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const MediaImageBitmapColorTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const MediaImageBitmapColorType = {
  
  kRGBA_8888: 0,
  kBGRA_8888: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const MicrophoneStateSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const MicrophoneState = {
  
  kUnknown: 0,
  kMuted: 1,
  kUnmuted: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const CameraStateSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const CameraState = {
  
  kUnknown: 0,
  kTurnedOn: 1,
  kTurnedOff: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class MediaSessionObserverPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media_session.mojom.MediaSessionObserver', scope);
  }
}

/** @interface */
export class MediaSessionObserverInterface {
  
  /**
   * @param { !MediaSessionInfo } info
   */

  mediaSessionInfoChanged(info) {}
  
  /**
   * @param { ?MediaMetadata } metadata
   */

  mediaSessionMetadataChanged(metadata) {}
  
  /**
   * @param { !Array<!MediaSessionAction> } action
   */

  mediaSessionActionsChanged(action) {}
  
  /**
   * @param { !Object<!MediaSessionImageType, !Array<!MediaImage>> } images
   */

  mediaSessionImagesChanged(images) {}
  
  /**
   * @param { ?MediaPosition } position
   */

  mediaSessionPositionChanged(position) {}
}

/**
 * @implements { MediaSessionObserverInterface }
 */
export class MediaSessionObserverRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!MediaSessionObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          MediaSessionObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!MediaSessionObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !MediaSessionInfo } info
   */

  mediaSessionInfoChanged(
      info) {
    this.proxy.sendMessage(
        0,
        MediaSessionObserver_MediaSessionInfoChanged_ParamsSpec.$,
        null,
        [
          info
        ],
        false);
  }

  
  /**
   * @param { ?MediaMetadata } metadata
   */

  mediaSessionMetadataChanged(
      metadata) {
    this.proxy.sendMessage(
        1,
        MediaSessionObserver_MediaSessionMetadataChanged_ParamsSpec.$,
        null,
        [
          metadata
        ],
        false);
  }

  
  /**
   * @param { !Array<!MediaSessionAction> } action
   */

  mediaSessionActionsChanged(
      action) {
    this.proxy.sendMessage(
        2,
        MediaSessionObserver_MediaSessionActionsChanged_ParamsSpec.$,
        null,
        [
          action
        ],
        false);
  }

  
  /**
   * @param { !Object<!MediaSessionImageType, !Array<!MediaImage>> } images
   */

  mediaSessionImagesChanged(
      images) {
    this.proxy.sendMessage(
        3,
        MediaSessionObserver_MediaSessionImagesChanged_ParamsSpec.$,
        null,
        [
          images
        ],
        false);
  }

  
  /**
   * @param { ?MediaPosition } position
   */

  mediaSessionPositionChanged(
      position) {
    this.proxy.sendMessage(
        4,
        MediaSessionObserver_MediaSessionPositionChanged_ParamsSpec.$,
        null,
        [
          position
        ],
        false);
  }
}

/**
 * An object which receives request messages for the MediaSessionObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class MediaSessionObserverReceiver {
  /**
   * @param {!MediaSessionObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!MediaSessionObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        MediaSessionObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MediaSessionObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        MediaSessionObserver_MediaSessionInfoChanged_ParamsSpec.$,
        null,
        impl.mediaSessionInfoChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        MediaSessionObserver_MediaSessionMetadataChanged_ParamsSpec.$,
        null,
        impl.mediaSessionMetadataChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        MediaSessionObserver_MediaSessionActionsChanged_ParamsSpec.$,
        null,
        impl.mediaSessionActionsChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        MediaSessionObserver_MediaSessionImagesChanged_ParamsSpec.$,
        null,
        impl.mediaSessionImagesChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        MediaSessionObserver_MediaSessionPositionChanged_ParamsSpec.$,
        null,
        impl.mediaSessionPositionChanged.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class MediaSessionObserver {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media_session.mojom.MediaSessionObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!MediaSessionObserverRemote}
   */
  static getRemote() {
    let remote = new MediaSessionObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the MediaSessionObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class MediaSessionObserverCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      MediaSessionObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MediaSessionObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.mediaSessionInfoChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        MediaSessionObserver_MediaSessionInfoChanged_ParamsSpec.$,
        null,
        this.mediaSessionInfoChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.mediaSessionMetadataChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        MediaSessionObserver_MediaSessionMetadataChanged_ParamsSpec.$,
        null,
        this.mediaSessionMetadataChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.mediaSessionActionsChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        MediaSessionObserver_MediaSessionActionsChanged_ParamsSpec.$,
        null,
        this.mediaSessionActionsChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.mediaSessionImagesChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        MediaSessionObserver_MediaSessionImagesChanged_ParamsSpec.$,
        null,
        this.mediaSessionImagesChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.mediaSessionPositionChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        MediaSessionObserver_MediaSessionPositionChanged_ParamsSpec.$,
        null,
        this.mediaSessionPositionChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class MediaSessionPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media_session.mojom.MediaSession', scope);
  }
}

/** @interface */
export class MediaSessionInterface {
  
  /**
   * @return {!Promise<{
        info: !MediaSessionInfo,
   *  }>}
   */

  getMediaSessionInfo() {}
  
  /**
   * @return {!Promise<{
        info: !MediaSessionDebugInfo,
   *  }>}
   */

  getDebugInfo() {}
  
  /**
   */

  startDucking() {}
  
  /**
   */

  stopDucking() {}
  
  /**
   * @param { !MediaSession_SuspendType } suspendType
   */

  suspend(suspendType) {}
  
  /**
   * @param { !MediaSession_SuspendType } suspendType
   */

  resume(suspendType) {}
  
  /**
   * @param { !MediaSessionObserverRemote } observer
   */

  addObserver(observer) {}
  
  /**
   */

  previousTrack() {}
  
  /**
   */

  nextTrack() {}
  
  /**
   * @param { !mojoBase_mojom_TimeDelta } seekTime
   */

  seek(seekTime) {}
  
  /**
   * @param { !MediaSession_SuspendType } suspendType
   */

  stop(suspendType) {}
  
  /**
   */

  skipAd() {}
  
  /**
   * @param { !MediaImage } image
   * @param { !number } minimumSizePx
   * @param { !number } desiredSizePx
   * @return {!Promise<{
        image: ?MediaImageBitmap,
   *  }>}
   */

  getMediaImageBitmap(image, minimumSizePx, desiredSizePx) {}
  
  /**
   * @param { !mojoBase_mojom_TimeDelta } seekTime
   */

  seekTo(seekTime) {}
  
  /**
   * @param { !mojoBase_mojom_TimeDelta } seekTime
   */

  scrubTo(seekTime) {}
  
  /**
   */

  enterPictureInPicture() {}
  
  /**
   */

  exitPictureInPicture() {}
  
  /**
   * @param { ?string } id
   */

  setAudioSinkId(id) {}
  
  /**
   */

  toggleMicrophone() {}
  
  /**
   */

  toggleCamera() {}
  
  /**
   */

  hangUp() {}
  
  /**
   */

  raise() {}
  
  /**
   * @param { !boolean } mute
   */

  setMute(mute) {}
  
  /**
   */

  requestMediaRemoting() {}
  
  /**
   */

  previousSlide() {}
  
  /**
   */

  nextSlide() {}
  
  /**
   */

  enterAutoPictureInPicture() {}
  
  /**
   * @return {!Promise<{
        hasSufficientlyVisibleVideo: !boolean,
   *  }>}
   */

  getVisibility() {}
}

/**
 * @implements { MediaSessionInterface }
 */
export class MediaSessionRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!MediaSessionPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          MediaSessionPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!MediaSessionPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        info: !MediaSessionInfo,
   *  }>}
   */

  getMediaSessionInfo() {
    return this.proxy.sendMessage(
        0,
        MediaSession_GetMediaSessionInfo_ParamsSpec.$,
        MediaSession_GetMediaSessionInfo_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        info: !MediaSessionDebugInfo,
   *  }>}
   */

  getDebugInfo() {
    return this.proxy.sendMessage(
        1,
        MediaSession_GetDebugInfo_ParamsSpec.$,
        MediaSession_GetDebugInfo_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   */

  startDucking() {
    this.proxy.sendMessage(
        2,
        MediaSession_StartDucking_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  stopDucking() {
    this.proxy.sendMessage(
        3,
        MediaSession_StopDucking_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !MediaSession_SuspendType } suspendType
   */

  suspend(
      suspendType) {
    this.proxy.sendMessage(
        4,
        MediaSession_Suspend_ParamsSpec.$,
        null,
        [
          suspendType
        ],
        false);
  }

  
  /**
   * @param { !MediaSession_SuspendType } suspendType
   */

  resume(
      suspendType) {
    this.proxy.sendMessage(
        5,
        MediaSession_Resume_ParamsSpec.$,
        null,
        [
          suspendType
        ],
        false);
  }

  
  /**
   * @param { !MediaSessionObserverRemote } observer
   */

  addObserver(
      observer) {
    this.proxy.sendMessage(
        6,
        MediaSession_AddObserver_ParamsSpec.$,
        null,
        [
          observer
        ],
        false);
  }

  
  /**
   */

  previousTrack() {
    this.proxy.sendMessage(
        7,
        MediaSession_PreviousTrack_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  nextTrack() {
    this.proxy.sendMessage(
        8,
        MediaSession_NextTrack_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_TimeDelta } seekTime
   */

  seek(
      seekTime) {
    this.proxy.sendMessage(
        9,
        MediaSession_Seek_ParamsSpec.$,
        null,
        [
          seekTime
        ],
        false);
  }

  
  /**
   * @param { !MediaSession_SuspendType } suspendType
   */

  stop(
      suspendType) {
    this.proxy.sendMessage(
        10,
        MediaSession_Stop_ParamsSpec.$,
        null,
        [
          suspendType
        ],
        false);
  }

  
  /**
   */

  skipAd() {
    this.proxy.sendMessage(
        11,
        MediaSession_SkipAd_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !MediaImage } image
   * @param { !number } minimumSizePx
   * @param { !number } desiredSizePx
   * @return {!Promise<{
        image: ?MediaImageBitmap,
   *  }>}
   */

  getMediaImageBitmap(
      image,
      minimumSizePx,
      desiredSizePx) {
    return this.proxy.sendMessage(
        12,
        MediaSession_GetMediaImageBitmap_ParamsSpec.$,
        MediaSession_GetMediaImageBitmap_ResponseParamsSpec.$,
        [
          image,
          minimumSizePx,
          desiredSizePx
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_TimeDelta } seekTime
   */

  seekTo(
      seekTime) {
    this.proxy.sendMessage(
        13,
        MediaSession_SeekTo_ParamsSpec.$,
        null,
        [
          seekTime
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_TimeDelta } seekTime
   */

  scrubTo(
      seekTime) {
    this.proxy.sendMessage(
        14,
        MediaSession_ScrubTo_ParamsSpec.$,
        null,
        [
          seekTime
        ],
        false);
  }

  
  /**
   */

  enterPictureInPicture() {
    this.proxy.sendMessage(
        15,
        MediaSession_EnterPictureInPicture_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  exitPictureInPicture() {
    this.proxy.sendMessage(
        16,
        MediaSession_ExitPictureInPicture_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { ?string } id
   */

  setAudioSinkId(
      id) {
    this.proxy.sendMessage(
        17,
        MediaSession_SetAudioSinkId_ParamsSpec.$,
        null,
        [
          id
        ],
        false);
  }

  
  /**
   */

  toggleMicrophone() {
    this.proxy.sendMessage(
        18,
        MediaSession_ToggleMicrophone_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  toggleCamera() {
    this.proxy.sendMessage(
        19,
        MediaSession_ToggleCamera_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  hangUp() {
    this.proxy.sendMessage(
        20,
        MediaSession_HangUp_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  raise() {
    this.proxy.sendMessage(
        21,
        MediaSession_Raise_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !boolean } mute
   */

  setMute(
      mute) {
    this.proxy.sendMessage(
        22,
        MediaSession_SetMute_ParamsSpec.$,
        null,
        [
          mute
        ],
        false);
  }

  
  /**
   */

  requestMediaRemoting() {
    this.proxy.sendMessage(
        23,
        MediaSession_RequestMediaRemoting_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  previousSlide() {
    this.proxy.sendMessage(
        24,
        MediaSession_PreviousSlide_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  nextSlide() {
    this.proxy.sendMessage(
        25,
        MediaSession_NextSlide_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  enterAutoPictureInPicture() {
    this.proxy.sendMessage(
        26,
        MediaSession_EnterAutoPictureInPicture_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        hasSufficientlyVisibleVideo: !boolean,
   *  }>}
   */

  getVisibility() {
    return this.proxy.sendMessage(
        27,
        MediaSession_GetVisibility_ParamsSpec.$,
        MediaSession_GetVisibility_ResponseParamsSpec.$,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the MediaSession
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class MediaSessionReceiver {
  /**
   * @param {!MediaSessionInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!MediaSessionRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        MediaSessionRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MediaSessionRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        MediaSession_GetMediaSessionInfo_ParamsSpec.$,
        MediaSession_GetMediaSessionInfo_ResponseParamsSpec.$,
        impl.getMediaSessionInfo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        MediaSession_GetDebugInfo_ParamsSpec.$,
        MediaSession_GetDebugInfo_ResponseParamsSpec.$,
        impl.getDebugInfo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        MediaSession_StartDucking_ParamsSpec.$,
        null,
        impl.startDucking.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        MediaSession_StopDucking_ParamsSpec.$,
        null,
        impl.stopDucking.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        MediaSession_Suspend_ParamsSpec.$,
        null,
        impl.suspend.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        MediaSession_Resume_ParamsSpec.$,
        null,
        impl.resume.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        MediaSession_AddObserver_ParamsSpec.$,
        null,
        impl.addObserver.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        MediaSession_PreviousTrack_ParamsSpec.$,
        null,
        impl.previousTrack.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        MediaSession_NextTrack_ParamsSpec.$,
        null,
        impl.nextTrack.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        MediaSession_Seek_ParamsSpec.$,
        null,
        impl.seek.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        MediaSession_Stop_ParamsSpec.$,
        null,
        impl.stop.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        MediaSession_SkipAd_ParamsSpec.$,
        null,
        impl.skipAd.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        MediaSession_GetMediaImageBitmap_ParamsSpec.$,
        MediaSession_GetMediaImageBitmap_ResponseParamsSpec.$,
        impl.getMediaImageBitmap.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        MediaSession_SeekTo_ParamsSpec.$,
        null,
        impl.seekTo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        14,
        MediaSession_ScrubTo_ParamsSpec.$,
        null,
        impl.scrubTo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        15,
        MediaSession_EnterPictureInPicture_ParamsSpec.$,
        null,
        impl.enterPictureInPicture.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        16,
        MediaSession_ExitPictureInPicture_ParamsSpec.$,
        null,
        impl.exitPictureInPicture.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        17,
        MediaSession_SetAudioSinkId_ParamsSpec.$,
        null,
        impl.setAudioSinkId.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        18,
        MediaSession_ToggleMicrophone_ParamsSpec.$,
        null,
        impl.toggleMicrophone.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        19,
        MediaSession_ToggleCamera_ParamsSpec.$,
        null,
        impl.toggleCamera.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        20,
        MediaSession_HangUp_ParamsSpec.$,
        null,
        impl.hangUp.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        21,
        MediaSession_Raise_ParamsSpec.$,
        null,
        impl.raise.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        22,
        MediaSession_SetMute_ParamsSpec.$,
        null,
        impl.setMute.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        23,
        MediaSession_RequestMediaRemoting_ParamsSpec.$,
        null,
        impl.requestMediaRemoting.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        24,
        MediaSession_PreviousSlide_ParamsSpec.$,
        null,
        impl.previousSlide.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        25,
        MediaSession_NextSlide_ParamsSpec.$,
        null,
        impl.nextSlide.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        26,
        MediaSession_EnterAutoPictureInPicture_ParamsSpec.$,
        null,
        impl.enterAutoPictureInPicture.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        27,
        MediaSession_GetVisibility_ParamsSpec.$,
        MediaSession_GetVisibility_ResponseParamsSpec.$,
        impl.getVisibility.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class MediaSession {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media_session.mojom.MediaSession";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!MediaSessionRemote}
   */
  static getRemote() {
    let remote = new MediaSessionRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const MediaSession_SuspendTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const MediaSession_SuspendType = {
  
  kSystem: 0,
  kUI: 1,
  kContent: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * An object which receives request messages for the MediaSession
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class MediaSessionCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      MediaSessionRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MediaSessionRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getMediaSessionInfo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        MediaSession_GetMediaSessionInfo_ParamsSpec.$,
        MediaSession_GetMediaSessionInfo_ResponseParamsSpec.$,
        this.getMediaSessionInfo.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getDebugInfo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        MediaSession_GetDebugInfo_ParamsSpec.$,
        MediaSession_GetDebugInfo_ResponseParamsSpec.$,
        this.getDebugInfo.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.startDucking =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        MediaSession_StartDucking_ParamsSpec.$,
        null,
        this.startDucking.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.stopDucking =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        MediaSession_StopDucking_ParamsSpec.$,
        null,
        this.stopDucking.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.suspend =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        MediaSession_Suspend_ParamsSpec.$,
        null,
        this.suspend.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.resume =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        MediaSession_Resume_ParamsSpec.$,
        null,
        this.resume.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addObserver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        MediaSession_AddObserver_ParamsSpec.$,
        null,
        this.addObserver.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.previousTrack =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        MediaSession_PreviousTrack_ParamsSpec.$,
        null,
        this.previousTrack.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.nextTrack =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        MediaSession_NextTrack_ParamsSpec.$,
        null,
        this.nextTrack.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.seek =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        MediaSession_Seek_ParamsSpec.$,
        null,
        this.seek.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.stop =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        MediaSession_Stop_ParamsSpec.$,
        null,
        this.stop.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.skipAd =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        MediaSession_SkipAd_ParamsSpec.$,
        null,
        this.skipAd.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getMediaImageBitmap =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        MediaSession_GetMediaImageBitmap_ParamsSpec.$,
        MediaSession_GetMediaImageBitmap_ResponseParamsSpec.$,
        this.getMediaImageBitmap.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.seekTo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        MediaSession_SeekTo_ParamsSpec.$,
        null,
        this.seekTo.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.scrubTo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        14,
        MediaSession_ScrubTo_ParamsSpec.$,
        null,
        this.scrubTo.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.enterPictureInPicture =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        15,
        MediaSession_EnterPictureInPicture_ParamsSpec.$,
        null,
        this.enterPictureInPicture.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.exitPictureInPicture =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        16,
        MediaSession_ExitPictureInPicture_ParamsSpec.$,
        null,
        this.exitPictureInPicture.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setAudioSinkId =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        17,
        MediaSession_SetAudioSinkId_ParamsSpec.$,
        null,
        this.setAudioSinkId.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.toggleMicrophone =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        18,
        MediaSession_ToggleMicrophone_ParamsSpec.$,
        null,
        this.toggleMicrophone.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.toggleCamera =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        19,
        MediaSession_ToggleCamera_ParamsSpec.$,
        null,
        this.toggleCamera.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.hangUp =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        20,
        MediaSession_HangUp_ParamsSpec.$,
        null,
        this.hangUp.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.raise =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        21,
        MediaSession_Raise_ParamsSpec.$,
        null,
        this.raise.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setMute =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        22,
        MediaSession_SetMute_ParamsSpec.$,
        null,
        this.setMute.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestMediaRemoting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        23,
        MediaSession_RequestMediaRemoting_ParamsSpec.$,
        null,
        this.requestMediaRemoting.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.previousSlide =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        24,
        MediaSession_PreviousSlide_ParamsSpec.$,
        null,
        this.previousSlide.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.nextSlide =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        25,
        MediaSession_NextSlide_ParamsSpec.$,
        null,
        this.nextSlide.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.enterAutoPictureInPicture =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        26,
        MediaSession_EnterAutoPictureInPicture_ParamsSpec.$,
        null,
        this.enterAutoPictureInPicture.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getVisibility =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        27,
        MediaSession_GetVisibility_ParamsSpec.$,
        MediaSession_GetVisibility_ResponseParamsSpec.$,
        this.getVisibility.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaImageSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ChapterInformationSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaMetadataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaImageBitmapSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaPositionSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RemotePlaybackMetadataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaSessionInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaSessionDebugInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaSessionObserver_MediaSessionInfoChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaSessionObserver_MediaSessionMetadataChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaSessionObserver_MediaSessionActionsChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaSessionObserver_MediaSessionImagesChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaSessionObserver_MediaSessionPositionChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaSession_GetMediaSessionInfo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaSession_GetMediaSessionInfo_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaSession_GetDebugInfo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaSession_GetDebugInfo_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaSession_StartDucking_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaSession_StopDucking_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaSession_Suspend_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaSession_Resume_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaSession_AddObserver_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaSession_PreviousTrack_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaSession_NextTrack_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaSession_Seek_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaSession_Stop_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaSession_SkipAd_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaSession_GetMediaImageBitmap_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaSession_GetMediaImageBitmap_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaSession_SeekTo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaSession_ScrubTo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaSession_EnterPictureInPicture_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaSession_ExitPictureInPicture_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaSession_SetAudioSinkId_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaSession_ToggleMicrophone_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaSession_ToggleCamera_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaSession_HangUp_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaSession_Raise_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaSession_SetMute_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaSession_RequestMediaRemoting_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaSession_PreviousSlide_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaSession_NextSlide_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaSession_EnterAutoPictureInPicture_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaSession_GetVisibility_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaSession_GetVisibility_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    MediaImageSpec.$,
    'MediaImage',
    [
      mojo.internal.StructField(
        'src', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'type', 8,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sizes', 16,
        0,
        mojo.internal.Array(gfx_mojom_SizeSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class MediaImage {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.src;
    /** @type { !mojoBase_mojom_String16 } */
    this.type;
    /** @type { !Array<!gfx_mojom_Size> } */
    this.sizes;
  }
}



mojo.internal.Struct(
    ChapterInformationSpec.$,
    'ChapterInformation',
    [
      mojo.internal.StructField(
        'title', 0,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'startTime', 8,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'artwork', 16,
        0,
        mojo.internal.Array(MediaImageSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class ChapterInformation {
  constructor() {
    /** @type { !mojoBase_mojom_String16 } */
    this.title;
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.startTime;
    /** @type { !Array<!MediaImage> } */
    this.artwork;
  }
}



mojo.internal.Struct(
    MediaMetadataSpec.$,
    'MediaMetadata',
    [
      mojo.internal.StructField(
        'title', 0,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'artist', 8,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'album', 16,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sourceTitle', 24,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'chapters', 32,
        0,
        mojo.internal.Array(ChapterInformationSpec.$, false),
        null,
        true /* nullable */,
        21,
      ),
    ],
    [[0, 40],[21, 48],]);



/**
 * @record
 */
export class MediaMetadata {
  constructor() {
    /** @type { !mojoBase_mojom_String16 } */
    this.title;
    /** @type { !mojoBase_mojom_String16 } */
    this.artist;
    /** @type { !mojoBase_mojom_String16 } */
    this.album;
    /** @type { !mojoBase_mojom_String16 } */
    this.sourceTitle;
    /** @type { (Array<!ChapterInformation>|undefined) } */
    this.chapters;
  }
}



mojo.internal.Struct(
    MediaImageBitmapSpec.$,
    'MediaImageBitmap',
    [
      mojo.internal.StructField(
        'width', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'height', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'pixelData', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'colorType', 16,
        0,
        MediaImageBitmapColorTypeSpec.$,
        0,
        false /* nullable */,
        5,
      ),
    ],
    [[0, 24],[5, 32],]);



/**
 * @record
 */
export class MediaImageBitmap {
  constructor() {
    /** @type { !number } */
    this.width;
    /** @type { !number } */
    this.height;
    /** @type { !Array<!number> } */
    this.pixelData;
    /** @type { !MediaImageBitmapColorType } */
    this.colorType;
  }
}



mojo.internal.Struct(
    MediaPositionSpec.$,
    'MediaPosition',
    [
      mojo.internal.StructField(
        'playbackRate', 0,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'duration', 8,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'position', 16,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'lastUpdatedTime', 24,
        0,
        mojoBase_mojom_TimeTicksSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'endOfMedia', 32,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        13,
      ),
    ],
    [[0, 40],[13, 48],]);



/**
 * @record
 */
export class MediaPosition {
  constructor() {
    /** @type { !number } */
    this.playbackRate;
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.duration;
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.position;
    /** @type { !mojoBase_mojom_TimeTicks } */
    this.lastUpdatedTime;
    /** @type { !boolean } */
    this.endOfMedia;
  }
}



mojo.internal.Struct(
    RemotePlaybackMetadataSpec.$,
    'RemotePlaybackMetadata',
    [
      mojo.internal.StructField(
        'videoCodec', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'audioCodec', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'remotePlaybackDisabled', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'remotePlaybackStarted', 16,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        17,
      ),
      mojo.internal.StructField(
        'unusedField', 24,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        17,
      ),
      mojo.internal.StructField(
        'isEncryptedMedia', 16,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        18,
      ),
    ],
    [[0, 32],[17, 40],[18, 40],]);



/**
 * @record
 */
export class RemotePlaybackMetadata {
  constructor() {
    /** @type { !string } */
    this.videoCodec;
    /** @type { !string } */
    this.audioCodec;
    /** @type { !boolean } */
    this.remotePlaybackDisabled;
    /** @type { !boolean } */
    this.remotePlaybackStarted;
    /** @type { (string|undefined) } */
    this.unusedField;
    /** @type { !boolean } */
    this.isEncryptedMedia;
  }
}


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const MediaSessionInfo_SessionStateSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const MediaSessionInfo_SessionState = {
  
  kActive: 0,
  kDucking: 1,
  kSuspended: 2,
  kInactive: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};


mojo.internal.Struct(
    MediaSessionInfoSpec.$,
    'MediaSessionInfo',
    [
      mojo.internal.StructField(
        'state', 0,
        0,
        MediaSessionInfo_SessionStateSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'forceDuck', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'playbackState', 8,
        0,
        MediaPlaybackStateSpec.$,
        0,
        false /* nullable */,
        1,
      ),
      mojo.internal.StructField(
        'isControllable', 4,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        2,
      ),
      mojo.internal.StructField(
        'preferStopForGainFocusLoss', 4,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        4,
      ),
      mojo.internal.StructField(
        'deprecatedIsSensitive', 4,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        6,
      ),
      mojo.internal.StructField(
        'pictureInPictureState', 12,
        0,
        MediaPictureInPictureStateSpec.$,
        0,
        false /* nullable */,
        7,
      ),
      mojo.internal.StructField(
        'deprecatedAudioVideoState', 16,
        0,
        MediaAudioVideoStateSpec.$,
        0,
        false /* nullable */,
        8,
      ),
      mojo.internal.StructField(
        'audioSinkId', 24,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        9,
      ),
      mojo.internal.StructField(
        'audioVideoStates', 32,
        0,
        mojo.internal.Array(MediaAudioVideoStateSpec.$, false),
        null,
        true /* nullable */,
        10,
      ),
      mojo.internal.StructField(
        'microphoneState', 20,
        0,
        MicrophoneStateSpec.$,
        0,
        false /* nullable */,
        11,
      ),
      mojo.internal.StructField(
        'cameraState', 40,
        0,
        CameraStateSpec.$,
        0,
        false /* nullable */,
        11,
      ),
      mojo.internal.StructField(
        'muted', 4,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        12,
      ),
      mojo.internal.StructField(
        'hasPresentation', 4,
        5,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        14,
      ),
      mojo.internal.StructField(
        'remotePlaybackMetadata', 48,
        0,
        RemotePlaybackMetadataSpec.$,
        null,
        true /* nullable */,
        15,
      ),
      mojo.internal.StructField(
        'hideMetadata', 4,
        6,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        16,
      ),
      mojo.internal.StructField(
        'ignoreForActiveSession', 4,
        7,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        20,
      ),
      mojo.internal.StructField(
        'meetsVisibilityThreshold', 5,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        21,
      ),
      mojo.internal.StructField(
        'canEnterBrowserInitiatedAutopip', 5,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        24,
      ),
    ],
    [[0, 16],[1, 24],[2, 24],[4, 24],[6, 24],[7, 24],[8, 32],[9, 40],[10, 48],[11, 56],[12, 56],[14, 56],[15, 64],[16, 64],[20, 64],[21, 64],[24, 64],]);



/**
 * @record
 */
export class MediaSessionInfo {
  constructor() {
    /** @type { !MediaSessionInfo_SessionState } */
    this.state;
    /** @type { !boolean } */
    this.forceDuck;
    /** @type { !MediaPlaybackState } */
    this.playbackState;
    /** @type { !boolean } */
    this.isControllable;
    /** @type { !boolean } */
    this.preferStopForGainFocusLoss;
    /** @type { !boolean } */
    this.deprecatedIsSensitive;
    /** @type { !MediaPictureInPictureState } */
    this.pictureInPictureState;
    /** @type { !MediaAudioVideoState } */
    this.deprecatedAudioVideoState;
    /** @type { (string|undefined) } */
    this.audioSinkId;
    /** @type { (Array<!MediaAudioVideoState>|undefined) } */
    this.audioVideoStates;
    /** @type { !MicrophoneState } */
    this.microphoneState;
    /** @type { !CameraState } */
    this.cameraState;
    /** @type { !boolean } */
    this.muted;
    /** @type { !boolean } */
    this.hasPresentation;
    /** @type { (RemotePlaybackMetadata|undefined) } */
    this.remotePlaybackMetadata;
    /** @type { !boolean } */
    this.hideMetadata;
    /** @type { !boolean } */
    this.ignoreForActiveSession;
    /** @type { !boolean } */
    this.meetsVisibilityThreshold;
    /** @type { !boolean } */
    this.canEnterBrowserInitiatedAutopip;
  }
}



mojo.internal.Struct(
    MediaSessionDebugInfoSpec.$,
    'MediaSessionDebugInfo',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'owner', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'state', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class MediaSessionDebugInfo {
  constructor() {
    /** @type { !string } */
    this.name;
    /** @type { !string } */
    this.owner;
    /** @type { !string } */
    this.state;
  }
}



mojo.internal.Struct(
    MediaSessionObserver_MediaSessionInfoChanged_ParamsSpec.$,
    'MediaSessionObserver_MediaSessionInfoChanged_Params',
    [
      mojo.internal.StructField(
        'info', 0,
        0,
        MediaSessionInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaSessionObserver_MediaSessionInfoChanged_Params {
  constructor() {
    /** @type { !MediaSessionInfo } */
    this.info;
  }
}



mojo.internal.Struct(
    MediaSessionObserver_MediaSessionMetadataChanged_ParamsSpec.$,
    'MediaSessionObserver_MediaSessionMetadataChanged_Params',
    [
      mojo.internal.StructField(
        'metadata', 0,
        0,
        MediaMetadataSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaSessionObserver_MediaSessionMetadataChanged_Params {
  constructor() {
    /** @type { (MediaMetadata|undefined) } */
    this.metadata;
  }
}



mojo.internal.Struct(
    MediaSessionObserver_MediaSessionActionsChanged_ParamsSpec.$,
    'MediaSessionObserver_MediaSessionActionsChanged_Params',
    [
      mojo.internal.StructField(
        'action', 0,
        0,
        mojo.internal.Array(MediaSessionActionSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaSessionObserver_MediaSessionActionsChanged_Params {
  constructor() {
    /** @type { !Array<!MediaSessionAction> } */
    this.action;
  }
}



mojo.internal.Struct(
    MediaSessionObserver_MediaSessionImagesChanged_ParamsSpec.$,
    'MediaSessionObserver_MediaSessionImagesChanged_Params',
    [
      mojo.internal.StructField(
        'images', 0,
        0,
        mojo.internal.Map(MediaSessionImageTypeSpec.$, mojo.internal.Array(MediaImageSpec.$, false), false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaSessionObserver_MediaSessionImagesChanged_Params {
  constructor() {
    /** @type { !Object<!MediaSessionImageType, !Array<!MediaImage>> } */
    this.images;
  }
}



mojo.internal.Struct(
    MediaSessionObserver_MediaSessionPositionChanged_ParamsSpec.$,
    'MediaSessionObserver_MediaSessionPositionChanged_Params',
    [
      mojo.internal.StructField(
        'position', 0,
        0,
        MediaPositionSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaSessionObserver_MediaSessionPositionChanged_Params {
  constructor() {
    /** @type { (MediaPosition|undefined) } */
    this.position;
  }
}



mojo.internal.Struct(
    MediaSession_GetMediaSessionInfo_ParamsSpec.$,
    'MediaSession_GetMediaSessionInfo_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class MediaSession_GetMediaSessionInfo_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    MediaSession_GetMediaSessionInfo_ResponseParamsSpec.$,
    'MediaSession_GetMediaSessionInfo_ResponseParams',
    [
      mojo.internal.StructField(
        'info', 0,
        0,
        MediaSessionInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaSession_GetMediaSessionInfo_ResponseParams {
  constructor() {
    /** @type { !MediaSessionInfo } */
    this.info;
  }
}



mojo.internal.Struct(
    MediaSession_GetDebugInfo_ParamsSpec.$,
    'MediaSession_GetDebugInfo_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class MediaSession_GetDebugInfo_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    MediaSession_GetDebugInfo_ResponseParamsSpec.$,
    'MediaSession_GetDebugInfo_ResponseParams',
    [
      mojo.internal.StructField(
        'info', 0,
        0,
        MediaSessionDebugInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaSession_GetDebugInfo_ResponseParams {
  constructor() {
    /** @type { !MediaSessionDebugInfo } */
    this.info;
  }
}



mojo.internal.Struct(
    MediaSession_StartDucking_ParamsSpec.$,
    'MediaSession_StartDucking_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class MediaSession_StartDucking_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    MediaSession_StopDucking_ParamsSpec.$,
    'MediaSession_StopDucking_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class MediaSession_StopDucking_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    MediaSession_Suspend_ParamsSpec.$,
    'MediaSession_Suspend_Params',
    [
      mojo.internal.StructField(
        'suspendType', 0,
        0,
        MediaSession_SuspendTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaSession_Suspend_Params {
  constructor() {
    /** @type { !MediaSession_SuspendType } */
    this.suspendType;
  }
}



mojo.internal.Struct(
    MediaSession_Resume_ParamsSpec.$,
    'MediaSession_Resume_Params',
    [
      mojo.internal.StructField(
        'suspendType', 0,
        0,
        MediaSession_SuspendTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaSession_Resume_Params {
  constructor() {
    /** @type { !MediaSession_SuspendType } */
    this.suspendType;
  }
}



mojo.internal.Struct(
    MediaSession_AddObserver_ParamsSpec.$,
    'MediaSession_AddObserver_Params',
    [
      mojo.internal.StructField(
        'observer', 0,
        0,
        mojo.internal.InterfaceProxy(MediaSessionObserverRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaSession_AddObserver_Params {
  constructor() {
    /** @type { !MediaSessionObserverRemote } */
    this.observer;
  }
}



mojo.internal.Struct(
    MediaSession_PreviousTrack_ParamsSpec.$,
    'MediaSession_PreviousTrack_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class MediaSession_PreviousTrack_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    MediaSession_NextTrack_ParamsSpec.$,
    'MediaSession_NextTrack_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class MediaSession_NextTrack_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    MediaSession_Seek_ParamsSpec.$,
    'MediaSession_Seek_Params',
    [
      mojo.internal.StructField(
        'seekTime', 0,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaSession_Seek_Params {
  constructor() {
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.seekTime;
  }
}



mojo.internal.Struct(
    MediaSession_Stop_ParamsSpec.$,
    'MediaSession_Stop_Params',
    [
      mojo.internal.StructField(
        'suspendType', 0,
        0,
        MediaSession_SuspendTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaSession_Stop_Params {
  constructor() {
    /** @type { !MediaSession_SuspendType } */
    this.suspendType;
  }
}



mojo.internal.Struct(
    MediaSession_SkipAd_ParamsSpec.$,
    'MediaSession_SkipAd_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class MediaSession_SkipAd_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    MediaSession_GetMediaImageBitmap_ParamsSpec.$,
    'MediaSession_GetMediaImageBitmap_Params',
    [
      mojo.internal.StructField(
        'image', 0,
        0,
        MediaImageSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'minimumSizePx', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'desiredSizePx', 12,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MediaSession_GetMediaImageBitmap_Params {
  constructor() {
    /** @type { !MediaImage } */
    this.image;
    /** @type { !number } */
    this.minimumSizePx;
    /** @type { !number } */
    this.desiredSizePx;
  }
}



mojo.internal.Struct(
    MediaSession_GetMediaImageBitmap_ResponseParamsSpec.$,
    'MediaSession_GetMediaImageBitmap_ResponseParams',
    [
      mojo.internal.StructField(
        'image', 0,
        0,
        MediaImageBitmapSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaSession_GetMediaImageBitmap_ResponseParams {
  constructor() {
    /** @type { (MediaImageBitmap|undefined) } */
    this.image;
  }
}



mojo.internal.Struct(
    MediaSession_SeekTo_ParamsSpec.$,
    'MediaSession_SeekTo_Params',
    [
      mojo.internal.StructField(
        'seekTime', 0,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaSession_SeekTo_Params {
  constructor() {
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.seekTime;
  }
}



mojo.internal.Struct(
    MediaSession_ScrubTo_ParamsSpec.$,
    'MediaSession_ScrubTo_Params',
    [
      mojo.internal.StructField(
        'seekTime', 0,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaSession_ScrubTo_Params {
  constructor() {
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.seekTime;
  }
}



mojo.internal.Struct(
    MediaSession_EnterPictureInPicture_ParamsSpec.$,
    'MediaSession_EnterPictureInPicture_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class MediaSession_EnterPictureInPicture_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    MediaSession_ExitPictureInPicture_ParamsSpec.$,
    'MediaSession_ExitPictureInPicture_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class MediaSession_ExitPictureInPicture_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    MediaSession_SetAudioSinkId_ParamsSpec.$,
    'MediaSession_SetAudioSinkId_Params',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaSession_SetAudioSinkId_Params {
  constructor() {
    /** @type { (string|undefined) } */
    this.id;
  }
}



mojo.internal.Struct(
    MediaSession_ToggleMicrophone_ParamsSpec.$,
    'MediaSession_ToggleMicrophone_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class MediaSession_ToggleMicrophone_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    MediaSession_ToggleCamera_ParamsSpec.$,
    'MediaSession_ToggleCamera_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class MediaSession_ToggleCamera_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    MediaSession_HangUp_ParamsSpec.$,
    'MediaSession_HangUp_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class MediaSession_HangUp_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    MediaSession_Raise_ParamsSpec.$,
    'MediaSession_Raise_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class MediaSession_Raise_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    MediaSession_SetMute_ParamsSpec.$,
    'MediaSession_SetMute_Params',
    [
      mojo.internal.StructField(
        'mute', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaSession_SetMute_Params {
  constructor() {
    /** @type { !boolean } */
    this.mute;
  }
}



mojo.internal.Struct(
    MediaSession_RequestMediaRemoting_ParamsSpec.$,
    'MediaSession_RequestMediaRemoting_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class MediaSession_RequestMediaRemoting_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    MediaSession_PreviousSlide_ParamsSpec.$,
    'MediaSession_PreviousSlide_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class MediaSession_PreviousSlide_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    MediaSession_NextSlide_ParamsSpec.$,
    'MediaSession_NextSlide_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class MediaSession_NextSlide_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    MediaSession_EnterAutoPictureInPicture_ParamsSpec.$,
    'MediaSession_EnterAutoPictureInPicture_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class MediaSession_EnterAutoPictureInPicture_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    MediaSession_GetVisibility_ParamsSpec.$,
    'MediaSession_GetVisibility_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class MediaSession_GetVisibility_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    MediaSession_GetVisibility_ResponseParamsSpec.$,
    'MediaSession_GetVisibility_ResponseParams',
    [
      mojo.internal.StructField(
        'hasSufficientlyVisibleVideo', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaSession_GetVisibility_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.hasSufficientlyVisibleVideo;
  }
}

