// services/media_session/public/mojom/media_session.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/media_session/public/mojom/media_session.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('mediaSession.mojom');
  var string16$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/string16.mojom', '../../../../mojo/public/mojom/base/string16.mojom.js');
  }
  var time$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../../mojo/public/mojom/base/time.mojom.js');
  }
  var geometry$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/geometry/mojom/geometry.mojom', '../../../../ui/gfx/geometry/mojom/geometry.mojom.js');
  }
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../../url/mojom/url.mojom.js');
  }


  var MediaPlaybackState = {};
  MediaPlaybackState.kPaused = 0;
  MediaPlaybackState.kPlaying = 1;
  MediaPlaybackState.MIN_VALUE = 0;
  MediaPlaybackState.MAX_VALUE = 1;

  MediaPlaybackState.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  MediaPlaybackState.toKnownEnumValue = function(value) {
    return value;
  };

  MediaPlaybackState.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var MediaSessionAction = {};
  MediaSessionAction.kPlay = 0;
  MediaSessionAction.kPause = 1;
  MediaSessionAction.kPreviousTrack = 2;
  MediaSessionAction.kNextTrack = 3;
  MediaSessionAction.kSeekBackward = 4;
  MediaSessionAction.kSeekForward = 5;
  MediaSessionAction.kSkipAd = 6;
  MediaSessionAction.kStop = 7;
  MediaSessionAction.kSeekTo = 8;
  MediaSessionAction.kScrubTo = 9;
  MediaSessionAction.kEnterPictureInPicture = 10;
  MediaSessionAction.kExitPictureInPicture = 11;
  MediaSessionAction.kSwitchAudioDevice = 12;
  MediaSessionAction.kToggleMicrophone = 13;
  MediaSessionAction.kToggleCamera = 14;
  MediaSessionAction.kHangUp = 15;
  MediaSessionAction.kRaise = 16;
  MediaSessionAction.kSetMute = 17;
  MediaSessionAction.kPreviousSlide = 18;
  MediaSessionAction.kNextSlide = 19;
  MediaSessionAction.kEnterAutoPictureInPicture = 20;
  MediaSessionAction.MIN_VALUE = 0;
  MediaSessionAction.MAX_VALUE = 20;

  MediaSessionAction.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
    case 16:
    case 17:
    case 18:
    case 19:
    case 20:
      return true;
    }
    return false;
  };

  MediaSessionAction.toKnownEnumValue = function(value) {
    return value;
  };

  MediaSessionAction.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var MediaSessionImageType = {};
  MediaSessionImageType.kArtwork = 0;
  MediaSessionImageType.kSourceIcon = 1;
  MediaSessionImageType.kChapter = 2;
  MediaSessionImageType.MIN_VALUE = 0;
  MediaSessionImageType.MAX_VALUE = 2;

  MediaSessionImageType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  MediaSessionImageType.toKnownEnumValue = function(value) {
    return value;
  };

  MediaSessionImageType.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var MediaPictureInPictureState = {};
  MediaPictureInPictureState.kNotInPictureInPicture = 0;
  MediaPictureInPictureState.kInPictureInPicture = 1;
  MediaPictureInPictureState.MIN_VALUE = 0;
  MediaPictureInPictureState.MAX_VALUE = 1;

  MediaPictureInPictureState.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  MediaPictureInPictureState.toKnownEnumValue = function(value) {
    return value;
  };

  MediaPictureInPictureState.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var MediaAudioVideoState = {};
  MediaAudioVideoState.kDeprecatedUnknown = 0;
  MediaAudioVideoState.kAudioOnly = 1;
  MediaAudioVideoState.kAudioVideo = 2;
  MediaAudioVideoState.kVideoOnly = 3;
  MediaAudioVideoState.MIN_VALUE = 0;
  MediaAudioVideoState.MAX_VALUE = 3;

  MediaAudioVideoState.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  MediaAudioVideoState.toKnownEnumValue = function(value) {
    return value;
  };

  MediaAudioVideoState.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var MediaImageBitmapColorType = {};
  MediaImageBitmapColorType.kRGBA_8888 = 0;
  MediaImageBitmapColorType.kBGRA_8888 = 1;
  MediaImageBitmapColorType.MIN_VALUE = 0;
  MediaImageBitmapColorType.MAX_VALUE = 1;

  MediaImageBitmapColorType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  MediaImageBitmapColorType.toKnownEnumValue = function(value) {
    return value;
  };

  MediaImageBitmapColorType.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var MicrophoneState = {};
  MicrophoneState.kUnknown = 0;
  MicrophoneState.kMuted = 1;
  MicrophoneState.kUnmuted = 2;
  MicrophoneState.MIN_VALUE = 0;
  MicrophoneState.MAX_VALUE = 2;

  MicrophoneState.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  MicrophoneState.toKnownEnumValue = function(value) {
    return value;
  };

  MicrophoneState.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var CameraState = {};
  CameraState.kUnknown = 0;
  CameraState.kTurnedOn = 1;
  CameraState.kTurnedOff = 2;
  CameraState.MIN_VALUE = 0;
  CameraState.MAX_VALUE = 2;

  CameraState.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  CameraState.toKnownEnumValue = function(value) {
    return value;
  };

  CameraState.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function MediaImage(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaImage.prototype.initDefaults_ = function() {
    this.src = null;
    this.type = null;
    this.sizes = null;
  };
  MediaImage.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaImage.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaImage.src
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaImage.type
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, string16$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaImage.sizes
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 8, new codec.PointerTo(geometry$.Size), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaImage.encodedSize = codec.kStructHeaderSize + 24;

  MediaImage.decode = function(decoder) {
    var packed;
    var val = new MediaImage();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.src =
        decoder.decodeStructPointer(url$.Url);
    val.type =
        decoder.decodeStructPointer(string16$.String16);
    val.sizes =
        decoder.decodeArrayPointer(new codec.PointerTo(geometry$.Size));
    return val;
  };

  MediaImage.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaImage.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.src);
    encoder.encodeStructPointer(string16$.String16, val.type);
    encoder.encodeArrayPointer(new codec.PointerTo(geometry$.Size), val.sizes);
  };
  function ChapterInformation(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ChapterInformation.prototype.initDefaults_ = function() {
    this.title = null;
    this.startTime = null;
    this.artwork = null;
  };
  ChapterInformation.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ChapterInformation.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ChapterInformation.title
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, string16$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ChapterInformation.startTime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, time$.TimeDelta, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ChapterInformation.artwork
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 8, new codec.PointerTo(MediaImage), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ChapterInformation.encodedSize = codec.kStructHeaderSize + 24;

  ChapterInformation.decode = function(decoder) {
    var packed;
    var val = new ChapterInformation();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.title =
        decoder.decodeStructPointer(string16$.String16);
    val.startTime =
        decoder.decodeStructPointer(time$.TimeDelta);
    val.artwork =
        decoder.decodeArrayPointer(new codec.PointerTo(MediaImage));
    return val;
  };

  ChapterInformation.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ChapterInformation.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(string16$.String16, val.title);
    encoder.encodeStructPointer(time$.TimeDelta, val.startTime);
    encoder.encodeArrayPointer(new codec.PointerTo(MediaImage), val.artwork);
  };
  function MediaMetadata(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaMetadata.prototype.initDefaults_ = function() {
    this.title = null;
    this.artist = null;
    this.album = null;
    this.sourceTitle = null;
    this.chapters = null;
  };
  MediaMetadata.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaMetadata.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40},
      {version: 21, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaMetadata.title
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, string16$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaMetadata.artist
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, string16$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaMetadata.album
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, string16$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaMetadata.sourceTitle
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, string16$.String16, false);
    if (err !== validator.validationError.NONE)
        return err;



    // version check MediaMetadata.chapters
    if (!messageValidator.isFieldInStructVersion(offset, 21))
      return validator.validationError.NONE;
    // validate MediaMetadata.chapters
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 32, 8, new codec.PointerTo(ChapterInformation), true, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaMetadata.encodedSize = codec.kStructHeaderSize + 40;

  MediaMetadata.decode = function(decoder) {
    var packed;
    var val = new MediaMetadata();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.title =
        decoder.decodeStructPointer(string16$.String16);
    val.artist =
        decoder.decodeStructPointer(string16$.String16);
    val.album =
        decoder.decodeStructPointer(string16$.String16);
    val.sourceTitle =
        decoder.decodeStructPointer(string16$.String16);
    if (version >= 21) {
      val.chapters =
          decoder.decodeArrayPointer(new codec.PointerTo(ChapterInformation));
    } else {
      val.chapters = null;
    }
    return val;
  };

  MediaMetadata.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaMetadata.encodedSize);
    encoder.writeUint32(21);
    encoder.encodeStructPointer(string16$.String16, val.title);
    encoder.encodeStructPointer(string16$.String16, val.artist);
    encoder.encodeStructPointer(string16$.String16, val.album);
    encoder.encodeStructPointer(string16$.String16, val.sourceTitle);
    encoder.encodeArrayPointer(new codec.PointerTo(ChapterInformation), val.chapters);
  };
  function MediaImageBitmap(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaImageBitmap.prototype.initDefaults_ = function() {
    this.width = 0;
    this.height = 0;
    this.pixelData = null;
    this.colorType = 0;
  };
  MediaImageBitmap.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaImageBitmap.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24},
      {version: 5, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    // validate MediaImageBitmap.pixelData
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;



    // version check MediaImageBitmap.colorType
    if (!messageValidator.isFieldInStructVersion(offset, 5))
      return validator.validationError.NONE;
    // validate MediaImageBitmap.colorType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 16, MediaImageBitmapColorType);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaImageBitmap.encodedSize = codec.kStructHeaderSize + 24;

  MediaImageBitmap.decode = function(decoder) {
    var packed;
    var val = new MediaImageBitmap();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.width =
        decoder.decodeStruct(codec.Int32);
    val.height =
        decoder.decodeStruct(codec.Int32);
    val.pixelData =
        decoder.decodeArrayPointer(codec.Uint8);
    if (version >= 5) {
      val.colorType =
          decoder.decodeStruct(new codec.Enum(MediaImageBitmapColorType));
    } else {
      val.colorType = null;
    }
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MediaImageBitmap.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaImageBitmap.encodedSize);
    encoder.writeUint32(5);
    encoder.encodeStruct(codec.Int32, val.width);
    encoder.encodeStruct(codec.Int32, val.height);
    encoder.encodeArrayPointer(codec.Uint8, val.pixelData);
    encoder.encodeStruct(codec.Int32, val.colorType);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MediaPosition(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaPosition.prototype.initDefaults_ = function() {
    this.playbackRate = 0;
    this.duration = null;
    this.position = null;
    this.lastUpdatedTime = null;
    this.endOfMedia = false;
  };
  MediaPosition.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaPosition.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40},
      {version: 13, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate MediaPosition.duration
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, time$.TimeDelta, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaPosition.position
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, time$.TimeDelta, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaPosition.lastUpdatedTime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, time$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  MediaPosition.encodedSize = codec.kStructHeaderSize + 40;

  MediaPosition.decode = function(decoder) {
    var packed;
    var val = new MediaPosition();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.playbackRate =
        decoder.decodeStruct(codec.Double);
    val.duration =
        decoder.decodeStructPointer(time$.TimeDelta);
    val.position =
        decoder.decodeStructPointer(time$.TimeDelta);
    val.lastUpdatedTime =
        decoder.decodeStructPointer(time$.TimeTicks);
    packed = decoder.readUint8();
    val.endOfMedia = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MediaPosition.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaPosition.encodedSize);
    encoder.writeUint32(13);
    encoder.encodeStruct(codec.Double, val.playbackRate);
    encoder.encodeStructPointer(time$.TimeDelta, val.duration);
    encoder.encodeStructPointer(time$.TimeDelta, val.position);
    encoder.encodeStructPointer(time$.TimeTicks, val.lastUpdatedTime);
    packed = 0;
    packed |= (val.endOfMedia & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function RemotePlaybackMetadata(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemotePlaybackMetadata.prototype.initDefaults_ = function() {
    this.videoCodec = null;
    this.audioCodec = null;
    this.remotePlaybackDisabled = false;
    this.remotePlaybackStarted = false;
    this.isEncryptedMedia = false;
    this.unusedField = null;
  };
  RemotePlaybackMetadata.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemotePlaybackMetadata.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32},
      {version: 17, numBytes: 40},
      {version: 18, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemotePlaybackMetadata.videoCodec
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemotePlaybackMetadata.audioCodec
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;





    // version check RemotePlaybackMetadata.unusedField
    if (!messageValidator.isFieldInStructVersion(offset, 17))
      return validator.validationError.NONE;
    // validate RemotePlaybackMetadata.unusedField
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, true)
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  RemotePlaybackMetadata.encodedSize = codec.kStructHeaderSize + 32;

  RemotePlaybackMetadata.decode = function(decoder) {
    var packed;
    var val = new RemotePlaybackMetadata();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.videoCodec =
        decoder.decodeStruct(codec.String);
    val.audioCodec =
        decoder.decodeStruct(codec.String);
    packed = decoder.readUint8();
    val.remotePlaybackDisabled = (packed >> 0) & 1 ? true : false;
    val.remotePlaybackStarted = (packed >> 1) & 1 ? true : false;
    val.isEncryptedMedia = (packed >> 2) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    if (version >= 17) {
      val.unusedField =
          decoder.decodeStruct(codec.String);
    } else {
      val.unusedField = null;
    }
    return val;
  };

  RemotePlaybackMetadata.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemotePlaybackMetadata.encodedSize);
    encoder.writeUint32(18);
    encoder.encodeStruct(codec.String, val.videoCodec);
    encoder.encodeStruct(codec.String, val.audioCodec);
    packed = 0;
    packed |= (val.remotePlaybackDisabled & 1) << 0
    packed |= (val.remotePlaybackStarted & 1) << 1
    packed |= (val.isEncryptedMedia & 1) << 2
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.unusedField);
  };
  function MediaSessionInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }

  MediaSessionInfo.SessionState = {};
  MediaSessionInfo.SessionState.kActive = 0;
  MediaSessionInfo.SessionState.kDucking = 1;
  MediaSessionInfo.SessionState.kSuspended = 2;
  MediaSessionInfo.SessionState.kInactive = 3;
  MediaSessionInfo.SessionState.MIN_VALUE = 0;
  MediaSessionInfo.SessionState.MAX_VALUE = 3;

  MediaSessionInfo.SessionState.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  MediaSessionInfo.SessionState.toKnownEnumValue = function(value) {
    return value;
  };

  MediaSessionInfo.SessionState.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  MediaSessionInfo.prototype.initDefaults_ = function() {
    this.state = 0;
    this.forceDuck = false;
    this.isControllable = false;
    this.preferStopForGainFocusLoss = false;
    this.deprecatedIsSensitive = false;
    this.muted = false;
    this.hasPresentation = false;
    this.hideMetadata = false;
    this.ignoreForActiveSession = false;
    this.meetsVisibilityThreshold = false;
    this.canEnterBrowserInitiatedAutopip = false;
    this.playbackState = 0;
    this.pictureInPictureState = 0;
    this.deprecatedAudioVideoState = 0;
    this.microphoneState = 0;
    this.audioSinkId = null;
    this.audioVideoStates = null;
    this.cameraState = 0;
    this.remotePlaybackMetadata = null;
  };
  MediaSessionInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaSessionInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16},
      {version: 1, numBytes: 24},
      {version: 2, numBytes: 24},
      {version: 4, numBytes: 24},
      {version: 6, numBytes: 24},
      {version: 7, numBytes: 24},
      {version: 8, numBytes: 32},
      {version: 9, numBytes: 40},
      {version: 10, numBytes: 48},
      {version: 11, numBytes: 56},
      {version: 12, numBytes: 56},
      {version: 14, numBytes: 56},
      {version: 15, numBytes: 64},
      {version: 16, numBytes: 64},
      {version: 20, numBytes: 64},
      {version: 21, numBytes: 64},
      {version: 24, numBytes: 64}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaSessionInfo.state
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, MediaSessionInfo.SessionState);
    if (err !== validator.validationError.NONE)
        return err;




    // version check MediaSessionInfo.playbackState
    if (!messageValidator.isFieldInStructVersion(offset, 1))
      return validator.validationError.NONE;
    // validate MediaSessionInfo.playbackState
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, MediaPlaybackState);
    if (err !== validator.validationError.NONE)
        return err;






    // version check MediaSessionInfo.pictureInPictureState
    if (!messageValidator.isFieldInStructVersion(offset, 7))
      return validator.validationError.NONE;
    // validate MediaSessionInfo.pictureInPictureState
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 12, MediaPictureInPictureState);
    if (err !== validator.validationError.NONE)
        return err;



    // version check MediaSessionInfo.deprecatedAudioVideoState
    if (!messageValidator.isFieldInStructVersion(offset, 8))
      return validator.validationError.NONE;
    // validate MediaSessionInfo.deprecatedAudioVideoState
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 16, MediaAudioVideoState);
    if (err !== validator.validationError.NONE)
        return err;



    // version check MediaSessionInfo.audioSinkId
    if (!messageValidator.isFieldInStructVersion(offset, 9))
      return validator.validationError.NONE;
    // validate MediaSessionInfo.audioSinkId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, true)
    if (err !== validator.validationError.NONE)
        return err;



    // version check MediaSessionInfo.audioVideoStates
    if (!messageValidator.isFieldInStructVersion(offset, 10))
      return validator.validationError.NONE;
    // validate MediaSessionInfo.audioVideoStates
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 32, 4, new codec.Enum(MediaAudioVideoState), true, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;



    // version check MediaSessionInfo.microphoneState
    if (!messageValidator.isFieldInStructVersion(offset, 11))
      return validator.validationError.NONE;
    // validate MediaSessionInfo.microphoneState
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 20, MicrophoneState);
    if (err !== validator.validationError.NONE)
        return err;



    // version check MediaSessionInfo.cameraState
    if (!messageValidator.isFieldInStructVersion(offset, 11))
      return validator.validationError.NONE;
    // validate MediaSessionInfo.cameraState
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 40, CameraState);
    if (err !== validator.validationError.NONE)
        return err;





    // version check MediaSessionInfo.remotePlaybackMetadata
    if (!messageValidator.isFieldInStructVersion(offset, 15))
      return validator.validationError.NONE;
    // validate MediaSessionInfo.remotePlaybackMetadata
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 48, RemotePlaybackMetadata, true);
    if (err !== validator.validationError.NONE)
        return err;





    return validator.validationError.NONE;
  };

  MediaSessionInfo.encodedSize = codec.kStructHeaderSize + 56;

  MediaSessionInfo.decode = function(decoder) {
    var packed;
    var val = new MediaSessionInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.state =
        decoder.decodeStruct(new codec.Enum(MediaSessionInfo.SessionState));
    packed = decoder.readUint8();
    val.forceDuck = (packed >> 0) & 1 ? true : false;
    val.isControllable = (packed >> 1) & 1 ? true : false;
    val.preferStopForGainFocusLoss = (packed >> 2) & 1 ? true : false;
    val.deprecatedIsSensitive = (packed >> 3) & 1 ? true : false;
    val.muted = (packed >> 4) & 1 ? true : false;
    val.hasPresentation = (packed >> 5) & 1 ? true : false;
    val.hideMetadata = (packed >> 6) & 1 ? true : false;
    val.ignoreForActiveSession = (packed >> 7) & 1 ? true : false;
    packed = decoder.readUint8();
    val.meetsVisibilityThreshold = (packed >> 0) & 1 ? true : false;
    val.canEnterBrowserInitiatedAutopip = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    if (version >= 1) {
      val.playbackState =
          decoder.decodeStruct(new codec.Enum(MediaPlaybackState));
    } else {
      val.playbackState = null;
    }
    if (version >= 7) {
      val.pictureInPictureState =
          decoder.decodeStruct(new codec.Enum(MediaPictureInPictureState));
    } else {
      val.pictureInPictureState = null;
    }
    if (version >= 8) {
      val.deprecatedAudioVideoState =
          decoder.decodeStruct(new codec.Enum(MediaAudioVideoState));
    } else {
      val.deprecatedAudioVideoState = null;
    }
    if (version >= 11) {
      val.microphoneState =
          decoder.decodeStruct(new codec.Enum(MicrophoneState));
    } else {
      val.microphoneState = null;
    }
    if (version >= 9) {
      val.audioSinkId =
          decoder.decodeStruct(codec.String);
    } else {
      val.audioSinkId = null;
    }
    if (version >= 10) {
      val.audioVideoStates =
          decoder.decodeArrayPointer(new codec.Enum(MediaAudioVideoState));
    } else {
      val.audioVideoStates = null;
    }
    if (version >= 11) {
      val.cameraState =
          decoder.decodeStruct(new codec.Enum(CameraState));
    } else {
      val.cameraState = null;
    }
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    if (version >= 15) {
      val.remotePlaybackMetadata =
          decoder.decodeStructPointer(RemotePlaybackMetadata);
    } else {
      val.remotePlaybackMetadata = null;
    }
    return val;
  };

  MediaSessionInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaSessionInfo.encodedSize);
    encoder.writeUint32(24);
    encoder.encodeStruct(codec.Int32, val.state);
    packed = 0;
    packed |= (val.forceDuck & 1) << 0
    packed |= (val.isControllable & 1) << 1
    packed |= (val.preferStopForGainFocusLoss & 1) << 2
    packed |= (val.deprecatedIsSensitive & 1) << 3
    packed |= (val.muted & 1) << 4
    packed |= (val.hasPresentation & 1) << 5
    packed |= (val.hideMetadata & 1) << 6
    packed |= (val.ignoreForActiveSession & 1) << 7
    encoder.writeUint8(packed);
    packed = 0;
    packed |= (val.meetsVisibilityThreshold & 1) << 0
    packed |= (val.canEnterBrowserInitiatedAutopip & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.playbackState);
    encoder.encodeStruct(codec.Int32, val.pictureInPictureState);
    encoder.encodeStruct(codec.Int32, val.deprecatedAudioVideoState);
    encoder.encodeStruct(codec.Int32, val.microphoneState);
    encoder.encodeStruct(codec.String, val.audioSinkId);
    encoder.encodeArrayPointer(new codec.Enum(MediaAudioVideoState), val.audioVideoStates);
    encoder.encodeStruct(codec.Int32, val.cameraState);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(RemotePlaybackMetadata, val.remotePlaybackMetadata);
  };
  function MediaSessionDebugInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaSessionDebugInfo.prototype.initDefaults_ = function() {
    this.name = null;
    this.owner = null;
    this.state = null;
  };
  MediaSessionDebugInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaSessionDebugInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaSessionDebugInfo.name
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaSessionDebugInfo.owner
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaSessionDebugInfo.state
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaSessionDebugInfo.encodedSize = codec.kStructHeaderSize + 24;

  MediaSessionDebugInfo.decode = function(decoder) {
    var packed;
    var val = new MediaSessionDebugInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.name =
        decoder.decodeStruct(codec.String);
    val.owner =
        decoder.decodeStruct(codec.String);
    val.state =
        decoder.decodeStruct(codec.String);
    return val;
  };

  MediaSessionDebugInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaSessionDebugInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.name);
    encoder.encodeStruct(codec.String, val.owner);
    encoder.encodeStruct(codec.String, val.state);
  };
  function MediaSessionObserver_MediaSessionInfoChanged_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaSessionObserver_MediaSessionInfoChanged_Params.prototype.initDefaults_ = function() {
    this.info = null;
  };
  MediaSessionObserver_MediaSessionInfoChanged_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaSessionObserver_MediaSessionInfoChanged_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaSessionObserver_MediaSessionInfoChanged_Params.info
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, MediaSessionInfo, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaSessionObserver_MediaSessionInfoChanged_Params.encodedSize = codec.kStructHeaderSize + 8;

  MediaSessionObserver_MediaSessionInfoChanged_Params.decode = function(decoder) {
    var packed;
    var val = new MediaSessionObserver_MediaSessionInfoChanged_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.info =
        decoder.decodeStructPointer(MediaSessionInfo);
    return val;
  };

  MediaSessionObserver_MediaSessionInfoChanged_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaSessionObserver_MediaSessionInfoChanged_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(MediaSessionInfo, val.info);
  };
  function MediaSessionObserver_MediaSessionMetadataChanged_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaSessionObserver_MediaSessionMetadataChanged_Params.prototype.initDefaults_ = function() {
    this.metadata = null;
  };
  MediaSessionObserver_MediaSessionMetadataChanged_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaSessionObserver_MediaSessionMetadataChanged_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaSessionObserver_MediaSessionMetadataChanged_Params.metadata
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, MediaMetadata, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaSessionObserver_MediaSessionMetadataChanged_Params.encodedSize = codec.kStructHeaderSize + 8;

  MediaSessionObserver_MediaSessionMetadataChanged_Params.decode = function(decoder) {
    var packed;
    var val = new MediaSessionObserver_MediaSessionMetadataChanged_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.metadata =
        decoder.decodeStructPointer(MediaMetadata);
    return val;
  };

  MediaSessionObserver_MediaSessionMetadataChanged_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaSessionObserver_MediaSessionMetadataChanged_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(MediaMetadata, val.metadata);
  };
  function MediaSessionObserver_MediaSessionActionsChanged_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaSessionObserver_MediaSessionActionsChanged_Params.prototype.initDefaults_ = function() {
    this.action = null;
  };
  MediaSessionObserver_MediaSessionActionsChanged_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaSessionObserver_MediaSessionActionsChanged_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaSessionObserver_MediaSessionActionsChanged_Params.action
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 4, new codec.Enum(MediaSessionAction), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaSessionObserver_MediaSessionActionsChanged_Params.encodedSize = codec.kStructHeaderSize + 8;

  MediaSessionObserver_MediaSessionActionsChanged_Params.decode = function(decoder) {
    var packed;
    var val = new MediaSessionObserver_MediaSessionActionsChanged_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.action =
        decoder.decodeArrayPointer(new codec.Enum(MediaSessionAction));
    return val;
  };

  MediaSessionObserver_MediaSessionActionsChanged_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaSessionObserver_MediaSessionActionsChanged_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.Enum(MediaSessionAction), val.action);
  };
  function MediaSessionObserver_MediaSessionImagesChanged_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaSessionObserver_MediaSessionImagesChanged_Params.prototype.initDefaults_ = function() {
    this.images = null;
  };
  MediaSessionObserver_MediaSessionImagesChanged_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaSessionObserver_MediaSessionImagesChanged_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaSessionObserver_MediaSessionImagesChanged_Params.images
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 0, false, new codec.Enum(MediaSessionImageType), new codec.ArrayOf(new codec.PointerTo(MediaImage)), false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaSessionObserver_MediaSessionImagesChanged_Params.encodedSize = codec.kStructHeaderSize + 8;

  MediaSessionObserver_MediaSessionImagesChanged_Params.decode = function(decoder) {
    var packed;
    var val = new MediaSessionObserver_MediaSessionImagesChanged_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.images =
        decoder.decodeMapPointer(new codec.Enum(MediaSessionImageType), new codec.ArrayOf(new codec.PointerTo(MediaImage)));
    return val;
  };

  MediaSessionObserver_MediaSessionImagesChanged_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaSessionObserver_MediaSessionImagesChanged_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeMapPointer(new codec.Enum(MediaSessionImageType), new codec.ArrayOf(new codec.PointerTo(MediaImage)), val.images);
  };
  function MediaSessionObserver_MediaSessionPositionChanged_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaSessionObserver_MediaSessionPositionChanged_Params.prototype.initDefaults_ = function() {
    this.position = null;
  };
  MediaSessionObserver_MediaSessionPositionChanged_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaSessionObserver_MediaSessionPositionChanged_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaSessionObserver_MediaSessionPositionChanged_Params.position
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, MediaPosition, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaSessionObserver_MediaSessionPositionChanged_Params.encodedSize = codec.kStructHeaderSize + 8;

  MediaSessionObserver_MediaSessionPositionChanged_Params.decode = function(decoder) {
    var packed;
    var val = new MediaSessionObserver_MediaSessionPositionChanged_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.position =
        decoder.decodeStructPointer(MediaPosition);
    return val;
  };

  MediaSessionObserver_MediaSessionPositionChanged_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaSessionObserver_MediaSessionPositionChanged_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(MediaPosition, val.position);
  };
  function MediaSession_GetMediaSessionInfo_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaSession_GetMediaSessionInfo_Params.prototype.initDefaults_ = function() {
  };
  MediaSession_GetMediaSessionInfo_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaSession_GetMediaSessionInfo_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaSession_GetMediaSessionInfo_Params.encodedSize = codec.kStructHeaderSize + 0;

  MediaSession_GetMediaSessionInfo_Params.decode = function(decoder) {
    var packed;
    var val = new MediaSession_GetMediaSessionInfo_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  MediaSession_GetMediaSessionInfo_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaSession_GetMediaSessionInfo_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function MediaSession_GetMediaSessionInfo_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaSession_GetMediaSessionInfo_ResponseParams.prototype.initDefaults_ = function() {
    this.info = null;
  };
  MediaSession_GetMediaSessionInfo_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaSession_GetMediaSessionInfo_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaSession_GetMediaSessionInfo_ResponseParams.info
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, MediaSessionInfo, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaSession_GetMediaSessionInfo_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  MediaSession_GetMediaSessionInfo_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new MediaSession_GetMediaSessionInfo_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.info =
        decoder.decodeStructPointer(MediaSessionInfo);
    return val;
  };

  MediaSession_GetMediaSessionInfo_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaSession_GetMediaSessionInfo_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(MediaSessionInfo, val.info);
  };
  function MediaSession_GetDebugInfo_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaSession_GetDebugInfo_Params.prototype.initDefaults_ = function() {
  };
  MediaSession_GetDebugInfo_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaSession_GetDebugInfo_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaSession_GetDebugInfo_Params.encodedSize = codec.kStructHeaderSize + 0;

  MediaSession_GetDebugInfo_Params.decode = function(decoder) {
    var packed;
    var val = new MediaSession_GetDebugInfo_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  MediaSession_GetDebugInfo_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaSession_GetDebugInfo_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function MediaSession_GetDebugInfo_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaSession_GetDebugInfo_ResponseParams.prototype.initDefaults_ = function() {
    this.info = null;
  };
  MediaSession_GetDebugInfo_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaSession_GetDebugInfo_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaSession_GetDebugInfo_ResponseParams.info
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, MediaSessionDebugInfo, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaSession_GetDebugInfo_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  MediaSession_GetDebugInfo_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new MediaSession_GetDebugInfo_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.info =
        decoder.decodeStructPointer(MediaSessionDebugInfo);
    return val;
  };

  MediaSession_GetDebugInfo_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaSession_GetDebugInfo_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(MediaSessionDebugInfo, val.info);
  };
  function MediaSession_StartDucking_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaSession_StartDucking_Params.prototype.initDefaults_ = function() {
  };
  MediaSession_StartDucking_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaSession_StartDucking_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaSession_StartDucking_Params.encodedSize = codec.kStructHeaderSize + 0;

  MediaSession_StartDucking_Params.decode = function(decoder) {
    var packed;
    var val = new MediaSession_StartDucking_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  MediaSession_StartDucking_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaSession_StartDucking_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function MediaSession_StopDucking_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaSession_StopDucking_Params.prototype.initDefaults_ = function() {
  };
  MediaSession_StopDucking_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaSession_StopDucking_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaSession_StopDucking_Params.encodedSize = codec.kStructHeaderSize + 0;

  MediaSession_StopDucking_Params.decode = function(decoder) {
    var packed;
    var val = new MediaSession_StopDucking_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  MediaSession_StopDucking_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaSession_StopDucking_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function MediaSession_Suspend_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaSession_Suspend_Params.prototype.initDefaults_ = function() {
    this.suspendType = 0;
  };
  MediaSession_Suspend_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaSession_Suspend_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaSession_Suspend_Params.suspendType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, MediaSession.SuspendType);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaSession_Suspend_Params.encodedSize = codec.kStructHeaderSize + 8;

  MediaSession_Suspend_Params.decode = function(decoder) {
    var packed;
    var val = new MediaSession_Suspend_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.suspendType =
        decoder.decodeStruct(new codec.Enum(MediaSession.SuspendType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MediaSession_Suspend_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaSession_Suspend_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.suspendType);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MediaSession_Resume_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaSession_Resume_Params.prototype.initDefaults_ = function() {
    this.suspendType = 0;
  };
  MediaSession_Resume_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaSession_Resume_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaSession_Resume_Params.suspendType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, MediaSession.SuspendType);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaSession_Resume_Params.encodedSize = codec.kStructHeaderSize + 8;

  MediaSession_Resume_Params.decode = function(decoder) {
    var packed;
    var val = new MediaSession_Resume_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.suspendType =
        decoder.decodeStruct(new codec.Enum(MediaSession.SuspendType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MediaSession_Resume_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaSession_Resume_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.suspendType);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MediaSession_AddObserver_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaSession_AddObserver_Params.prototype.initDefaults_ = function() {
    this.observer = new MediaSessionObserverPtr();
  };
  MediaSession_AddObserver_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaSession_AddObserver_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaSession_AddObserver_Params.observer
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaSession_AddObserver_Params.encodedSize = codec.kStructHeaderSize + 8;

  MediaSession_AddObserver_Params.decode = function(decoder) {
    var packed;
    var val = new MediaSession_AddObserver_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.observer =
        decoder.decodeStruct(new codec.Interface(MediaSessionObserverPtr));
    return val;
  };

  MediaSession_AddObserver_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaSession_AddObserver_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(MediaSessionObserverPtr), val.observer);
  };
  function MediaSession_PreviousTrack_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaSession_PreviousTrack_Params.prototype.initDefaults_ = function() {
  };
  MediaSession_PreviousTrack_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaSession_PreviousTrack_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaSession_PreviousTrack_Params.encodedSize = codec.kStructHeaderSize + 0;

  MediaSession_PreviousTrack_Params.decode = function(decoder) {
    var packed;
    var val = new MediaSession_PreviousTrack_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  MediaSession_PreviousTrack_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaSession_PreviousTrack_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function MediaSession_NextTrack_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaSession_NextTrack_Params.prototype.initDefaults_ = function() {
  };
  MediaSession_NextTrack_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaSession_NextTrack_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaSession_NextTrack_Params.encodedSize = codec.kStructHeaderSize + 0;

  MediaSession_NextTrack_Params.decode = function(decoder) {
    var packed;
    var val = new MediaSession_NextTrack_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  MediaSession_NextTrack_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaSession_NextTrack_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function MediaSession_Seek_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaSession_Seek_Params.prototype.initDefaults_ = function() {
    this.seekTime = null;
  };
  MediaSession_Seek_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaSession_Seek_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaSession_Seek_Params.seekTime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, time$.TimeDelta, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaSession_Seek_Params.encodedSize = codec.kStructHeaderSize + 8;

  MediaSession_Seek_Params.decode = function(decoder) {
    var packed;
    var val = new MediaSession_Seek_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.seekTime =
        decoder.decodeStructPointer(time$.TimeDelta);
    return val;
  };

  MediaSession_Seek_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaSession_Seek_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(time$.TimeDelta, val.seekTime);
  };
  function MediaSession_Stop_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaSession_Stop_Params.prototype.initDefaults_ = function() {
    this.suspendType = 0;
  };
  MediaSession_Stop_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaSession_Stop_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaSession_Stop_Params.suspendType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, MediaSession.SuspendType);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaSession_Stop_Params.encodedSize = codec.kStructHeaderSize + 8;

  MediaSession_Stop_Params.decode = function(decoder) {
    var packed;
    var val = new MediaSession_Stop_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.suspendType =
        decoder.decodeStruct(new codec.Enum(MediaSession.SuspendType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MediaSession_Stop_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaSession_Stop_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.suspendType);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MediaSession_SkipAd_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaSession_SkipAd_Params.prototype.initDefaults_ = function() {
  };
  MediaSession_SkipAd_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaSession_SkipAd_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaSession_SkipAd_Params.encodedSize = codec.kStructHeaderSize + 0;

  MediaSession_SkipAd_Params.decode = function(decoder) {
    var packed;
    var val = new MediaSession_SkipAd_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  MediaSession_SkipAd_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaSession_SkipAd_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function MediaSession_GetMediaImageBitmap_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaSession_GetMediaImageBitmap_Params.prototype.initDefaults_ = function() {
    this.image = null;
    this.minimumSizePx = 0;
    this.desiredSizePx = 0;
  };
  MediaSession_GetMediaImageBitmap_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaSession_GetMediaImageBitmap_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaSession_GetMediaImageBitmap_Params.image
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, MediaImage, false);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  MediaSession_GetMediaImageBitmap_Params.encodedSize = codec.kStructHeaderSize + 16;

  MediaSession_GetMediaImageBitmap_Params.decode = function(decoder) {
    var packed;
    var val = new MediaSession_GetMediaImageBitmap_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.image =
        decoder.decodeStructPointer(MediaImage);
    val.minimumSizePx =
        decoder.decodeStruct(codec.Int32);
    val.desiredSizePx =
        decoder.decodeStruct(codec.Int32);
    return val;
  };

  MediaSession_GetMediaImageBitmap_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaSession_GetMediaImageBitmap_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(MediaImage, val.image);
    encoder.encodeStruct(codec.Int32, val.minimumSizePx);
    encoder.encodeStruct(codec.Int32, val.desiredSizePx);
  };
  function MediaSession_GetMediaImageBitmap_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaSession_GetMediaImageBitmap_ResponseParams.prototype.initDefaults_ = function() {
    this.image = null;
  };
  MediaSession_GetMediaImageBitmap_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaSession_GetMediaImageBitmap_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaSession_GetMediaImageBitmap_ResponseParams.image
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, MediaImageBitmap, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaSession_GetMediaImageBitmap_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  MediaSession_GetMediaImageBitmap_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new MediaSession_GetMediaImageBitmap_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.image =
        decoder.decodeStructPointer(MediaImageBitmap);
    return val;
  };

  MediaSession_GetMediaImageBitmap_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaSession_GetMediaImageBitmap_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(MediaImageBitmap, val.image);
  };
  function MediaSession_SeekTo_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaSession_SeekTo_Params.prototype.initDefaults_ = function() {
    this.seekTime = null;
  };
  MediaSession_SeekTo_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaSession_SeekTo_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaSession_SeekTo_Params.seekTime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, time$.TimeDelta, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaSession_SeekTo_Params.encodedSize = codec.kStructHeaderSize + 8;

  MediaSession_SeekTo_Params.decode = function(decoder) {
    var packed;
    var val = new MediaSession_SeekTo_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.seekTime =
        decoder.decodeStructPointer(time$.TimeDelta);
    return val;
  };

  MediaSession_SeekTo_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaSession_SeekTo_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(time$.TimeDelta, val.seekTime);
  };
  function MediaSession_ScrubTo_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaSession_ScrubTo_Params.prototype.initDefaults_ = function() {
    this.seekTime = null;
  };
  MediaSession_ScrubTo_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaSession_ScrubTo_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaSession_ScrubTo_Params.seekTime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, time$.TimeDelta, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaSession_ScrubTo_Params.encodedSize = codec.kStructHeaderSize + 8;

  MediaSession_ScrubTo_Params.decode = function(decoder) {
    var packed;
    var val = new MediaSession_ScrubTo_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.seekTime =
        decoder.decodeStructPointer(time$.TimeDelta);
    return val;
  };

  MediaSession_ScrubTo_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaSession_ScrubTo_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(time$.TimeDelta, val.seekTime);
  };
  function MediaSession_EnterPictureInPicture_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaSession_EnterPictureInPicture_Params.prototype.initDefaults_ = function() {
  };
  MediaSession_EnterPictureInPicture_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaSession_EnterPictureInPicture_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaSession_EnterPictureInPicture_Params.encodedSize = codec.kStructHeaderSize + 0;

  MediaSession_EnterPictureInPicture_Params.decode = function(decoder) {
    var packed;
    var val = new MediaSession_EnterPictureInPicture_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  MediaSession_EnterPictureInPicture_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaSession_EnterPictureInPicture_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function MediaSession_ExitPictureInPicture_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaSession_ExitPictureInPicture_Params.prototype.initDefaults_ = function() {
  };
  MediaSession_ExitPictureInPicture_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaSession_ExitPictureInPicture_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaSession_ExitPictureInPicture_Params.encodedSize = codec.kStructHeaderSize + 0;

  MediaSession_ExitPictureInPicture_Params.decode = function(decoder) {
    var packed;
    var val = new MediaSession_ExitPictureInPicture_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  MediaSession_ExitPictureInPicture_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaSession_ExitPictureInPicture_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function MediaSession_SetAudioSinkId_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaSession_SetAudioSinkId_Params.prototype.initDefaults_ = function() {
    this.id = null;
  };
  MediaSession_SetAudioSinkId_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaSession_SetAudioSinkId_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MediaSession_SetAudioSinkId_Params.id
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, true)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaSession_SetAudioSinkId_Params.encodedSize = codec.kStructHeaderSize + 8;

  MediaSession_SetAudioSinkId_Params.decode = function(decoder) {
    var packed;
    var val = new MediaSession_SetAudioSinkId_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.id =
        decoder.decodeStruct(codec.String);
    return val;
  };

  MediaSession_SetAudioSinkId_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaSession_SetAudioSinkId_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.id);
  };
  function MediaSession_ToggleMicrophone_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaSession_ToggleMicrophone_Params.prototype.initDefaults_ = function() {
  };
  MediaSession_ToggleMicrophone_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaSession_ToggleMicrophone_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaSession_ToggleMicrophone_Params.encodedSize = codec.kStructHeaderSize + 0;

  MediaSession_ToggleMicrophone_Params.decode = function(decoder) {
    var packed;
    var val = new MediaSession_ToggleMicrophone_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  MediaSession_ToggleMicrophone_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaSession_ToggleMicrophone_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function MediaSession_ToggleCamera_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaSession_ToggleCamera_Params.prototype.initDefaults_ = function() {
  };
  MediaSession_ToggleCamera_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaSession_ToggleCamera_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaSession_ToggleCamera_Params.encodedSize = codec.kStructHeaderSize + 0;

  MediaSession_ToggleCamera_Params.decode = function(decoder) {
    var packed;
    var val = new MediaSession_ToggleCamera_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  MediaSession_ToggleCamera_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaSession_ToggleCamera_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function MediaSession_HangUp_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaSession_HangUp_Params.prototype.initDefaults_ = function() {
  };
  MediaSession_HangUp_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaSession_HangUp_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaSession_HangUp_Params.encodedSize = codec.kStructHeaderSize + 0;

  MediaSession_HangUp_Params.decode = function(decoder) {
    var packed;
    var val = new MediaSession_HangUp_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  MediaSession_HangUp_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaSession_HangUp_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function MediaSession_Raise_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaSession_Raise_Params.prototype.initDefaults_ = function() {
  };
  MediaSession_Raise_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaSession_Raise_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaSession_Raise_Params.encodedSize = codec.kStructHeaderSize + 0;

  MediaSession_Raise_Params.decode = function(decoder) {
    var packed;
    var val = new MediaSession_Raise_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  MediaSession_Raise_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaSession_Raise_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function MediaSession_SetMute_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaSession_SetMute_Params.prototype.initDefaults_ = function() {
    this.mute = false;
  };
  MediaSession_SetMute_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaSession_SetMute_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  MediaSession_SetMute_Params.encodedSize = codec.kStructHeaderSize + 8;

  MediaSession_SetMute_Params.decode = function(decoder) {
    var packed;
    var val = new MediaSession_SetMute_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.mute = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MediaSession_SetMute_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaSession_SetMute_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.mute & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function MediaSession_RequestMediaRemoting_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaSession_RequestMediaRemoting_Params.prototype.initDefaults_ = function() {
  };
  MediaSession_RequestMediaRemoting_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaSession_RequestMediaRemoting_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaSession_RequestMediaRemoting_Params.encodedSize = codec.kStructHeaderSize + 0;

  MediaSession_RequestMediaRemoting_Params.decode = function(decoder) {
    var packed;
    var val = new MediaSession_RequestMediaRemoting_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  MediaSession_RequestMediaRemoting_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaSession_RequestMediaRemoting_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function MediaSession_PreviousSlide_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaSession_PreviousSlide_Params.prototype.initDefaults_ = function() {
  };
  MediaSession_PreviousSlide_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaSession_PreviousSlide_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaSession_PreviousSlide_Params.encodedSize = codec.kStructHeaderSize + 0;

  MediaSession_PreviousSlide_Params.decode = function(decoder) {
    var packed;
    var val = new MediaSession_PreviousSlide_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  MediaSession_PreviousSlide_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaSession_PreviousSlide_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function MediaSession_NextSlide_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaSession_NextSlide_Params.prototype.initDefaults_ = function() {
  };
  MediaSession_NextSlide_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaSession_NextSlide_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaSession_NextSlide_Params.encodedSize = codec.kStructHeaderSize + 0;

  MediaSession_NextSlide_Params.decode = function(decoder) {
    var packed;
    var val = new MediaSession_NextSlide_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  MediaSession_NextSlide_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaSession_NextSlide_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function MediaSession_EnterAutoPictureInPicture_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaSession_EnterAutoPictureInPicture_Params.prototype.initDefaults_ = function() {
  };
  MediaSession_EnterAutoPictureInPicture_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaSession_EnterAutoPictureInPicture_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaSession_EnterAutoPictureInPicture_Params.encodedSize = codec.kStructHeaderSize + 0;

  MediaSession_EnterAutoPictureInPicture_Params.decode = function(decoder) {
    var packed;
    var val = new MediaSession_EnterAutoPictureInPicture_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  MediaSession_EnterAutoPictureInPicture_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaSession_EnterAutoPictureInPicture_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function MediaSession_GetVisibility_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaSession_GetVisibility_Params.prototype.initDefaults_ = function() {
  };
  MediaSession_GetVisibility_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaSession_GetVisibility_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  MediaSession_GetVisibility_Params.encodedSize = codec.kStructHeaderSize + 0;

  MediaSession_GetVisibility_Params.decode = function(decoder) {
    var packed;
    var val = new MediaSession_GetVisibility_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  MediaSession_GetVisibility_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaSession_GetVisibility_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function MediaSession_GetVisibility_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MediaSession_GetVisibility_ResponseParams.prototype.initDefaults_ = function() {
    this.hasSufficientlyVisibleVideo = false;
  };
  MediaSession_GetVisibility_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MediaSession_GetVisibility_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  MediaSession_GetVisibility_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  MediaSession_GetVisibility_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new MediaSession_GetVisibility_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.hasSufficientlyVisibleVideo = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  MediaSession_GetVisibility_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MediaSession_GetVisibility_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.hasSufficientlyVisibleVideo & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  var kMediaSessionObserver_MediaSessionInfoChanged_Name = 0;
  var kMediaSessionObserver_MediaSessionMetadataChanged_Name = 1;
  var kMediaSessionObserver_MediaSessionActionsChanged_Name = 2;
  var kMediaSessionObserver_MediaSessionImagesChanged_Name = 3;
  var kMediaSessionObserver_MediaSessionPositionChanged_Name = 4;

  function MediaSessionObserverPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(MediaSessionObserver,
                                                   handleOrPtrInfo);
  }

  function MediaSessionObserverAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        MediaSessionObserver, associatedInterfacePtrInfo);
  }

  MediaSessionObserverAssociatedPtr.prototype =
      Object.create(MediaSessionObserverPtr.prototype);
  MediaSessionObserverAssociatedPtr.prototype.constructor =
      MediaSessionObserverAssociatedPtr;

  function MediaSessionObserverProxy(receiver) {
    this.receiver_ = receiver;
  }
  MediaSessionObserverPtr.prototype.mediaSessionInfoChanged = function() {
    return MediaSessionObserverProxy.prototype.mediaSessionInfoChanged
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaSessionObserverProxy.prototype.mediaSessionInfoChanged = function(info) {
    var params_ = new MediaSessionObserver_MediaSessionInfoChanged_Params();
    params_.info = info;
    var builder = new codec.MessageV0Builder(
        kMediaSessionObserver_MediaSessionInfoChanged_Name,
        codec.align(MediaSessionObserver_MediaSessionInfoChanged_Params.encodedSize));
    builder.encodeStruct(MediaSessionObserver_MediaSessionInfoChanged_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaSessionObserverPtr.prototype.mediaSessionMetadataChanged = function() {
    return MediaSessionObserverProxy.prototype.mediaSessionMetadataChanged
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaSessionObserverProxy.prototype.mediaSessionMetadataChanged = function(metadata) {
    var params_ = new MediaSessionObserver_MediaSessionMetadataChanged_Params();
    params_.metadata = metadata;
    var builder = new codec.MessageV0Builder(
        kMediaSessionObserver_MediaSessionMetadataChanged_Name,
        codec.align(MediaSessionObserver_MediaSessionMetadataChanged_Params.encodedSize));
    builder.encodeStruct(MediaSessionObserver_MediaSessionMetadataChanged_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaSessionObserverPtr.prototype.mediaSessionActionsChanged = function() {
    return MediaSessionObserverProxy.prototype.mediaSessionActionsChanged
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaSessionObserverProxy.prototype.mediaSessionActionsChanged = function(action) {
    var params_ = new MediaSessionObserver_MediaSessionActionsChanged_Params();
    params_.action = action;
    var builder = new codec.MessageV0Builder(
        kMediaSessionObserver_MediaSessionActionsChanged_Name,
        codec.align(MediaSessionObserver_MediaSessionActionsChanged_Params.encodedSize));
    builder.encodeStruct(MediaSessionObserver_MediaSessionActionsChanged_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaSessionObserverPtr.prototype.mediaSessionImagesChanged = function() {
    return MediaSessionObserverProxy.prototype.mediaSessionImagesChanged
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaSessionObserverProxy.prototype.mediaSessionImagesChanged = function(images) {
    var params_ = new MediaSessionObserver_MediaSessionImagesChanged_Params();
    params_.images = images;
    var builder = new codec.MessageV0Builder(
        kMediaSessionObserver_MediaSessionImagesChanged_Name,
        codec.align(MediaSessionObserver_MediaSessionImagesChanged_Params.encodedSize));
    builder.encodeStruct(MediaSessionObserver_MediaSessionImagesChanged_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaSessionObserverPtr.prototype.mediaSessionPositionChanged = function() {
    return MediaSessionObserverProxy.prototype.mediaSessionPositionChanged
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaSessionObserverProxy.prototype.mediaSessionPositionChanged = function(position) {
    var params_ = new MediaSessionObserver_MediaSessionPositionChanged_Params();
    params_.position = position;
    var builder = new codec.MessageV0Builder(
        kMediaSessionObserver_MediaSessionPositionChanged_Name,
        codec.align(MediaSessionObserver_MediaSessionPositionChanged_Params.encodedSize));
    builder.encodeStruct(MediaSessionObserver_MediaSessionPositionChanged_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function MediaSessionObserverStub(delegate) {
    this.delegate_ = delegate;
  }
  MediaSessionObserverStub.prototype.mediaSessionInfoChanged = function(info) {
    return this.delegate_ && this.delegate_.mediaSessionInfoChanged && this.delegate_.mediaSessionInfoChanged(info);
  }
  MediaSessionObserverStub.prototype.mediaSessionMetadataChanged = function(metadata) {
    return this.delegate_ && this.delegate_.mediaSessionMetadataChanged && this.delegate_.mediaSessionMetadataChanged(metadata);
  }
  MediaSessionObserverStub.prototype.mediaSessionActionsChanged = function(action) {
    return this.delegate_ && this.delegate_.mediaSessionActionsChanged && this.delegate_.mediaSessionActionsChanged(action);
  }
  MediaSessionObserverStub.prototype.mediaSessionImagesChanged = function(images) {
    return this.delegate_ && this.delegate_.mediaSessionImagesChanged && this.delegate_.mediaSessionImagesChanged(images);
  }
  MediaSessionObserverStub.prototype.mediaSessionPositionChanged = function(position) {
    return this.delegate_ && this.delegate_.mediaSessionPositionChanged && this.delegate_.mediaSessionPositionChanged(position);
  }

  MediaSessionObserverStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kMediaSessionObserver_MediaSessionInfoChanged_Name:
      var params = reader.decodeStruct(MediaSessionObserver_MediaSessionInfoChanged_Params);
      this.mediaSessionInfoChanged(params.info);
      return true;
    case kMediaSessionObserver_MediaSessionMetadataChanged_Name:
      var params = reader.decodeStruct(MediaSessionObserver_MediaSessionMetadataChanged_Params);
      this.mediaSessionMetadataChanged(params.metadata);
      return true;
    case kMediaSessionObserver_MediaSessionActionsChanged_Name:
      var params = reader.decodeStruct(MediaSessionObserver_MediaSessionActionsChanged_Params);
      this.mediaSessionActionsChanged(params.action);
      return true;
    case kMediaSessionObserver_MediaSessionImagesChanged_Name:
      var params = reader.decodeStruct(MediaSessionObserver_MediaSessionImagesChanged_Params);
      this.mediaSessionImagesChanged(params.images);
      return true;
    case kMediaSessionObserver_MediaSessionPositionChanged_Name:
      var params = reader.decodeStruct(MediaSessionObserver_MediaSessionPositionChanged_Params);
      this.mediaSessionPositionChanged(params.position);
      return true;
    default:
      return false;
    }
  };

  MediaSessionObserverStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateMediaSessionObserverRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kMediaSessionObserver_MediaSessionInfoChanged_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaSessionObserver_MediaSessionInfoChanged_Params;
      break;
      case kMediaSessionObserver_MediaSessionMetadataChanged_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaSessionObserver_MediaSessionMetadataChanged_Params;
      break;
      case kMediaSessionObserver_MediaSessionActionsChanged_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaSessionObserver_MediaSessionActionsChanged_Params;
      break;
      case kMediaSessionObserver_MediaSessionImagesChanged_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaSessionObserver_MediaSessionImagesChanged_Params;
      break;
      case kMediaSessionObserver_MediaSessionPositionChanged_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaSessionObserver_MediaSessionPositionChanged_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateMediaSessionObserverResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var MediaSessionObserver = {
    name: 'media_session.mojom.MediaSessionObserver',
    kVersion: 0,
    ptrClass: MediaSessionObserverPtr,
    proxyClass: MediaSessionObserverProxy,
    stubClass: MediaSessionObserverStub,
    validateRequest: validateMediaSessionObserverRequest,
    validateResponse: null,
  };
  MediaSessionObserverStub.prototype.validator = validateMediaSessionObserverRequest;
  MediaSessionObserverProxy.prototype.validator = null;
  var kMediaSession_GetMediaSessionInfo_Name = 0;
  var kMediaSession_GetDebugInfo_Name = 1;
  var kMediaSession_StartDucking_Name = 2;
  var kMediaSession_StopDucking_Name = 3;
  var kMediaSession_Suspend_Name = 4;
  var kMediaSession_Resume_Name = 5;
  var kMediaSession_AddObserver_Name = 6;
  var kMediaSession_PreviousTrack_Name = 7;
  var kMediaSession_NextTrack_Name = 8;
  var kMediaSession_Seek_Name = 9;
  var kMediaSession_Stop_Name = 10;
  var kMediaSession_SkipAd_Name = 11;
  var kMediaSession_GetMediaImageBitmap_Name = 12;
  var kMediaSession_SeekTo_Name = 13;
  var kMediaSession_ScrubTo_Name = 14;
  var kMediaSession_EnterPictureInPicture_Name = 15;
  var kMediaSession_ExitPictureInPicture_Name = 16;
  var kMediaSession_SetAudioSinkId_Name = 17;
  var kMediaSession_ToggleMicrophone_Name = 18;
  var kMediaSession_ToggleCamera_Name = 19;
  var kMediaSession_HangUp_Name = 20;
  var kMediaSession_Raise_Name = 21;
  var kMediaSession_SetMute_Name = 22;
  var kMediaSession_RequestMediaRemoting_Name = 23;
  var kMediaSession_PreviousSlide_Name = 24;
  var kMediaSession_NextSlide_Name = 25;
  var kMediaSession_EnterAutoPictureInPicture_Name = 26;
  var kMediaSession_GetVisibility_Name = 27;

  function MediaSessionPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(MediaSession,
                                                   handleOrPtrInfo);
  }

  function MediaSessionAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        MediaSession, associatedInterfacePtrInfo);
  }

  MediaSessionAssociatedPtr.prototype =
      Object.create(MediaSessionPtr.prototype);
  MediaSessionAssociatedPtr.prototype.constructor =
      MediaSessionAssociatedPtr;

  function MediaSessionProxy(receiver) {
    this.receiver_ = receiver;
  }
  MediaSessionPtr.prototype.getMediaSessionInfo = function() {
    return MediaSessionProxy.prototype.getMediaSessionInfo
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaSessionProxy.prototype.getMediaSessionInfo = function() {
    var params_ = new MediaSession_GetMediaSessionInfo_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kMediaSession_GetMediaSessionInfo_Name,
          codec.align(MediaSession_GetMediaSessionInfo_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(MediaSession_GetMediaSessionInfo_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(MediaSession_GetMediaSessionInfo_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  MediaSessionPtr.prototype.getDebugInfo = function() {
    return MediaSessionProxy.prototype.getDebugInfo
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaSessionProxy.prototype.getDebugInfo = function() {
    var params_ = new MediaSession_GetDebugInfo_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kMediaSession_GetDebugInfo_Name,
          codec.align(MediaSession_GetDebugInfo_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(MediaSession_GetDebugInfo_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(MediaSession_GetDebugInfo_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  MediaSessionPtr.prototype.startDucking = function() {
    return MediaSessionProxy.prototype.startDucking
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaSessionProxy.prototype.startDucking = function() {
    var params_ = new MediaSession_StartDucking_Params();
    var builder = new codec.MessageV0Builder(
        kMediaSession_StartDucking_Name,
        codec.align(MediaSession_StartDucking_Params.encodedSize));
    builder.encodeStruct(MediaSession_StartDucking_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaSessionPtr.prototype.stopDucking = function() {
    return MediaSessionProxy.prototype.stopDucking
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaSessionProxy.prototype.stopDucking = function() {
    var params_ = new MediaSession_StopDucking_Params();
    var builder = new codec.MessageV0Builder(
        kMediaSession_StopDucking_Name,
        codec.align(MediaSession_StopDucking_Params.encodedSize));
    builder.encodeStruct(MediaSession_StopDucking_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaSessionPtr.prototype.suspend = function() {
    return MediaSessionProxy.prototype.suspend
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaSessionProxy.prototype.suspend = function(suspendType) {
    var params_ = new MediaSession_Suspend_Params();
    params_.suspendType = suspendType;
    var builder = new codec.MessageV0Builder(
        kMediaSession_Suspend_Name,
        codec.align(MediaSession_Suspend_Params.encodedSize));
    builder.encodeStruct(MediaSession_Suspend_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaSessionPtr.prototype.resume = function() {
    return MediaSessionProxy.prototype.resume
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaSessionProxy.prototype.resume = function(suspendType) {
    var params_ = new MediaSession_Resume_Params();
    params_.suspendType = suspendType;
    var builder = new codec.MessageV0Builder(
        kMediaSession_Resume_Name,
        codec.align(MediaSession_Resume_Params.encodedSize));
    builder.encodeStruct(MediaSession_Resume_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaSessionPtr.prototype.addObserver = function() {
    return MediaSessionProxy.prototype.addObserver
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaSessionProxy.prototype.addObserver = function(observer) {
    var params_ = new MediaSession_AddObserver_Params();
    params_.observer = observer;
    var builder = new codec.MessageV0Builder(
        kMediaSession_AddObserver_Name,
        codec.align(MediaSession_AddObserver_Params.encodedSize));
    builder.encodeStruct(MediaSession_AddObserver_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaSessionPtr.prototype.previousTrack = function() {
    return MediaSessionProxy.prototype.previousTrack
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaSessionProxy.prototype.previousTrack = function() {
    var params_ = new MediaSession_PreviousTrack_Params();
    var builder = new codec.MessageV0Builder(
        kMediaSession_PreviousTrack_Name,
        codec.align(MediaSession_PreviousTrack_Params.encodedSize));
    builder.encodeStruct(MediaSession_PreviousTrack_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaSessionPtr.prototype.nextTrack = function() {
    return MediaSessionProxy.prototype.nextTrack
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaSessionProxy.prototype.nextTrack = function() {
    var params_ = new MediaSession_NextTrack_Params();
    var builder = new codec.MessageV0Builder(
        kMediaSession_NextTrack_Name,
        codec.align(MediaSession_NextTrack_Params.encodedSize));
    builder.encodeStruct(MediaSession_NextTrack_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaSessionPtr.prototype.seek = function() {
    return MediaSessionProxy.prototype.seek
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaSessionProxy.prototype.seek = function(seekTime) {
    var params_ = new MediaSession_Seek_Params();
    params_.seekTime = seekTime;
    var builder = new codec.MessageV0Builder(
        kMediaSession_Seek_Name,
        codec.align(MediaSession_Seek_Params.encodedSize));
    builder.encodeStruct(MediaSession_Seek_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaSessionPtr.prototype.stop = function() {
    return MediaSessionProxy.prototype.stop
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaSessionProxy.prototype.stop = function(suspendType) {
    var params_ = new MediaSession_Stop_Params();
    params_.suspendType = suspendType;
    var builder = new codec.MessageV0Builder(
        kMediaSession_Stop_Name,
        codec.align(MediaSession_Stop_Params.encodedSize));
    builder.encodeStruct(MediaSession_Stop_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaSessionPtr.prototype.skipAd = function() {
    return MediaSessionProxy.prototype.skipAd
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaSessionProxy.prototype.skipAd = function() {
    var params_ = new MediaSession_SkipAd_Params();
    var builder = new codec.MessageV0Builder(
        kMediaSession_SkipAd_Name,
        codec.align(MediaSession_SkipAd_Params.encodedSize));
    builder.encodeStruct(MediaSession_SkipAd_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaSessionPtr.prototype.getMediaImageBitmap = function() {
    return MediaSessionProxy.prototype.getMediaImageBitmap
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaSessionProxy.prototype.getMediaImageBitmap = function(image, minimumSizePx, desiredSizePx) {
    var params_ = new MediaSession_GetMediaImageBitmap_Params();
    params_.image = image;
    params_.minimumSizePx = minimumSizePx;
    params_.desiredSizePx = desiredSizePx;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kMediaSession_GetMediaImageBitmap_Name,
          codec.align(MediaSession_GetMediaImageBitmap_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(MediaSession_GetMediaImageBitmap_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(MediaSession_GetMediaImageBitmap_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  MediaSessionPtr.prototype.seekTo = function() {
    return MediaSessionProxy.prototype.seekTo
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaSessionProxy.prototype.seekTo = function(seekTime) {
    var params_ = new MediaSession_SeekTo_Params();
    params_.seekTime = seekTime;
    var builder = new codec.MessageV0Builder(
        kMediaSession_SeekTo_Name,
        codec.align(MediaSession_SeekTo_Params.encodedSize));
    builder.encodeStruct(MediaSession_SeekTo_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaSessionPtr.prototype.scrubTo = function() {
    return MediaSessionProxy.prototype.scrubTo
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaSessionProxy.prototype.scrubTo = function(seekTime) {
    var params_ = new MediaSession_ScrubTo_Params();
    params_.seekTime = seekTime;
    var builder = new codec.MessageV0Builder(
        kMediaSession_ScrubTo_Name,
        codec.align(MediaSession_ScrubTo_Params.encodedSize));
    builder.encodeStruct(MediaSession_ScrubTo_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaSessionPtr.prototype.enterPictureInPicture = function() {
    return MediaSessionProxy.prototype.enterPictureInPicture
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaSessionProxy.prototype.enterPictureInPicture = function() {
    var params_ = new MediaSession_EnterPictureInPicture_Params();
    var builder = new codec.MessageV0Builder(
        kMediaSession_EnterPictureInPicture_Name,
        codec.align(MediaSession_EnterPictureInPicture_Params.encodedSize));
    builder.encodeStruct(MediaSession_EnterPictureInPicture_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaSessionPtr.prototype.exitPictureInPicture = function() {
    return MediaSessionProxy.prototype.exitPictureInPicture
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaSessionProxy.prototype.exitPictureInPicture = function() {
    var params_ = new MediaSession_ExitPictureInPicture_Params();
    var builder = new codec.MessageV0Builder(
        kMediaSession_ExitPictureInPicture_Name,
        codec.align(MediaSession_ExitPictureInPicture_Params.encodedSize));
    builder.encodeStruct(MediaSession_ExitPictureInPicture_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaSessionPtr.prototype.setAudioSinkId = function() {
    return MediaSessionProxy.prototype.setAudioSinkId
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaSessionProxy.prototype.setAudioSinkId = function(id) {
    var params_ = new MediaSession_SetAudioSinkId_Params();
    params_.id = id;
    var builder = new codec.MessageV0Builder(
        kMediaSession_SetAudioSinkId_Name,
        codec.align(MediaSession_SetAudioSinkId_Params.encodedSize));
    builder.encodeStruct(MediaSession_SetAudioSinkId_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaSessionPtr.prototype.toggleMicrophone = function() {
    return MediaSessionProxy.prototype.toggleMicrophone
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaSessionProxy.prototype.toggleMicrophone = function() {
    var params_ = new MediaSession_ToggleMicrophone_Params();
    var builder = new codec.MessageV0Builder(
        kMediaSession_ToggleMicrophone_Name,
        codec.align(MediaSession_ToggleMicrophone_Params.encodedSize));
    builder.encodeStruct(MediaSession_ToggleMicrophone_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaSessionPtr.prototype.toggleCamera = function() {
    return MediaSessionProxy.prototype.toggleCamera
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaSessionProxy.prototype.toggleCamera = function() {
    var params_ = new MediaSession_ToggleCamera_Params();
    var builder = new codec.MessageV0Builder(
        kMediaSession_ToggleCamera_Name,
        codec.align(MediaSession_ToggleCamera_Params.encodedSize));
    builder.encodeStruct(MediaSession_ToggleCamera_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaSessionPtr.prototype.hangUp = function() {
    return MediaSessionProxy.prototype.hangUp
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaSessionProxy.prototype.hangUp = function() {
    var params_ = new MediaSession_HangUp_Params();
    var builder = new codec.MessageV0Builder(
        kMediaSession_HangUp_Name,
        codec.align(MediaSession_HangUp_Params.encodedSize));
    builder.encodeStruct(MediaSession_HangUp_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaSessionPtr.prototype.raise = function() {
    return MediaSessionProxy.prototype.raise
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaSessionProxy.prototype.raise = function() {
    var params_ = new MediaSession_Raise_Params();
    var builder = new codec.MessageV0Builder(
        kMediaSession_Raise_Name,
        codec.align(MediaSession_Raise_Params.encodedSize));
    builder.encodeStruct(MediaSession_Raise_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaSessionPtr.prototype.setMute = function() {
    return MediaSessionProxy.prototype.setMute
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaSessionProxy.prototype.setMute = function(mute) {
    var params_ = new MediaSession_SetMute_Params();
    params_.mute = mute;
    var builder = new codec.MessageV0Builder(
        kMediaSession_SetMute_Name,
        codec.align(MediaSession_SetMute_Params.encodedSize));
    builder.encodeStruct(MediaSession_SetMute_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaSessionPtr.prototype.requestMediaRemoting = function() {
    return MediaSessionProxy.prototype.requestMediaRemoting
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaSessionProxy.prototype.requestMediaRemoting = function() {
    var params_ = new MediaSession_RequestMediaRemoting_Params();
    var builder = new codec.MessageV0Builder(
        kMediaSession_RequestMediaRemoting_Name,
        codec.align(MediaSession_RequestMediaRemoting_Params.encodedSize));
    builder.encodeStruct(MediaSession_RequestMediaRemoting_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaSessionPtr.prototype.previousSlide = function() {
    return MediaSessionProxy.prototype.previousSlide
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaSessionProxy.prototype.previousSlide = function() {
    var params_ = new MediaSession_PreviousSlide_Params();
    var builder = new codec.MessageV0Builder(
        kMediaSession_PreviousSlide_Name,
        codec.align(MediaSession_PreviousSlide_Params.encodedSize));
    builder.encodeStruct(MediaSession_PreviousSlide_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaSessionPtr.prototype.nextSlide = function() {
    return MediaSessionProxy.prototype.nextSlide
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaSessionProxy.prototype.nextSlide = function() {
    var params_ = new MediaSession_NextSlide_Params();
    var builder = new codec.MessageV0Builder(
        kMediaSession_NextSlide_Name,
        codec.align(MediaSession_NextSlide_Params.encodedSize));
    builder.encodeStruct(MediaSession_NextSlide_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaSessionPtr.prototype.enterAutoPictureInPicture = function() {
    return MediaSessionProxy.prototype.enterAutoPictureInPicture
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaSessionProxy.prototype.enterAutoPictureInPicture = function() {
    var params_ = new MediaSession_EnterAutoPictureInPicture_Params();
    var builder = new codec.MessageV0Builder(
        kMediaSession_EnterAutoPictureInPicture_Name,
        codec.align(MediaSession_EnterAutoPictureInPicture_Params.encodedSize));
    builder.encodeStruct(MediaSession_EnterAutoPictureInPicture_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  MediaSessionPtr.prototype.getVisibility = function() {
    return MediaSessionProxy.prototype.getVisibility
        .apply(this.ptr.getProxy(), arguments);
  };

  MediaSessionProxy.prototype.getVisibility = function() {
    var params_ = new MediaSession_GetVisibility_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kMediaSession_GetVisibility_Name,
          codec.align(MediaSession_GetVisibility_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(MediaSession_GetVisibility_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(MediaSession_GetVisibility_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function MediaSessionStub(delegate) {
    this.delegate_ = delegate;
  }
  MediaSessionStub.prototype.getMediaSessionInfo = function() {
    return this.delegate_ && this.delegate_.getMediaSessionInfo && this.delegate_.getMediaSessionInfo();
  }
  MediaSessionStub.prototype.getDebugInfo = function() {
    return this.delegate_ && this.delegate_.getDebugInfo && this.delegate_.getDebugInfo();
  }
  MediaSessionStub.prototype.startDucking = function() {
    return this.delegate_ && this.delegate_.startDucking && this.delegate_.startDucking();
  }
  MediaSessionStub.prototype.stopDucking = function() {
    return this.delegate_ && this.delegate_.stopDucking && this.delegate_.stopDucking();
  }
  MediaSessionStub.prototype.suspend = function(suspendType) {
    return this.delegate_ && this.delegate_.suspend && this.delegate_.suspend(suspendType);
  }
  MediaSessionStub.prototype.resume = function(suspendType) {
    return this.delegate_ && this.delegate_.resume && this.delegate_.resume(suspendType);
  }
  MediaSessionStub.prototype.addObserver = function(observer) {
    return this.delegate_ && this.delegate_.addObserver && this.delegate_.addObserver(observer);
  }
  MediaSessionStub.prototype.previousTrack = function() {
    return this.delegate_ && this.delegate_.previousTrack && this.delegate_.previousTrack();
  }
  MediaSessionStub.prototype.nextTrack = function() {
    return this.delegate_ && this.delegate_.nextTrack && this.delegate_.nextTrack();
  }
  MediaSessionStub.prototype.seek = function(seekTime) {
    return this.delegate_ && this.delegate_.seek && this.delegate_.seek(seekTime);
  }
  MediaSessionStub.prototype.stop = function(suspendType) {
    return this.delegate_ && this.delegate_.stop && this.delegate_.stop(suspendType);
  }
  MediaSessionStub.prototype.skipAd = function() {
    return this.delegate_ && this.delegate_.skipAd && this.delegate_.skipAd();
  }
  MediaSessionStub.prototype.getMediaImageBitmap = function(image, minimumSizePx, desiredSizePx) {
    return this.delegate_ && this.delegate_.getMediaImageBitmap && this.delegate_.getMediaImageBitmap(image, minimumSizePx, desiredSizePx);
  }
  MediaSessionStub.prototype.seekTo = function(seekTime) {
    return this.delegate_ && this.delegate_.seekTo && this.delegate_.seekTo(seekTime);
  }
  MediaSessionStub.prototype.scrubTo = function(seekTime) {
    return this.delegate_ && this.delegate_.scrubTo && this.delegate_.scrubTo(seekTime);
  }
  MediaSessionStub.prototype.enterPictureInPicture = function() {
    return this.delegate_ && this.delegate_.enterPictureInPicture && this.delegate_.enterPictureInPicture();
  }
  MediaSessionStub.prototype.exitPictureInPicture = function() {
    return this.delegate_ && this.delegate_.exitPictureInPicture && this.delegate_.exitPictureInPicture();
  }
  MediaSessionStub.prototype.setAudioSinkId = function(id) {
    return this.delegate_ && this.delegate_.setAudioSinkId && this.delegate_.setAudioSinkId(id);
  }
  MediaSessionStub.prototype.toggleMicrophone = function() {
    return this.delegate_ && this.delegate_.toggleMicrophone && this.delegate_.toggleMicrophone();
  }
  MediaSessionStub.prototype.toggleCamera = function() {
    return this.delegate_ && this.delegate_.toggleCamera && this.delegate_.toggleCamera();
  }
  MediaSessionStub.prototype.hangUp = function() {
    return this.delegate_ && this.delegate_.hangUp && this.delegate_.hangUp();
  }
  MediaSessionStub.prototype.raise = function() {
    return this.delegate_ && this.delegate_.raise && this.delegate_.raise();
  }
  MediaSessionStub.prototype.setMute = function(mute) {
    return this.delegate_ && this.delegate_.setMute && this.delegate_.setMute(mute);
  }
  MediaSessionStub.prototype.requestMediaRemoting = function() {
    return this.delegate_ && this.delegate_.requestMediaRemoting && this.delegate_.requestMediaRemoting();
  }
  MediaSessionStub.prototype.previousSlide = function() {
    return this.delegate_ && this.delegate_.previousSlide && this.delegate_.previousSlide();
  }
  MediaSessionStub.prototype.nextSlide = function() {
    return this.delegate_ && this.delegate_.nextSlide && this.delegate_.nextSlide();
  }
  MediaSessionStub.prototype.enterAutoPictureInPicture = function() {
    return this.delegate_ && this.delegate_.enterAutoPictureInPicture && this.delegate_.enterAutoPictureInPicture();
  }
  MediaSessionStub.prototype.getVisibility = function() {
    return this.delegate_ && this.delegate_.getVisibility && this.delegate_.getVisibility();
  }

  MediaSessionStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kMediaSession_StartDucking_Name:
      var params = reader.decodeStruct(MediaSession_StartDucking_Params);
      this.startDucking();
      return true;
    case kMediaSession_StopDucking_Name:
      var params = reader.decodeStruct(MediaSession_StopDucking_Params);
      this.stopDucking();
      return true;
    case kMediaSession_Suspend_Name:
      var params = reader.decodeStruct(MediaSession_Suspend_Params);
      this.suspend(params.suspendType);
      return true;
    case kMediaSession_Resume_Name:
      var params = reader.decodeStruct(MediaSession_Resume_Params);
      this.resume(params.suspendType);
      return true;
    case kMediaSession_AddObserver_Name:
      var params = reader.decodeStruct(MediaSession_AddObserver_Params);
      this.addObserver(params.observer);
      return true;
    case kMediaSession_PreviousTrack_Name:
      var params = reader.decodeStruct(MediaSession_PreviousTrack_Params);
      this.previousTrack();
      return true;
    case kMediaSession_NextTrack_Name:
      var params = reader.decodeStruct(MediaSession_NextTrack_Params);
      this.nextTrack();
      return true;
    case kMediaSession_Seek_Name:
      var params = reader.decodeStruct(MediaSession_Seek_Params);
      this.seek(params.seekTime);
      return true;
    case kMediaSession_Stop_Name:
      var params = reader.decodeStruct(MediaSession_Stop_Params);
      this.stop(params.suspendType);
      return true;
    case kMediaSession_SkipAd_Name:
      var params = reader.decodeStruct(MediaSession_SkipAd_Params);
      this.skipAd();
      return true;
    case kMediaSession_SeekTo_Name:
      var params = reader.decodeStruct(MediaSession_SeekTo_Params);
      this.seekTo(params.seekTime);
      return true;
    case kMediaSession_ScrubTo_Name:
      var params = reader.decodeStruct(MediaSession_ScrubTo_Params);
      this.scrubTo(params.seekTime);
      return true;
    case kMediaSession_EnterPictureInPicture_Name:
      var params = reader.decodeStruct(MediaSession_EnterPictureInPicture_Params);
      this.enterPictureInPicture();
      return true;
    case kMediaSession_ExitPictureInPicture_Name:
      var params = reader.decodeStruct(MediaSession_ExitPictureInPicture_Params);
      this.exitPictureInPicture();
      return true;
    case kMediaSession_SetAudioSinkId_Name:
      var params = reader.decodeStruct(MediaSession_SetAudioSinkId_Params);
      this.setAudioSinkId(params.id);
      return true;
    case kMediaSession_ToggleMicrophone_Name:
      var params = reader.decodeStruct(MediaSession_ToggleMicrophone_Params);
      this.toggleMicrophone();
      return true;
    case kMediaSession_ToggleCamera_Name:
      var params = reader.decodeStruct(MediaSession_ToggleCamera_Params);
      this.toggleCamera();
      return true;
    case kMediaSession_HangUp_Name:
      var params = reader.decodeStruct(MediaSession_HangUp_Params);
      this.hangUp();
      return true;
    case kMediaSession_Raise_Name:
      var params = reader.decodeStruct(MediaSession_Raise_Params);
      this.raise();
      return true;
    case kMediaSession_SetMute_Name:
      var params = reader.decodeStruct(MediaSession_SetMute_Params);
      this.setMute(params.mute);
      return true;
    case kMediaSession_RequestMediaRemoting_Name:
      var params = reader.decodeStruct(MediaSession_RequestMediaRemoting_Params);
      this.requestMediaRemoting();
      return true;
    case kMediaSession_PreviousSlide_Name:
      var params = reader.decodeStruct(MediaSession_PreviousSlide_Params);
      this.previousSlide();
      return true;
    case kMediaSession_NextSlide_Name:
      var params = reader.decodeStruct(MediaSession_NextSlide_Params);
      this.nextSlide();
      return true;
    case kMediaSession_EnterAutoPictureInPicture_Name:
      var params = reader.decodeStruct(MediaSession_EnterAutoPictureInPicture_Params);
      this.enterAutoPictureInPicture();
      return true;
    default:
      return false;
    }
  };

  MediaSessionStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kMediaSession_GetMediaSessionInfo_Name:
      var params = reader.decodeStruct(MediaSession_GetMediaSessionInfo_Params);
      this.getMediaSessionInfo().then(function(response) {
        var responseParams =
            new MediaSession_GetMediaSessionInfo_ResponseParams();
        responseParams.info = response.info;
        var builder = new codec.MessageV1Builder(
            kMediaSession_GetMediaSessionInfo_Name,
            codec.align(MediaSession_GetMediaSessionInfo_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(MediaSession_GetMediaSessionInfo_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kMediaSession_GetDebugInfo_Name:
      var params = reader.decodeStruct(MediaSession_GetDebugInfo_Params);
      this.getDebugInfo().then(function(response) {
        var responseParams =
            new MediaSession_GetDebugInfo_ResponseParams();
        responseParams.info = response.info;
        var builder = new codec.MessageV1Builder(
            kMediaSession_GetDebugInfo_Name,
            codec.align(MediaSession_GetDebugInfo_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(MediaSession_GetDebugInfo_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kMediaSession_GetMediaImageBitmap_Name:
      var params = reader.decodeStruct(MediaSession_GetMediaImageBitmap_Params);
      this.getMediaImageBitmap(params.image, params.minimumSizePx, params.desiredSizePx).then(function(response) {
        var responseParams =
            new MediaSession_GetMediaImageBitmap_ResponseParams();
        responseParams.image = response.image;
        var builder = new codec.MessageV1Builder(
            kMediaSession_GetMediaImageBitmap_Name,
            codec.align(MediaSession_GetMediaImageBitmap_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(MediaSession_GetMediaImageBitmap_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kMediaSession_GetVisibility_Name:
      var params = reader.decodeStruct(MediaSession_GetVisibility_Params);
      this.getVisibility().then(function(response) {
        var responseParams =
            new MediaSession_GetVisibility_ResponseParams();
        responseParams.hasSufficientlyVisibleVideo = response.hasSufficientlyVisibleVideo;
        var builder = new codec.MessageV1Builder(
            kMediaSession_GetVisibility_Name,
            codec.align(MediaSession_GetVisibility_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(MediaSession_GetVisibility_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateMediaSessionRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kMediaSession_GetMediaSessionInfo_Name:
        if (message.expectsResponse())
          paramsClass = MediaSession_GetMediaSessionInfo_Params;
      break;
      case kMediaSession_GetDebugInfo_Name:
        if (message.expectsResponse())
          paramsClass = MediaSession_GetDebugInfo_Params;
      break;
      case kMediaSession_StartDucking_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaSession_StartDucking_Params;
      break;
      case kMediaSession_StopDucking_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaSession_StopDucking_Params;
      break;
      case kMediaSession_Suspend_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaSession_Suspend_Params;
      break;
      case kMediaSession_Resume_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaSession_Resume_Params;
      break;
      case kMediaSession_AddObserver_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaSession_AddObserver_Params;
      break;
      case kMediaSession_PreviousTrack_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaSession_PreviousTrack_Params;
      break;
      case kMediaSession_NextTrack_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaSession_NextTrack_Params;
      break;
      case kMediaSession_Seek_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaSession_Seek_Params;
      break;
      case kMediaSession_Stop_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaSession_Stop_Params;
      break;
      case kMediaSession_SkipAd_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaSession_SkipAd_Params;
      break;
      case kMediaSession_GetMediaImageBitmap_Name:
        if (message.expectsResponse())
          paramsClass = MediaSession_GetMediaImageBitmap_Params;
      break;
      case kMediaSession_SeekTo_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaSession_SeekTo_Params;
      break;
      case kMediaSession_ScrubTo_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaSession_ScrubTo_Params;
      break;
      case kMediaSession_EnterPictureInPicture_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaSession_EnterPictureInPicture_Params;
      break;
      case kMediaSession_ExitPictureInPicture_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaSession_ExitPictureInPicture_Params;
      break;
      case kMediaSession_SetAudioSinkId_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaSession_SetAudioSinkId_Params;
      break;
      case kMediaSession_ToggleMicrophone_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaSession_ToggleMicrophone_Params;
      break;
      case kMediaSession_ToggleCamera_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaSession_ToggleCamera_Params;
      break;
      case kMediaSession_HangUp_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaSession_HangUp_Params;
      break;
      case kMediaSession_Raise_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaSession_Raise_Params;
      break;
      case kMediaSession_SetMute_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaSession_SetMute_Params;
      break;
      case kMediaSession_RequestMediaRemoting_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaSession_RequestMediaRemoting_Params;
      break;
      case kMediaSession_PreviousSlide_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaSession_PreviousSlide_Params;
      break;
      case kMediaSession_NextSlide_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaSession_NextSlide_Params;
      break;
      case kMediaSession_EnterAutoPictureInPicture_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = MediaSession_EnterAutoPictureInPicture_Params;
      break;
      case kMediaSession_GetVisibility_Name:
        if (message.expectsResponse())
          paramsClass = MediaSession_GetVisibility_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateMediaSessionResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kMediaSession_GetMediaSessionInfo_Name:
        if (message.isResponse())
          paramsClass = MediaSession_GetMediaSessionInfo_ResponseParams;
        break;
      case kMediaSession_GetDebugInfo_Name:
        if (message.isResponse())
          paramsClass = MediaSession_GetDebugInfo_ResponseParams;
        break;
      case kMediaSession_GetMediaImageBitmap_Name:
        if (message.isResponse())
          paramsClass = MediaSession_GetMediaImageBitmap_ResponseParams;
        break;
      case kMediaSession_GetVisibility_Name:
        if (message.isResponse())
          paramsClass = MediaSession_GetVisibility_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var MediaSession = {
    name: 'media_session.mojom.MediaSession',
    kVersion: 23,
    ptrClass: MediaSessionPtr,
    proxyClass: MediaSessionProxy,
    stubClass: MediaSessionStub,
    validateRequest: validateMediaSessionRequest,
    validateResponse: validateMediaSessionResponse,
  };
  MediaSession.SuspendType = {};
  MediaSession.SuspendType.kSystem = 0;
  MediaSession.SuspendType.kUI = 1;
  MediaSession.SuspendType.kContent = 2;
  MediaSession.SuspendType.MIN_VALUE = 0;
  MediaSession.SuspendType.MAX_VALUE = 2;

  MediaSession.SuspendType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  MediaSession.SuspendType.toKnownEnumValue = function(value) {
    return value;
  };

  MediaSession.SuspendType.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  MediaSessionStub.prototype.validator = validateMediaSessionRequest;
  MediaSessionProxy.prototype.validator = validateMediaSessionResponse;
  exports.MediaPlaybackState = MediaPlaybackState;
  exports.MediaSessionAction = MediaSessionAction;
  exports.MediaSessionImageType = MediaSessionImageType;
  exports.MediaPictureInPictureState = MediaPictureInPictureState;
  exports.MediaAudioVideoState = MediaAudioVideoState;
  exports.MediaImageBitmapColorType = MediaImageBitmapColorType;
  exports.MicrophoneState = MicrophoneState;
  exports.CameraState = CameraState;
  exports.MediaImage = MediaImage;
  exports.ChapterInformation = ChapterInformation;
  exports.MediaMetadata = MediaMetadata;
  exports.MediaImageBitmap = MediaImageBitmap;
  exports.MediaPosition = MediaPosition;
  exports.RemotePlaybackMetadata = RemotePlaybackMetadata;
  exports.MediaSessionInfo = MediaSessionInfo;
  exports.MediaSessionDebugInfo = MediaSessionDebugInfo;
  exports.MediaSessionObserver = MediaSessionObserver;
  exports.MediaSessionObserverPtr = MediaSessionObserverPtr;
  exports.MediaSessionObserverAssociatedPtr = MediaSessionObserverAssociatedPtr;
  exports.MediaSession = MediaSession;
  exports.MediaSessionPtr = MediaSessionPtr;
  exports.MediaSessionAssociatedPtr = MediaSessionAssociatedPtr;
})();