// services/media_session/public/mojom/media_session.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_MEDIA_SESSION_PUBLIC_MOJOM_MEDIA_SESSION_MOJOM_SEND_VALIDATION_H_
#define SERVICES_MEDIA_SESSION_PUBLIC_MOJOM_MEDIA_SESSION_MOJOM_SEND_VALIDATION_H_

#include "services/media_session/public/mojom/media_session.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"

#include "services/media_session/public/mojom/media_session.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::media_session::mojom::MediaPlaybackState, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::media_session::mojom::MediaSessionAction, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::media_session::mojom::MediaSessionImageType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::media_session::mojom::MediaPictureInPictureState, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::media_session::mojom::MediaAudioVideoState, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::media_session::mojom::MediaImageBitmapColorType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::media_session::mojom::MicrophoneState, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::media_session::mojom::CameraState, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media_session::mojom::MediaImageDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media_session::mojom::MediaImageDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media_session::mojom::internal::MediaImage_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::src(input)) in_src = Traits::src(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->src)::BaseType> src_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_src,
        src_fragment);

      fragment->src.Set(
          src_fragment.is_null() ? nullptr : src_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->src.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null src in MediaImage struct");

      decltype(Traits::type(input)) in_type = Traits::type(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->type)::BaseType> type_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_type,
        type_fragment);

      fragment->type.Set(
          type_fragment.is_null() ? nullptr : type_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->type.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null type in MediaImage struct");

      decltype(Traits::sizes(input)) in_sizes = Traits::sizes(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->sizes)::BaseType>
          sizes_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& sizes_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::gfx::mojom::SizeDataView>, send_validation>(
        in_sizes,
        sizes_fragment,
        &sizes_validate_params);

      fragment->sizes.Set(
          sizes_fragment.is_null() ? nullptr : sizes_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->sizes.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null sizes in MediaImage struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media_session::mojom::ChapterInformationDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media_session::mojom::ChapterInformationDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media_session::mojom::internal::ChapterInformation_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::title(input)) in_title = Traits::title(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->title)::BaseType> title_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_title,
        title_fragment);

      fragment->title.Set(
          title_fragment.is_null() ? nullptr : title_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->title.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null title in ChapterInformation struct");

      decltype(Traits::startTime(input)) in_startTime = Traits::startTime(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->startTime)::BaseType> startTime_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_startTime,
        startTime_fragment);

      fragment->startTime.Set(
          startTime_fragment.is_null() ? nullptr : startTime_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->startTime.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null startTime in ChapterInformation struct");

      decltype(Traits::artwork(input)) in_artwork = Traits::artwork(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->artwork)::BaseType>
          artwork_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& artwork_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::media_session::mojom::MediaImageDataView>, send_validation>(
        in_artwork,
        artwork_fragment,
        &artwork_validate_params);

      fragment->artwork.Set(
          artwork_fragment.is_null() ? nullptr : artwork_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->artwork.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null artwork in ChapterInformation struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media_session::mojom::MediaMetadataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media_session::mojom::MediaMetadataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media_session::mojom::internal::MediaMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::title(input)) in_title = Traits::title(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->title)::BaseType> title_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_title,
        title_fragment);

      fragment->title.Set(
          title_fragment.is_null() ? nullptr : title_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->title.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null title in MediaMetadata struct");

      decltype(Traits::artist(input)) in_artist = Traits::artist(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->artist)::BaseType> artist_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_artist,
        artist_fragment);

      fragment->artist.Set(
          artist_fragment.is_null() ? nullptr : artist_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->artist.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null artist in MediaMetadata struct");

      decltype(Traits::album(input)) in_album = Traits::album(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->album)::BaseType> album_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_album,
        album_fragment);

      fragment->album.Set(
          album_fragment.is_null() ? nullptr : album_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->album.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null album in MediaMetadata struct");

      decltype(Traits::source_title(input)) in_source_title = Traits::source_title(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->source_title)::BaseType> source_title_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::String16DataView, send_validation>(
        in_source_title,
        source_title_fragment);

      fragment->source_title.Set(
          source_title_fragment.is_null() ? nullptr : source_title_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->source_title.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null source_title in MediaMetadata struct");

      decltype(Traits::chapters(input)) in_chapters = Traits::chapters(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->chapters)::BaseType>
          chapters_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& chapters_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::media_session::mojom::ChapterInformationDataView>, send_validation>(
        in_chapters,
        chapters_fragment,
        &chapters_validate_params);

      fragment->chapters.Set(
          chapters_fragment.is_null() ? nullptr : chapters_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media_session::mojom::MediaImageBitmapDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media_session::mojom::MediaImageBitmapDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media_session::mojom::internal::MediaImageBitmap_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->width = Traits::width(input);

      fragment->height = Traits::height(input);

      decltype(Traits::pixel_data(input)) in_pixel_data = Traits::pixel_data(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->pixel_data)::BaseType>
          pixel_data_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& pixel_data_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>, send_validation>(
        in_pixel_data,
        pixel_data_fragment,
        &pixel_data_validate_params);

      fragment->pixel_data.Set(
          pixel_data_fragment.is_null() ? nullptr : pixel_data_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->pixel_data.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null pixel_data in MediaImageBitmap struct");

      
      mojo::internal::Serialize<::media_session::mojom::MediaImageBitmapColorType>(
        Traits::color_type(input),
        &fragment->color_type);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media_session::mojom::MediaPositionDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media_session::mojom::MediaPositionDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media_session::mojom::internal::MediaPosition_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->playback_rate = Traits::playback_rate(input);

      decltype(Traits::duration(input)) in_duration = Traits::duration(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->duration)::BaseType> duration_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_duration,
        duration_fragment);

      fragment->duration.Set(
          duration_fragment.is_null() ? nullptr : duration_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->duration.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null duration in MediaPosition struct");

      decltype(Traits::position(input)) in_position = Traits::position(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->position)::BaseType> position_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView, send_validation>(
        in_position,
        position_fragment);

      fragment->position.Set(
          position_fragment.is_null() ? nullptr : position_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->position.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null position in MediaPosition struct");

      decltype(Traits::last_updated_time(input)) in_last_updated_time = Traits::last_updated_time(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->last_updated_time)::BaseType> last_updated_time_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView, send_validation>(
        in_last_updated_time,
        last_updated_time_fragment);

      fragment->last_updated_time.Set(
          last_updated_time_fragment.is_null() ? nullptr : last_updated_time_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->last_updated_time.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null last_updated_time in MediaPosition struct");

      fragment->end_of_media = Traits::end_of_media(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media_session::mojom::RemotePlaybackMetadataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media_session::mojom::RemotePlaybackMetadataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media_session::mojom::internal::RemotePlaybackMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::video_codec(input)) in_video_codec = Traits::video_codec(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->video_codec)::BaseType> video_codec_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_video_codec,
        video_codec_fragment);

      fragment->video_codec.Set(
          video_codec_fragment.is_null() ? nullptr : video_codec_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->video_codec.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null video_codec in RemotePlaybackMetadata struct");

      decltype(Traits::audio_codec(input)) in_audio_codec = Traits::audio_codec(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->audio_codec)::BaseType> audio_codec_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_audio_codec,
        audio_codec_fragment);

      fragment->audio_codec.Set(
          audio_codec_fragment.is_null() ? nullptr : audio_codec_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->audio_codec.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null audio_codec in RemotePlaybackMetadata struct");

      fragment->remote_playback_disabled = Traits::remote_playback_disabled(input);

      fragment->remote_playback_started = Traits::remote_playback_started(input);

      decltype(Traits::unused_field(input)) in_unused_field = Traits::unused_field(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->unused_field)::BaseType> unused_field_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_unused_field,
        unused_field_fragment);

      fragment->unused_field.Set(
          unused_field_fragment.is_null() ? nullptr : unused_field_fragment.data());

      fragment->is_encrypted_media = Traits::is_encrypted_media(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media_session::mojom::MediaSessionInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media_session::mojom::MediaSessionInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media_session::mojom::internal::MediaSessionInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::media_session::mojom::MediaSessionInfo_SessionState>(
        Traits::state(input),
        &fragment->state);

      fragment->force_duck = Traits::force_duck(input);

      
      mojo::internal::Serialize<::media_session::mojom::MediaPlaybackState>(
        Traits::playback_state(input),
        &fragment->playback_state);

      fragment->is_controllable = Traits::is_controllable(input);

      fragment->prefer_stop_for_gain_focus_loss = Traits::prefer_stop_for_gain_focus_loss(input);

      fragment->deprecated_is_sensitive = Traits::deprecated_is_sensitive(input);

      
      mojo::internal::Serialize<::media_session::mojom::MediaPictureInPictureState>(
        Traits::picture_in_picture_state(input),
        &fragment->picture_in_picture_state);

      
      mojo::internal::Serialize<::media_session::mojom::MediaAudioVideoState>(
        Traits::deprecated_audio_video_state(input),
        &fragment->deprecated_audio_video_state);

      decltype(Traits::audio_sink_id(input)) in_audio_sink_id = Traits::audio_sink_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->audio_sink_id)::BaseType> audio_sink_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_audio_sink_id,
        audio_sink_id_fragment);

      fragment->audio_sink_id.Set(
          audio_sink_id_fragment.is_null() ? nullptr : audio_sink_id_fragment.data());

      decltype(Traits::audio_video_states(input)) in_audio_video_states = Traits::audio_video_states(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->audio_video_states)::BaseType>
          audio_video_states_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& audio_video_states_validate_params =
          mojo::internal::GetArrayOfEnumsValidator<0, false, ::media_session::mojom::internal::MediaAudioVideoState_Data::Validate>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::media_session::mojom::MediaAudioVideoState>, send_validation>(
        in_audio_video_states,
        audio_video_states_fragment,
        &audio_video_states_validate_params);

      fragment->audio_video_states.Set(
          audio_video_states_fragment.is_null() ? nullptr : audio_video_states_fragment.data());

      
      mojo::internal::Serialize<::media_session::mojom::MicrophoneState>(
        Traits::microphone_state(input),
        &fragment->microphone_state);

      
      mojo::internal::Serialize<::media_session::mojom::CameraState>(
        Traits::camera_state(input),
        &fragment->camera_state);

      fragment->muted = Traits::muted(input);

      fragment->has_presentation = Traits::has_presentation(input);

      decltype(Traits::remote_playback_metadata(input)) in_remote_playback_metadata = Traits::remote_playback_metadata(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->remote_playback_metadata)::BaseType> remote_playback_metadata_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::media_session::mojom::RemotePlaybackMetadataDataView, send_validation>(
        in_remote_playback_metadata,
        remote_playback_metadata_fragment);

      fragment->remote_playback_metadata.Set(
          remote_playback_metadata_fragment.is_null() ? nullptr : remote_playback_metadata_fragment.data());

      fragment->hide_metadata = Traits::hide_metadata(input);

      fragment->ignore_for_active_session = Traits::ignore_for_active_session(input);

      fragment->meets_visibility_threshold = Traits::meets_visibility_threshold(input);

      fragment->can_enter_browser_initiated_autopip = Traits::can_enter_browser_initiated_autopip(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media_session::mojom::MediaSessionDebugInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media_session::mojom::MediaSessionDebugInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media_session::mojom::internal::MediaSessionDebugInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::name(input)) in_name = Traits::name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->name)::BaseType> name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_name,
        name_fragment);

      fragment->name.Set(
          name_fragment.is_null() ? nullptr : name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in MediaSessionDebugInfo struct");

      decltype(Traits::owner(input)) in_owner = Traits::owner(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->owner)::BaseType> owner_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_owner,
        owner_fragment);

      fragment->owner.Set(
          owner_fragment.is_null() ? nullptr : owner_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->owner.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null owner in MediaSessionDebugInfo struct");

      decltype(Traits::state(input)) in_state = Traits::state(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->state)::BaseType> state_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_state,
        state_fragment);

      fragment->state.Set(
          state_fragment.is_null() ? nullptr : state_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->state.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null state in MediaSessionDebugInfo struct");
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_MEDIA_SESSION_PUBLIC_MOJOM_MEDIA_SESSION_MOJOM_SEND_VALIDATION_H_