// services/media_session/public/mojom/media_controller.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  TimeDelta as mojoBase_mojom_TimeDelta,
  TimeDeltaSpec as mojoBase_mojom_TimeDeltaSpec
} from '../../../../mojo/public/mojom/base/time.mojom.m.js';

import {
  UnguessableToken as mojoBase_mojom_UnguessableToken,
  UnguessableTokenSpec as mojoBase_mojom_UnguessableTokenSpec
} from '../../../../mojo/public/mojom/base/unguessable_token.mojom.m.js';

import {
  MediaSessionAction as mediaSession_mojom_MediaSessionAction,
  MediaSessionActionSpec as mediaSession_mojom_MediaSessionActionSpec,
  MediaSessionImageType as mediaSession_mojom_MediaSessionImageType,
  MediaSessionImageTypeSpec as mediaSession_mojom_MediaSessionImageTypeSpec,
  MediaImageBitmap as mediaSession_mojom_MediaImageBitmap,
  MediaImageBitmapSpec as mediaSession_mojom_MediaImageBitmapSpec,
  MediaMetadata as mediaSession_mojom_MediaMetadata,
  MediaMetadataSpec as mediaSession_mojom_MediaMetadataSpec,
  MediaPosition as mediaSession_mojom_MediaPosition,
  MediaPositionSpec as mediaSession_mojom_MediaPositionSpec,
  MediaSessionInfo as mediaSession_mojom_MediaSessionInfo,
  MediaSessionInfoSpec as mediaSession_mojom_MediaSessionInfoSpec
} from './media_session.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class MediaControllerManagerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media_session.mojom.MediaControllerManager', scope);
  }
}

/** @interface */
export class MediaControllerManagerInterface {
  
  /**
   * @param { !MediaControllerPendingReceiver } receiver
   * @param { !mojoBase_mojom_UnguessableToken } requestId
   */

  createMediaControllerForSession(receiver, requestId) {}
  
  /**
   * @param { !MediaControllerPendingReceiver } receiver
   */

  createActiveMediaController(receiver) {}
  
  /**
   */

  suspendAllSessions() {}
}

/**
 * @implements { MediaControllerManagerInterface }
 */
export class MediaControllerManagerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!MediaControllerManagerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          MediaControllerManagerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!MediaControllerManagerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !MediaControllerPendingReceiver } receiver
   * @param { !mojoBase_mojom_UnguessableToken } requestId
   */

  createMediaControllerForSession(
      receiver,
      requestId) {
    this.proxy.sendMessage(
        0,
        MediaControllerManager_CreateMediaControllerForSession_ParamsSpec.$,
        null,
        [
          receiver,
          requestId
        ],
        false);
  }

  
  /**
   * @param { !MediaControllerPendingReceiver } receiver
   */

  createActiveMediaController(
      receiver) {
    this.proxy.sendMessage(
        1,
        MediaControllerManager_CreateActiveMediaController_ParamsSpec.$,
        null,
        [
          receiver
        ],
        false);
  }

  
  /**
   */

  suspendAllSessions() {
    this.proxy.sendMessage(
        2,
        MediaControllerManager_SuspendAllSessions_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the MediaControllerManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class MediaControllerManagerReceiver {
  /**
   * @param {!MediaControllerManagerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!MediaControllerManagerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        MediaControllerManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MediaControllerManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        MediaControllerManager_CreateMediaControllerForSession_ParamsSpec.$,
        null,
        impl.createMediaControllerForSession.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        MediaControllerManager_CreateActiveMediaController_ParamsSpec.$,
        null,
        impl.createActiveMediaController.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        MediaControllerManager_SuspendAllSessions_ParamsSpec.$,
        null,
        impl.suspendAllSessions.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class MediaControllerManager {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media_session.mojom.MediaControllerManager";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!MediaControllerManagerRemote}
   */
  static getRemote() {
    let remote = new MediaControllerManagerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the MediaControllerManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class MediaControllerManagerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      MediaControllerManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MediaControllerManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createMediaControllerForSession =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        MediaControllerManager_CreateMediaControllerForSession_ParamsSpec.$,
        null,
        this.createMediaControllerForSession.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createActiveMediaController =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        MediaControllerManager_CreateActiveMediaController_ParamsSpec.$,
        null,
        this.createActiveMediaController.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.suspendAllSessions =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        MediaControllerManager_SuspendAllSessions_ParamsSpec.$,
        null,
        this.suspendAllSessions.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class MediaControllerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media_session.mojom.MediaController', scope);
  }
}

/** @interface */
export class MediaControllerInterface {
  
  /**
   */

  suspend() {}
  
  /**
   */

  resume() {}
  
  /**
   */

  stop() {}
  
  /**
   */

  toggleSuspendResume() {}
  
  /**
   * @param { !MediaControllerObserverRemote } observer
   */

  addObserver(observer) {}
  
  /**
   */

  previousTrack() {}
  
  /**
   */

  nextTrack() {}
  
  /**
   * @param { !mojoBase_mojom_TimeDelta } seekTime
   */

  seek(seekTime) {}
  
  /**
   * @param { !mediaSession_mojom_MediaSessionImageType } type
   * @param { !number } minimumSizePx
   * @param { !number } desiredSizePx
   * @param { !MediaControllerImageObserverRemote } observer
   */

  observeImages(type, minimumSizePx, desiredSizePx, observer) {}
  
  /**
   * @param { !mojoBase_mojom_TimeDelta } seekTime
   */

  seekTo(seekTime) {}
  
  /**
   * @param { !mojoBase_mojom_TimeDelta } seekTime
   */

  scrubTo(seekTime) {}
  
  /**
   */

  enterPictureInPicture() {}
  
  /**
   */

  exitPictureInPicture() {}
  
  /**
   * @param { ?string } id
   */

  setAudioSinkId(id) {}
  
  /**
   */

  toggleMicrophone() {}
  
  /**
   */

  toggleCamera() {}
  
  /**
   */

  hangUp() {}
  
  /**
   */

  raise() {}
  
  /**
   * @param { !boolean } mute
   */

  setMute(mute) {}
  
  /**
   */

  requestMediaRemoting() {}
  
  /**
   */

  enterAutoPictureInPicture() {}
  
  /**
   */

  skipAd() {}
}

/**
 * @implements { MediaControllerInterface }
 */
export class MediaControllerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!MediaControllerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          MediaControllerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!MediaControllerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  suspend() {
    this.proxy.sendMessage(
        0,
        MediaController_Suspend_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  resume() {
    this.proxy.sendMessage(
        1,
        MediaController_Resume_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  stop() {
    this.proxy.sendMessage(
        2,
        MediaController_Stop_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  toggleSuspendResume() {
    this.proxy.sendMessage(
        3,
        MediaController_ToggleSuspendResume_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !MediaControllerObserverRemote } observer
   */

  addObserver(
      observer) {
    this.proxy.sendMessage(
        4,
        MediaController_AddObserver_ParamsSpec.$,
        null,
        [
          observer
        ],
        false);
  }

  
  /**
   */

  previousTrack() {
    this.proxy.sendMessage(
        5,
        MediaController_PreviousTrack_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  nextTrack() {
    this.proxy.sendMessage(
        6,
        MediaController_NextTrack_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_TimeDelta } seekTime
   */

  seek(
      seekTime) {
    this.proxy.sendMessage(
        7,
        MediaController_Seek_ParamsSpec.$,
        null,
        [
          seekTime
        ],
        false);
  }

  
  /**
   * @param { !mediaSession_mojom_MediaSessionImageType } type
   * @param { !number } minimumSizePx
   * @param { !number } desiredSizePx
   * @param { !MediaControllerImageObserverRemote } observer
   */

  observeImages(
      type,
      minimumSizePx,
      desiredSizePx,
      observer) {
    this.proxy.sendMessage(
        8,
        MediaController_ObserveImages_ParamsSpec.$,
        null,
        [
          type,
          minimumSizePx,
          desiredSizePx,
          observer
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_TimeDelta } seekTime
   */

  seekTo(
      seekTime) {
    this.proxy.sendMessage(
        9,
        MediaController_SeekTo_ParamsSpec.$,
        null,
        [
          seekTime
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_TimeDelta } seekTime
   */

  scrubTo(
      seekTime) {
    this.proxy.sendMessage(
        10,
        MediaController_ScrubTo_ParamsSpec.$,
        null,
        [
          seekTime
        ],
        false);
  }

  
  /**
   */

  enterPictureInPicture() {
    this.proxy.sendMessage(
        11,
        MediaController_EnterPictureInPicture_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  exitPictureInPicture() {
    this.proxy.sendMessage(
        12,
        MediaController_ExitPictureInPicture_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { ?string } id
   */

  setAudioSinkId(
      id) {
    this.proxy.sendMessage(
        13,
        MediaController_SetAudioSinkId_ParamsSpec.$,
        null,
        [
          id
        ],
        false);
  }

  
  /**
   */

  toggleMicrophone() {
    this.proxy.sendMessage(
        14,
        MediaController_ToggleMicrophone_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  toggleCamera() {
    this.proxy.sendMessage(
        15,
        MediaController_ToggleCamera_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  hangUp() {
    this.proxy.sendMessage(
        16,
        MediaController_HangUp_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  raise() {
    this.proxy.sendMessage(
        17,
        MediaController_Raise_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !boolean } mute
   */

  setMute(
      mute) {
    this.proxy.sendMessage(
        18,
        MediaController_SetMute_ParamsSpec.$,
        null,
        [
          mute
        ],
        false);
  }

  
  /**
   */

  requestMediaRemoting() {
    this.proxy.sendMessage(
        19,
        MediaController_RequestMediaRemoting_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  enterAutoPictureInPicture() {
    this.proxy.sendMessage(
        20,
        MediaController_EnterAutoPictureInPicture_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  skipAd() {
    this.proxy.sendMessage(
        21,
        MediaController_SkipAd_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the MediaController
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class MediaControllerReceiver {
  /**
   * @param {!MediaControllerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!MediaControllerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        MediaControllerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MediaControllerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        MediaController_Suspend_ParamsSpec.$,
        null,
        impl.suspend.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        MediaController_Resume_ParamsSpec.$,
        null,
        impl.resume.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        MediaController_Stop_ParamsSpec.$,
        null,
        impl.stop.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        MediaController_ToggleSuspendResume_ParamsSpec.$,
        null,
        impl.toggleSuspendResume.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        MediaController_AddObserver_ParamsSpec.$,
        null,
        impl.addObserver.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        MediaController_PreviousTrack_ParamsSpec.$,
        null,
        impl.previousTrack.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        MediaController_NextTrack_ParamsSpec.$,
        null,
        impl.nextTrack.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        MediaController_Seek_ParamsSpec.$,
        null,
        impl.seek.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        MediaController_ObserveImages_ParamsSpec.$,
        null,
        impl.observeImages.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        MediaController_SeekTo_ParamsSpec.$,
        null,
        impl.seekTo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        MediaController_ScrubTo_ParamsSpec.$,
        null,
        impl.scrubTo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        MediaController_EnterPictureInPicture_ParamsSpec.$,
        null,
        impl.enterPictureInPicture.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        MediaController_ExitPictureInPicture_ParamsSpec.$,
        null,
        impl.exitPictureInPicture.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        MediaController_SetAudioSinkId_ParamsSpec.$,
        null,
        impl.setAudioSinkId.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        14,
        MediaController_ToggleMicrophone_ParamsSpec.$,
        null,
        impl.toggleMicrophone.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        15,
        MediaController_ToggleCamera_ParamsSpec.$,
        null,
        impl.toggleCamera.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        16,
        MediaController_HangUp_ParamsSpec.$,
        null,
        impl.hangUp.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        17,
        MediaController_Raise_ParamsSpec.$,
        null,
        impl.raise.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        18,
        MediaController_SetMute_ParamsSpec.$,
        null,
        impl.setMute.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        19,
        MediaController_RequestMediaRemoting_ParamsSpec.$,
        null,
        impl.requestMediaRemoting.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        20,
        MediaController_EnterAutoPictureInPicture_ParamsSpec.$,
        null,
        impl.enterAutoPictureInPicture.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        21,
        MediaController_SkipAd_ParamsSpec.$,
        null,
        impl.skipAd.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class MediaController {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media_session.mojom.MediaController";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!MediaControllerRemote}
   */
  static getRemote() {
    let remote = new MediaControllerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the MediaController
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class MediaControllerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      MediaControllerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MediaControllerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.suspend =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        MediaController_Suspend_ParamsSpec.$,
        null,
        this.suspend.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.resume =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        MediaController_Resume_ParamsSpec.$,
        null,
        this.resume.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.stop =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        MediaController_Stop_ParamsSpec.$,
        null,
        this.stop.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.toggleSuspendResume =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        MediaController_ToggleSuspendResume_ParamsSpec.$,
        null,
        this.toggleSuspendResume.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addObserver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        MediaController_AddObserver_ParamsSpec.$,
        null,
        this.addObserver.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.previousTrack =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        MediaController_PreviousTrack_ParamsSpec.$,
        null,
        this.previousTrack.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.nextTrack =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        MediaController_NextTrack_ParamsSpec.$,
        null,
        this.nextTrack.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.seek =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        MediaController_Seek_ParamsSpec.$,
        null,
        this.seek.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.observeImages =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        MediaController_ObserveImages_ParamsSpec.$,
        null,
        this.observeImages.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.seekTo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        MediaController_SeekTo_ParamsSpec.$,
        null,
        this.seekTo.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.scrubTo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        MediaController_ScrubTo_ParamsSpec.$,
        null,
        this.scrubTo.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.enterPictureInPicture =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        MediaController_EnterPictureInPicture_ParamsSpec.$,
        null,
        this.enterPictureInPicture.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.exitPictureInPicture =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        MediaController_ExitPictureInPicture_ParamsSpec.$,
        null,
        this.exitPictureInPicture.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setAudioSinkId =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        MediaController_SetAudioSinkId_ParamsSpec.$,
        null,
        this.setAudioSinkId.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.toggleMicrophone =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        14,
        MediaController_ToggleMicrophone_ParamsSpec.$,
        null,
        this.toggleMicrophone.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.toggleCamera =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        15,
        MediaController_ToggleCamera_ParamsSpec.$,
        null,
        this.toggleCamera.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.hangUp =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        16,
        MediaController_HangUp_ParamsSpec.$,
        null,
        this.hangUp.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.raise =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        17,
        MediaController_Raise_ParamsSpec.$,
        null,
        this.raise.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setMute =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        18,
        MediaController_SetMute_ParamsSpec.$,
        null,
        this.setMute.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestMediaRemoting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        19,
        MediaController_RequestMediaRemoting_ParamsSpec.$,
        null,
        this.requestMediaRemoting.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.enterAutoPictureInPicture =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        20,
        MediaController_EnterAutoPictureInPicture_ParamsSpec.$,
        null,
        this.enterAutoPictureInPicture.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.skipAd =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        21,
        MediaController_SkipAd_ParamsSpec.$,
        null,
        this.skipAd.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class MediaControllerObserverPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media_session.mojom.MediaControllerObserver', scope);
  }
}

/** @interface */
export class MediaControllerObserverInterface {
  
  /**
   * @param { ?mediaSession_mojom_MediaSessionInfo } info
   */

  mediaSessionInfoChanged(info) {}
  
  /**
   * @param { ?mediaSession_mojom_MediaMetadata } metadata
   */

  mediaSessionMetadataChanged(metadata) {}
  
  /**
   * @param { !Array<!mediaSession_mojom_MediaSessionAction> } action
   */

  mediaSessionActionsChanged(action) {}
  
  /**
   * @param { ?mojoBase_mojom_UnguessableToken } requestId
   */

  mediaSessionChanged(requestId) {}
  
  /**
   * @param { ?mediaSession_mojom_MediaPosition } position
   */

  mediaSessionPositionChanged(position) {}
}

/**
 * @implements { MediaControllerObserverInterface }
 */
export class MediaControllerObserverRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!MediaControllerObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          MediaControllerObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!MediaControllerObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { ?mediaSession_mojom_MediaSessionInfo } info
   */

  mediaSessionInfoChanged(
      info) {
    this.proxy.sendMessage(
        0,
        MediaControllerObserver_MediaSessionInfoChanged_ParamsSpec.$,
        null,
        [
          info
        ],
        false);
  }

  
  /**
   * @param { ?mediaSession_mojom_MediaMetadata } metadata
   */

  mediaSessionMetadataChanged(
      metadata) {
    this.proxy.sendMessage(
        1,
        MediaControllerObserver_MediaSessionMetadataChanged_ParamsSpec.$,
        null,
        [
          metadata
        ],
        false);
  }

  
  /**
   * @param { !Array<!mediaSession_mojom_MediaSessionAction> } action
   */

  mediaSessionActionsChanged(
      action) {
    this.proxy.sendMessage(
        2,
        MediaControllerObserver_MediaSessionActionsChanged_ParamsSpec.$,
        null,
        [
          action
        ],
        false);
  }

  
  /**
   * @param { ?mojoBase_mojom_UnguessableToken } requestId
   */

  mediaSessionChanged(
      requestId) {
    this.proxy.sendMessage(
        3,
        MediaControllerObserver_MediaSessionChanged_ParamsSpec.$,
        null,
        [
          requestId
        ],
        false);
  }

  
  /**
   * @param { ?mediaSession_mojom_MediaPosition } position
   */

  mediaSessionPositionChanged(
      position) {
    this.proxy.sendMessage(
        4,
        MediaControllerObserver_MediaSessionPositionChanged_ParamsSpec.$,
        null,
        [
          position
        ],
        false);
  }
}

/**
 * An object which receives request messages for the MediaControllerObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class MediaControllerObserverReceiver {
  /**
   * @param {!MediaControllerObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!MediaControllerObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        MediaControllerObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MediaControllerObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        MediaControllerObserver_MediaSessionInfoChanged_ParamsSpec.$,
        null,
        impl.mediaSessionInfoChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        MediaControllerObserver_MediaSessionMetadataChanged_ParamsSpec.$,
        null,
        impl.mediaSessionMetadataChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        MediaControllerObserver_MediaSessionActionsChanged_ParamsSpec.$,
        null,
        impl.mediaSessionActionsChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        MediaControllerObserver_MediaSessionChanged_ParamsSpec.$,
        null,
        impl.mediaSessionChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        MediaControllerObserver_MediaSessionPositionChanged_ParamsSpec.$,
        null,
        impl.mediaSessionPositionChanged.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class MediaControllerObserver {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media_session.mojom.MediaControllerObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!MediaControllerObserverRemote}
   */
  static getRemote() {
    let remote = new MediaControllerObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the MediaControllerObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class MediaControllerObserverCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      MediaControllerObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MediaControllerObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.mediaSessionInfoChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        MediaControllerObserver_MediaSessionInfoChanged_ParamsSpec.$,
        null,
        this.mediaSessionInfoChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.mediaSessionMetadataChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        MediaControllerObserver_MediaSessionMetadataChanged_ParamsSpec.$,
        null,
        this.mediaSessionMetadataChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.mediaSessionActionsChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        MediaControllerObserver_MediaSessionActionsChanged_ParamsSpec.$,
        null,
        this.mediaSessionActionsChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.mediaSessionChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        MediaControllerObserver_MediaSessionChanged_ParamsSpec.$,
        null,
        this.mediaSessionChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.mediaSessionPositionChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        MediaControllerObserver_MediaSessionPositionChanged_ParamsSpec.$,
        null,
        this.mediaSessionPositionChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class MediaControllerImageObserverPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media_session.mojom.MediaControllerImageObserver', scope);
  }
}

/** @interface */
export class MediaControllerImageObserverInterface {
  
  /**
   * @param { !mediaSession_mojom_MediaSessionImageType } type
   * @param { ?mediaSession_mojom_MediaImageBitmap } bitmap
   */

  mediaControllerImageChanged(type, bitmap) {}
  
  /**
   * @param { !number } index
   * @param { ?mediaSession_mojom_MediaImageBitmap } bitmap
   */

  mediaControllerChapterImageChanged(index, bitmap) {}
}

/**
 * @implements { MediaControllerImageObserverInterface }
 */
export class MediaControllerImageObserverRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!MediaControllerImageObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          MediaControllerImageObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!MediaControllerImageObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !mediaSession_mojom_MediaSessionImageType } type
   * @param { ?mediaSession_mojom_MediaImageBitmap } bitmap
   */

  mediaControllerImageChanged(
      type,
      bitmap) {
    this.proxy.sendMessage(
        0,
        MediaControllerImageObserver_MediaControllerImageChanged_ParamsSpec.$,
        null,
        [
          type,
          bitmap
        ],
        false);
  }

  
  /**
   * @param { !number } index
   * @param { ?mediaSession_mojom_MediaImageBitmap } bitmap
   */

  mediaControllerChapterImageChanged(
      index,
      bitmap) {
    this.proxy.sendMessage(
        1,
        MediaControllerImageObserver_MediaControllerChapterImageChanged_ParamsSpec.$,
        null,
        [
          index,
          bitmap
        ],
        false);
  }
}

/**
 * An object which receives request messages for the MediaControllerImageObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class MediaControllerImageObserverReceiver {
  /**
   * @param {!MediaControllerImageObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!MediaControllerImageObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        MediaControllerImageObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MediaControllerImageObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        MediaControllerImageObserver_MediaControllerImageChanged_ParamsSpec.$,
        null,
        impl.mediaControllerImageChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        MediaControllerImageObserver_MediaControllerChapterImageChanged_ParamsSpec.$,
        null,
        impl.mediaControllerChapterImageChanged.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class MediaControllerImageObserver {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media_session.mojom.MediaControllerImageObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!MediaControllerImageObserverRemote}
   */
  static getRemote() {
    let remote = new MediaControllerImageObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the MediaControllerImageObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class MediaControllerImageObserverCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      MediaControllerImageObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MediaControllerImageObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.mediaControllerImageChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        MediaControllerImageObserver_MediaControllerImageChanged_ParamsSpec.$,
        null,
        this.mediaControllerImageChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.mediaControllerChapterImageChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        MediaControllerImageObserver_MediaControllerChapterImageChanged_ParamsSpec.$,
        null,
        this.mediaControllerChapterImageChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaControllerManager_CreateMediaControllerForSession_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaControllerManager_CreateActiveMediaController_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaControllerManager_SuspendAllSessions_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaController_Suspend_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaController_Resume_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaController_Stop_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaController_ToggleSuspendResume_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaController_AddObserver_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaController_PreviousTrack_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaController_NextTrack_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaController_Seek_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaController_ObserveImages_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaController_SeekTo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaController_ScrubTo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaController_EnterPictureInPicture_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaController_ExitPictureInPicture_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaController_SetAudioSinkId_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaController_ToggleMicrophone_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaController_ToggleCamera_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaController_HangUp_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaController_Raise_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaController_SetMute_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaController_RequestMediaRemoting_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaController_EnterAutoPictureInPicture_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaController_SkipAd_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaControllerObserver_MediaSessionInfoChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaControllerObserver_MediaSessionMetadataChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaControllerObserver_MediaSessionActionsChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaControllerObserver_MediaSessionChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaControllerObserver_MediaSessionPositionChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaControllerImageObserver_MediaControllerImageChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MediaControllerImageObserver_MediaControllerChapterImageChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    MediaControllerManager_CreateMediaControllerForSession_ParamsSpec.$,
    'MediaControllerManager_CreateMediaControllerForSession_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(MediaControllerPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'requestId', 8,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MediaControllerManager_CreateMediaControllerForSession_Params {
  constructor() {
    /** @type { !MediaControllerPendingReceiver } */
    this.receiver;
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.requestId;
  }
}



mojo.internal.Struct(
    MediaControllerManager_CreateActiveMediaController_ParamsSpec.$,
    'MediaControllerManager_CreateActiveMediaController_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(MediaControllerPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaControllerManager_CreateActiveMediaController_Params {
  constructor() {
    /** @type { !MediaControllerPendingReceiver } */
    this.receiver;
  }
}



mojo.internal.Struct(
    MediaControllerManager_SuspendAllSessions_ParamsSpec.$,
    'MediaControllerManager_SuspendAllSessions_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class MediaControllerManager_SuspendAllSessions_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    MediaController_Suspend_ParamsSpec.$,
    'MediaController_Suspend_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class MediaController_Suspend_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    MediaController_Resume_ParamsSpec.$,
    'MediaController_Resume_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class MediaController_Resume_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    MediaController_Stop_ParamsSpec.$,
    'MediaController_Stop_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class MediaController_Stop_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    MediaController_ToggleSuspendResume_ParamsSpec.$,
    'MediaController_ToggleSuspendResume_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class MediaController_ToggleSuspendResume_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    MediaController_AddObserver_ParamsSpec.$,
    'MediaController_AddObserver_Params',
    [
      mojo.internal.StructField(
        'observer', 0,
        0,
        mojo.internal.InterfaceProxy(MediaControllerObserverRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaController_AddObserver_Params {
  constructor() {
    /** @type { !MediaControllerObserverRemote } */
    this.observer;
  }
}



mojo.internal.Struct(
    MediaController_PreviousTrack_ParamsSpec.$,
    'MediaController_PreviousTrack_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class MediaController_PreviousTrack_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    MediaController_NextTrack_ParamsSpec.$,
    'MediaController_NextTrack_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class MediaController_NextTrack_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    MediaController_Seek_ParamsSpec.$,
    'MediaController_Seek_Params',
    [
      mojo.internal.StructField(
        'seekTime', 0,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaController_Seek_Params {
  constructor() {
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.seekTime;
  }
}



mojo.internal.Struct(
    MediaController_ObserveImages_ParamsSpec.$,
    'MediaController_ObserveImages_Params',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        mediaSession_mojom_MediaSessionImageTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'minimumSizePx', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'desiredSizePx', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'observer', 12,
        0,
        mojo.internal.InterfaceProxy(MediaControllerImageObserverRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class MediaController_ObserveImages_Params {
  constructor() {
    /** @type { !mediaSession_mojom_MediaSessionImageType } */
    this.type;
    /** @type { !number } */
    this.minimumSizePx;
    /** @type { !number } */
    this.desiredSizePx;
    /** @type { !MediaControllerImageObserverRemote } */
    this.observer;
  }
}



mojo.internal.Struct(
    MediaController_SeekTo_ParamsSpec.$,
    'MediaController_SeekTo_Params',
    [
      mojo.internal.StructField(
        'seekTime', 0,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaController_SeekTo_Params {
  constructor() {
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.seekTime;
  }
}



mojo.internal.Struct(
    MediaController_ScrubTo_ParamsSpec.$,
    'MediaController_ScrubTo_Params',
    [
      mojo.internal.StructField(
        'seekTime', 0,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaController_ScrubTo_Params {
  constructor() {
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.seekTime;
  }
}



mojo.internal.Struct(
    MediaController_EnterPictureInPicture_ParamsSpec.$,
    'MediaController_EnterPictureInPicture_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class MediaController_EnterPictureInPicture_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    MediaController_ExitPictureInPicture_ParamsSpec.$,
    'MediaController_ExitPictureInPicture_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class MediaController_ExitPictureInPicture_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    MediaController_SetAudioSinkId_ParamsSpec.$,
    'MediaController_SetAudioSinkId_Params',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaController_SetAudioSinkId_Params {
  constructor() {
    /** @type { (string|undefined) } */
    this.id;
  }
}



mojo.internal.Struct(
    MediaController_ToggleMicrophone_ParamsSpec.$,
    'MediaController_ToggleMicrophone_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class MediaController_ToggleMicrophone_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    MediaController_ToggleCamera_ParamsSpec.$,
    'MediaController_ToggleCamera_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class MediaController_ToggleCamera_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    MediaController_HangUp_ParamsSpec.$,
    'MediaController_HangUp_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class MediaController_HangUp_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    MediaController_Raise_ParamsSpec.$,
    'MediaController_Raise_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class MediaController_Raise_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    MediaController_SetMute_ParamsSpec.$,
    'MediaController_SetMute_Params',
    [
      mojo.internal.StructField(
        'mute', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaController_SetMute_Params {
  constructor() {
    /** @type { !boolean } */
    this.mute;
  }
}



mojo.internal.Struct(
    MediaController_RequestMediaRemoting_ParamsSpec.$,
    'MediaController_RequestMediaRemoting_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class MediaController_RequestMediaRemoting_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    MediaController_EnterAutoPictureInPicture_ParamsSpec.$,
    'MediaController_EnterAutoPictureInPicture_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class MediaController_EnterAutoPictureInPicture_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    MediaController_SkipAd_ParamsSpec.$,
    'MediaController_SkipAd_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class MediaController_SkipAd_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    MediaControllerObserver_MediaSessionInfoChanged_ParamsSpec.$,
    'MediaControllerObserver_MediaSessionInfoChanged_Params',
    [
      mojo.internal.StructField(
        'info', 0,
        0,
        mediaSession_mojom_MediaSessionInfoSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaControllerObserver_MediaSessionInfoChanged_Params {
  constructor() {
    /** @type { (mediaSession_mojom_MediaSessionInfo|undefined) } */
    this.info;
  }
}



mojo.internal.Struct(
    MediaControllerObserver_MediaSessionMetadataChanged_ParamsSpec.$,
    'MediaControllerObserver_MediaSessionMetadataChanged_Params',
    [
      mojo.internal.StructField(
        'metadata', 0,
        0,
        mediaSession_mojom_MediaMetadataSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaControllerObserver_MediaSessionMetadataChanged_Params {
  constructor() {
    /** @type { (mediaSession_mojom_MediaMetadata|undefined) } */
    this.metadata;
  }
}



mojo.internal.Struct(
    MediaControllerObserver_MediaSessionActionsChanged_ParamsSpec.$,
    'MediaControllerObserver_MediaSessionActionsChanged_Params',
    [
      mojo.internal.StructField(
        'action', 0,
        0,
        mojo.internal.Array(mediaSession_mojom_MediaSessionActionSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaControllerObserver_MediaSessionActionsChanged_Params {
  constructor() {
    /** @type { !Array<!mediaSession_mojom_MediaSessionAction> } */
    this.action;
  }
}



mojo.internal.Struct(
    MediaControllerObserver_MediaSessionChanged_ParamsSpec.$,
    'MediaControllerObserver_MediaSessionChanged_Params',
    [
      mojo.internal.StructField(
        'requestId', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaControllerObserver_MediaSessionChanged_Params {
  constructor() {
    /** @type { (mojoBase_mojom_UnguessableToken|undefined) } */
    this.requestId;
  }
}



mojo.internal.Struct(
    MediaControllerObserver_MediaSessionPositionChanged_ParamsSpec.$,
    'MediaControllerObserver_MediaSessionPositionChanged_Params',
    [
      mojo.internal.StructField(
        'position', 0,
        0,
        mediaSession_mojom_MediaPositionSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MediaControllerObserver_MediaSessionPositionChanged_Params {
  constructor() {
    /** @type { (mediaSession_mojom_MediaPosition|undefined) } */
    this.position;
  }
}



mojo.internal.Struct(
    MediaControllerImageObserver_MediaControllerImageChanged_ParamsSpec.$,
    'MediaControllerImageObserver_MediaControllerImageChanged_Params',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        mediaSession_mojom_MediaSessionImageTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'bitmap', 8,
        0,
        mediaSession_mojom_MediaImageBitmapSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MediaControllerImageObserver_MediaControllerImageChanged_Params {
  constructor() {
    /** @type { !mediaSession_mojom_MediaSessionImageType } */
    this.type;
    /** @type { (mediaSession_mojom_MediaImageBitmap|undefined) } */
    this.bitmap;
  }
}



mojo.internal.Struct(
    MediaControllerImageObserver_MediaControllerChapterImageChanged_ParamsSpec.$,
    'MediaControllerImageObserver_MediaControllerChapterImageChanged_Params',
    [
      mojo.internal.StructField(
        'index', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'bitmap', 8,
        0,
        mediaSession_mojom_MediaImageBitmapSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MediaControllerImageObserver_MediaControllerChapterImageChanged_Params {
  constructor() {
    /** @type { !number } */
    this.index;
    /** @type { (mediaSession_mojom_MediaImageBitmap|undefined) } */
    this.bitmap;
  }
}

