// services/media_session/public/mojom/media_controller.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_MEDIA_SESSION_PUBLIC_MOJOM_MEDIA_CONTROLLER_MOJOM_TEST_UTILS_H_
#define SERVICES_MEDIA_SESSION_PUBLIC_MOJOM_MEDIA_CONTROLLER_MOJOM_TEST_UTILS_H_

#include "services/media_session/public/mojom/media_controller.mojom.h"


namespace media_session::mojom {


class  MediaControllerManagerInterceptorForTesting : public MediaControllerManager {
  virtual MediaControllerManager* GetForwardingInterface() = 0;
  void CreateMediaControllerForSession(::mojo::PendingReceiver<MediaController> receiver, const ::base::UnguessableToken& request_id) override;
  void CreateActiveMediaController(::mojo::PendingReceiver<MediaController> receiver) override;
  void SuspendAllSessions() override;
};
class  MediaControllerManagerAsyncWaiter {
 public:
  explicit MediaControllerManagerAsyncWaiter(MediaControllerManager* proxy);

  MediaControllerManagerAsyncWaiter(const MediaControllerManagerAsyncWaiter&) = delete;
  MediaControllerManagerAsyncWaiter& operator=(const MediaControllerManagerAsyncWaiter&) = delete;

  ~MediaControllerManagerAsyncWaiter();

 private:
  MediaControllerManager* const proxy_;
};


class  MediaControllerInterceptorForTesting : public MediaController {
  virtual MediaController* GetForwardingInterface() = 0;
  void Suspend() override;
  void Resume() override;
  void Stop() override;
  void ToggleSuspendResume() override;
  void AddObserver(::mojo::PendingRemote<MediaControllerObserver> observer) override;
  void PreviousTrack() override;
  void NextTrack() override;
  void Seek(::base::TimeDelta seek_time) override;
  void ObserveImages(::media_session::mojom::MediaSessionImageType type, int32_t minimum_size_px, int32_t desired_size_px, ::mojo::PendingRemote<MediaControllerImageObserver> observer) override;
  void SeekTo(::base::TimeDelta seek_time) override;
  void ScrubTo(::base::TimeDelta seek_time) override;
  void EnterPictureInPicture() override;
  void ExitPictureInPicture() override;
  void SetAudioSinkId(const std::optional<std::string>& id) override;
  void ToggleMicrophone() override;
  void ToggleCamera() override;
  void HangUp() override;
  void Raise() override;
  void SetMute(bool mute) override;
  void RequestMediaRemoting() override;
  void EnterAutoPictureInPicture() override;
  void SkipAd() override;
};
class  MediaControllerAsyncWaiter {
 public:
  explicit MediaControllerAsyncWaiter(MediaController* proxy);

  MediaControllerAsyncWaiter(const MediaControllerAsyncWaiter&) = delete;
  MediaControllerAsyncWaiter& operator=(const MediaControllerAsyncWaiter&) = delete;

  ~MediaControllerAsyncWaiter();

 private:
  MediaController* const proxy_;
};


class  MediaControllerObserverInterceptorForTesting : public MediaControllerObserver {
  virtual MediaControllerObserver* GetForwardingInterface() = 0;
  void MediaSessionInfoChanged(::media_session::mojom::MediaSessionInfoPtr info) override;
  void MediaSessionMetadataChanged(const std::optional<::media_session::MediaMetadata>& metadata) override;
  void MediaSessionActionsChanged(const std::vector<::media_session::mojom::MediaSessionAction>& action) override;
  void MediaSessionChanged(const std::optional<::base::UnguessableToken>& request_id) override;
  void MediaSessionPositionChanged(const std::optional<::media_session::MediaPosition>& position) override;
};
class  MediaControllerObserverAsyncWaiter {
 public:
  explicit MediaControllerObserverAsyncWaiter(MediaControllerObserver* proxy);

  MediaControllerObserverAsyncWaiter(const MediaControllerObserverAsyncWaiter&) = delete;
  MediaControllerObserverAsyncWaiter& operator=(const MediaControllerObserverAsyncWaiter&) = delete;

  ~MediaControllerObserverAsyncWaiter();

 private:
  MediaControllerObserver* const proxy_;
};


class  MediaControllerImageObserverInterceptorForTesting : public MediaControllerImageObserver {
  virtual MediaControllerImageObserver* GetForwardingInterface() = 0;
  void MediaControllerImageChanged(::media_session::mojom::MediaSessionImageType type, const ::SkBitmap& bitmap) override;
  void MediaControllerChapterImageChanged(int32_t index, const ::SkBitmap& bitmap) override;
};
class  MediaControllerImageObserverAsyncWaiter {
 public:
  explicit MediaControllerImageObserverAsyncWaiter(MediaControllerImageObserver* proxy);

  MediaControllerImageObserverAsyncWaiter(const MediaControllerImageObserverAsyncWaiter&) = delete;
  MediaControllerImageObserverAsyncWaiter& operator=(const MediaControllerImageObserverAsyncWaiter&) = delete;

  ~MediaControllerImageObserverAsyncWaiter();

 private:
  MediaControllerImageObserver* const proxy_;
};




}  // media_session::mojom

#endif  // SERVICES_MEDIA_SESSION_PUBLIC_MOJOM_MEDIA_CONTROLLER_MOJOM_TEST_UTILS_H_