// services/media_session/public/mojom/media_controller.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_MEDIA_SESSION_PUBLIC_MOJOM_MEDIA_CONTROLLER_MOJOM_PARAMS_DATA_H_
#define SERVICES_MEDIA_SESSION_PUBLIC_MOJOM_MEDIA_CONTROLLER_MOJOM_PARAMS_DATA_H_
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace media_session::mojom {
namespace internal {
class  MediaControllerManager_CreateMediaControllerForSession_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Handle_Data receiver;
  uint8_t pad0_[4];
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data> request_id;

 private:
  friend class mojo::internal::MessageFragment<MediaControllerManager_CreateMediaControllerForSession_Params_Data>;

  MediaControllerManager_CreateMediaControllerForSession_Params_Data();
  ~MediaControllerManager_CreateMediaControllerForSession_Params_Data() = delete;
};
static_assert(sizeof(MediaControllerManager_CreateMediaControllerForSession_Params_Data) == 24,
              "Bad sizeof(MediaControllerManager_CreateMediaControllerForSession_Params_Data)");
class  MediaControllerManager_CreateActiveMediaController_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Handle_Data receiver;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<MediaControllerManager_CreateActiveMediaController_Params_Data>;

  MediaControllerManager_CreateActiveMediaController_Params_Data();
  ~MediaControllerManager_CreateActiveMediaController_Params_Data() = delete;
};
static_assert(sizeof(MediaControllerManager_CreateActiveMediaController_Params_Data) == 16,
              "Bad sizeof(MediaControllerManager_CreateActiveMediaController_Params_Data)");
class  MediaControllerManager_SuspendAllSessions_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<MediaControllerManager_SuspendAllSessions_Params_Data>;

  MediaControllerManager_SuspendAllSessions_Params_Data();
  ~MediaControllerManager_SuspendAllSessions_Params_Data() = delete;
};
static_assert(sizeof(MediaControllerManager_SuspendAllSessions_Params_Data) == 8,
              "Bad sizeof(MediaControllerManager_SuspendAllSessions_Params_Data)");
class  MediaController_Suspend_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<MediaController_Suspend_Params_Data>;

  MediaController_Suspend_Params_Data();
  ~MediaController_Suspend_Params_Data() = delete;
};
static_assert(sizeof(MediaController_Suspend_Params_Data) == 8,
              "Bad sizeof(MediaController_Suspend_Params_Data)");
class  MediaController_Resume_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<MediaController_Resume_Params_Data>;

  MediaController_Resume_Params_Data();
  ~MediaController_Resume_Params_Data() = delete;
};
static_assert(sizeof(MediaController_Resume_Params_Data) == 8,
              "Bad sizeof(MediaController_Resume_Params_Data)");
class  MediaController_Stop_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<MediaController_Stop_Params_Data>;

  MediaController_Stop_Params_Data();
  ~MediaController_Stop_Params_Data() = delete;
};
static_assert(sizeof(MediaController_Stop_Params_Data) == 8,
              "Bad sizeof(MediaController_Stop_Params_Data)");
class  MediaController_ToggleSuspendResume_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<MediaController_ToggleSuspendResume_Params_Data>;

  MediaController_ToggleSuspendResume_Params_Data();
  ~MediaController_ToggleSuspendResume_Params_Data() = delete;
};
static_assert(sizeof(MediaController_ToggleSuspendResume_Params_Data) == 8,
              "Bad sizeof(MediaController_ToggleSuspendResume_Params_Data)");
class  MediaController_AddObserver_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Interface_Data observer;

 private:
  friend class mojo::internal::MessageFragment<MediaController_AddObserver_Params_Data>;

  MediaController_AddObserver_Params_Data();
  ~MediaController_AddObserver_Params_Data() = delete;
};
static_assert(sizeof(MediaController_AddObserver_Params_Data) == 16,
              "Bad sizeof(MediaController_AddObserver_Params_Data)");
class  MediaController_PreviousTrack_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<MediaController_PreviousTrack_Params_Data>;

  MediaController_PreviousTrack_Params_Data();
  ~MediaController_PreviousTrack_Params_Data() = delete;
};
static_assert(sizeof(MediaController_PreviousTrack_Params_Data) == 8,
              "Bad sizeof(MediaController_PreviousTrack_Params_Data)");
class  MediaController_NextTrack_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<MediaController_NextTrack_Params_Data>;

  MediaController_NextTrack_Params_Data();
  ~MediaController_NextTrack_Params_Data() = delete;
};
static_assert(sizeof(MediaController_NextTrack_Params_Data) == 8,
              "Bad sizeof(MediaController_NextTrack_Params_Data)");
class  MediaController_Seek_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> seek_time;

 private:
  friend class mojo::internal::MessageFragment<MediaController_Seek_Params_Data>;

  MediaController_Seek_Params_Data();
  ~MediaController_Seek_Params_Data() = delete;
};
static_assert(sizeof(MediaController_Seek_Params_Data) == 16,
              "Bad sizeof(MediaController_Seek_Params_Data)");
class  MediaController_ObserveImages_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t type;
  int32_t minimum_size_px;
  int32_t desired_size_px;
  mojo::internal::Interface_Data observer;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<MediaController_ObserveImages_Params_Data>;

  MediaController_ObserveImages_Params_Data();
  ~MediaController_ObserveImages_Params_Data() = delete;
};
static_assert(sizeof(MediaController_ObserveImages_Params_Data) == 32,
              "Bad sizeof(MediaController_ObserveImages_Params_Data)");
class  MediaController_SeekTo_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> seek_time;

 private:
  friend class mojo::internal::MessageFragment<MediaController_SeekTo_Params_Data>;

  MediaController_SeekTo_Params_Data();
  ~MediaController_SeekTo_Params_Data() = delete;
};
static_assert(sizeof(MediaController_SeekTo_Params_Data) == 16,
              "Bad sizeof(MediaController_SeekTo_Params_Data)");
class  MediaController_ScrubTo_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> seek_time;

 private:
  friend class mojo::internal::MessageFragment<MediaController_ScrubTo_Params_Data>;

  MediaController_ScrubTo_Params_Data();
  ~MediaController_ScrubTo_Params_Data() = delete;
};
static_assert(sizeof(MediaController_ScrubTo_Params_Data) == 16,
              "Bad sizeof(MediaController_ScrubTo_Params_Data)");
class  MediaController_EnterPictureInPicture_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<MediaController_EnterPictureInPicture_Params_Data>;

  MediaController_EnterPictureInPicture_Params_Data();
  ~MediaController_EnterPictureInPicture_Params_Data() = delete;
};
static_assert(sizeof(MediaController_EnterPictureInPicture_Params_Data) == 8,
              "Bad sizeof(MediaController_EnterPictureInPicture_Params_Data)");
class  MediaController_ExitPictureInPicture_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<MediaController_ExitPictureInPicture_Params_Data>;

  MediaController_ExitPictureInPicture_Params_Data();
  ~MediaController_ExitPictureInPicture_Params_Data() = delete;
};
static_assert(sizeof(MediaController_ExitPictureInPicture_Params_Data) == 8,
              "Bad sizeof(MediaController_ExitPictureInPicture_Params_Data)");
class  MediaController_SetAudioSinkId_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> id;

 private:
  friend class mojo::internal::MessageFragment<MediaController_SetAudioSinkId_Params_Data>;

  MediaController_SetAudioSinkId_Params_Data();
  ~MediaController_SetAudioSinkId_Params_Data() = delete;
};
static_assert(sizeof(MediaController_SetAudioSinkId_Params_Data) == 16,
              "Bad sizeof(MediaController_SetAudioSinkId_Params_Data)");
class  MediaController_ToggleMicrophone_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<MediaController_ToggleMicrophone_Params_Data>;

  MediaController_ToggleMicrophone_Params_Data();
  ~MediaController_ToggleMicrophone_Params_Data() = delete;
};
static_assert(sizeof(MediaController_ToggleMicrophone_Params_Data) == 8,
              "Bad sizeof(MediaController_ToggleMicrophone_Params_Data)");
class  MediaController_ToggleCamera_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<MediaController_ToggleCamera_Params_Data>;

  MediaController_ToggleCamera_Params_Data();
  ~MediaController_ToggleCamera_Params_Data() = delete;
};
static_assert(sizeof(MediaController_ToggleCamera_Params_Data) == 8,
              "Bad sizeof(MediaController_ToggleCamera_Params_Data)");
class  MediaController_HangUp_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<MediaController_HangUp_Params_Data>;

  MediaController_HangUp_Params_Data();
  ~MediaController_HangUp_Params_Data() = delete;
};
static_assert(sizeof(MediaController_HangUp_Params_Data) == 8,
              "Bad sizeof(MediaController_HangUp_Params_Data)");
class  MediaController_Raise_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<MediaController_Raise_Params_Data>;

  MediaController_Raise_Params_Data();
  ~MediaController_Raise_Params_Data() = delete;
};
static_assert(sizeof(MediaController_Raise_Params_Data) == 8,
              "Bad sizeof(MediaController_Raise_Params_Data)");
class  MediaController_SetMute_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t mute : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<MediaController_SetMute_Params_Data>;

  MediaController_SetMute_Params_Data();
  ~MediaController_SetMute_Params_Data() = delete;
};
static_assert(sizeof(MediaController_SetMute_Params_Data) == 16,
              "Bad sizeof(MediaController_SetMute_Params_Data)");
class  MediaController_RequestMediaRemoting_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<MediaController_RequestMediaRemoting_Params_Data>;

  MediaController_RequestMediaRemoting_Params_Data();
  ~MediaController_RequestMediaRemoting_Params_Data() = delete;
};
static_assert(sizeof(MediaController_RequestMediaRemoting_Params_Data) == 8,
              "Bad sizeof(MediaController_RequestMediaRemoting_Params_Data)");
class  MediaController_EnterAutoPictureInPicture_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<MediaController_EnterAutoPictureInPicture_Params_Data>;

  MediaController_EnterAutoPictureInPicture_Params_Data();
  ~MediaController_EnterAutoPictureInPicture_Params_Data() = delete;
};
static_assert(sizeof(MediaController_EnterAutoPictureInPicture_Params_Data) == 8,
              "Bad sizeof(MediaController_EnterAutoPictureInPicture_Params_Data)");
class  MediaController_SkipAd_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<MediaController_SkipAd_Params_Data>;

  MediaController_SkipAd_Params_Data();
  ~MediaController_SkipAd_Params_Data() = delete;
};
static_assert(sizeof(MediaController_SkipAd_Params_Data) == 8,
              "Bad sizeof(MediaController_SkipAd_Params_Data)");
class  MediaControllerObserver_MediaSessionInfoChanged_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::media_session::mojom::internal::MediaSessionInfo_Data> info;

 private:
  friend class mojo::internal::MessageFragment<MediaControllerObserver_MediaSessionInfoChanged_Params_Data>;

  MediaControllerObserver_MediaSessionInfoChanged_Params_Data();
  ~MediaControllerObserver_MediaSessionInfoChanged_Params_Data() = delete;
};
static_assert(sizeof(MediaControllerObserver_MediaSessionInfoChanged_Params_Data) == 16,
              "Bad sizeof(MediaControllerObserver_MediaSessionInfoChanged_Params_Data)");
class  MediaControllerObserver_MediaSessionMetadataChanged_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::media_session::mojom::internal::MediaMetadata_Data> metadata;

 private:
  friend class mojo::internal::MessageFragment<MediaControllerObserver_MediaSessionMetadataChanged_Params_Data>;

  MediaControllerObserver_MediaSessionMetadataChanged_Params_Data();
  ~MediaControllerObserver_MediaSessionMetadataChanged_Params_Data() = delete;
};
static_assert(sizeof(MediaControllerObserver_MediaSessionMetadataChanged_Params_Data) == 16,
              "Bad sizeof(MediaControllerObserver_MediaSessionMetadataChanged_Params_Data)");
class  MediaControllerObserver_MediaSessionActionsChanged_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<int32_t>> action;

 private:
  friend class mojo::internal::MessageFragment<MediaControllerObserver_MediaSessionActionsChanged_Params_Data>;

  MediaControllerObserver_MediaSessionActionsChanged_Params_Data();
  ~MediaControllerObserver_MediaSessionActionsChanged_Params_Data() = delete;
};
static_assert(sizeof(MediaControllerObserver_MediaSessionActionsChanged_Params_Data) == 16,
              "Bad sizeof(MediaControllerObserver_MediaSessionActionsChanged_Params_Data)");
class  MediaControllerObserver_MediaSessionChanged_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data> request_id;

 private:
  friend class mojo::internal::MessageFragment<MediaControllerObserver_MediaSessionChanged_Params_Data>;

  MediaControllerObserver_MediaSessionChanged_Params_Data();
  ~MediaControllerObserver_MediaSessionChanged_Params_Data() = delete;
};
static_assert(sizeof(MediaControllerObserver_MediaSessionChanged_Params_Data) == 16,
              "Bad sizeof(MediaControllerObserver_MediaSessionChanged_Params_Data)");
class  MediaControllerObserver_MediaSessionPositionChanged_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::media_session::mojom::internal::MediaPosition_Data> position;

 private:
  friend class mojo::internal::MessageFragment<MediaControllerObserver_MediaSessionPositionChanged_Params_Data>;

  MediaControllerObserver_MediaSessionPositionChanged_Params_Data();
  ~MediaControllerObserver_MediaSessionPositionChanged_Params_Data() = delete;
};
static_assert(sizeof(MediaControllerObserver_MediaSessionPositionChanged_Params_Data) == 16,
              "Bad sizeof(MediaControllerObserver_MediaSessionPositionChanged_Params_Data)");
class  MediaControllerImageObserver_MediaControllerImageChanged_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t type;
  uint8_t pad0_[4];
  mojo::internal::Pointer<::media_session::mojom::internal::MediaImageBitmap_Data> bitmap;

 private:
  friend class mojo::internal::MessageFragment<MediaControllerImageObserver_MediaControllerImageChanged_Params_Data>;

  MediaControllerImageObserver_MediaControllerImageChanged_Params_Data();
  ~MediaControllerImageObserver_MediaControllerImageChanged_Params_Data() = delete;
};
static_assert(sizeof(MediaControllerImageObserver_MediaControllerImageChanged_Params_Data) == 24,
              "Bad sizeof(MediaControllerImageObserver_MediaControllerImageChanged_Params_Data)");
class  MediaControllerImageObserver_MediaControllerChapterImageChanged_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t index;
  uint8_t pad0_[4];
  mojo::internal::Pointer<::media_session::mojom::internal::MediaImageBitmap_Data> bitmap;

 private:
  friend class mojo::internal::MessageFragment<MediaControllerImageObserver_MediaControllerChapterImageChanged_Params_Data>;

  MediaControllerImageObserver_MediaControllerChapterImageChanged_Params_Data();
  ~MediaControllerImageObserver_MediaControllerChapterImageChanged_Params_Data() = delete;
};
static_assert(sizeof(MediaControllerImageObserver_MediaControllerChapterImageChanged_Params_Data) == 24,
              "Bad sizeof(MediaControllerImageObserver_MediaControllerChapterImageChanged_Params_Data)");

}  // namespace internal


class MediaControllerManager_CreateMediaControllerForSession_ParamsDataView {
 public:
  MediaControllerManager_CreateMediaControllerForSession_ParamsDataView() = default;

  MediaControllerManager_CreateMediaControllerForSession_ParamsDataView(
      internal::MediaControllerManager_CreateMediaControllerForSession_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::media_session::mojom::MediaControllerInterfaceBase>>(
            &data_->receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
  inline void GetRequestIdDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequestId(UserType* output) {
    
    auto* pointer = data_->request_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
 private:
  internal::MediaControllerManager_CreateMediaControllerForSession_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaControllerManager_CreateActiveMediaController_ParamsDataView {
 public:
  MediaControllerManager_CreateActiveMediaController_ParamsDataView() = default;

  MediaControllerManager_CreateActiveMediaController_ParamsDataView(
      internal::MediaControllerManager_CreateActiveMediaController_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::media_session::mojom::MediaControllerInterfaceBase>>(
            &data_->receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::MediaControllerManager_CreateActiveMediaController_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaControllerManager_SuspendAllSessions_ParamsDataView {
 public:
  MediaControllerManager_SuspendAllSessions_ParamsDataView() = default;

  MediaControllerManager_SuspendAllSessions_ParamsDataView(
      internal::MediaControllerManager_SuspendAllSessions_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::MediaControllerManager_SuspendAllSessions_Params_Data* data_ = nullptr;
};


class MediaController_Suspend_ParamsDataView {
 public:
  MediaController_Suspend_ParamsDataView() = default;

  MediaController_Suspend_ParamsDataView(
      internal::MediaController_Suspend_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::MediaController_Suspend_Params_Data* data_ = nullptr;
};


class MediaController_Resume_ParamsDataView {
 public:
  MediaController_Resume_ParamsDataView() = default;

  MediaController_Resume_ParamsDataView(
      internal::MediaController_Resume_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::MediaController_Resume_Params_Data* data_ = nullptr;
};


class MediaController_Stop_ParamsDataView {
 public:
  MediaController_Stop_ParamsDataView() = default;

  MediaController_Stop_ParamsDataView(
      internal::MediaController_Stop_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::MediaController_Stop_Params_Data* data_ = nullptr;
};


class MediaController_ToggleSuspendResume_ParamsDataView {
 public:
  MediaController_ToggleSuspendResume_ParamsDataView() = default;

  MediaController_ToggleSuspendResume_ParamsDataView(
      internal::MediaController_ToggleSuspendResume_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::MediaController_ToggleSuspendResume_Params_Data* data_ = nullptr;
};


class MediaController_AddObserver_ParamsDataView {
 public:
  MediaController_AddObserver_ParamsDataView() = default;

  MediaController_AddObserver_ParamsDataView(
      internal::MediaController_AddObserver_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeObserver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::media_session::mojom::MediaControllerObserverInterfaceBase>>(
            &data_->observer, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::MediaController_AddObserver_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaController_PreviousTrack_ParamsDataView {
 public:
  MediaController_PreviousTrack_ParamsDataView() = default;

  MediaController_PreviousTrack_ParamsDataView(
      internal::MediaController_PreviousTrack_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::MediaController_PreviousTrack_Params_Data* data_ = nullptr;
};


class MediaController_NextTrack_ParamsDataView {
 public:
  MediaController_NextTrack_ParamsDataView() = default;

  MediaController_NextTrack_ParamsDataView(
      internal::MediaController_NextTrack_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::MediaController_NextTrack_Params_Data* data_ = nullptr;
};


class MediaController_Seek_ParamsDataView {
 public:
  MediaController_Seek_ParamsDataView() = default;

  MediaController_Seek_ParamsDataView(
      internal::MediaController_Seek_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSeekTimeDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSeekTime(UserType* output) {
    
    auto* pointer = data_->seek_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
 private:
  internal::MediaController_Seek_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaController_ObserveImages_ParamsDataView {
 public:
  MediaController_ObserveImages_ParamsDataView() = default;

  MediaController_ObserveImages_ParamsDataView(
      internal::MediaController_ObserveImages_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::media_session::mojom::MediaSessionImageType>(
        data_value, output);
  }
  ::media_session::mojom::MediaSessionImageType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media_session::mojom::MediaSessionImageType>(data_->type));
  }
  int32_t minimum_size_px() const {
    return data_->minimum_size_px;
  }
  int32_t desired_size_px() const {
    return data_->desired_size_px;
  }
  template <typename UserType>
  UserType TakeObserver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::media_session::mojom::MediaControllerImageObserverInterfaceBase>>(
            &data_->observer, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::MediaController_ObserveImages_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaController_SeekTo_ParamsDataView {
 public:
  MediaController_SeekTo_ParamsDataView() = default;

  MediaController_SeekTo_ParamsDataView(
      internal::MediaController_SeekTo_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSeekTimeDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSeekTime(UserType* output) {
    
    auto* pointer = data_->seek_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
 private:
  internal::MediaController_SeekTo_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaController_ScrubTo_ParamsDataView {
 public:
  MediaController_ScrubTo_ParamsDataView() = default;

  MediaController_ScrubTo_ParamsDataView(
      internal::MediaController_ScrubTo_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSeekTimeDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSeekTime(UserType* output) {
    
    auto* pointer = data_->seek_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
 private:
  internal::MediaController_ScrubTo_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaController_EnterPictureInPicture_ParamsDataView {
 public:
  MediaController_EnterPictureInPicture_ParamsDataView() = default;

  MediaController_EnterPictureInPicture_ParamsDataView(
      internal::MediaController_EnterPictureInPicture_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::MediaController_EnterPictureInPicture_Params_Data* data_ = nullptr;
};


class MediaController_ExitPictureInPicture_ParamsDataView {
 public:
  MediaController_ExitPictureInPicture_ParamsDataView() = default;

  MediaController_ExitPictureInPicture_ParamsDataView(
      internal::MediaController_ExitPictureInPicture_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::MediaController_ExitPictureInPicture_Params_Data* data_ = nullptr;
};


class MediaController_SetAudioSinkId_ParamsDataView {
 public:
  MediaController_SetAudioSinkId_ParamsDataView() = default;

  MediaController_SetAudioSinkId_ParamsDataView(
      internal::MediaController_SetAudioSinkId_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadId` instead "
    "of `ReadId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::MediaController_SetAudioSinkId_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaController_ToggleMicrophone_ParamsDataView {
 public:
  MediaController_ToggleMicrophone_ParamsDataView() = default;

  MediaController_ToggleMicrophone_ParamsDataView(
      internal::MediaController_ToggleMicrophone_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::MediaController_ToggleMicrophone_Params_Data* data_ = nullptr;
};


class MediaController_ToggleCamera_ParamsDataView {
 public:
  MediaController_ToggleCamera_ParamsDataView() = default;

  MediaController_ToggleCamera_ParamsDataView(
      internal::MediaController_ToggleCamera_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::MediaController_ToggleCamera_Params_Data* data_ = nullptr;
};


class MediaController_HangUp_ParamsDataView {
 public:
  MediaController_HangUp_ParamsDataView() = default;

  MediaController_HangUp_ParamsDataView(
      internal::MediaController_HangUp_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::MediaController_HangUp_Params_Data* data_ = nullptr;
};


class MediaController_Raise_ParamsDataView {
 public:
  MediaController_Raise_ParamsDataView() = default;

  MediaController_Raise_ParamsDataView(
      internal::MediaController_Raise_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::MediaController_Raise_Params_Data* data_ = nullptr;
};


class MediaController_SetMute_ParamsDataView {
 public:
  MediaController_SetMute_ParamsDataView() = default;

  MediaController_SetMute_ParamsDataView(
      internal::MediaController_SetMute_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool mute() const {
    return data_->mute;
  }
 private:
  internal::MediaController_SetMute_Params_Data* data_ = nullptr;
};


class MediaController_RequestMediaRemoting_ParamsDataView {
 public:
  MediaController_RequestMediaRemoting_ParamsDataView() = default;

  MediaController_RequestMediaRemoting_ParamsDataView(
      internal::MediaController_RequestMediaRemoting_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::MediaController_RequestMediaRemoting_Params_Data* data_ = nullptr;
};


class MediaController_EnterAutoPictureInPicture_ParamsDataView {
 public:
  MediaController_EnterAutoPictureInPicture_ParamsDataView() = default;

  MediaController_EnterAutoPictureInPicture_ParamsDataView(
      internal::MediaController_EnterAutoPictureInPicture_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::MediaController_EnterAutoPictureInPicture_Params_Data* data_ = nullptr;
};


class MediaController_SkipAd_ParamsDataView {
 public:
  MediaController_SkipAd_ParamsDataView() = default;

  MediaController_SkipAd_ParamsDataView(
      internal::MediaController_SkipAd_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::MediaController_SkipAd_Params_Data* data_ = nullptr;
};


class MediaControllerObserver_MediaSessionInfoChanged_ParamsDataView {
 public:
  MediaControllerObserver_MediaSessionInfoChanged_ParamsDataView() = default;

  MediaControllerObserver_MediaSessionInfoChanged_ParamsDataView(
      internal::MediaControllerObserver_MediaSessionInfoChanged_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInfoDataView(
      ::media_session::mojom::MediaSessionInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInfo(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media_session::mojom::MediaSessionInfoDataView, UserType>(),
    "Attempting to read the optional `info` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInfo` instead "
    "of `ReadInfo if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->info.Get();
    return mojo::internal::Deserialize<::media_session::mojom::MediaSessionInfoDataView>(
        pointer, output, message_);
  }
 private:
  internal::MediaControllerObserver_MediaSessionInfoChanged_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaControllerObserver_MediaSessionMetadataChanged_ParamsDataView {
 public:
  MediaControllerObserver_MediaSessionMetadataChanged_ParamsDataView() = default;

  MediaControllerObserver_MediaSessionMetadataChanged_ParamsDataView(
      internal::MediaControllerObserver_MediaSessionMetadataChanged_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMetadataDataView(
      ::media_session::mojom::MediaMetadataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMetadata(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media_session::mojom::MediaMetadataDataView, UserType>(),
    "Attempting to read the optional `metadata` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMetadata` instead "
    "of `ReadMetadata if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->metadata.Get();
    return mojo::internal::Deserialize<::media_session::mojom::MediaMetadataDataView>(
        pointer, output, message_);
  }
 private:
  internal::MediaControllerObserver_MediaSessionMetadataChanged_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaControllerObserver_MediaSessionActionsChanged_ParamsDataView {
 public:
  MediaControllerObserver_MediaSessionActionsChanged_ParamsDataView() = default;

  MediaControllerObserver_MediaSessionActionsChanged_ParamsDataView(
      internal::MediaControllerObserver_MediaSessionActionsChanged_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetActionDataView(
      mojo::ArrayDataView<::media_session::mojom::MediaSessionAction>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAction(UserType* output) {
    
    auto* pointer = data_->action.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media_session::mojom::MediaSessionAction>>(
        pointer, output, message_);
  }
 private:
  internal::MediaControllerObserver_MediaSessionActionsChanged_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaControllerObserver_MediaSessionChanged_ParamsDataView {
 public:
  MediaControllerObserver_MediaSessionChanged_ParamsDataView() = default;

  MediaControllerObserver_MediaSessionChanged_ParamsDataView(
      internal::MediaControllerObserver_MediaSessionChanged_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRequestIdDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequestId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::UnguessableTokenDataView, UserType>(),
    "Attempting to read the optional `request_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRequestId` instead "
    "of `ReadRequestId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->request_id.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
 private:
  internal::MediaControllerObserver_MediaSessionChanged_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaControllerObserver_MediaSessionPositionChanged_ParamsDataView {
 public:
  MediaControllerObserver_MediaSessionPositionChanged_ParamsDataView() = default;

  MediaControllerObserver_MediaSessionPositionChanged_ParamsDataView(
      internal::MediaControllerObserver_MediaSessionPositionChanged_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPositionDataView(
      ::media_session::mojom::MediaPositionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPosition(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media_session::mojom::MediaPositionDataView, UserType>(),
    "Attempting to read the optional `position` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPosition` instead "
    "of `ReadPosition if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->position.Get();
    return mojo::internal::Deserialize<::media_session::mojom::MediaPositionDataView>(
        pointer, output, message_);
  }
 private:
  internal::MediaControllerObserver_MediaSessionPositionChanged_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaControllerImageObserver_MediaControllerImageChanged_ParamsDataView {
 public:
  MediaControllerImageObserver_MediaControllerImageChanged_ParamsDataView() = default;

  MediaControllerImageObserver_MediaControllerImageChanged_ParamsDataView(
      internal::MediaControllerImageObserver_MediaControllerImageChanged_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::media_session::mojom::MediaSessionImageType>(
        data_value, output);
  }
  ::media_session::mojom::MediaSessionImageType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media_session::mojom::MediaSessionImageType>(data_->type));
  }
  inline void GetBitmapDataView(
      ::media_session::mojom::MediaImageBitmapDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBitmap(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media_session::mojom::MediaImageBitmapDataView, UserType>(),
    "Attempting to read the optional `bitmap` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBitmap` instead "
    "of `ReadBitmap if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->bitmap.Get();
    return mojo::internal::Deserialize<::media_session::mojom::MediaImageBitmapDataView>(
        pointer, output, message_);
  }
 private:
  internal::MediaControllerImageObserver_MediaControllerImageChanged_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaControllerImageObserver_MediaControllerChapterImageChanged_ParamsDataView {
 public:
  MediaControllerImageObserver_MediaControllerChapterImageChanged_ParamsDataView() = default;

  MediaControllerImageObserver_MediaControllerChapterImageChanged_ParamsDataView(
      internal::MediaControllerImageObserver_MediaControllerChapterImageChanged_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t index() const {
    return data_->index;
  }
  inline void GetBitmapDataView(
      ::media_session::mojom::MediaImageBitmapDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBitmap(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media_session::mojom::MediaImageBitmapDataView, UserType>(),
    "Attempting to read the optional `bitmap` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBitmap` instead "
    "of `ReadBitmap if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->bitmap.Get();
    return mojo::internal::Deserialize<::media_session::mojom::MediaImageBitmapDataView>(
        pointer, output, message_);
  }
 private:
  internal::MediaControllerImageObserver_MediaControllerChapterImageChanged_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};

inline void MediaControllerManager_CreateMediaControllerForSession_ParamsDataView::GetRequestIdDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->request_id.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}




















inline void MediaController_Seek_ParamsDataView::GetSeekTimeDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->seek_time.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}




inline void MediaController_SeekTo_ParamsDataView::GetSeekTimeDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->seek_time.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}


inline void MediaController_ScrubTo_ParamsDataView::GetSeekTimeDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->seek_time.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}






inline void MediaController_SetAudioSinkId_ParamsDataView::GetIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->id.Get();
  *output = mojo::StringDataView(pointer, message_);
}


















inline void MediaControllerObserver_MediaSessionInfoChanged_ParamsDataView::GetInfoDataView(
    ::media_session::mojom::MediaSessionInfoDataView* output) {
  auto pointer = data_->info.Get();
  *output = ::media_session::mojom::MediaSessionInfoDataView(pointer, message_);
}


inline void MediaControllerObserver_MediaSessionMetadataChanged_ParamsDataView::GetMetadataDataView(
    ::media_session::mojom::MediaMetadataDataView* output) {
  auto pointer = data_->metadata.Get();
  *output = ::media_session::mojom::MediaMetadataDataView(pointer, message_);
}


inline void MediaControllerObserver_MediaSessionActionsChanged_ParamsDataView::GetActionDataView(
    mojo::ArrayDataView<::media_session::mojom::MediaSessionAction>* output) {
  auto pointer = data_->action.Get();
  *output = mojo::ArrayDataView<::media_session::mojom::MediaSessionAction>(pointer, message_);
}


inline void MediaControllerObserver_MediaSessionChanged_ParamsDataView::GetRequestIdDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->request_id.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}


inline void MediaControllerObserver_MediaSessionPositionChanged_ParamsDataView::GetPositionDataView(
    ::media_session::mojom::MediaPositionDataView* output) {
  auto pointer = data_->position.Get();
  *output = ::media_session::mojom::MediaPositionDataView(pointer, message_);
}


inline void MediaControllerImageObserver_MediaControllerImageChanged_ParamsDataView::GetBitmapDataView(
    ::media_session::mojom::MediaImageBitmapDataView* output) {
  auto pointer = data_->bitmap.Get();
  *output = ::media_session::mojom::MediaImageBitmapDataView(pointer, message_);
}


inline void MediaControllerImageObserver_MediaControllerChapterImageChanged_ParamsDataView::GetBitmapDataView(
    ::media_session::mojom::MediaImageBitmapDataView* output) {
  auto pointer = data_->bitmap.Get();
  *output = ::media_session::mojom::MediaImageBitmapDataView(pointer, message_);
}



}  // media_session::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // SERVICES_MEDIA_SESSION_PUBLIC_MOJOM_MEDIA_CONTROLLER_MOJOM_PARAMS_DATA_H_