// services/media_session/public/mojom/media_controller.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('mediaSession.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
mediaSession.mojom.MediaControllerManagerPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        mediaSession.mojom.MediaControllerManager.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { mediaSession.mojom.MediaControllerManagerInterface }
 */
mediaSession.mojom.MediaControllerManagerRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!mediaSession.mojom.MediaControllerManagerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          mediaSession.mojom.MediaControllerManagerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!mediaSession.mojom.MediaControllerManagerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !mediaSession.mojom.MediaControllerPendingReceiver } receiver
   * @param { !mojoBase.mojom.UnguessableToken } requestId
   */

  createMediaControllerForSession(
      receiver,
      requestId) {
    this.proxy.sendMessage(
        0,
        mediaSession.mojom.MediaControllerManager_CreateMediaControllerForSession_ParamsSpec.$,
        null,
        [
          receiver,
          requestId
        ],
        false);
  }

  
  /**
   * @param { !mediaSession.mojom.MediaControllerPendingReceiver } receiver
   */

  createActiveMediaController(
      receiver) {
    this.proxy.sendMessage(
        1,
        mediaSession.mojom.MediaControllerManager_CreateActiveMediaController_ParamsSpec.$,
        null,
        [
          receiver
        ],
        false);
  }

  
  /**
   */

  suspendAllSessions() {
    this.proxy.sendMessage(
        2,
        mediaSession.mojom.MediaControllerManager_SuspendAllSessions_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the MediaControllerManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
mediaSession.mojom.MediaControllerManagerReceiver = class {
  /**
   * @param {!mediaSession.mojom.MediaControllerManagerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!mediaSession.mojom.MediaControllerManagerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        mediaSession.mojom.MediaControllerManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!mediaSession.mojom.MediaControllerManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        mediaSession.mojom.MediaControllerManager_CreateMediaControllerForSession_ParamsSpec.$,
        null,
        impl.createMediaControllerForSession.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        mediaSession.mojom.MediaControllerManager_CreateActiveMediaController_ParamsSpec.$,
        null,
        impl.createActiveMediaController.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        mediaSession.mojom.MediaControllerManager_SuspendAllSessions_ParamsSpec.$,
        null,
        impl.suspendAllSessions.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
mediaSession.mojom.MediaControllerManager = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media_session.mojom.MediaControllerManager";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!mediaSession.mojom.MediaControllerManagerRemote}
   * @export
   */
  static getRemote() {
    let remote = new mediaSession.mojom.MediaControllerManagerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the MediaControllerManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
mediaSession.mojom.MediaControllerManagerCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      mediaSession.mojom.MediaControllerManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!mediaSession.mojom.MediaControllerManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createMediaControllerForSession =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        mediaSession.mojom.MediaControllerManager_CreateMediaControllerForSession_ParamsSpec.$,
        null,
        this.createMediaControllerForSession.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createActiveMediaController =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        mediaSession.mojom.MediaControllerManager_CreateActiveMediaController_ParamsSpec.$,
        null,
        this.createActiveMediaController.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.suspendAllSessions =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        mediaSession.mojom.MediaControllerManager_SuspendAllSessions_ParamsSpec.$,
        null,
        this.suspendAllSessions.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
mediaSession.mojom.MediaControllerPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        mediaSession.mojom.MediaController.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { mediaSession.mojom.MediaControllerInterface }
 */
mediaSession.mojom.MediaControllerRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!mediaSession.mojom.MediaControllerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          mediaSession.mojom.MediaControllerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!mediaSession.mojom.MediaControllerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  suspend() {
    this.proxy.sendMessage(
        0,
        mediaSession.mojom.MediaController_Suspend_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  resume() {
    this.proxy.sendMessage(
        1,
        mediaSession.mojom.MediaController_Resume_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  stop() {
    this.proxy.sendMessage(
        2,
        mediaSession.mojom.MediaController_Stop_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  toggleSuspendResume() {
    this.proxy.sendMessage(
        3,
        mediaSession.mojom.MediaController_ToggleSuspendResume_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !mediaSession.mojom.MediaControllerObserverRemote } observer
   */

  addObserver(
      observer) {
    this.proxy.sendMessage(
        4,
        mediaSession.mojom.MediaController_AddObserver_ParamsSpec.$,
        null,
        [
          observer
        ],
        false);
  }

  
  /**
   */

  previousTrack() {
    this.proxy.sendMessage(
        5,
        mediaSession.mojom.MediaController_PreviousTrack_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  nextTrack() {
    this.proxy.sendMessage(
        6,
        mediaSession.mojom.MediaController_NextTrack_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.TimeDelta } seekTime
   */

  seek(
      seekTime) {
    this.proxy.sendMessage(
        7,
        mediaSession.mojom.MediaController_Seek_ParamsSpec.$,
        null,
        [
          seekTime
        ],
        false);
  }

  
  /**
   * @param { !mediaSession.mojom.MediaSessionImageType } type
   * @param { !number } minimumSizePx
   * @param { !number } desiredSizePx
   * @param { !mediaSession.mojom.MediaControllerImageObserverRemote } observer
   */

  observeImages(
      type,
      minimumSizePx,
      desiredSizePx,
      observer) {
    this.proxy.sendMessage(
        8,
        mediaSession.mojom.MediaController_ObserveImages_ParamsSpec.$,
        null,
        [
          type,
          minimumSizePx,
          desiredSizePx,
          observer
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.TimeDelta } seekTime
   */

  seekTo(
      seekTime) {
    this.proxy.sendMessage(
        9,
        mediaSession.mojom.MediaController_SeekTo_ParamsSpec.$,
        null,
        [
          seekTime
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.TimeDelta } seekTime
   */

  scrubTo(
      seekTime) {
    this.proxy.sendMessage(
        10,
        mediaSession.mojom.MediaController_ScrubTo_ParamsSpec.$,
        null,
        [
          seekTime
        ],
        false);
  }

  
  /**
   */

  enterPictureInPicture() {
    this.proxy.sendMessage(
        11,
        mediaSession.mojom.MediaController_EnterPictureInPicture_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  exitPictureInPicture() {
    this.proxy.sendMessage(
        12,
        mediaSession.mojom.MediaController_ExitPictureInPicture_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { ?string } id
   */

  setAudioSinkId(
      id) {
    this.proxy.sendMessage(
        13,
        mediaSession.mojom.MediaController_SetAudioSinkId_ParamsSpec.$,
        null,
        [
          id
        ],
        false);
  }

  
  /**
   */

  toggleMicrophone() {
    this.proxy.sendMessage(
        14,
        mediaSession.mojom.MediaController_ToggleMicrophone_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  toggleCamera() {
    this.proxy.sendMessage(
        15,
        mediaSession.mojom.MediaController_ToggleCamera_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  hangUp() {
    this.proxy.sendMessage(
        16,
        mediaSession.mojom.MediaController_HangUp_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  raise() {
    this.proxy.sendMessage(
        17,
        mediaSession.mojom.MediaController_Raise_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !boolean } mute
   */

  setMute(
      mute) {
    this.proxy.sendMessage(
        18,
        mediaSession.mojom.MediaController_SetMute_ParamsSpec.$,
        null,
        [
          mute
        ],
        false);
  }

  
  /**
   */

  requestMediaRemoting() {
    this.proxy.sendMessage(
        19,
        mediaSession.mojom.MediaController_RequestMediaRemoting_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  enterAutoPictureInPicture() {
    this.proxy.sendMessage(
        20,
        mediaSession.mojom.MediaController_EnterAutoPictureInPicture_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  skipAd() {
    this.proxy.sendMessage(
        21,
        mediaSession.mojom.MediaController_SkipAd_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the MediaController
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
mediaSession.mojom.MediaControllerReceiver = class {
  /**
   * @param {!mediaSession.mojom.MediaControllerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!mediaSession.mojom.MediaControllerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        mediaSession.mojom.MediaControllerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!mediaSession.mojom.MediaControllerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        mediaSession.mojom.MediaController_Suspend_ParamsSpec.$,
        null,
        impl.suspend.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        mediaSession.mojom.MediaController_Resume_ParamsSpec.$,
        null,
        impl.resume.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        mediaSession.mojom.MediaController_Stop_ParamsSpec.$,
        null,
        impl.stop.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        mediaSession.mojom.MediaController_ToggleSuspendResume_ParamsSpec.$,
        null,
        impl.toggleSuspendResume.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        mediaSession.mojom.MediaController_AddObserver_ParamsSpec.$,
        null,
        impl.addObserver.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        mediaSession.mojom.MediaController_PreviousTrack_ParamsSpec.$,
        null,
        impl.previousTrack.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        mediaSession.mojom.MediaController_NextTrack_ParamsSpec.$,
        null,
        impl.nextTrack.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        mediaSession.mojom.MediaController_Seek_ParamsSpec.$,
        null,
        impl.seek.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        mediaSession.mojom.MediaController_ObserveImages_ParamsSpec.$,
        null,
        impl.observeImages.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        mediaSession.mojom.MediaController_SeekTo_ParamsSpec.$,
        null,
        impl.seekTo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        mediaSession.mojom.MediaController_ScrubTo_ParamsSpec.$,
        null,
        impl.scrubTo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        mediaSession.mojom.MediaController_EnterPictureInPicture_ParamsSpec.$,
        null,
        impl.enterPictureInPicture.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        mediaSession.mojom.MediaController_ExitPictureInPicture_ParamsSpec.$,
        null,
        impl.exitPictureInPicture.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        mediaSession.mojom.MediaController_SetAudioSinkId_ParamsSpec.$,
        null,
        impl.setAudioSinkId.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        14,
        mediaSession.mojom.MediaController_ToggleMicrophone_ParamsSpec.$,
        null,
        impl.toggleMicrophone.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        15,
        mediaSession.mojom.MediaController_ToggleCamera_ParamsSpec.$,
        null,
        impl.toggleCamera.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        16,
        mediaSession.mojom.MediaController_HangUp_ParamsSpec.$,
        null,
        impl.hangUp.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        17,
        mediaSession.mojom.MediaController_Raise_ParamsSpec.$,
        null,
        impl.raise.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        18,
        mediaSession.mojom.MediaController_SetMute_ParamsSpec.$,
        null,
        impl.setMute.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        19,
        mediaSession.mojom.MediaController_RequestMediaRemoting_ParamsSpec.$,
        null,
        impl.requestMediaRemoting.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        20,
        mediaSession.mojom.MediaController_EnterAutoPictureInPicture_ParamsSpec.$,
        null,
        impl.enterAutoPictureInPicture.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        21,
        mediaSession.mojom.MediaController_SkipAd_ParamsSpec.$,
        null,
        impl.skipAd.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
mediaSession.mojom.MediaController = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media_session.mojom.MediaController";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!mediaSession.mojom.MediaControllerRemote}
   * @export
   */
  static getRemote() {
    let remote = new mediaSession.mojom.MediaControllerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the MediaController
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
mediaSession.mojom.MediaControllerCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      mediaSession.mojom.MediaControllerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!mediaSession.mojom.MediaControllerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.suspend =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        mediaSession.mojom.MediaController_Suspend_ParamsSpec.$,
        null,
        this.suspend.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.resume =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        mediaSession.mojom.MediaController_Resume_ParamsSpec.$,
        null,
        this.resume.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.stop =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        mediaSession.mojom.MediaController_Stop_ParamsSpec.$,
        null,
        this.stop.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.toggleSuspendResume =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        mediaSession.mojom.MediaController_ToggleSuspendResume_ParamsSpec.$,
        null,
        this.toggleSuspendResume.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addObserver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        mediaSession.mojom.MediaController_AddObserver_ParamsSpec.$,
        null,
        this.addObserver.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.previousTrack =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        mediaSession.mojom.MediaController_PreviousTrack_ParamsSpec.$,
        null,
        this.previousTrack.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.nextTrack =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        mediaSession.mojom.MediaController_NextTrack_ParamsSpec.$,
        null,
        this.nextTrack.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.seek =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        mediaSession.mojom.MediaController_Seek_ParamsSpec.$,
        null,
        this.seek.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.observeImages =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        mediaSession.mojom.MediaController_ObserveImages_ParamsSpec.$,
        null,
        this.observeImages.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.seekTo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        mediaSession.mojom.MediaController_SeekTo_ParamsSpec.$,
        null,
        this.seekTo.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.scrubTo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        mediaSession.mojom.MediaController_ScrubTo_ParamsSpec.$,
        null,
        this.scrubTo.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.enterPictureInPicture =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        mediaSession.mojom.MediaController_EnterPictureInPicture_ParamsSpec.$,
        null,
        this.enterPictureInPicture.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.exitPictureInPicture =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        mediaSession.mojom.MediaController_ExitPictureInPicture_ParamsSpec.$,
        null,
        this.exitPictureInPicture.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setAudioSinkId =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        mediaSession.mojom.MediaController_SetAudioSinkId_ParamsSpec.$,
        null,
        this.setAudioSinkId.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.toggleMicrophone =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        14,
        mediaSession.mojom.MediaController_ToggleMicrophone_ParamsSpec.$,
        null,
        this.toggleMicrophone.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.toggleCamera =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        15,
        mediaSession.mojom.MediaController_ToggleCamera_ParamsSpec.$,
        null,
        this.toggleCamera.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.hangUp =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        16,
        mediaSession.mojom.MediaController_HangUp_ParamsSpec.$,
        null,
        this.hangUp.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.raise =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        17,
        mediaSession.mojom.MediaController_Raise_ParamsSpec.$,
        null,
        this.raise.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setMute =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        18,
        mediaSession.mojom.MediaController_SetMute_ParamsSpec.$,
        null,
        this.setMute.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestMediaRemoting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        19,
        mediaSession.mojom.MediaController_RequestMediaRemoting_ParamsSpec.$,
        null,
        this.requestMediaRemoting.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.enterAutoPictureInPicture =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        20,
        mediaSession.mojom.MediaController_EnterAutoPictureInPicture_ParamsSpec.$,
        null,
        this.enterAutoPictureInPicture.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.skipAd =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        21,
        mediaSession.mojom.MediaController_SkipAd_ParamsSpec.$,
        null,
        this.skipAd.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
mediaSession.mojom.MediaControllerObserverPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        mediaSession.mojom.MediaControllerObserver.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { mediaSession.mojom.MediaControllerObserverInterface }
 */
mediaSession.mojom.MediaControllerObserverRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!mediaSession.mojom.MediaControllerObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          mediaSession.mojom.MediaControllerObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!mediaSession.mojom.MediaControllerObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { ?mediaSession.mojom.MediaSessionInfo } info
   */

  mediaSessionInfoChanged(
      info) {
    this.proxy.sendMessage(
        0,
        mediaSession.mojom.MediaControllerObserver_MediaSessionInfoChanged_ParamsSpec.$,
        null,
        [
          info
        ],
        false);
  }

  
  /**
   * @param { ?mediaSession.mojom.MediaMetadata } metadata
   */

  mediaSessionMetadataChanged(
      metadata) {
    this.proxy.sendMessage(
        1,
        mediaSession.mojom.MediaControllerObserver_MediaSessionMetadataChanged_ParamsSpec.$,
        null,
        [
          metadata
        ],
        false);
  }

  
  /**
   * @param { !Array<!mediaSession.mojom.MediaSessionAction> } action
   */

  mediaSessionActionsChanged(
      action) {
    this.proxy.sendMessage(
        2,
        mediaSession.mojom.MediaControllerObserver_MediaSessionActionsChanged_ParamsSpec.$,
        null,
        [
          action
        ],
        false);
  }

  
  /**
   * @param { ?mojoBase.mojom.UnguessableToken } requestId
   */

  mediaSessionChanged(
      requestId) {
    this.proxy.sendMessage(
        3,
        mediaSession.mojom.MediaControllerObserver_MediaSessionChanged_ParamsSpec.$,
        null,
        [
          requestId
        ],
        false);
  }

  
  /**
   * @param { ?mediaSession.mojom.MediaPosition } position
   */

  mediaSessionPositionChanged(
      position) {
    this.proxy.sendMessage(
        4,
        mediaSession.mojom.MediaControllerObserver_MediaSessionPositionChanged_ParamsSpec.$,
        null,
        [
          position
        ],
        false);
  }
};

/**
 * An object which receives request messages for the MediaControllerObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
mediaSession.mojom.MediaControllerObserverReceiver = class {
  /**
   * @param {!mediaSession.mojom.MediaControllerObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!mediaSession.mojom.MediaControllerObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        mediaSession.mojom.MediaControllerObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!mediaSession.mojom.MediaControllerObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        mediaSession.mojom.MediaControllerObserver_MediaSessionInfoChanged_ParamsSpec.$,
        null,
        impl.mediaSessionInfoChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        mediaSession.mojom.MediaControllerObserver_MediaSessionMetadataChanged_ParamsSpec.$,
        null,
        impl.mediaSessionMetadataChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        mediaSession.mojom.MediaControllerObserver_MediaSessionActionsChanged_ParamsSpec.$,
        null,
        impl.mediaSessionActionsChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        mediaSession.mojom.MediaControllerObserver_MediaSessionChanged_ParamsSpec.$,
        null,
        impl.mediaSessionChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        mediaSession.mojom.MediaControllerObserver_MediaSessionPositionChanged_ParamsSpec.$,
        null,
        impl.mediaSessionPositionChanged.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
mediaSession.mojom.MediaControllerObserver = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media_session.mojom.MediaControllerObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!mediaSession.mojom.MediaControllerObserverRemote}
   * @export
   */
  static getRemote() {
    let remote = new mediaSession.mojom.MediaControllerObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the MediaControllerObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
mediaSession.mojom.MediaControllerObserverCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      mediaSession.mojom.MediaControllerObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!mediaSession.mojom.MediaControllerObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.mediaSessionInfoChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        mediaSession.mojom.MediaControllerObserver_MediaSessionInfoChanged_ParamsSpec.$,
        null,
        this.mediaSessionInfoChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.mediaSessionMetadataChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        mediaSession.mojom.MediaControllerObserver_MediaSessionMetadataChanged_ParamsSpec.$,
        null,
        this.mediaSessionMetadataChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.mediaSessionActionsChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        mediaSession.mojom.MediaControllerObserver_MediaSessionActionsChanged_ParamsSpec.$,
        null,
        this.mediaSessionActionsChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.mediaSessionChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        mediaSession.mojom.MediaControllerObserver_MediaSessionChanged_ParamsSpec.$,
        null,
        this.mediaSessionChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.mediaSessionPositionChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        mediaSession.mojom.MediaControllerObserver_MediaSessionPositionChanged_ParamsSpec.$,
        null,
        this.mediaSessionPositionChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
mediaSession.mojom.MediaControllerImageObserverPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        mediaSession.mojom.MediaControllerImageObserver.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { mediaSession.mojom.MediaControllerImageObserverInterface }
 */
mediaSession.mojom.MediaControllerImageObserverRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!mediaSession.mojom.MediaControllerImageObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          mediaSession.mojom.MediaControllerImageObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!mediaSession.mojom.MediaControllerImageObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !mediaSession.mojom.MediaSessionImageType } type
   * @param { ?mediaSession.mojom.MediaImageBitmap } bitmap
   */

  mediaControllerImageChanged(
      type,
      bitmap) {
    this.proxy.sendMessage(
        0,
        mediaSession.mojom.MediaControllerImageObserver_MediaControllerImageChanged_ParamsSpec.$,
        null,
        [
          type,
          bitmap
        ],
        false);
  }

  
  /**
   * @param { !number } index
   * @param { ?mediaSession.mojom.MediaImageBitmap } bitmap
   */

  mediaControllerChapterImageChanged(
      index,
      bitmap) {
    this.proxy.sendMessage(
        1,
        mediaSession.mojom.MediaControllerImageObserver_MediaControllerChapterImageChanged_ParamsSpec.$,
        null,
        [
          index,
          bitmap
        ],
        false);
  }
};

/**
 * An object which receives request messages for the MediaControllerImageObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
mediaSession.mojom.MediaControllerImageObserverReceiver = class {
  /**
   * @param {!mediaSession.mojom.MediaControllerImageObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!mediaSession.mojom.MediaControllerImageObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        mediaSession.mojom.MediaControllerImageObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!mediaSession.mojom.MediaControllerImageObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        mediaSession.mojom.MediaControllerImageObserver_MediaControllerImageChanged_ParamsSpec.$,
        null,
        impl.mediaControllerImageChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        mediaSession.mojom.MediaControllerImageObserver_MediaControllerChapterImageChanged_ParamsSpec.$,
        null,
        impl.mediaControllerChapterImageChanged.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
mediaSession.mojom.MediaControllerImageObserver = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media_session.mojom.MediaControllerImageObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!mediaSession.mojom.MediaControllerImageObserverRemote}
   * @export
   */
  static getRemote() {
    let remote = new mediaSession.mojom.MediaControllerImageObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the MediaControllerImageObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
mediaSession.mojom.MediaControllerImageObserverCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      mediaSession.mojom.MediaControllerImageObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!mediaSession.mojom.MediaControllerImageObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.mediaControllerImageChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        mediaSession.mojom.MediaControllerImageObserver_MediaControllerImageChanged_ParamsSpec.$,
        null,
        this.mediaControllerImageChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.mediaControllerChapterImageChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        mediaSession.mojom.MediaControllerImageObserver_MediaControllerChapterImageChanged_ParamsSpec.$,
        null,
        this.mediaControllerChapterImageChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaControllerManager_CreateMediaControllerForSession_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaControllerManager_CreateActiveMediaController_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaControllerManager_SuspendAllSessions_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaController_Suspend_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaController_Resume_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaController_Stop_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaController_ToggleSuspendResume_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaController_AddObserver_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaController_PreviousTrack_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaController_NextTrack_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaController_Seek_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaController_ObserveImages_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaController_SeekTo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaController_ScrubTo_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaController_EnterPictureInPicture_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaController_ExitPictureInPicture_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaController_SetAudioSinkId_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaController_ToggleMicrophone_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaController_ToggleCamera_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaController_HangUp_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaController_Raise_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaController_SetMute_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaController_RequestMediaRemoting_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaController_EnterAutoPictureInPicture_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaController_SkipAd_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaControllerObserver_MediaSessionInfoChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaControllerObserver_MediaSessionMetadataChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaControllerObserver_MediaSessionActionsChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaControllerObserver_MediaSessionChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaControllerObserver_MediaSessionPositionChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaControllerImageObserver_MediaControllerImageChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.MediaControllerImageObserver_MediaControllerChapterImageChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    mediaSession.mojom.MediaControllerManager_CreateMediaControllerForSession_ParamsSpec.$,
    'MediaControllerManager_CreateMediaControllerForSession_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(mediaSession.mojom.MediaControllerPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'requestId', 8,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
mediaSession.mojom.MediaControllerManager_CreateMediaControllerForSession_Params = class {
  constructor() {
    /** @export { !mediaSession.mojom.MediaControllerPendingReceiver } */
    this.receiver;
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.requestId;
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaControllerManager_CreateActiveMediaController_ParamsSpec.$,
    'MediaControllerManager_CreateActiveMediaController_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(mediaSession.mojom.MediaControllerPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
mediaSession.mojom.MediaControllerManager_CreateActiveMediaController_Params = class {
  constructor() {
    /** @export { !mediaSession.mojom.MediaControllerPendingReceiver } */
    this.receiver;
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaControllerManager_SuspendAllSessions_ParamsSpec.$,
    'MediaControllerManager_SuspendAllSessions_Params',
    [
    ],
    [[0, 8],]);





/** @record */
mediaSession.mojom.MediaControllerManager_SuspendAllSessions_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaController_Suspend_ParamsSpec.$,
    'MediaController_Suspend_Params',
    [
    ],
    [[0, 8],]);





/** @record */
mediaSession.mojom.MediaController_Suspend_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaController_Resume_ParamsSpec.$,
    'MediaController_Resume_Params',
    [
    ],
    [[0, 8],]);





/** @record */
mediaSession.mojom.MediaController_Resume_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaController_Stop_ParamsSpec.$,
    'MediaController_Stop_Params',
    [
    ],
    [[0, 8],]);





/** @record */
mediaSession.mojom.MediaController_Stop_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaController_ToggleSuspendResume_ParamsSpec.$,
    'MediaController_ToggleSuspendResume_Params',
    [
    ],
    [[0, 8],]);





/** @record */
mediaSession.mojom.MediaController_ToggleSuspendResume_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaController_AddObserver_ParamsSpec.$,
    'MediaController_AddObserver_Params',
    [
      mojo.internal.StructField(
        'observer', 0,
        0,
        mojo.internal.InterfaceProxy(mediaSession.mojom.MediaControllerObserverRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
mediaSession.mojom.MediaController_AddObserver_Params = class {
  constructor() {
    /** @export { !mediaSession.mojom.MediaControllerObserverRemote } */
    this.observer;
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaController_PreviousTrack_ParamsSpec.$,
    'MediaController_PreviousTrack_Params',
    [
    ],
    [[0, 8],]);





/** @record */
mediaSession.mojom.MediaController_PreviousTrack_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaController_NextTrack_ParamsSpec.$,
    'MediaController_NextTrack_Params',
    [
    ],
    [[0, 8],]);





/** @record */
mediaSession.mojom.MediaController_NextTrack_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaController_Seek_ParamsSpec.$,
    'MediaController_Seek_Params',
    [
      mojo.internal.StructField(
        'seekTime', 0,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
mediaSession.mojom.MediaController_Seek_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.TimeDelta } */
    this.seekTime;
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaController_ObserveImages_ParamsSpec.$,
    'MediaController_ObserveImages_Params',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        mediaSession.mojom.MediaSessionImageTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'minimumSizePx', 4,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'desiredSizePx', 8,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'observer', 12,
        0,
        mojo.internal.InterfaceProxy(mediaSession.mojom.MediaControllerImageObserverRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
mediaSession.mojom.MediaController_ObserveImages_Params = class {
  constructor() {
    /** @export { !mediaSession.mojom.MediaSessionImageType } */
    this.type;
    /** @export { !number } */
    this.minimumSizePx;
    /** @export { !number } */
    this.desiredSizePx;
    /** @export { !mediaSession.mojom.MediaControllerImageObserverRemote } */
    this.observer;
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaController_SeekTo_ParamsSpec.$,
    'MediaController_SeekTo_Params',
    [
      mojo.internal.StructField(
        'seekTime', 0,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
mediaSession.mojom.MediaController_SeekTo_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.TimeDelta } */
    this.seekTime;
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaController_ScrubTo_ParamsSpec.$,
    'MediaController_ScrubTo_Params',
    [
      mojo.internal.StructField(
        'seekTime', 0,
        0,
        mojoBase.mojom.TimeDeltaSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
mediaSession.mojom.MediaController_ScrubTo_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.TimeDelta } */
    this.seekTime;
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaController_EnterPictureInPicture_ParamsSpec.$,
    'MediaController_EnterPictureInPicture_Params',
    [
    ],
    [[0, 8],]);





/** @record */
mediaSession.mojom.MediaController_EnterPictureInPicture_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaController_ExitPictureInPicture_ParamsSpec.$,
    'MediaController_ExitPictureInPicture_Params',
    [
    ],
    [[0, 8],]);





/** @record */
mediaSession.mojom.MediaController_ExitPictureInPicture_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaController_SetAudioSinkId_ParamsSpec.$,
    'MediaController_SetAudioSinkId_Params',
    [
      mojo.internal.StructField(
        'id', 0,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
mediaSession.mojom.MediaController_SetAudioSinkId_Params = class {
  constructor() {
    /** @export { (string|undefined) } */
    this.id;
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaController_ToggleMicrophone_ParamsSpec.$,
    'MediaController_ToggleMicrophone_Params',
    [
    ],
    [[0, 8],]);





/** @record */
mediaSession.mojom.MediaController_ToggleMicrophone_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaController_ToggleCamera_ParamsSpec.$,
    'MediaController_ToggleCamera_Params',
    [
    ],
    [[0, 8],]);





/** @record */
mediaSession.mojom.MediaController_ToggleCamera_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaController_HangUp_ParamsSpec.$,
    'MediaController_HangUp_Params',
    [
    ],
    [[0, 8],]);





/** @record */
mediaSession.mojom.MediaController_HangUp_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaController_Raise_ParamsSpec.$,
    'MediaController_Raise_Params',
    [
    ],
    [[0, 8],]);





/** @record */
mediaSession.mojom.MediaController_Raise_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaController_SetMute_ParamsSpec.$,
    'MediaController_SetMute_Params',
    [
      mojo.internal.StructField(
        'mute', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
mediaSession.mojom.MediaController_SetMute_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.mute;
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaController_RequestMediaRemoting_ParamsSpec.$,
    'MediaController_RequestMediaRemoting_Params',
    [
    ],
    [[0, 8],]);





/** @record */
mediaSession.mojom.MediaController_RequestMediaRemoting_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaController_EnterAutoPictureInPicture_ParamsSpec.$,
    'MediaController_EnterAutoPictureInPicture_Params',
    [
    ],
    [[0, 8],]);





/** @record */
mediaSession.mojom.MediaController_EnterAutoPictureInPicture_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaController_SkipAd_ParamsSpec.$,
    'MediaController_SkipAd_Params',
    [
    ],
    [[0, 8],]);





/** @record */
mediaSession.mojom.MediaController_SkipAd_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaControllerObserver_MediaSessionInfoChanged_ParamsSpec.$,
    'MediaControllerObserver_MediaSessionInfoChanged_Params',
    [
      mojo.internal.StructField(
        'info', 0,
        0,
        mediaSession.mojom.MediaSessionInfoSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
mediaSession.mojom.MediaControllerObserver_MediaSessionInfoChanged_Params = class {
  constructor() {
    /** @export { (mediaSession.mojom.MediaSessionInfo|undefined) } */
    this.info;
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaControllerObserver_MediaSessionMetadataChanged_ParamsSpec.$,
    'MediaControllerObserver_MediaSessionMetadataChanged_Params',
    [
      mojo.internal.StructField(
        'metadata', 0,
        0,
        mediaSession.mojom.MediaMetadataSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
mediaSession.mojom.MediaControllerObserver_MediaSessionMetadataChanged_Params = class {
  constructor() {
    /** @export { (mediaSession.mojom.MediaMetadata|undefined) } */
    this.metadata;
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaControllerObserver_MediaSessionActionsChanged_ParamsSpec.$,
    'MediaControllerObserver_MediaSessionActionsChanged_Params',
    [
      mojo.internal.StructField(
        'action', 0,
        0,
        mojo.internal.Array(mediaSession.mojom.MediaSessionActionSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
mediaSession.mojom.MediaControllerObserver_MediaSessionActionsChanged_Params = class {
  constructor() {
    /** @export { !Array<!mediaSession.mojom.MediaSessionAction> } */
    this.action;
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaControllerObserver_MediaSessionChanged_ParamsSpec.$,
    'MediaControllerObserver_MediaSessionChanged_Params',
    [
      mojo.internal.StructField(
        'requestId', 0,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
mediaSession.mojom.MediaControllerObserver_MediaSessionChanged_Params = class {
  constructor() {
    /** @export { (mojoBase.mojom.UnguessableToken|undefined) } */
    this.requestId;
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaControllerObserver_MediaSessionPositionChanged_ParamsSpec.$,
    'MediaControllerObserver_MediaSessionPositionChanged_Params',
    [
      mojo.internal.StructField(
        'position', 0,
        0,
        mediaSession.mojom.MediaPositionSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
mediaSession.mojom.MediaControllerObserver_MediaSessionPositionChanged_Params = class {
  constructor() {
    /** @export { (mediaSession.mojom.MediaPosition|undefined) } */
    this.position;
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaControllerImageObserver_MediaControllerImageChanged_ParamsSpec.$,
    'MediaControllerImageObserver_MediaControllerImageChanged_Params',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        mediaSession.mojom.MediaSessionImageTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'bitmap', 8,
        0,
        mediaSession.mojom.MediaImageBitmapSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
mediaSession.mojom.MediaControllerImageObserver_MediaControllerImageChanged_Params = class {
  constructor() {
    /** @export { !mediaSession.mojom.MediaSessionImageType } */
    this.type;
    /** @export { (mediaSession.mojom.MediaImageBitmap|undefined) } */
    this.bitmap;
  }
};



mojo.internal.Struct(
    mediaSession.mojom.MediaControllerImageObserver_MediaControllerChapterImageChanged_ParamsSpec.$,
    'MediaControllerImageObserver_MediaControllerChapterImageChanged_Params',
    [
      mojo.internal.StructField(
        'index', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'bitmap', 8,
        0,
        mediaSession.mojom.MediaImageBitmapSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
mediaSession.mojom.MediaControllerImageObserver_MediaControllerChapterImageChanged_Params = class {
  constructor() {
    /** @export { !number } */
    this.index;
    /** @export { (mediaSession.mojom.MediaImageBitmap|undefined) } */
    this.bitmap;
  }
};

