// services/media_session/public/mojom/audio_focus.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  UnguessableToken as mojoBase_mojom_UnguessableToken,
  UnguessableTokenSpec as mojoBase_mojom_UnguessableTokenSpec
} from '../../../../mojo/public/mojom/base/unguessable_token.mojom.m.js';

import {
  MediaSessionRemote as mediaSession_mojom_MediaSessionRemote,
  MediaSessionPendingReceiver as mediaSession_mojom_MediaSessionPendingReceiver,
  MediaSessionDebugInfo as mediaSession_mojom_MediaSessionDebugInfo,
  MediaSessionDebugInfoSpec as mediaSession_mojom_MediaSessionDebugInfoSpec,
  MediaSessionInfo as mediaSession_mojom_MediaSessionInfo,
  MediaSessionInfoSpec as mediaSession_mojom_MediaSessionInfoSpec
} from './media_session.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const EnforcementModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const EnforcementMode = {
  
  kDefault: 0,
  kNone: 1,
  kSingleGroup: 2,
  kSingleSession: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const AudioFocusTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const AudioFocusType = {
  
  kGain: 0,
  kGainTransientMayDuck: 1,
  kGainTransient: 2,
  kAmbient: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class AudioFocusObserverPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media_session.mojom.AudioFocusObserver', scope);
  }
}

/** @interface */
export class AudioFocusObserverInterface {
  
  /**
   * @param { !AudioFocusRequestState } state
   */

  onFocusGained(state) {}
  
  /**
   * @param { !AudioFocusRequestState } state
   */

  onFocusLost(state) {}
  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } requestId
   */

  onRequestIdReleased(requestId) {}
}

/**
 * @implements { AudioFocusObserverInterface }
 */
export class AudioFocusObserverRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!AudioFocusObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          AudioFocusObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!AudioFocusObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !AudioFocusRequestState } state
   */

  onFocusGained(
      state) {
    this.proxy.sendMessage(
        0,
        AudioFocusObserver_OnFocusGained_ParamsSpec.$,
        null,
        [
          state
        ],
        false);
  }

  
  /**
   * @param { !AudioFocusRequestState } state
   */

  onFocusLost(
      state) {
    this.proxy.sendMessage(
        1,
        AudioFocusObserver_OnFocusLost_ParamsSpec.$,
        null,
        [
          state
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } requestId
   */

  onRequestIdReleased(
      requestId) {
    this.proxy.sendMessage(
        2,
        AudioFocusObserver_OnRequestIdReleased_ParamsSpec.$,
        null,
        [
          requestId
        ],
        false);
  }
}

/**
 * An object which receives request messages for the AudioFocusObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AudioFocusObserverReceiver {
  /**
   * @param {!AudioFocusObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!AudioFocusObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        AudioFocusObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AudioFocusObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        AudioFocusObserver_OnFocusGained_ParamsSpec.$,
        null,
        impl.onFocusGained.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        AudioFocusObserver_OnFocusLost_ParamsSpec.$,
        null,
        impl.onFocusLost.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        AudioFocusObserver_OnRequestIdReleased_ParamsSpec.$,
        null,
        impl.onRequestIdReleased.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class AudioFocusObserver {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media_session.mojom.AudioFocusObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!AudioFocusObserverRemote}
   */
  static getRemote() {
    let remote = new AudioFocusObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the AudioFocusObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AudioFocusObserverCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      AudioFocusObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AudioFocusObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onFocusGained =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        AudioFocusObserver_OnFocusGained_ParamsSpec.$,
        null,
        this.onFocusGained.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onFocusLost =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        AudioFocusObserver_OnFocusLost_ParamsSpec.$,
        null,
        this.onFocusLost.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onRequestIdReleased =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        AudioFocusObserver_OnRequestIdReleased_ParamsSpec.$,
        null,
        this.onRequestIdReleased.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class AudioFocusRequestClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media_session.mojom.AudioFocusRequestClient', scope);
  }
}

/** @interface */
export class AudioFocusRequestClientInterface {
  
  /**
   * @param { !mediaSession_mojom_MediaSessionInfo } sessionInfo
   * @param { !AudioFocusType } type
   * @return {!Promise}
   */

  requestAudioFocus(sessionInfo, type) {}
  
  /**
   */

  abandonAudioFocus() {}
  
  /**
   * @param { !mediaSession_mojom_MediaSessionInfo } sessionInfo
   */

  mediaSessionInfoChanged(sessionInfo) {}
}

/**
 * @implements { AudioFocusRequestClientInterface }
 */
export class AudioFocusRequestClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!AudioFocusRequestClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          AudioFocusRequestClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!AudioFocusRequestClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !mediaSession_mojom_MediaSessionInfo } sessionInfo
   * @param { !AudioFocusType } type
   * @return {!Promise}
   */

  requestAudioFocus(
      sessionInfo,
      type) {
    return this.proxy.sendMessage(
        0,
        AudioFocusRequestClient_RequestAudioFocus_ParamsSpec.$,
        AudioFocusRequestClient_RequestAudioFocus_ResponseParamsSpec.$,
        [
          sessionInfo,
          type
        ],
        false);
  }

  
  /**
   */

  abandonAudioFocus() {
    this.proxy.sendMessage(
        1,
        AudioFocusRequestClient_AbandonAudioFocus_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !mediaSession_mojom_MediaSessionInfo } sessionInfo
   */

  mediaSessionInfoChanged(
      sessionInfo) {
    this.proxy.sendMessage(
        2,
        AudioFocusRequestClient_MediaSessionInfoChanged_ParamsSpec.$,
        null,
        [
          sessionInfo
        ],
        false);
  }
}

/**
 * An object which receives request messages for the AudioFocusRequestClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AudioFocusRequestClientReceiver {
  /**
   * @param {!AudioFocusRequestClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!AudioFocusRequestClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        AudioFocusRequestClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AudioFocusRequestClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        AudioFocusRequestClient_RequestAudioFocus_ParamsSpec.$,
        AudioFocusRequestClient_RequestAudioFocus_ResponseParamsSpec.$,
        impl.requestAudioFocus.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        AudioFocusRequestClient_AbandonAudioFocus_ParamsSpec.$,
        null,
        impl.abandonAudioFocus.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        AudioFocusRequestClient_MediaSessionInfoChanged_ParamsSpec.$,
        null,
        impl.mediaSessionInfoChanged.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class AudioFocusRequestClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media_session.mojom.AudioFocusRequestClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!AudioFocusRequestClientRemote}
   */
  static getRemote() {
    let remote = new AudioFocusRequestClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the AudioFocusRequestClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AudioFocusRequestClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      AudioFocusRequestClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AudioFocusRequestClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestAudioFocus =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        AudioFocusRequestClient_RequestAudioFocus_ParamsSpec.$,
        AudioFocusRequestClient_RequestAudioFocus_ResponseParamsSpec.$,
        this.requestAudioFocus.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.abandonAudioFocus =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        AudioFocusRequestClient_AbandonAudioFocus_ParamsSpec.$,
        null,
        this.abandonAudioFocus.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.mediaSessionInfoChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        AudioFocusRequestClient_MediaSessionInfoChanged_ParamsSpec.$,
        null,
        this.mediaSessionInfoChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class AudioFocusManagerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media_session.mojom.AudioFocusManager', scope);
  }
}

/** @interface */
export class AudioFocusManagerInterface {
  
  /**
   * @param { !AudioFocusRequestClientPendingReceiver } client
   * @param { !mediaSession_mojom_MediaSessionRemote } session
   * @param { !mediaSession_mojom_MediaSessionInfo } sessionInfo
   * @param { !AudioFocusType } type
   * @return {!Promise<{
        requestId: !mojoBase_mojom_UnguessableToken,
   *  }>}
   */

  requestAudioFocus(client, session, sessionInfo, type) {}
  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } requestId
   * @param { !AudioFocusRequestClientPendingReceiver } client
   * @param { !mediaSession_mojom_MediaSessionRemote } session
   * @param { !mediaSession_mojom_MediaSessionInfo } sessionInfo
   * @param { !AudioFocusType } type
   * @param { !mojoBase_mojom_UnguessableToken } groupId
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  requestGroupedAudioFocus(requestId, client, session, sessionInfo, type, groupId) {}
  
  /**
   * @return {!Promise<{
        requests: !Array<!AudioFocusRequestState>,
   *  }>}
   */

  getFocusRequests() {}
  
  /**
   * @param { !AudioFocusObserverRemote } observer
   */

  addObserver(observer) {}
  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } identity
   * @param { !string } name
   */

  setSource(identity, name) {}
  
  /**
   * @param { !EnforcementMode } mode
   */

  setEnforcementMode(mode) {}
  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } sourceId
   * @param { !AudioFocusObserverRemote } observer
   */

  addSourceObserver(sourceId, observer) {}
  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } sourceId
   * @return {!Promise<{
        requests: !Array<!AudioFocusRequestState>,
   *  }>}
   */

  getSourceFocusRequests(sourceId) {}
  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } requestId
   */

  requestIdReleased(requestId) {}
  
  /**
   * @param { ?mojoBase_mojom_UnguessableToken } exemptedRequestId
   */

  startDuckingAllAudio(exemptedRequestId) {}
  
  /**
   */

  stopDuckingAllAudio() {}
  
  /**
   * @return {!Promise}
   */

  flushForTesting() {}
}

/**
 * @implements { AudioFocusManagerInterface }
 */
export class AudioFocusManagerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!AudioFocusManagerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          AudioFocusManagerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!AudioFocusManagerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !AudioFocusRequestClientPendingReceiver } client
   * @param { !mediaSession_mojom_MediaSessionRemote } session
   * @param { !mediaSession_mojom_MediaSessionInfo } sessionInfo
   * @param { !AudioFocusType } type
   * @return {!Promise<{
        requestId: !mojoBase_mojom_UnguessableToken,
   *  }>}
   */

  requestAudioFocus(
      client,
      session,
      sessionInfo,
      type) {
    return this.proxy.sendMessage(
        0,
        AudioFocusManager_RequestAudioFocus_ParamsSpec.$,
        AudioFocusManager_RequestAudioFocus_ResponseParamsSpec.$,
        [
          client,
          session,
          sessionInfo,
          type
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } requestId
   * @param { !AudioFocusRequestClientPendingReceiver } client
   * @param { !mediaSession_mojom_MediaSessionRemote } session
   * @param { !mediaSession_mojom_MediaSessionInfo } sessionInfo
   * @param { !AudioFocusType } type
   * @param { !mojoBase_mojom_UnguessableToken } groupId
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  requestGroupedAudioFocus(
      requestId,
      client,
      session,
      sessionInfo,
      type,
      groupId) {
    return this.proxy.sendMessage(
        4,
        AudioFocusManager_RequestGroupedAudioFocus_ParamsSpec.$,
        AudioFocusManager_RequestGroupedAudioFocus_ResponseParamsSpec.$,
        [
          requestId,
          client,
          session,
          sessionInfo,
          type,
          groupId
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        requests: !Array<!AudioFocusRequestState>,
   *  }>}
   */

  getFocusRequests() {
    return this.proxy.sendMessage(
        1,
        AudioFocusManager_GetFocusRequests_ParamsSpec.$,
        AudioFocusManager_GetFocusRequests_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !AudioFocusObserverRemote } observer
   */

  addObserver(
      observer) {
    this.proxy.sendMessage(
        2,
        AudioFocusManager_AddObserver_ParamsSpec.$,
        null,
        [
          observer
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } identity
   * @param { !string } name
   */

  setSource(
      identity,
      name) {
    this.proxy.sendMessage(
        6,
        AudioFocusManager_SetSource_ParamsSpec.$,
        null,
        [
          identity,
          name
        ],
        false);
  }

  
  /**
   * @param { !EnforcementMode } mode
   */

  setEnforcementMode(
      mode) {
    this.proxy.sendMessage(
        5,
        AudioFocusManager_SetEnforcementMode_ParamsSpec.$,
        null,
        [
          mode
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } sourceId
   * @param { !AudioFocusObserverRemote } observer
   */

  addSourceObserver(
      sourceId,
      observer) {
    this.proxy.sendMessage(
        7,
        AudioFocusManager_AddSourceObserver_ParamsSpec.$,
        null,
        [
          sourceId,
          observer
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } sourceId
   * @return {!Promise<{
        requests: !Array<!AudioFocusRequestState>,
   *  }>}
   */

  getSourceFocusRequests(
      sourceId) {
    return this.proxy.sendMessage(
        8,
        AudioFocusManager_GetSourceFocusRequests_ParamsSpec.$,
        AudioFocusManager_GetSourceFocusRequests_ResponseParamsSpec.$,
        [
          sourceId
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } requestId
   */

  requestIdReleased(
      requestId) {
    this.proxy.sendMessage(
        9,
        AudioFocusManager_RequestIdReleased_ParamsSpec.$,
        null,
        [
          requestId
        ],
        false);
  }

  
  /**
   * @param { ?mojoBase_mojom_UnguessableToken } exemptedRequestId
   */

  startDuckingAllAudio(
      exemptedRequestId) {
    this.proxy.sendMessage(
        10,
        AudioFocusManager_StartDuckingAllAudio_ParamsSpec.$,
        null,
        [
          exemptedRequestId
        ],
        false);
  }

  
  /**
   */

  stopDuckingAllAudio() {
    this.proxy.sendMessage(
        11,
        AudioFocusManager_StopDuckingAllAudio_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  flushForTesting() {
    return this.proxy.sendMessage(
        12,
        AudioFocusManager_FlushForTesting_ParamsSpec.$,
        AudioFocusManager_FlushForTesting_ResponseParamsSpec.$,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the AudioFocusManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AudioFocusManagerReceiver {
  /**
   * @param {!AudioFocusManagerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!AudioFocusManagerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        AudioFocusManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AudioFocusManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        AudioFocusManager_RequestAudioFocus_ParamsSpec.$,
        AudioFocusManager_RequestAudioFocus_ResponseParamsSpec.$,
        impl.requestAudioFocus.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        AudioFocusManager_RequestGroupedAudioFocus_ParamsSpec.$,
        AudioFocusManager_RequestGroupedAudioFocus_ResponseParamsSpec.$,
        impl.requestGroupedAudioFocus.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        AudioFocusManager_GetFocusRequests_ParamsSpec.$,
        AudioFocusManager_GetFocusRequests_ResponseParamsSpec.$,
        impl.getFocusRequests.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        AudioFocusManager_AddObserver_ParamsSpec.$,
        null,
        impl.addObserver.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        AudioFocusManager_SetSource_ParamsSpec.$,
        null,
        impl.setSource.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        AudioFocusManager_SetEnforcementMode_ParamsSpec.$,
        null,
        impl.setEnforcementMode.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        AudioFocusManager_AddSourceObserver_ParamsSpec.$,
        null,
        impl.addSourceObserver.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        AudioFocusManager_GetSourceFocusRequests_ParamsSpec.$,
        AudioFocusManager_GetSourceFocusRequests_ResponseParamsSpec.$,
        impl.getSourceFocusRequests.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        AudioFocusManager_RequestIdReleased_ParamsSpec.$,
        null,
        impl.requestIdReleased.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        AudioFocusManager_StartDuckingAllAudio_ParamsSpec.$,
        null,
        impl.startDuckingAllAudio.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        AudioFocusManager_StopDuckingAllAudio_ParamsSpec.$,
        null,
        impl.stopDuckingAllAudio.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        AudioFocusManager_FlushForTesting_ParamsSpec.$,
        AudioFocusManager_FlushForTesting_ResponseParamsSpec.$,
        impl.flushForTesting.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class AudioFocusManager {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media_session.mojom.AudioFocusManager";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!AudioFocusManagerRemote}
   */
  static getRemote() {
    let remote = new AudioFocusManagerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the AudioFocusManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AudioFocusManagerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      AudioFocusManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AudioFocusManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestAudioFocus =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        AudioFocusManager_RequestAudioFocus_ParamsSpec.$,
        AudioFocusManager_RequestAudioFocus_ResponseParamsSpec.$,
        this.requestAudioFocus.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestGroupedAudioFocus =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        AudioFocusManager_RequestGroupedAudioFocus_ParamsSpec.$,
        AudioFocusManager_RequestGroupedAudioFocus_ResponseParamsSpec.$,
        this.requestGroupedAudioFocus.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getFocusRequests =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        AudioFocusManager_GetFocusRequests_ParamsSpec.$,
        AudioFocusManager_GetFocusRequests_ResponseParamsSpec.$,
        this.getFocusRequests.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addObserver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        AudioFocusManager_AddObserver_ParamsSpec.$,
        null,
        this.addObserver.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setSource =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        AudioFocusManager_SetSource_ParamsSpec.$,
        null,
        this.setSource.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setEnforcementMode =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        AudioFocusManager_SetEnforcementMode_ParamsSpec.$,
        null,
        this.setEnforcementMode.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addSourceObserver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        AudioFocusManager_AddSourceObserver_ParamsSpec.$,
        null,
        this.addSourceObserver.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getSourceFocusRequests =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        AudioFocusManager_GetSourceFocusRequests_ParamsSpec.$,
        AudioFocusManager_GetSourceFocusRequests_ResponseParamsSpec.$,
        this.getSourceFocusRequests.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestIdReleased =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        AudioFocusManager_RequestIdReleased_ParamsSpec.$,
        null,
        this.requestIdReleased.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.startDuckingAllAudio =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        AudioFocusManager_StartDuckingAllAudio_ParamsSpec.$,
        null,
        this.startDuckingAllAudio.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.stopDuckingAllAudio =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        AudioFocusManager_StopDuckingAllAudio_ParamsSpec.$,
        null,
        this.stopDuckingAllAudio.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.flushForTesting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        AudioFocusManager_FlushForTesting_ParamsSpec.$,
        AudioFocusManager_FlushForTesting_ResponseParamsSpec.$,
        this.flushForTesting.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class AudioFocusManagerDebugPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'media_session.mojom.AudioFocusManagerDebug', scope);
  }
}

/** @interface */
export class AudioFocusManagerDebugInterface {
  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } requestId
   * @return {!Promise<{
        debugInfo: !mediaSession_mojom_MediaSessionDebugInfo,
   *  }>}
   */

  getDebugInfoForRequest(requestId) {}
}

/**
 * @implements { AudioFocusManagerDebugInterface }
 */
export class AudioFocusManagerDebugRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!AudioFocusManagerDebugPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          AudioFocusManagerDebugPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!AudioFocusManagerDebugPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !mojoBase_mojom_UnguessableToken } requestId
   * @return {!Promise<{
        debugInfo: !mediaSession_mojom_MediaSessionDebugInfo,
   *  }>}
   */

  getDebugInfoForRequest(
      requestId) {
    return this.proxy.sendMessage(
        0,
        AudioFocusManagerDebug_GetDebugInfoForRequest_ParamsSpec.$,
        AudioFocusManagerDebug_GetDebugInfoForRequest_ResponseParamsSpec.$,
        [
          requestId
        ],
        false);
  }
}

/**
 * An object which receives request messages for the AudioFocusManagerDebug
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class AudioFocusManagerDebugReceiver {
  /**
   * @param {!AudioFocusManagerDebugInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!AudioFocusManagerDebugRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        AudioFocusManagerDebugRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AudioFocusManagerDebugRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        AudioFocusManagerDebug_GetDebugInfoForRequest_ParamsSpec.$,
        AudioFocusManagerDebug_GetDebugInfoForRequest_ResponseParamsSpec.$,
        impl.getDebugInfoForRequest.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class AudioFocusManagerDebug {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media_session.mojom.AudioFocusManagerDebug";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!AudioFocusManagerDebugRemote}
   */
  static getRemote() {
    let remote = new AudioFocusManagerDebugRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the AudioFocusManagerDebug
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class AudioFocusManagerDebugCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      AudioFocusManagerDebugRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!AudioFocusManagerDebugRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getDebugInfoForRequest =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        AudioFocusManagerDebug_GetDebugInfoForRequest_ParamsSpec.$,
        AudioFocusManagerDebug_GetDebugInfoForRequest_ResponseParamsSpec.$,
        this.getDebugInfoForRequest.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioFocusRequestStateSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioFocusObserver_OnFocusGained_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioFocusObserver_OnFocusLost_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioFocusObserver_OnRequestIdReleased_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioFocusRequestClient_RequestAudioFocus_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioFocusRequestClient_RequestAudioFocus_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioFocusRequestClient_AbandonAudioFocus_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioFocusRequestClient_MediaSessionInfoChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioFocusManager_RequestAudioFocus_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioFocusManager_RequestAudioFocus_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioFocusManager_RequestGroupedAudioFocus_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioFocusManager_RequestGroupedAudioFocus_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioFocusManager_GetFocusRequests_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioFocusManager_GetFocusRequests_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioFocusManager_AddObserver_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioFocusManager_SetSource_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioFocusManager_SetEnforcementMode_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioFocusManager_AddSourceObserver_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioFocusManager_GetSourceFocusRequests_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioFocusManager_GetSourceFocusRequests_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioFocusManager_RequestIdReleased_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioFocusManager_StartDuckingAllAudio_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioFocusManager_StopDuckingAllAudio_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioFocusManager_FlushForTesting_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioFocusManager_FlushForTesting_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioFocusManagerDebug_GetDebugInfoForRequest_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const AudioFocusManagerDebug_GetDebugInfoForRequest_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    AudioFocusRequestStateSpec.$,
    'AudioFocusRequestState',
    [
      mojo.internal.StructField(
        'sessionInfo', 0,
        0,
        mediaSession_mojom_MediaSessionInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'audioFocusType', 8,
        0,
        AudioFocusTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sourceName', 16,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        2,
      ),
      mojo.internal.StructField(
        'requestId', 24,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        true /* nullable */,
        3,
      ),
      mojo.internal.StructField(
        'sourceId', 32,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        true /* nullable */,
        9,
      ),
    ],
    [[0, 24],[2, 32],[3, 40],[9, 48],]);



/**
 * @record
 */
export class AudioFocusRequestState {
  constructor() {
    /** @type { !mediaSession_mojom_MediaSessionInfo } */
    this.sessionInfo;
    /** @type { !AudioFocusType } */
    this.audioFocusType;
    /** @type { (string|undefined) } */
    this.sourceName;
    /** @type { (mojoBase_mojom_UnguessableToken|undefined) } */
    this.requestId;
    /** @type { (mojoBase_mojom_UnguessableToken|undefined) } */
    this.sourceId;
  }
}



mojo.internal.Struct(
    AudioFocusObserver_OnFocusGained_ParamsSpec.$,
    'AudioFocusObserver_OnFocusGained_Params',
    [
      mojo.internal.StructField(
        'state', 0,
        0,
        AudioFocusRequestStateSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AudioFocusObserver_OnFocusGained_Params {
  constructor() {
    /** @type { !AudioFocusRequestState } */
    this.state;
  }
}



mojo.internal.Struct(
    AudioFocusObserver_OnFocusLost_ParamsSpec.$,
    'AudioFocusObserver_OnFocusLost_Params',
    [
      mojo.internal.StructField(
        'state', 0,
        0,
        AudioFocusRequestStateSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AudioFocusObserver_OnFocusLost_Params {
  constructor() {
    /** @type { !AudioFocusRequestState } */
    this.state;
  }
}



mojo.internal.Struct(
    AudioFocusObserver_OnRequestIdReleased_ParamsSpec.$,
    'AudioFocusObserver_OnRequestIdReleased_Params',
    [
      mojo.internal.StructField(
        'requestId', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AudioFocusObserver_OnRequestIdReleased_Params {
  constructor() {
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.requestId;
  }
}



mojo.internal.Struct(
    AudioFocusRequestClient_RequestAudioFocus_ParamsSpec.$,
    'AudioFocusRequestClient_RequestAudioFocus_Params',
    [
      mojo.internal.StructField(
        'sessionInfo', 0,
        0,
        mediaSession_mojom_MediaSessionInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'type', 8,
        0,
        AudioFocusTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AudioFocusRequestClient_RequestAudioFocus_Params {
  constructor() {
    /** @type { !mediaSession_mojom_MediaSessionInfo } */
    this.sessionInfo;
    /** @type { !AudioFocusType } */
    this.type;
  }
}



mojo.internal.Struct(
    AudioFocusRequestClient_RequestAudioFocus_ResponseParamsSpec.$,
    'AudioFocusRequestClient_RequestAudioFocus_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class AudioFocusRequestClient_RequestAudioFocus_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    AudioFocusRequestClient_AbandonAudioFocus_ParamsSpec.$,
    'AudioFocusRequestClient_AbandonAudioFocus_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class AudioFocusRequestClient_AbandonAudioFocus_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    AudioFocusRequestClient_MediaSessionInfoChanged_ParamsSpec.$,
    'AudioFocusRequestClient_MediaSessionInfoChanged_Params',
    [
      mojo.internal.StructField(
        'sessionInfo', 0,
        0,
        mediaSession_mojom_MediaSessionInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AudioFocusRequestClient_MediaSessionInfoChanged_Params {
  constructor() {
    /** @type { !mediaSession_mojom_MediaSessionInfo } */
    this.sessionInfo;
  }
}



mojo.internal.Struct(
    AudioFocusManager_RequestAudioFocus_ParamsSpec.$,
    'AudioFocusManager_RequestAudioFocus_Params',
    [
      mojo.internal.StructField(
        'client', 0,
        0,
        mojo.internal.InterfaceRequest(AudioFocusRequestClientPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'session', 4,
        0,
        mojo.internal.InterfaceProxy(mediaSession_mojom_MediaSessionRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sessionInfo', 16,
        0,
        mediaSession_mojom_MediaSessionInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'type', 12,
        0,
        AudioFocusTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class AudioFocusManager_RequestAudioFocus_Params {
  constructor() {
    /** @type { !AudioFocusRequestClientPendingReceiver } */
    this.client;
    /** @type { !mediaSession_mojom_MediaSessionRemote } */
    this.session;
    /** @type { !mediaSession_mojom_MediaSessionInfo } */
    this.sessionInfo;
    /** @type { !AudioFocusType } */
    this.type;
  }
}



mojo.internal.Struct(
    AudioFocusManager_RequestAudioFocus_ResponseParamsSpec.$,
    'AudioFocusManager_RequestAudioFocus_ResponseParams',
    [
      mojo.internal.StructField(
        'requestId', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AudioFocusManager_RequestAudioFocus_ResponseParams {
  constructor() {
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.requestId;
  }
}



mojo.internal.Struct(
    AudioFocusManager_RequestGroupedAudioFocus_ParamsSpec.$,
    'AudioFocusManager_RequestGroupedAudioFocus_Params',
    [
      mojo.internal.StructField(
        'requestId', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'client', 8,
        0,
        mojo.internal.InterfaceRequest(AudioFocusRequestClientPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'session', 12,
        0,
        mojo.internal.InterfaceProxy(mediaSession_mojom_MediaSessionRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sessionInfo', 24,
        0,
        mediaSession_mojom_MediaSessionInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'type', 20,
        0,
        AudioFocusTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'groupId', 32,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class AudioFocusManager_RequestGroupedAudioFocus_Params {
  constructor() {
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.requestId;
    /** @type { !AudioFocusRequestClientPendingReceiver } */
    this.client;
    /** @type { !mediaSession_mojom_MediaSessionRemote } */
    this.session;
    /** @type { !mediaSession_mojom_MediaSessionInfo } */
    this.sessionInfo;
    /** @type { !AudioFocusType } */
    this.type;
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.groupId;
  }
}



mojo.internal.Struct(
    AudioFocusManager_RequestGroupedAudioFocus_ResponseParamsSpec.$,
    'AudioFocusManager_RequestGroupedAudioFocus_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AudioFocusManager_RequestGroupedAudioFocus_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
  }
}



mojo.internal.Struct(
    AudioFocusManager_GetFocusRequests_ParamsSpec.$,
    'AudioFocusManager_GetFocusRequests_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class AudioFocusManager_GetFocusRequests_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    AudioFocusManager_GetFocusRequests_ResponseParamsSpec.$,
    'AudioFocusManager_GetFocusRequests_ResponseParams',
    [
      mojo.internal.StructField(
        'requests', 0,
        0,
        mojo.internal.Array(AudioFocusRequestStateSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AudioFocusManager_GetFocusRequests_ResponseParams {
  constructor() {
    /** @type { !Array<!AudioFocusRequestState> } */
    this.requests;
  }
}



mojo.internal.Struct(
    AudioFocusManager_AddObserver_ParamsSpec.$,
    'AudioFocusManager_AddObserver_Params',
    [
      mojo.internal.StructField(
        'observer', 0,
        0,
        mojo.internal.InterfaceProxy(AudioFocusObserverRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AudioFocusManager_AddObserver_Params {
  constructor() {
    /** @type { !AudioFocusObserverRemote } */
    this.observer;
  }
}



mojo.internal.Struct(
    AudioFocusManager_SetSource_ParamsSpec.$,
    'AudioFocusManager_SetSource_Params',
    [
      mojo.internal.StructField(
        'identity', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'name', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AudioFocusManager_SetSource_Params {
  constructor() {
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.identity;
    /** @type { !string } */
    this.name;
  }
}



mojo.internal.Struct(
    AudioFocusManager_SetEnforcementMode_ParamsSpec.$,
    'AudioFocusManager_SetEnforcementMode_Params',
    [
      mojo.internal.StructField(
        'mode', 0,
        0,
        EnforcementModeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AudioFocusManager_SetEnforcementMode_Params {
  constructor() {
    /** @type { !EnforcementMode } */
    this.mode;
  }
}



mojo.internal.Struct(
    AudioFocusManager_AddSourceObserver_ParamsSpec.$,
    'AudioFocusManager_AddSourceObserver_Params',
    [
      mojo.internal.StructField(
        'sourceId', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'observer', 8,
        0,
        mojo.internal.InterfaceProxy(AudioFocusObserverRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class AudioFocusManager_AddSourceObserver_Params {
  constructor() {
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.sourceId;
    /** @type { !AudioFocusObserverRemote } */
    this.observer;
  }
}



mojo.internal.Struct(
    AudioFocusManager_GetSourceFocusRequests_ParamsSpec.$,
    'AudioFocusManager_GetSourceFocusRequests_Params',
    [
      mojo.internal.StructField(
        'sourceId', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AudioFocusManager_GetSourceFocusRequests_Params {
  constructor() {
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.sourceId;
  }
}



mojo.internal.Struct(
    AudioFocusManager_GetSourceFocusRequests_ResponseParamsSpec.$,
    'AudioFocusManager_GetSourceFocusRequests_ResponseParams',
    [
      mojo.internal.StructField(
        'requests', 0,
        0,
        mojo.internal.Array(AudioFocusRequestStateSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AudioFocusManager_GetSourceFocusRequests_ResponseParams {
  constructor() {
    /** @type { !Array<!AudioFocusRequestState> } */
    this.requests;
  }
}



mojo.internal.Struct(
    AudioFocusManager_RequestIdReleased_ParamsSpec.$,
    'AudioFocusManager_RequestIdReleased_Params',
    [
      mojo.internal.StructField(
        'requestId', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AudioFocusManager_RequestIdReleased_Params {
  constructor() {
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.requestId;
  }
}



mojo.internal.Struct(
    AudioFocusManager_StartDuckingAllAudio_ParamsSpec.$,
    'AudioFocusManager_StartDuckingAllAudio_Params',
    [
      mojo.internal.StructField(
        'exemptedRequestId', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AudioFocusManager_StartDuckingAllAudio_Params {
  constructor() {
    /** @type { (mojoBase_mojom_UnguessableToken|undefined) } */
    this.exemptedRequestId;
  }
}



mojo.internal.Struct(
    AudioFocusManager_StopDuckingAllAudio_ParamsSpec.$,
    'AudioFocusManager_StopDuckingAllAudio_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class AudioFocusManager_StopDuckingAllAudio_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    AudioFocusManager_FlushForTesting_ParamsSpec.$,
    'AudioFocusManager_FlushForTesting_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class AudioFocusManager_FlushForTesting_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    AudioFocusManager_FlushForTesting_ResponseParamsSpec.$,
    'AudioFocusManager_FlushForTesting_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class AudioFocusManager_FlushForTesting_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    AudioFocusManagerDebug_GetDebugInfoForRequest_ParamsSpec.$,
    'AudioFocusManagerDebug_GetDebugInfoForRequest_Params',
    [
      mojo.internal.StructField(
        'requestId', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AudioFocusManagerDebug_GetDebugInfoForRequest_Params {
  constructor() {
    /** @type { !mojoBase_mojom_UnguessableToken } */
    this.requestId;
  }
}



mojo.internal.Struct(
    AudioFocusManagerDebug_GetDebugInfoForRequest_ResponseParamsSpec.$,
    'AudioFocusManagerDebug_GetDebugInfoForRequest_ResponseParams',
    [
      mojo.internal.StructField(
        'debugInfo', 0,
        0,
        mediaSession_mojom_MediaSessionDebugInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class AudioFocusManagerDebug_GetDebugInfoForRequest_ResponseParams {
  constructor() {
    /** @type { !mediaSession_mojom_MediaSessionDebugInfo } */
    this.debugInfo;
  }
}

