// services/media_session/public/mojom/audio_focus.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_MEDIA_SESSION_PUBLIC_MOJOM_AUDIO_FOCUS_MOJOM_SEND_VALIDATION_H_
#define SERVICES_MEDIA_SESSION_PUBLIC_MOJOM_AUDIO_FOCUS_MOJOM_SEND_VALIDATION_H_

#include "services/media_session/public/mojom/audio_focus.mojom-shared-internal.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "services/media_session/public/mojom/media_session.mojom-shared.h"

#include "services/media_session/public/mojom/audio_focus.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::media_session::mojom::EnforcementMode, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::media_session::mojom::AudioFocusType, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::media_session::mojom::AudioFocusRequestStateDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media_session::mojom::AudioFocusRequestStateDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media_session::mojom::internal::AudioFocusRequestState_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::session_info(input)) in_session_info = Traits::session_info(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->session_info)::BaseType> session_info_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::media_session::mojom::MediaSessionInfoDataView, send_validation>(
        in_session_info,
        session_info_fragment);

      fragment->session_info.Set(
          session_info_fragment.is_null() ? nullptr : session_info_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->session_info.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null session_info in AudioFocusRequestState struct");

      
      mojo::internal::Serialize<::media_session::mojom::AudioFocusType>(
        Traits::audio_focus_type(input),
        &fragment->audio_focus_type);

      decltype(Traits::source_name(input)) in_source_name = Traits::source_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->source_name)::BaseType> source_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_source_name,
        source_name_fragment);

      fragment->source_name.Set(
          source_name_fragment.is_null() ? nullptr : source_name_fragment.data());

      decltype(Traits::request_id(input)) in_request_id = Traits::request_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->request_id)::BaseType> request_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView, send_validation>(
        in_request_id,
        request_id_fragment);

      fragment->request_id.Set(
          request_id_fragment.is_null() ? nullptr : request_id_fragment.data());

      decltype(Traits::source_id(input)) in_source_id = Traits::source_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->source_id)::BaseType> source_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView, send_validation>(
        in_source_id,
        source_id_fragment);

      fragment->source_id.Set(
          source_id_fragment.is_null() ? nullptr : source_id_fragment.data());
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_MEDIA_SESSION_PUBLIC_MOJOM_AUDIO_FOCUS_MOJOM_SEND_VALIDATION_H_