// services/media_session/public/mojom/audio_focus.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('mediaSession.mojom');





/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
mediaSession.mojom.EnforcementModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
mediaSession.mojom.EnforcementMode = {
  
  kDefault: 0,
  kNone: 1,
  kSingleGroup: 2,
  kSingleSession: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};


/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
mediaSession.mojom.AudioFocusTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
mediaSession.mojom.AudioFocusType = {
  
  kGain: 0,
  kGainTransientMayDuck: 1,
  kGainTransient: 2,
  kAmbient: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};





/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
mediaSession.mojom.AudioFocusObserverPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        mediaSession.mojom.AudioFocusObserver.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { mediaSession.mojom.AudioFocusObserverInterface }
 */
mediaSession.mojom.AudioFocusObserverRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!mediaSession.mojom.AudioFocusObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          mediaSession.mojom.AudioFocusObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!mediaSession.mojom.AudioFocusObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !mediaSession.mojom.AudioFocusRequestState } state
   */

  onFocusGained(
      state) {
    this.proxy.sendMessage(
        0,
        mediaSession.mojom.AudioFocusObserver_OnFocusGained_ParamsSpec.$,
        null,
        [
          state
        ],
        false);
  }

  
  /**
   * @param { !mediaSession.mojom.AudioFocusRequestState } state
   */

  onFocusLost(
      state) {
    this.proxy.sendMessage(
        1,
        mediaSession.mojom.AudioFocusObserver_OnFocusLost_ParamsSpec.$,
        null,
        [
          state
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.UnguessableToken } requestId
   */

  onRequestIdReleased(
      requestId) {
    this.proxy.sendMessage(
        2,
        mediaSession.mojom.AudioFocusObserver_OnRequestIdReleased_ParamsSpec.$,
        null,
        [
          requestId
        ],
        false);
  }
};

/**
 * An object which receives request messages for the AudioFocusObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
mediaSession.mojom.AudioFocusObserverReceiver = class {
  /**
   * @param {!mediaSession.mojom.AudioFocusObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!mediaSession.mojom.AudioFocusObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        mediaSession.mojom.AudioFocusObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!mediaSession.mojom.AudioFocusObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        mediaSession.mojom.AudioFocusObserver_OnFocusGained_ParamsSpec.$,
        null,
        impl.onFocusGained.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        mediaSession.mojom.AudioFocusObserver_OnFocusLost_ParamsSpec.$,
        null,
        impl.onFocusLost.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        mediaSession.mojom.AudioFocusObserver_OnRequestIdReleased_ParamsSpec.$,
        null,
        impl.onRequestIdReleased.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
mediaSession.mojom.AudioFocusObserver = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media_session.mojom.AudioFocusObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!mediaSession.mojom.AudioFocusObserverRemote}
   * @export
   */
  static getRemote() {
    let remote = new mediaSession.mojom.AudioFocusObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the AudioFocusObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
mediaSession.mojom.AudioFocusObserverCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      mediaSession.mojom.AudioFocusObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!mediaSession.mojom.AudioFocusObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onFocusGained =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        mediaSession.mojom.AudioFocusObserver_OnFocusGained_ParamsSpec.$,
        null,
        this.onFocusGained.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onFocusLost =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        mediaSession.mojom.AudioFocusObserver_OnFocusLost_ParamsSpec.$,
        null,
        this.onFocusLost.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onRequestIdReleased =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        mediaSession.mojom.AudioFocusObserver_OnRequestIdReleased_ParamsSpec.$,
        null,
        this.onRequestIdReleased.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
mediaSession.mojom.AudioFocusRequestClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        mediaSession.mojom.AudioFocusRequestClient.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { mediaSession.mojom.AudioFocusRequestClientInterface }
 */
mediaSession.mojom.AudioFocusRequestClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!mediaSession.mojom.AudioFocusRequestClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          mediaSession.mojom.AudioFocusRequestClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!mediaSession.mojom.AudioFocusRequestClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !mediaSession.mojom.MediaSessionInfo } sessionInfo
   * @param { !mediaSession.mojom.AudioFocusType } type
   * @return {!Promise}
   */

  requestAudioFocus(
      sessionInfo,
      type) {
    return this.proxy.sendMessage(
        0,
        mediaSession.mojom.AudioFocusRequestClient_RequestAudioFocus_ParamsSpec.$,
        mediaSession.mojom.AudioFocusRequestClient_RequestAudioFocus_ResponseParamsSpec.$,
        [
          sessionInfo,
          type
        ],
        false);
  }

  
  /**
   */

  abandonAudioFocus() {
    this.proxy.sendMessage(
        1,
        mediaSession.mojom.AudioFocusRequestClient_AbandonAudioFocus_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !mediaSession.mojom.MediaSessionInfo } sessionInfo
   */

  mediaSessionInfoChanged(
      sessionInfo) {
    this.proxy.sendMessage(
        2,
        mediaSession.mojom.AudioFocusRequestClient_MediaSessionInfoChanged_ParamsSpec.$,
        null,
        [
          sessionInfo
        ],
        false);
  }
};

/**
 * An object which receives request messages for the AudioFocusRequestClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
mediaSession.mojom.AudioFocusRequestClientReceiver = class {
  /**
   * @param {!mediaSession.mojom.AudioFocusRequestClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!mediaSession.mojom.AudioFocusRequestClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        mediaSession.mojom.AudioFocusRequestClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!mediaSession.mojom.AudioFocusRequestClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        mediaSession.mojom.AudioFocusRequestClient_RequestAudioFocus_ParamsSpec.$,
        mediaSession.mojom.AudioFocusRequestClient_RequestAudioFocus_ResponseParamsSpec.$,
        impl.requestAudioFocus.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        mediaSession.mojom.AudioFocusRequestClient_AbandonAudioFocus_ParamsSpec.$,
        null,
        impl.abandonAudioFocus.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        mediaSession.mojom.AudioFocusRequestClient_MediaSessionInfoChanged_ParamsSpec.$,
        null,
        impl.mediaSessionInfoChanged.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
mediaSession.mojom.AudioFocusRequestClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media_session.mojom.AudioFocusRequestClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!mediaSession.mojom.AudioFocusRequestClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new mediaSession.mojom.AudioFocusRequestClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the AudioFocusRequestClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
mediaSession.mojom.AudioFocusRequestClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      mediaSession.mojom.AudioFocusRequestClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!mediaSession.mojom.AudioFocusRequestClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestAudioFocus =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        mediaSession.mojom.AudioFocusRequestClient_RequestAudioFocus_ParamsSpec.$,
        mediaSession.mojom.AudioFocusRequestClient_RequestAudioFocus_ResponseParamsSpec.$,
        this.requestAudioFocus.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.abandonAudioFocus =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        mediaSession.mojom.AudioFocusRequestClient_AbandonAudioFocus_ParamsSpec.$,
        null,
        this.abandonAudioFocus.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.mediaSessionInfoChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        mediaSession.mojom.AudioFocusRequestClient_MediaSessionInfoChanged_ParamsSpec.$,
        null,
        this.mediaSessionInfoChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
mediaSession.mojom.AudioFocusManagerPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        mediaSession.mojom.AudioFocusManager.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { mediaSession.mojom.AudioFocusManagerInterface }
 */
mediaSession.mojom.AudioFocusManagerRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!mediaSession.mojom.AudioFocusManagerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          mediaSession.mojom.AudioFocusManagerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!mediaSession.mojom.AudioFocusManagerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !mediaSession.mojom.AudioFocusRequestClientPendingReceiver } client
   * @param { !mediaSession.mojom.MediaSessionRemote } session
   * @param { !mediaSession.mojom.MediaSessionInfo } sessionInfo
   * @param { !mediaSession.mojom.AudioFocusType } type
   * @return {!Promise<{
        requestId: !mojoBase.mojom.UnguessableToken,
   *  }>}
   */

  requestAudioFocus(
      client,
      session,
      sessionInfo,
      type) {
    return this.proxy.sendMessage(
        0,
        mediaSession.mojom.AudioFocusManager_RequestAudioFocus_ParamsSpec.$,
        mediaSession.mojom.AudioFocusManager_RequestAudioFocus_ResponseParamsSpec.$,
        [
          client,
          session,
          sessionInfo,
          type
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.UnguessableToken } requestId
   * @param { !mediaSession.mojom.AudioFocusRequestClientPendingReceiver } client
   * @param { !mediaSession.mojom.MediaSessionRemote } session
   * @param { !mediaSession.mojom.MediaSessionInfo } sessionInfo
   * @param { !mediaSession.mojom.AudioFocusType } type
   * @param { !mojoBase.mojom.UnguessableToken } groupId
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  requestGroupedAudioFocus(
      requestId,
      client,
      session,
      sessionInfo,
      type,
      groupId) {
    return this.proxy.sendMessage(
        4,
        mediaSession.mojom.AudioFocusManager_RequestGroupedAudioFocus_ParamsSpec.$,
        mediaSession.mojom.AudioFocusManager_RequestGroupedAudioFocus_ResponseParamsSpec.$,
        [
          requestId,
          client,
          session,
          sessionInfo,
          type,
          groupId
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        requests: !Array<!mediaSession.mojom.AudioFocusRequestState>,
   *  }>}
   */

  getFocusRequests() {
    return this.proxy.sendMessage(
        1,
        mediaSession.mojom.AudioFocusManager_GetFocusRequests_ParamsSpec.$,
        mediaSession.mojom.AudioFocusManager_GetFocusRequests_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !mediaSession.mojom.AudioFocusObserverRemote } observer
   */

  addObserver(
      observer) {
    this.proxy.sendMessage(
        2,
        mediaSession.mojom.AudioFocusManager_AddObserver_ParamsSpec.$,
        null,
        [
          observer
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.UnguessableToken } identity
   * @param { !string } name
   */

  setSource(
      identity,
      name) {
    this.proxy.sendMessage(
        6,
        mediaSession.mojom.AudioFocusManager_SetSource_ParamsSpec.$,
        null,
        [
          identity,
          name
        ],
        false);
  }

  
  /**
   * @param { !mediaSession.mojom.EnforcementMode } mode
   */

  setEnforcementMode(
      mode) {
    this.proxy.sendMessage(
        5,
        mediaSession.mojom.AudioFocusManager_SetEnforcementMode_ParamsSpec.$,
        null,
        [
          mode
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.UnguessableToken } sourceId
   * @param { !mediaSession.mojom.AudioFocusObserverRemote } observer
   */

  addSourceObserver(
      sourceId,
      observer) {
    this.proxy.sendMessage(
        7,
        mediaSession.mojom.AudioFocusManager_AddSourceObserver_ParamsSpec.$,
        null,
        [
          sourceId,
          observer
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.UnguessableToken } sourceId
   * @return {!Promise<{
        requests: !Array<!mediaSession.mojom.AudioFocusRequestState>,
   *  }>}
   */

  getSourceFocusRequests(
      sourceId) {
    return this.proxy.sendMessage(
        8,
        mediaSession.mojom.AudioFocusManager_GetSourceFocusRequests_ParamsSpec.$,
        mediaSession.mojom.AudioFocusManager_GetSourceFocusRequests_ResponseParamsSpec.$,
        [
          sourceId
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.UnguessableToken } requestId
   */

  requestIdReleased(
      requestId) {
    this.proxy.sendMessage(
        9,
        mediaSession.mojom.AudioFocusManager_RequestIdReleased_ParamsSpec.$,
        null,
        [
          requestId
        ],
        false);
  }

  
  /**
   * @param { ?mojoBase.mojom.UnguessableToken } exemptedRequestId
   */

  startDuckingAllAudio(
      exemptedRequestId) {
    this.proxy.sendMessage(
        10,
        mediaSession.mojom.AudioFocusManager_StartDuckingAllAudio_ParamsSpec.$,
        null,
        [
          exemptedRequestId
        ],
        false);
  }

  
  /**
   */

  stopDuckingAllAudio() {
    this.proxy.sendMessage(
        11,
        mediaSession.mojom.AudioFocusManager_StopDuckingAllAudio_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  flushForTesting() {
    return this.proxy.sendMessage(
        12,
        mediaSession.mojom.AudioFocusManager_FlushForTesting_ParamsSpec.$,
        mediaSession.mojom.AudioFocusManager_FlushForTesting_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the AudioFocusManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
mediaSession.mojom.AudioFocusManagerReceiver = class {
  /**
   * @param {!mediaSession.mojom.AudioFocusManagerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!mediaSession.mojom.AudioFocusManagerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        mediaSession.mojom.AudioFocusManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!mediaSession.mojom.AudioFocusManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        mediaSession.mojom.AudioFocusManager_RequestAudioFocus_ParamsSpec.$,
        mediaSession.mojom.AudioFocusManager_RequestAudioFocus_ResponseParamsSpec.$,
        impl.requestAudioFocus.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        mediaSession.mojom.AudioFocusManager_RequestGroupedAudioFocus_ParamsSpec.$,
        mediaSession.mojom.AudioFocusManager_RequestGroupedAudioFocus_ResponseParamsSpec.$,
        impl.requestGroupedAudioFocus.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        mediaSession.mojom.AudioFocusManager_GetFocusRequests_ParamsSpec.$,
        mediaSession.mojom.AudioFocusManager_GetFocusRequests_ResponseParamsSpec.$,
        impl.getFocusRequests.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        mediaSession.mojom.AudioFocusManager_AddObserver_ParamsSpec.$,
        null,
        impl.addObserver.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        mediaSession.mojom.AudioFocusManager_SetSource_ParamsSpec.$,
        null,
        impl.setSource.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        mediaSession.mojom.AudioFocusManager_SetEnforcementMode_ParamsSpec.$,
        null,
        impl.setEnforcementMode.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        mediaSession.mojom.AudioFocusManager_AddSourceObserver_ParamsSpec.$,
        null,
        impl.addSourceObserver.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        mediaSession.mojom.AudioFocusManager_GetSourceFocusRequests_ParamsSpec.$,
        mediaSession.mojom.AudioFocusManager_GetSourceFocusRequests_ResponseParamsSpec.$,
        impl.getSourceFocusRequests.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        mediaSession.mojom.AudioFocusManager_RequestIdReleased_ParamsSpec.$,
        null,
        impl.requestIdReleased.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        mediaSession.mojom.AudioFocusManager_StartDuckingAllAudio_ParamsSpec.$,
        null,
        impl.startDuckingAllAudio.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        mediaSession.mojom.AudioFocusManager_StopDuckingAllAudio_ParamsSpec.$,
        null,
        impl.stopDuckingAllAudio.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        mediaSession.mojom.AudioFocusManager_FlushForTesting_ParamsSpec.$,
        mediaSession.mojom.AudioFocusManager_FlushForTesting_ResponseParamsSpec.$,
        impl.flushForTesting.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
mediaSession.mojom.AudioFocusManager = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media_session.mojom.AudioFocusManager";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!mediaSession.mojom.AudioFocusManagerRemote}
   * @export
   */
  static getRemote() {
    let remote = new mediaSession.mojom.AudioFocusManagerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the AudioFocusManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
mediaSession.mojom.AudioFocusManagerCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      mediaSession.mojom.AudioFocusManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!mediaSession.mojom.AudioFocusManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestAudioFocus =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        mediaSession.mojom.AudioFocusManager_RequestAudioFocus_ParamsSpec.$,
        mediaSession.mojom.AudioFocusManager_RequestAudioFocus_ResponseParamsSpec.$,
        this.requestAudioFocus.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestGroupedAudioFocus =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        mediaSession.mojom.AudioFocusManager_RequestGroupedAudioFocus_ParamsSpec.$,
        mediaSession.mojom.AudioFocusManager_RequestGroupedAudioFocus_ResponseParamsSpec.$,
        this.requestGroupedAudioFocus.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getFocusRequests =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        mediaSession.mojom.AudioFocusManager_GetFocusRequests_ParamsSpec.$,
        mediaSession.mojom.AudioFocusManager_GetFocusRequests_ResponseParamsSpec.$,
        this.getFocusRequests.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addObserver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        mediaSession.mojom.AudioFocusManager_AddObserver_ParamsSpec.$,
        null,
        this.addObserver.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setSource =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        mediaSession.mojom.AudioFocusManager_SetSource_ParamsSpec.$,
        null,
        this.setSource.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setEnforcementMode =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        mediaSession.mojom.AudioFocusManager_SetEnforcementMode_ParamsSpec.$,
        null,
        this.setEnforcementMode.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addSourceObserver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        mediaSession.mojom.AudioFocusManager_AddSourceObserver_ParamsSpec.$,
        null,
        this.addSourceObserver.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getSourceFocusRequests =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        mediaSession.mojom.AudioFocusManager_GetSourceFocusRequests_ParamsSpec.$,
        mediaSession.mojom.AudioFocusManager_GetSourceFocusRequests_ResponseParamsSpec.$,
        this.getSourceFocusRequests.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestIdReleased =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        mediaSession.mojom.AudioFocusManager_RequestIdReleased_ParamsSpec.$,
        null,
        this.requestIdReleased.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.startDuckingAllAudio =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        mediaSession.mojom.AudioFocusManager_StartDuckingAllAudio_ParamsSpec.$,
        null,
        this.startDuckingAllAudio.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.stopDuckingAllAudio =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        mediaSession.mojom.AudioFocusManager_StopDuckingAllAudio_ParamsSpec.$,
        null,
        this.stopDuckingAllAudio.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.flushForTesting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        mediaSession.mojom.AudioFocusManager_FlushForTesting_ParamsSpec.$,
        mediaSession.mojom.AudioFocusManager_FlushForTesting_ResponseParamsSpec.$,
        this.flushForTesting.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
mediaSession.mojom.AudioFocusManagerDebugPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        mediaSession.mojom.AudioFocusManagerDebug.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { mediaSession.mojom.AudioFocusManagerDebugInterface }
 */
mediaSession.mojom.AudioFocusManagerDebugRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!mediaSession.mojom.AudioFocusManagerDebugPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          mediaSession.mojom.AudioFocusManagerDebugPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!mediaSession.mojom.AudioFocusManagerDebugPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !mojoBase.mojom.UnguessableToken } requestId
   * @return {!Promise<{
        debugInfo: !mediaSession.mojom.MediaSessionDebugInfo,
   *  }>}
   */

  getDebugInfoForRequest(
      requestId) {
    return this.proxy.sendMessage(
        0,
        mediaSession.mojom.AudioFocusManagerDebug_GetDebugInfoForRequest_ParamsSpec.$,
        mediaSession.mojom.AudioFocusManagerDebug_GetDebugInfoForRequest_ResponseParamsSpec.$,
        [
          requestId
        ],
        false);
  }
};

/**
 * An object which receives request messages for the AudioFocusManagerDebug
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
mediaSession.mojom.AudioFocusManagerDebugReceiver = class {
  /**
   * @param {!mediaSession.mojom.AudioFocusManagerDebugInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!mediaSession.mojom.AudioFocusManagerDebugRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        mediaSession.mojom.AudioFocusManagerDebugRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!mediaSession.mojom.AudioFocusManagerDebugRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        mediaSession.mojom.AudioFocusManagerDebug_GetDebugInfoForRequest_ParamsSpec.$,
        mediaSession.mojom.AudioFocusManagerDebug_GetDebugInfoForRequest_ResponseParamsSpec.$,
        impl.getDebugInfoForRequest.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
mediaSession.mojom.AudioFocusManagerDebug = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "media_session.mojom.AudioFocusManagerDebug";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!mediaSession.mojom.AudioFocusManagerDebugRemote}
   * @export
   */
  static getRemote() {
    let remote = new mediaSession.mojom.AudioFocusManagerDebugRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the AudioFocusManagerDebug
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
mediaSession.mojom.AudioFocusManagerDebugCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      mediaSession.mojom.AudioFocusManagerDebugRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!mediaSession.mojom.AudioFocusManagerDebugRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getDebugInfoForRequest =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        mediaSession.mojom.AudioFocusManagerDebug_GetDebugInfoForRequest_ParamsSpec.$,
        mediaSession.mojom.AudioFocusManagerDebug_GetDebugInfoForRequest_ResponseParamsSpec.$,
        this.getDebugInfoForRequest.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.AudioFocusRequestStateSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.AudioFocusObserver_OnFocusGained_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.AudioFocusObserver_OnFocusLost_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.AudioFocusObserver_OnRequestIdReleased_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.AudioFocusRequestClient_RequestAudioFocus_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.AudioFocusRequestClient_RequestAudioFocus_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.AudioFocusRequestClient_AbandonAudioFocus_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.AudioFocusRequestClient_MediaSessionInfoChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.AudioFocusManager_RequestAudioFocus_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.AudioFocusManager_RequestAudioFocus_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.AudioFocusManager_RequestGroupedAudioFocus_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.AudioFocusManager_RequestGroupedAudioFocus_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.AudioFocusManager_GetFocusRequests_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.AudioFocusManager_GetFocusRequests_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.AudioFocusManager_AddObserver_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.AudioFocusManager_SetSource_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.AudioFocusManager_SetEnforcementMode_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.AudioFocusManager_AddSourceObserver_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.AudioFocusManager_GetSourceFocusRequests_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.AudioFocusManager_GetSourceFocusRequests_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.AudioFocusManager_RequestIdReleased_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.AudioFocusManager_StartDuckingAllAudio_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.AudioFocusManager_StopDuckingAllAudio_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.AudioFocusManager_FlushForTesting_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.AudioFocusManager_FlushForTesting_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.AudioFocusManagerDebug_GetDebugInfoForRequest_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
mediaSession.mojom.AudioFocusManagerDebug_GetDebugInfoForRequest_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    mediaSession.mojom.AudioFocusRequestStateSpec.$,
    'AudioFocusRequestState',
    [
      mojo.internal.StructField(
        'sessionInfo', 0,
        0,
        mediaSession.mojom.MediaSessionInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'audioFocusType', 8,
        0,
        mediaSession.mojom.AudioFocusTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sourceName', 16,
        0,
        mojo.internal.String,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'requestId', 24,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sourceId', 32,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],[2, 32],[3, 40],[9, 48],]);





/** @record */
mediaSession.mojom.AudioFocusRequestState = class {
  constructor() {
    /** @export { !mediaSession.mojom.MediaSessionInfo } */
    this.sessionInfo;
    /** @export { !mediaSession.mojom.AudioFocusType } */
    this.audioFocusType;
    /** @export { (string|undefined) } */
    this.sourceName;
    /** @export { (mojoBase.mojom.UnguessableToken|undefined) } */
    this.requestId;
    /** @export { (mojoBase.mojom.UnguessableToken|undefined) } */
    this.sourceId;
  }
};



mojo.internal.Struct(
    mediaSession.mojom.AudioFocusObserver_OnFocusGained_ParamsSpec.$,
    'AudioFocusObserver_OnFocusGained_Params',
    [
      mojo.internal.StructField(
        'state', 0,
        0,
        mediaSession.mojom.AudioFocusRequestStateSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
mediaSession.mojom.AudioFocusObserver_OnFocusGained_Params = class {
  constructor() {
    /** @export { !mediaSession.mojom.AudioFocusRequestState } */
    this.state;
  }
};



mojo.internal.Struct(
    mediaSession.mojom.AudioFocusObserver_OnFocusLost_ParamsSpec.$,
    'AudioFocusObserver_OnFocusLost_Params',
    [
      mojo.internal.StructField(
        'state', 0,
        0,
        mediaSession.mojom.AudioFocusRequestStateSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
mediaSession.mojom.AudioFocusObserver_OnFocusLost_Params = class {
  constructor() {
    /** @export { !mediaSession.mojom.AudioFocusRequestState } */
    this.state;
  }
};



mojo.internal.Struct(
    mediaSession.mojom.AudioFocusObserver_OnRequestIdReleased_ParamsSpec.$,
    'AudioFocusObserver_OnRequestIdReleased_Params',
    [
      mojo.internal.StructField(
        'requestId', 0,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
mediaSession.mojom.AudioFocusObserver_OnRequestIdReleased_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.requestId;
  }
};



mojo.internal.Struct(
    mediaSession.mojom.AudioFocusRequestClient_RequestAudioFocus_ParamsSpec.$,
    'AudioFocusRequestClient_RequestAudioFocus_Params',
    [
      mojo.internal.StructField(
        'sessionInfo', 0,
        0,
        mediaSession.mojom.MediaSessionInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'type', 8,
        0,
        mediaSession.mojom.AudioFocusTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
mediaSession.mojom.AudioFocusRequestClient_RequestAudioFocus_Params = class {
  constructor() {
    /** @export { !mediaSession.mojom.MediaSessionInfo } */
    this.sessionInfo;
    /** @export { !mediaSession.mojom.AudioFocusType } */
    this.type;
  }
};



mojo.internal.Struct(
    mediaSession.mojom.AudioFocusRequestClient_RequestAudioFocus_ResponseParamsSpec.$,
    'AudioFocusRequestClient_RequestAudioFocus_ResponseParams',
    [
    ],
    [[0, 8],]);





/** @record */
mediaSession.mojom.AudioFocusRequestClient_RequestAudioFocus_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    mediaSession.mojom.AudioFocusRequestClient_AbandonAudioFocus_ParamsSpec.$,
    'AudioFocusRequestClient_AbandonAudioFocus_Params',
    [
    ],
    [[0, 8],]);





/** @record */
mediaSession.mojom.AudioFocusRequestClient_AbandonAudioFocus_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    mediaSession.mojom.AudioFocusRequestClient_MediaSessionInfoChanged_ParamsSpec.$,
    'AudioFocusRequestClient_MediaSessionInfoChanged_Params',
    [
      mojo.internal.StructField(
        'sessionInfo', 0,
        0,
        mediaSession.mojom.MediaSessionInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
mediaSession.mojom.AudioFocusRequestClient_MediaSessionInfoChanged_Params = class {
  constructor() {
    /** @export { !mediaSession.mojom.MediaSessionInfo } */
    this.sessionInfo;
  }
};



mojo.internal.Struct(
    mediaSession.mojom.AudioFocusManager_RequestAudioFocus_ParamsSpec.$,
    'AudioFocusManager_RequestAudioFocus_Params',
    [
      mojo.internal.StructField(
        'client', 0,
        0,
        mojo.internal.InterfaceRequest(mediaSession.mojom.AudioFocusRequestClientPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'session', 4,
        0,
        mojo.internal.InterfaceProxy(mediaSession.mojom.MediaSessionRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sessionInfo', 16,
        0,
        mediaSession.mojom.MediaSessionInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'type', 12,
        0,
        mediaSession.mojom.AudioFocusTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
mediaSession.mojom.AudioFocusManager_RequestAudioFocus_Params = class {
  constructor() {
    /** @export { !mediaSession.mojom.AudioFocusRequestClientPendingReceiver } */
    this.client;
    /** @export { !mediaSession.mojom.MediaSessionRemote } */
    this.session;
    /** @export { !mediaSession.mojom.MediaSessionInfo } */
    this.sessionInfo;
    /** @export { !mediaSession.mojom.AudioFocusType } */
    this.type;
  }
};



mojo.internal.Struct(
    mediaSession.mojom.AudioFocusManager_RequestAudioFocus_ResponseParamsSpec.$,
    'AudioFocusManager_RequestAudioFocus_ResponseParams',
    [
      mojo.internal.StructField(
        'requestId', 0,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
mediaSession.mojom.AudioFocusManager_RequestAudioFocus_ResponseParams = class {
  constructor() {
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.requestId;
  }
};



mojo.internal.Struct(
    mediaSession.mojom.AudioFocusManager_RequestGroupedAudioFocus_ParamsSpec.$,
    'AudioFocusManager_RequestGroupedAudioFocus_Params',
    [
      mojo.internal.StructField(
        'requestId', 0,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'client', 8,
        0,
        mojo.internal.InterfaceRequest(mediaSession.mojom.AudioFocusRequestClientPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'session', 12,
        0,
        mojo.internal.InterfaceProxy(mediaSession.mojom.MediaSessionRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'sessionInfo', 24,
        0,
        mediaSession.mojom.MediaSessionInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'type', 20,
        0,
        mediaSession.mojom.AudioFocusTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'groupId', 32,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 48],]);





/** @record */
mediaSession.mojom.AudioFocusManager_RequestGroupedAudioFocus_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.requestId;
    /** @export { !mediaSession.mojom.AudioFocusRequestClientPendingReceiver } */
    this.client;
    /** @export { !mediaSession.mojom.MediaSessionRemote } */
    this.session;
    /** @export { !mediaSession.mojom.MediaSessionInfo } */
    this.sessionInfo;
    /** @export { !mediaSession.mojom.AudioFocusType } */
    this.type;
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.groupId;
  }
};



mojo.internal.Struct(
    mediaSession.mojom.AudioFocusManager_RequestGroupedAudioFocus_ResponseParamsSpec.$,
    'AudioFocusManager_RequestGroupedAudioFocus_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
mediaSession.mojom.AudioFocusManager_RequestGroupedAudioFocus_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
  }
};



mojo.internal.Struct(
    mediaSession.mojom.AudioFocusManager_GetFocusRequests_ParamsSpec.$,
    'AudioFocusManager_GetFocusRequests_Params',
    [
    ],
    [[0, 8],]);





/** @record */
mediaSession.mojom.AudioFocusManager_GetFocusRequests_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    mediaSession.mojom.AudioFocusManager_GetFocusRequests_ResponseParamsSpec.$,
    'AudioFocusManager_GetFocusRequests_ResponseParams',
    [
      mojo.internal.StructField(
        'requests', 0,
        0,
        mojo.internal.Array(mediaSession.mojom.AudioFocusRequestStateSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
mediaSession.mojom.AudioFocusManager_GetFocusRequests_ResponseParams = class {
  constructor() {
    /** @export { !Array<!mediaSession.mojom.AudioFocusRequestState> } */
    this.requests;
  }
};



mojo.internal.Struct(
    mediaSession.mojom.AudioFocusManager_AddObserver_ParamsSpec.$,
    'AudioFocusManager_AddObserver_Params',
    [
      mojo.internal.StructField(
        'observer', 0,
        0,
        mojo.internal.InterfaceProxy(mediaSession.mojom.AudioFocusObserverRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
mediaSession.mojom.AudioFocusManager_AddObserver_Params = class {
  constructor() {
    /** @export { !mediaSession.mojom.AudioFocusObserverRemote } */
    this.observer;
  }
};



mojo.internal.Struct(
    mediaSession.mojom.AudioFocusManager_SetSource_ParamsSpec.$,
    'AudioFocusManager_SetSource_Params',
    [
      mojo.internal.StructField(
        'identity', 0,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'name', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
mediaSession.mojom.AudioFocusManager_SetSource_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.identity;
    /** @export { !string } */
    this.name;
  }
};



mojo.internal.Struct(
    mediaSession.mojom.AudioFocusManager_SetEnforcementMode_ParamsSpec.$,
    'AudioFocusManager_SetEnforcementMode_Params',
    [
      mojo.internal.StructField(
        'mode', 0,
        0,
        mediaSession.mojom.EnforcementModeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
mediaSession.mojom.AudioFocusManager_SetEnforcementMode_Params = class {
  constructor() {
    /** @export { !mediaSession.mojom.EnforcementMode } */
    this.mode;
  }
};



mojo.internal.Struct(
    mediaSession.mojom.AudioFocusManager_AddSourceObserver_ParamsSpec.$,
    'AudioFocusManager_AddSourceObserver_Params',
    [
      mojo.internal.StructField(
        'sourceId', 0,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'observer', 8,
        0,
        mojo.internal.InterfaceProxy(mediaSession.mojom.AudioFocusObserverRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
mediaSession.mojom.AudioFocusManager_AddSourceObserver_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.sourceId;
    /** @export { !mediaSession.mojom.AudioFocusObserverRemote } */
    this.observer;
  }
};



mojo.internal.Struct(
    mediaSession.mojom.AudioFocusManager_GetSourceFocusRequests_ParamsSpec.$,
    'AudioFocusManager_GetSourceFocusRequests_Params',
    [
      mojo.internal.StructField(
        'sourceId', 0,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
mediaSession.mojom.AudioFocusManager_GetSourceFocusRequests_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.sourceId;
  }
};



mojo.internal.Struct(
    mediaSession.mojom.AudioFocusManager_GetSourceFocusRequests_ResponseParamsSpec.$,
    'AudioFocusManager_GetSourceFocusRequests_ResponseParams',
    [
      mojo.internal.StructField(
        'requests', 0,
        0,
        mojo.internal.Array(mediaSession.mojom.AudioFocusRequestStateSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
mediaSession.mojom.AudioFocusManager_GetSourceFocusRequests_ResponseParams = class {
  constructor() {
    /** @export { !Array<!mediaSession.mojom.AudioFocusRequestState> } */
    this.requests;
  }
};



mojo.internal.Struct(
    mediaSession.mojom.AudioFocusManager_RequestIdReleased_ParamsSpec.$,
    'AudioFocusManager_RequestIdReleased_Params',
    [
      mojo.internal.StructField(
        'requestId', 0,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
mediaSession.mojom.AudioFocusManager_RequestIdReleased_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.requestId;
  }
};



mojo.internal.Struct(
    mediaSession.mojom.AudioFocusManager_StartDuckingAllAudio_ParamsSpec.$,
    'AudioFocusManager_StartDuckingAllAudio_Params',
    [
      mojo.internal.StructField(
        'exemptedRequestId', 0,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
mediaSession.mojom.AudioFocusManager_StartDuckingAllAudio_Params = class {
  constructor() {
    /** @export { (mojoBase.mojom.UnguessableToken|undefined) } */
    this.exemptedRequestId;
  }
};



mojo.internal.Struct(
    mediaSession.mojom.AudioFocusManager_StopDuckingAllAudio_ParamsSpec.$,
    'AudioFocusManager_StopDuckingAllAudio_Params',
    [
    ],
    [[0, 8],]);





/** @record */
mediaSession.mojom.AudioFocusManager_StopDuckingAllAudio_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    mediaSession.mojom.AudioFocusManager_FlushForTesting_ParamsSpec.$,
    'AudioFocusManager_FlushForTesting_Params',
    [
    ],
    [[0, 8],]);





/** @record */
mediaSession.mojom.AudioFocusManager_FlushForTesting_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    mediaSession.mojom.AudioFocusManager_FlushForTesting_ResponseParamsSpec.$,
    'AudioFocusManager_FlushForTesting_ResponseParams',
    [
    ],
    [[0, 8],]);





/** @record */
mediaSession.mojom.AudioFocusManager_FlushForTesting_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    mediaSession.mojom.AudioFocusManagerDebug_GetDebugInfoForRequest_ParamsSpec.$,
    'AudioFocusManagerDebug_GetDebugInfoForRequest_Params',
    [
      mojo.internal.StructField(
        'requestId', 0,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
mediaSession.mojom.AudioFocusManagerDebug_GetDebugInfoForRequest_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.requestId;
  }
};



mojo.internal.Struct(
    mediaSession.mojom.AudioFocusManagerDebug_GetDebugInfoForRequest_ResponseParamsSpec.$,
    'AudioFocusManagerDebug_GetDebugInfoForRequest_ResponseParams',
    [
      mojo.internal.StructField(
        'debugInfo', 0,
        0,
        mediaSession.mojom.MediaSessionDebugInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
mediaSession.mojom.AudioFocusManagerDebug_GetDebugInfoForRequest_ResponseParams = class {
  constructor() {
    /** @export { !mediaSession.mojom.MediaSessionDebugInfo } */
    this.debugInfo;
  }
};

