// services/media_session/public/mojom/audio_focus.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_MEDIA_SESSION_PUBLIC_MOJOM_AUDIO_FOCUS_MOJOM_DATA_VIEW_H_
#define SERVICES_MEDIA_SESSION_PUBLIC_MOJOM_AUDIO_FOCUS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "services/media_session/public/mojom/audio_focus.mojom-shared-internal.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "services/media_session/public/mojom/media_session.mojom-shared.h"


namespace media_session::mojom {
class AudioFocusRequestStateDataView;



}  // media_session::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::media_session::mojom::AudioFocusRequestStateDataView> {
  using Data = ::media_session::mojom::internal::AudioFocusRequestState_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace media_session::mojom {


enum class EnforcementMode : int32_t {
  
  kDefault = 0,
  
  kNone = 1,
  
  kSingleGroup = 2,
  
  kSingleSession = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, EnforcementMode value);
inline bool IsKnownEnumValue(EnforcementMode value) {
  return internal::EnforcementMode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class AudioFocusType : int32_t {
  
  kGain = 0,
  
  kGainTransientMayDuck = 1,
  
  kGainTransient = 2,
  
  kAmbient = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, AudioFocusType value);
inline bool IsKnownEnumValue(AudioFocusType value) {
  return internal::AudioFocusType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class AudioFocusObserverInterfaceBase {};

using AudioFocusObserverPtrDataView =
    mojo::InterfacePtrDataView<AudioFocusObserverInterfaceBase>;
using AudioFocusObserverRequestDataView =
    mojo::InterfaceRequestDataView<AudioFocusObserverInterfaceBase>;
using AudioFocusObserverAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<AudioFocusObserverInterfaceBase>;
using AudioFocusObserverAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<AudioFocusObserverInterfaceBase>;
class AudioFocusRequestClientInterfaceBase {};

using AudioFocusRequestClientPtrDataView =
    mojo::InterfacePtrDataView<AudioFocusRequestClientInterfaceBase>;
using AudioFocusRequestClientRequestDataView =
    mojo::InterfaceRequestDataView<AudioFocusRequestClientInterfaceBase>;
using AudioFocusRequestClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<AudioFocusRequestClientInterfaceBase>;
using AudioFocusRequestClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<AudioFocusRequestClientInterfaceBase>;
class AudioFocusManagerInterfaceBase {};

using AudioFocusManagerPtrDataView =
    mojo::InterfacePtrDataView<AudioFocusManagerInterfaceBase>;
using AudioFocusManagerRequestDataView =
    mojo::InterfaceRequestDataView<AudioFocusManagerInterfaceBase>;
using AudioFocusManagerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<AudioFocusManagerInterfaceBase>;
using AudioFocusManagerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<AudioFocusManagerInterfaceBase>;
class AudioFocusManagerDebugInterfaceBase {};

using AudioFocusManagerDebugPtrDataView =
    mojo::InterfacePtrDataView<AudioFocusManagerDebugInterfaceBase>;
using AudioFocusManagerDebugRequestDataView =
    mojo::InterfaceRequestDataView<AudioFocusManagerDebugInterfaceBase>;
using AudioFocusManagerDebugAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<AudioFocusManagerDebugInterfaceBase>;
using AudioFocusManagerDebugAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<AudioFocusManagerDebugInterfaceBase>;


class AudioFocusRequestStateDataView {
 public:
  AudioFocusRequestStateDataView() = default;

  AudioFocusRequestStateDataView(
      internal::AudioFocusRequestState_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSessionInfoDataView(
      ::media_session::mojom::MediaSessionInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSessionInfo(UserType* output) {
    
    auto* pointer = data_->session_info.Get();
    return mojo::internal::Deserialize<::media_session::mojom::MediaSessionInfoDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadAudioFocusType(UserType* output) const {
    auto data_value = data_->audio_focus_type;
    return mojo::internal::Deserialize<::media_session::mojom::AudioFocusType>(
        data_value, output);
  }
  AudioFocusType audio_focus_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media_session::mojom::AudioFocusType>(data_->audio_focus_type));
  }
  inline void GetSourceNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSourceName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `source_name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSourceName` instead "
    "of `ReadSourceName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->header_.version >= 2
                    ? data_->source_name.Get() : nullptr;
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetRequestIdDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRequestId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::UnguessableTokenDataView, UserType>(),
    "Attempting to read the optional `request_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRequestId` instead "
    "of `ReadRequestId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->header_.version >= 3
                    ? data_->request_id.Get() : nullptr;
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
  inline void GetSourceIdDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSourceId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::UnguessableTokenDataView, UserType>(),
    "Attempting to read the optional `source_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSourceId` instead "
    "of `ReadSourceId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->header_.version >= 9
                    ? data_->source_id.Get() : nullptr;
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        pointer, output, message_);
  }
 private:
  internal::AudioFocusRequestState_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // media_session::mojom

#endif  // SERVICES_MEDIA_SESSION_PUBLIC_MOJOM_AUDIO_FOCUS_MOJOM_DATA_VIEW_H_