// services/media_session/public/mojom/audio_focus.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_MEDIA_SESSION_PUBLIC_MOJOM_AUDIO_FOCUS_MOJOM_BLINK_H_
#define SERVICES_MEDIA_SESSION_PUBLIC_MOJOM_AUDIO_FOCUS_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/media_session/public/mojom/audio_focus.mojom-features.h"  // IWYU pragma: export
#include "services/media_session/public/mojom/audio_focus.mojom-shared.h"  // IWYU pragma: export
#include "services/media_session/public/mojom/audio_focus.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/unguessable_token.mojom-blink.h"
#include "services/media_session/public/mojom/media_session.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "base/token.h"
#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace media_session::mojom::blink {

class AudioFocusObserverProxy;

template <typename ImplRefTraits>
class AudioFocusObserverStub;

class AudioFocusObserverRequestValidator;


class BLINK_PLATFORM_EXPORT AudioFocusObserver
    : public AudioFocusObserverInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "media_session.mojom.AudioFocusObserver";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 8;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = AudioFocusObserverInterfaceBase;
  using Proxy_ = AudioFocusObserverProxy;

  template <typename ImplRefTraits>
  using Stub_ = AudioFocusObserverStub<ImplRefTraits>;

  using RequestValidator_ = AudioFocusObserverRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnFocusGainedMinVersion = 0,
    kOnFocusLostMinVersion = 0,
    kOnRequestIdReleasedMinVersion = 8,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnFocusGained_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnFocusLost_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnRequestIdReleased_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~AudioFocusObserver() = default;

  virtual void OnFocusGained(AudioFocusRequestStatePtr state) = 0;

  virtual void OnFocusLost(AudioFocusRequestStatePtr state) = 0;

  virtual void OnRequestIdReleased(const ::base::UnguessableToken& request_id) = 0;
};

class AudioFocusRequestClientProxy;

template <typename ImplRefTraits>
class AudioFocusRequestClientStub;

class AudioFocusRequestClientRequestValidator;
class AudioFocusRequestClientResponseValidator;


class BLINK_PLATFORM_EXPORT AudioFocusRequestClient
    : public AudioFocusRequestClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "media_session.mojom.AudioFocusRequestClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = AudioFocusRequestClientInterfaceBase;
  using Proxy_ = AudioFocusRequestClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = AudioFocusRequestClientStub<ImplRefTraits>;

  using RequestValidator_ = AudioFocusRequestClientRequestValidator;
  using ResponseValidator_ = AudioFocusRequestClientResponseValidator;
  enum MethodMinVersions : uint32_t {
    kRequestAudioFocusMinVersion = 0,
    kAbandonAudioFocusMinVersion = 0,
    kMediaSessionInfoChangedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct RequestAudioFocus_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AbandonAudioFocus_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct MediaSessionInfoChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~AudioFocusRequestClient() = default;

  using RequestAudioFocusCallback = base::OnceCallback<void()>;
  using RequestAudioFocusMojoCallback = base::OnceCallback<void()>;

  virtual void RequestAudioFocus(::media_session::mojom::blink::MediaSessionInfoPtr session_info, AudioFocusType type, RequestAudioFocusCallback callback) = 0;

  virtual void AbandonAudioFocus() = 0;

  virtual void MediaSessionInfoChanged(::media_session::mojom::blink::MediaSessionInfoPtr session_info) = 0;
};

class AudioFocusManagerProxy;

template <typename ImplRefTraits>
class AudioFocusManagerStub;

class AudioFocusManagerRequestValidator;
class AudioFocusManagerResponseValidator;


class BLINK_PLATFORM_EXPORT AudioFocusManager
    : public AudioFocusManagerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "media_session.mojom.AudioFocusManager";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr base::Token Uuid_{ 12444946592442959705ULL,
                                      10272338341526043560ULL };
  static constexpr uint32_t Version_ = 10;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = AudioFocusManagerInterfaceBase;
  using Proxy_ = AudioFocusManagerProxy;

  template <typename ImplRefTraits>
  using Stub_ = AudioFocusManagerStub<ImplRefTraits>;

  using RequestValidator_ = AudioFocusManagerRequestValidator;
  using ResponseValidator_ = AudioFocusManagerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kRequestAudioFocusMinVersion = 0,
    kRequestGroupedAudioFocusMinVersion = 4,
    kGetFocusRequestsMinVersion = 0,
    kAddObserverMinVersion = 0,
    kSetSourceMinVersion = 6,
    kSetEnforcementModeMinVersion = 5,
    kAddSourceObserverMinVersion = 7,
    kGetSourceFocusRequestsMinVersion = 7,
    kRequestIdReleasedMinVersion = 8,
    kStartDuckingAllAudioMinVersion = 10,
    kStopDuckingAllAudioMinVersion = 10,
    kFlushForTestingMinVersion = 10,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct RequestAudioFocus_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestGroupedAudioFocus_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetFocusRequests_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AddObserver_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetSource_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetEnforcementMode_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AddSourceObserver_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetSourceFocusRequests_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestIdReleased_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StartDuckingAllAudio_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StopDuckingAllAudio_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct FlushForTesting_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~AudioFocusManager() = default;

  using RequestAudioFocusCallback = base::OnceCallback<void(const ::base::UnguessableToken&)>;
  using RequestAudioFocusMojoCallback = base::OnceCallback<void(const ::base::UnguessableToken&)>;

  virtual void RequestAudioFocus(::mojo::PendingReceiver<AudioFocusRequestClient> client, ::mojo::PendingRemote<::media_session::mojom::blink::MediaSession> session, ::media_session::mojom::blink::MediaSessionInfoPtr session_info, AudioFocusType type, RequestAudioFocusCallback callback) = 0;

  using RequestGroupedAudioFocusCallback = base::OnceCallback<void(bool)>;
  using RequestGroupedAudioFocusMojoCallback = base::OnceCallback<void(bool)>;

  virtual void RequestGroupedAudioFocus(const ::base::UnguessableToken& request_id, ::mojo::PendingReceiver<AudioFocusRequestClient> client, ::mojo::PendingRemote<::media_session::mojom::blink::MediaSession> session, ::media_session::mojom::blink::MediaSessionInfoPtr session_info, AudioFocusType type, const ::base::UnguessableToken& group_id, RequestGroupedAudioFocusCallback callback) = 0;

  using GetFocusRequestsCallback = base::OnceCallback<void(::blink::Vector<AudioFocusRequestStatePtr>)>;
  using GetFocusRequestsMojoCallback = base::OnceCallback<void(::blink::Vector<AudioFocusRequestStatePtr>)>;

  virtual void GetFocusRequests(GetFocusRequestsCallback callback) = 0;

  virtual void AddObserver(::mojo::PendingRemote<AudioFocusObserver> observer) = 0;

  virtual void SetSource(const ::base::UnguessableToken& identity, const ::blink::String& name) = 0;

  virtual void SetEnforcementMode(EnforcementMode mode) = 0;

  virtual void AddSourceObserver(const ::base::UnguessableToken& source_id, ::mojo::PendingRemote<AudioFocusObserver> observer) = 0;

  using GetSourceFocusRequestsCallback = base::OnceCallback<void(::blink::Vector<AudioFocusRequestStatePtr>)>;
  using GetSourceFocusRequestsMojoCallback = base::OnceCallback<void(::blink::Vector<AudioFocusRequestStatePtr>)>;

  virtual void GetSourceFocusRequests(const ::base::UnguessableToken& source_id, GetSourceFocusRequestsCallback callback) = 0;

  virtual void RequestIdReleased(const ::base::UnguessableToken& request_id) = 0;

  virtual void StartDuckingAllAudio(const std::optional<::base::UnguessableToken>& exempted_request_id) = 0;

  virtual void StopDuckingAllAudio() = 0;

  using FlushForTestingCallback = base::OnceCallback<void()>;
  using FlushForTestingMojoCallback = base::OnceCallback<void()>;

  virtual void FlushForTesting(FlushForTestingCallback callback) = 0;
};

class AudioFocusManagerDebugProxy;

template <typename ImplRefTraits>
class AudioFocusManagerDebugStub;

class AudioFocusManagerDebugRequestValidator;
class AudioFocusManagerDebugResponseValidator;


class BLINK_PLATFORM_EXPORT AudioFocusManagerDebug
    : public AudioFocusManagerDebugInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "media_session.mojom.AudioFocusManagerDebug";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr base::Token Uuid_{ 14103221393334618575ULL,
                                      9807650304369957750ULL };
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = AudioFocusManagerDebugInterfaceBase;
  using Proxy_ = AudioFocusManagerDebugProxy;

  template <typename ImplRefTraits>
  using Stub_ = AudioFocusManagerDebugStub<ImplRefTraits>;

  using RequestValidator_ = AudioFocusManagerDebugRequestValidator;
  using ResponseValidator_ = AudioFocusManagerDebugResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetDebugInfoForRequestMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetDebugInfoForRequest_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~AudioFocusManagerDebug() = default;

  using GetDebugInfoForRequestCallback = base::OnceCallback<void(::media_session::mojom::blink::MediaSessionDebugInfoPtr)>;
  using GetDebugInfoForRequestMojoCallback = base::OnceCallback<void(::media_session::mojom::blink::MediaSessionDebugInfoPtr)>;

  virtual void GetDebugInfoForRequest(const ::base::UnguessableToken& request_id, GetDebugInfoForRequestCallback callback) = 0;
};



class BLINK_PLATFORM_EXPORT AudioFocusObserverProxy
    : public AudioFocusObserver {
 public:
  using InterfaceType = AudioFocusObserver;

  explicit AudioFocusObserverProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnFocusGained(AudioFocusRequestStatePtr state) final;
  
  void OnFocusLost(AudioFocusRequestStatePtr state) final;
  
  void OnRequestIdReleased(const ::base::UnguessableToken& request_id) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_PLATFORM_EXPORT AudioFocusRequestClientProxy
    : public AudioFocusRequestClient {
 public:
  using InterfaceType = AudioFocusRequestClient;

  explicit AudioFocusRequestClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void RequestAudioFocus(::media_session::mojom::blink::MediaSessionInfoPtr session_info, AudioFocusType type, RequestAudioFocusCallback callback) final;
  
  void AbandonAudioFocus() final;
  
  void MediaSessionInfoChanged(::media_session::mojom::blink::MediaSessionInfoPtr session_info) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_PLATFORM_EXPORT AudioFocusManagerProxy
    : public AudioFocusManager {
 public:
  using InterfaceType = AudioFocusManager;

  explicit AudioFocusManagerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void RequestAudioFocus(::mojo::PendingReceiver<AudioFocusRequestClient> client, ::mojo::PendingRemote<::media_session::mojom::blink::MediaSession> session, ::media_session::mojom::blink::MediaSessionInfoPtr session_info, AudioFocusType type, RequestAudioFocusCallback callback) final;
  
  void RequestGroupedAudioFocus(const ::base::UnguessableToken& request_id, ::mojo::PendingReceiver<AudioFocusRequestClient> client, ::mojo::PendingRemote<::media_session::mojom::blink::MediaSession> session, ::media_session::mojom::blink::MediaSessionInfoPtr session_info, AudioFocusType type, const ::base::UnguessableToken& group_id, RequestGroupedAudioFocusCallback callback) final;
  
  void GetFocusRequests(GetFocusRequestsCallback callback) final;
  
  void AddObserver(::mojo::PendingRemote<AudioFocusObserver> observer) final;
  
  void SetSource(const ::base::UnguessableToken& identity, const ::blink::String& name) final;
  
  void SetEnforcementMode(EnforcementMode mode) final;
  
  void AddSourceObserver(const ::base::UnguessableToken& source_id, ::mojo::PendingRemote<AudioFocusObserver> observer) final;
  
  void GetSourceFocusRequests(const ::base::UnguessableToken& source_id, GetSourceFocusRequestsCallback callback) final;
  
  void RequestIdReleased(const ::base::UnguessableToken& request_id) final;
  
  void StartDuckingAllAudio(const std::optional<::base::UnguessableToken>& exempted_request_id) final;
  
  void StopDuckingAllAudio() final;
  
  void FlushForTesting(FlushForTestingCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_PLATFORM_EXPORT AudioFocusManagerDebugProxy
    : public AudioFocusManagerDebug {
 public:
  using InterfaceType = AudioFocusManagerDebug;

  explicit AudioFocusManagerDebugProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetDebugInfoForRequest(const ::base::UnguessableToken& request_id, GetDebugInfoForRequestCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_PLATFORM_EXPORT AudioFocusObserverStubDispatch {
 public:
  static bool Accept(AudioFocusObserver* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      AudioFocusObserver* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<AudioFocusObserver>>
class AudioFocusObserverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  AudioFocusObserverStub() = default;
  ~AudioFocusObserverStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AudioFocusObserverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AudioFocusObserverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT AudioFocusRequestClientStubDispatch {
 public:
  static bool Accept(AudioFocusRequestClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      AudioFocusRequestClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<AudioFocusRequestClient>>
class AudioFocusRequestClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  AudioFocusRequestClientStub() = default;
  ~AudioFocusRequestClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AudioFocusRequestClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AudioFocusRequestClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT AudioFocusManagerStubDispatch {
 public:
  static bool Accept(AudioFocusManager* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      AudioFocusManager* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<AudioFocusManager>>
class AudioFocusManagerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  AudioFocusManagerStub() = default;
  ~AudioFocusManagerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AudioFocusManagerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AudioFocusManagerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT AudioFocusManagerDebugStubDispatch {
 public:
  static bool Accept(AudioFocusManagerDebug* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      AudioFocusManagerDebug* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<AudioFocusManagerDebug>>
class AudioFocusManagerDebugStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  AudioFocusManagerDebugStub() = default;
  ~AudioFocusManagerDebugStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AudioFocusManagerDebugStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AudioFocusManagerDebugStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT AudioFocusObserverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT AudioFocusRequestClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT AudioFocusManagerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT AudioFocusManagerDebugRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT AudioFocusRequestClientResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT AudioFocusManagerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT AudioFocusManagerDebugResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class BLINK_PLATFORM_EXPORT AudioFocusRequestState {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AudioFocusRequestState, T>::value>;
  using DataView = AudioFocusRequestStateDataView;
  using Data_ = internal::AudioFocusRequestState_Data;

  template <typename... Args>
  static AudioFocusRequestStatePtr New(Args&&... args) {
    return AudioFocusRequestStatePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AudioFocusRequestStatePtr From(const U& u) {
    return mojo::TypeConverter<AudioFocusRequestStatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AudioFocusRequestState>::Convert(*this);
  }


  AudioFocusRequestState();

  AudioFocusRequestState(
      ::media_session::mojom::blink::MediaSessionInfoPtr session_info,
      AudioFocusType audio_focus_type);

  AudioFocusRequestState(
      ::media_session::mojom::blink::MediaSessionInfoPtr session_info,
      AudioFocusType audio_focus_type,
      const ::blink::String& source_name);

  AudioFocusRequestState(
      ::media_session::mojom::blink::MediaSessionInfoPtr session_info,
      AudioFocusType audio_focus_type,
      const ::blink::String& source_name,
      const std::optional<::base::UnguessableToken>& request_id);

  AudioFocusRequestState(
      ::media_session::mojom::blink::MediaSessionInfoPtr session_info,
      AudioFocusType audio_focus_type,
      const ::blink::String& source_name,
      const std::optional<::base::UnguessableToken>& request_id,
      const std::optional<::base::UnguessableToken>& source_id);

AudioFocusRequestState(const AudioFocusRequestState&) = delete;
AudioFocusRequestState& operator=(const AudioFocusRequestState&) = delete;

  ~AudioFocusRequestState();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AudioFocusRequestStatePtr>
  AudioFocusRequestStatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AudioFocusRequestState::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AudioFocusRequestState::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AudioFocusRequestState::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AudioFocusRequestState::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AudioFocusRequestState::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AudioFocusRequestState::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AudioFocusRequestState_UnserializedMessageContext<
            UserType, AudioFocusRequestState::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AudioFocusRequestState::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AudioFocusRequestState::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AudioFocusRequestState_UnserializedMessageContext<
            UserType, AudioFocusRequestState::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AudioFocusRequestState::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::media_session::mojom::blink::MediaSessionInfoPtr session_info;
  
  AudioFocusType audio_focus_type;
  
  ::blink::String source_name;
  
  std::optional<::base::UnguessableToken> request_id;
  
  std::optional<::base::UnguessableToken> source_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AudioFocusRequestState::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AudioFocusRequestState::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AudioFocusRequestState::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AudioFocusRequestState::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
AudioFocusRequestStatePtr AudioFocusRequestState::Clone() const {
  return New(
      mojo::Clone(session_info),
      mojo::Clone(audio_focus_type),
      mojo::Clone(source_name),
      mojo::Clone(request_id),
      mojo::Clone(source_id)
  );
}

template <typename T, AudioFocusRequestState::EnableIfSame<T>*>
bool AudioFocusRequestState::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->session_info, other_struct.session_info))
    return false;
  if (!mojo::Equals(this->audio_focus_type, other_struct.audio_focus_type))
    return false;
  if (!mojo::Equals(this->source_name, other_struct.source_name))
    return false;
  if (!mojo::Equals(this->request_id, other_struct.request_id))
    return false;
  if (!mojo::Equals(this->source_id, other_struct.source_id))
    return false;
  return true;
}

template <typename T, AudioFocusRequestState::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.session_info < rhs.session_info)
    return true;
  if (rhs.session_info < lhs.session_info)
    return false;
  if (lhs.audio_focus_type < rhs.audio_focus_type)
    return true;
  if (rhs.audio_focus_type < lhs.audio_focus_type)
    return false;
  if (lhs.source_name < rhs.source_name)
    return true;
  if (rhs.source_name < lhs.source_name)
    return false;
  if (lhs.request_id < rhs.request_id)
    return true;
  if (rhs.request_id < lhs.request_id)
    return false;
  if (lhs.source_id < rhs.source_id)
    return true;
  if (rhs.source_id < lhs.source_id)
    return false;
  return false;
}


}  // media_session::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::media_session::mojom::blink::AudioFocusRequestState::DataView,
                                         ::media_session::mojom::blink::AudioFocusRequestStatePtr> {
  static bool IsNull(const ::media_session::mojom::blink::AudioFocusRequestStatePtr& input) { return !input; }
  static void SetToNull(::media_session::mojom::blink::AudioFocusRequestStatePtr* output) { output->reset(); }

  static const decltype(::media_session::mojom::blink::AudioFocusRequestState::session_info)& session_info(
      const ::media_session::mojom::blink::AudioFocusRequestStatePtr& input) {
    return input->session_info;
  }

  static decltype(::media_session::mojom::blink::AudioFocusRequestState::audio_focus_type) audio_focus_type(
      const ::media_session::mojom::blink::AudioFocusRequestStatePtr& input) {
    return input->audio_focus_type;
  }

  static const decltype(::media_session::mojom::blink::AudioFocusRequestState::source_name)& source_name(
      const ::media_session::mojom::blink::AudioFocusRequestStatePtr& input) {
    return input->source_name;
  }

  static const decltype(::media_session::mojom::blink::AudioFocusRequestState::request_id)& request_id(
      const ::media_session::mojom::blink::AudioFocusRequestStatePtr& input) {
    return input->request_id;
  }

  static const decltype(::media_session::mojom::blink::AudioFocusRequestState::source_id)& source_id(
      const ::media_session::mojom::blink::AudioFocusRequestStatePtr& input) {
    return input->source_id;
  }

  static bool Read(::media_session::mojom::blink::AudioFocusRequestState::DataView input, ::media_session::mojom::blink::AudioFocusRequestStatePtr* output);
};

}  // namespace mojo

#endif  // SERVICES_MEDIA_SESSION_PUBLIC_MOJOM_AUDIO_FOCUS_MOJOM_BLINK_H_