// services/image_annotation/public/mojom/image_annotation.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_IMAGE_ANNOTATION_PUBLIC_MOJOM_IMAGE_ANNOTATION_MOJOM_SHARED_H_
#define SERVICES_IMAGE_ANNOTATION_PUBLIC_MOJOM_IMAGE_ANNOTATION_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/image_annotation/public/mojom/image_annotation.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "services/image_annotation/public/mojom/image_annotation.mojom-data-view.h"




namespace std {

template <>
struct hash<::image_annotation::mojom::AnnotateImageError>
    : public mojo::internal::EnumHashImpl<::image_annotation::mojom::AnnotateImageError> {};

template <>
struct hash<::image_annotation::mojom::AnnotationType>
    : public mojo::internal::EnumHashImpl<::image_annotation::mojom::AnnotationType> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::image_annotation::mojom::AnnotateImageError, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::image_annotation::mojom::AnnotateImageError, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::image_annotation::mojom::AnnotateImageError>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::image_annotation::mojom::AnnotationType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::image_annotation::mojom::AnnotationType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::image_annotation::mojom::AnnotationType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::image_annotation::mojom::AnnotationDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::image_annotation::mojom::AnnotationDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::image_annotation::mojom::internal::Annotation_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::image_annotation::mojom::AnnotationType>(
      Traits::type(input),
      &fragment->type);

    fragment->score = Traits::score(input);

    decltype(Traits::text(input)) in_text = Traits::text(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->text)::BaseType> text_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_text,
      text_fragment);

    fragment->text.Set(
        text_fragment.is_null() ? nullptr : text_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->text.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null text in Annotation struct");
  }

  static bool Deserialize(::image_annotation::mojom::internal::Annotation_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::image_annotation::mojom::AnnotationDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::image_annotation::mojom::AnnotateImageResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::image_annotation::mojom::AnnotateImageResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::image_annotation::mojom::internal::AnnotateImageResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::image_annotation::mojom::AnnotateImageResultDataView::Tag::kErrorCode: {
    decltype(Traits::error_code(input))
    in_error_code = Traits::error_code(input);
        
mojo::internal::Serialize<::image_annotation::mojom::AnnotateImageError>(
  in_error_code,
  &fragment->data.f_error_code);
    break;
  }
  case ::image_annotation::mojom::AnnotateImageResultDataView::Tag::kAnnotations: {
    decltype(Traits::annotations(input))
    in_annotations = Traits::annotations(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_annotations)::BaseType>
    value_fragment(fragment.message());
        constexpr const mojo::internal::ContainerValidateParams& annotations_validate_params =
            mojo::internal::GetArrayValidator<0, false, nullptr>();
        
mojo::internal::Serialize<mojo::ArrayDataView<::image_annotation::mojom::AnnotationDataView>>(
  in_annotations,
  value_fragment,
  &annotations_validate_params);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null annotations in AnnotateImageResult union");
    fragment->data.f_annotations.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::image_annotation::mojom::internal::AnnotateImageResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::image_annotation::mojom::AnnotateImageResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace image_annotation::mojom {

inline void AnnotationDataView::GetTextDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->text.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void AnnotateImageResultDataView::GetAnnotationsDataView(
    mojo::ArrayDataView<AnnotationDataView>* output) const {
  CHECK(is_annotations());
  *output = mojo::ArrayDataView<AnnotationDataView>(data_->data.f_annotations.Get(), message_);
}


}  // image_annotation::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::image_annotation::mojom::AnnotateImageError> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::image_annotation::mojom::AnnotateImageError value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::image_annotation::mojom::AnnotationType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::image_annotation::mojom::AnnotationType value);
};

} // namespace perfetto

#endif  // SERVICES_IMAGE_ANNOTATION_PUBLIC_MOJOM_IMAGE_ANNOTATION_MOJOM_SHARED_H_