// services/image_annotation/public/mojom/image_annotation.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_IMAGE_ANNOTATION_PUBLIC_MOJOM_IMAGE_ANNOTATION_MOJOM_SEND_VALIDATION_H_
#define SERVICES_IMAGE_ANNOTATION_PUBLIC_MOJOM_IMAGE_ANNOTATION_MOJOM_SEND_VALIDATION_H_

#include "services/image_annotation/public/mojom/image_annotation.mojom-shared-internal.h"

#include "services/image_annotation/public/mojom/image_annotation.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::image_annotation::mojom::AnnotateImageError, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::image_annotation::mojom::AnnotationType, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::image_annotation::mojom::AnnotationDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::image_annotation::mojom::AnnotationDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::image_annotation::mojom::internal::Annotation_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::image_annotation::mojom::AnnotationType>(
        Traits::type(input),
        &fragment->type);

      fragment->score = Traits::score(input);

      decltype(Traits::text(input)) in_text = Traits::text(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->text)::BaseType> text_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_text,
        text_fragment);

      fragment->text.Set(
          text_fragment.is_null() ? nullptr : text_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->text.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null text in Annotation struct");
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::image_annotation::mojom::AnnotateImageResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::image_annotation::mojom::AnnotateImageResultDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::image_annotation::mojom::internal::AnnotateImageResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::image_annotation::mojom::AnnotateImageResultDataView::Tag::kErrorCode: {
    decltype(Traits::error_code(input))
    in_error_code = Traits::error_code(input);
        
mojo::internal::Serialize<::image_annotation::mojom::AnnotateImageError, send_validation>(
  in_error_code,
  &fragment->data.f_error_code);
    break;
  }
  case ::image_annotation::mojom::AnnotateImageResultDataView::Tag::kAnnotations: {
    decltype(Traits::annotations(input))
    in_annotations = Traits::annotations(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_annotations)::BaseType>
    value_fragment(fragment.message());
        constexpr const mojo::internal::ContainerValidateParams& annotations_validate_params =
            mojo::internal::GetArrayValidator<0, false, nullptr>();
        
mojo::internal::Serialize<mojo::ArrayDataView<::image_annotation::mojom::AnnotationDataView>, send_validation>(
  in_annotations,
  value_fragment,
  &annotations_validate_params);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null annotations in AnnotateImageResult union");
    fragment->data.f_annotations.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_IMAGE_ANNOTATION_PUBLIC_MOJOM_IMAGE_ANNOTATION_MOJOM_SEND_VALIDATION_H_