// services/device/public/mojom/wake_lock_context.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  WakeLockReason as device_mojom_WakeLockReason,
  WakeLockReasonSpec as device_mojom_WakeLockReasonSpec,
  WakeLockType as device_mojom_WakeLockType,
  WakeLockTypeSpec as device_mojom_WakeLockTypeSpec,
  WakeLockRemote as device_mojom_WakeLockRemote,
  WakeLockPendingReceiver as device_mojom_WakeLockPendingReceiver
} from './wake_lock.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class WakeLockContextPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'device.mojom.WakeLockContext', scope);
  }
}

/** @interface */
export class WakeLockContextInterface {
  
  /**
   * @param { !device_mojom_WakeLockType } type
   * @param { !device_mojom_WakeLockReason } reason
   * @param { !string } description
   * @param { !device_mojom_WakeLockPendingReceiver } wakeLock
   */

  getWakeLock(type, reason, description, wakeLock) {}
}

/**
 * @implements { WakeLockContextInterface }
 */
export class WakeLockContextRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!WakeLockContextPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          WakeLockContextPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!WakeLockContextPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !device_mojom_WakeLockType } type
   * @param { !device_mojom_WakeLockReason } reason
   * @param { !string } description
   * @param { !device_mojom_WakeLockPendingReceiver } wakeLock
   */

  getWakeLock(
      type,
      reason,
      description,
      wakeLock) {
    this.proxy.sendMessage(
        0,
        WakeLockContext_GetWakeLock_ParamsSpec.$,
        null,
        [
          type,
          reason,
          description,
          wakeLock
        ],
        false);
  }
}

/**
 * An object which receives request messages for the WakeLockContext
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class WakeLockContextReceiver {
  /**
   * @param {!WakeLockContextInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!WakeLockContextRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        WakeLockContextRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!WakeLockContextRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        WakeLockContext_GetWakeLock_ParamsSpec.$,
        null,
        impl.getWakeLock.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class WakeLockContext {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.WakeLockContext";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!WakeLockContextRemote}
   */
  static getRemote() {
    let remote = new WakeLockContextRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the WakeLockContext
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class WakeLockContextCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      WakeLockContextRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!WakeLockContextRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getWakeLock =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        WakeLockContext_GetWakeLock_ParamsSpec.$,
        null,
        this.getWakeLock.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WakeLockContext_GetWakeLock_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    WakeLockContext_GetWakeLock_ParamsSpec.$,
    'WakeLockContext_GetWakeLock_Params',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        device_mojom_WakeLockTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'reason', 4,
        0,
        device_mojom_WakeLockReasonSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'description', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'wakeLock', 16,
        0,
        mojo.internal.InterfaceRequest(device_mojom_WakeLockPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class WakeLockContext_GetWakeLock_Params {
  constructor() {
    /** @type { !device_mojom_WakeLockType } */
    this.type;
    /** @type { !device_mojom_WakeLockReason } */
    this.reason;
    /** @type { !string } */
    this.description;
    /** @type { !device_mojom_WakeLockPendingReceiver } */
    this.wakeLock;
  }
}

