// services/device/public/mojom/vibration_manager.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class VibrationManagerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'device.mojom.VibrationManager', scope);
  }
}

/** @interface */
export class VibrationManagerInterface {
  
  /**
   * @param { !bigint } milliseconds
   * @return {!Promise}
   */

  vibrate(milliseconds) {}
  
  /**
   * @return {!Promise}
   */

  cancel() {}
}

/**
 * @implements { VibrationManagerInterface }
 */
export class VibrationManagerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!VibrationManagerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          VibrationManagerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!VibrationManagerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !bigint } milliseconds
   * @return {!Promise}
   */

  vibrate(
      milliseconds) {
    return this.proxy.sendMessage(
        0,
        VibrationManager_Vibrate_ParamsSpec.$,
        VibrationManager_Vibrate_ResponseParamsSpec.$,
        [
          milliseconds
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  cancel() {
    return this.proxy.sendMessage(
        1,
        VibrationManager_Cancel_ParamsSpec.$,
        VibrationManager_Cancel_ResponseParamsSpec.$,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the VibrationManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class VibrationManagerReceiver {
  /**
   * @param {!VibrationManagerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!VibrationManagerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        VibrationManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!VibrationManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        VibrationManager_Vibrate_ParamsSpec.$,
        VibrationManager_Vibrate_ResponseParamsSpec.$,
        impl.vibrate.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        VibrationManager_Cancel_ParamsSpec.$,
        VibrationManager_Cancel_ResponseParamsSpec.$,
        impl.cancel.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class VibrationManager {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.VibrationManager";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!VibrationManagerRemote}
   */
  static getRemote() {
    let remote = new VibrationManagerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the VibrationManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class VibrationManagerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      VibrationManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!VibrationManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.vibrate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        VibrationManager_Vibrate_ParamsSpec.$,
        VibrationManager_Vibrate_ResponseParamsSpec.$,
        this.vibrate.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.cancel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        VibrationManager_Cancel_ParamsSpec.$,
        VibrationManager_Cancel_ResponseParamsSpec.$,
        this.cancel.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class VibrationManagerListenerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'device.mojom.VibrationManagerListener', scope);
  }
}

/** @interface */
export class VibrationManagerListenerInterface {
  
  /**
   */

  onVibrate() {}
}

/**
 * @implements { VibrationManagerListenerInterface }
 */
export class VibrationManagerListenerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!VibrationManagerListenerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          VibrationManagerListenerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!VibrationManagerListenerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  onVibrate() {
    this.proxy.sendMessage(
        0,
        VibrationManagerListener_OnVibrate_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the VibrationManagerListener
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class VibrationManagerListenerReceiver {
  /**
   * @param {!VibrationManagerListenerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!VibrationManagerListenerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        VibrationManagerListenerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!VibrationManagerListenerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        VibrationManagerListener_OnVibrate_ParamsSpec.$,
        null,
        impl.onVibrate.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class VibrationManagerListener {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.VibrationManagerListener";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!VibrationManagerListenerRemote}
   */
  static getRemote() {
    let remote = new VibrationManagerListenerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the VibrationManagerListener
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class VibrationManagerListenerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      VibrationManagerListenerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!VibrationManagerListenerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onVibrate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        VibrationManagerListener_OnVibrate_ParamsSpec.$,
        null,
        this.onVibrate.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VibrationManager_Vibrate_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VibrationManager_Vibrate_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VibrationManager_Cancel_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VibrationManager_Cancel_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const VibrationManagerListener_OnVibrate_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    VibrationManager_Vibrate_ParamsSpec.$,
    'VibrationManager_Vibrate_Params',
    [
      mojo.internal.StructField(
        'milliseconds', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class VibrationManager_Vibrate_Params {
  constructor() {
    /** @type { !bigint } */
    this.milliseconds;
  }
}



mojo.internal.Struct(
    VibrationManager_Vibrate_ResponseParamsSpec.$,
    'VibrationManager_Vibrate_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class VibrationManager_Vibrate_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    VibrationManager_Cancel_ParamsSpec.$,
    'VibrationManager_Cancel_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class VibrationManager_Cancel_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    VibrationManager_Cancel_ResponseParamsSpec.$,
    'VibrationManager_Cancel_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class VibrationManager_Cancel_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    VibrationManagerListener_OnVibrate_ParamsSpec.$,
    'VibrationManagerListener_OnVibrate_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class VibrationManagerListener_OnVibrate_Params {
  constructor() {
  }
}

