// services/device/public/mojom/usb_manager_test.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/device/public/mojom/usb_manager_test.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/device/public/mojom/usb_manager_test.mojom-params-data.h"
#include "services/device/public/mojom/usb_manager_test.mojom-shared-message-ids.h"

#include "services/device/public/mojom/usb_manager_test.mojom-import-headers.h"
#include "services/device/public/mojom/usb_manager_test.mojom-test-utils.h"


namespace device::mojom {
TestDeviceInfo::TestDeviceInfo()
    : guid(),
      name(),
      serial_number(),
      landing_page() {}

TestDeviceInfo::TestDeviceInfo(
    const std::string& guid_in,
    const std::string& name_in,
    const std::string& serial_number_in,
    const ::GURL& landing_page_in)
    : guid(std::move(guid_in)),
      name(std::move(name_in)),
      serial_number(std::move(serial_number_in)),
      landing_page(std::move(landing_page_in)) {}

TestDeviceInfo::~TestDeviceInfo() = default;

void TestDeviceInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "guid"), this->guid,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "serial_number"), this->serial_number,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "landing_page"), this->landing_page,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TestDeviceInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

UsbDeviceManagerTest::IPCStableHashFunction UsbDeviceManagerTest::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::UsbDeviceManagerTest>(message.name())) {
    case messages::UsbDeviceManagerTest::kAddDeviceForTesting: {
      return &UsbDeviceManagerTest::AddDeviceForTesting_Sym::IPCStableHash;
    }
    case messages::UsbDeviceManagerTest::kRemoveDeviceForTesting: {
      return &UsbDeviceManagerTest::RemoveDeviceForTesting_Sym::IPCStableHash;
    }
    case messages::UsbDeviceManagerTest::kGetTestDevices: {
      return &UsbDeviceManagerTest::GetTestDevices_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* UsbDeviceManagerTest::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::UsbDeviceManagerTest>(message.name())) {
      case messages::UsbDeviceManagerTest::kAddDeviceForTesting:
            return "Receive device::mojom::UsbDeviceManagerTest::AddDeviceForTesting";
      case messages::UsbDeviceManagerTest::kRemoveDeviceForTesting:
            return "Receive device::mojom::UsbDeviceManagerTest::RemoveDeviceForTesting";
      case messages::UsbDeviceManagerTest::kGetTestDevices:
            return "Receive device::mojom::UsbDeviceManagerTest::GetTestDevices";
    }
  } else {
    switch (static_cast<messages::UsbDeviceManagerTest>(message.name())) {
      case messages::UsbDeviceManagerTest::kAddDeviceForTesting:
            return "Receive reply device::mojom::UsbDeviceManagerTest::AddDeviceForTesting";
      case messages::UsbDeviceManagerTest::kRemoveDeviceForTesting:
            return "Receive reply device::mojom::UsbDeviceManagerTest::RemoveDeviceForTesting";
      case messages::UsbDeviceManagerTest::kGetTestDevices:
            return "Receive reply device::mojom::UsbDeviceManagerTest::GetTestDevices";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t UsbDeviceManagerTest::AddDeviceForTesting_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x38eaa739;  // IPCStableHash for device::mojom::UsbDeviceManagerTest::AddDeviceForTesting
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UsbDeviceManagerTest::RemoveDeviceForTesting_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc2548b1f;  // IPCStableHash for device::mojom::UsbDeviceManagerTest::RemoveDeviceForTesting
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t UsbDeviceManagerTest::GetTestDevices_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2793dff8;  // IPCStableHash for device::mojom::UsbDeviceManagerTest::GetTestDevices
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class UsbDeviceManagerTest_AddDeviceForTesting_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  UsbDeviceManagerTest_AddDeviceForTesting_ForwardToCallback(
      UsbDeviceManagerTest::AddDeviceForTestingCallback callback
      ) : callback_(std::move(callback)) {
  }

  UsbDeviceManagerTest_AddDeviceForTesting_ForwardToCallback(const UsbDeviceManagerTest_AddDeviceForTesting_ForwardToCallback&) = delete;
  UsbDeviceManagerTest_AddDeviceForTesting_ForwardToCallback& operator=(const UsbDeviceManagerTest_AddDeviceForTesting_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  UsbDeviceManagerTest::AddDeviceForTestingCallback callback_;
};

class UsbDeviceManagerTest_RemoveDeviceForTesting_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  UsbDeviceManagerTest_RemoveDeviceForTesting_ForwardToCallback(
      UsbDeviceManagerTest::RemoveDeviceForTestingCallback callback
      ) : callback_(std::move(callback)) {
  }

  UsbDeviceManagerTest_RemoveDeviceForTesting_ForwardToCallback(const UsbDeviceManagerTest_RemoveDeviceForTesting_ForwardToCallback&) = delete;
  UsbDeviceManagerTest_RemoveDeviceForTesting_ForwardToCallback& operator=(const UsbDeviceManagerTest_RemoveDeviceForTesting_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  UsbDeviceManagerTest::RemoveDeviceForTestingCallback callback_;
};

class UsbDeviceManagerTest_GetTestDevices_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  UsbDeviceManagerTest_GetTestDevices_ForwardToCallback(
      UsbDeviceManagerTest::GetTestDevicesCallback callback
      ) : callback_(std::move(callback)) {
  }

  UsbDeviceManagerTest_GetTestDevices_ForwardToCallback(const UsbDeviceManagerTest_GetTestDevices_ForwardToCallback&) = delete;
  UsbDeviceManagerTest_GetTestDevices_ForwardToCallback& operator=(const UsbDeviceManagerTest_GetTestDevices_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  UsbDeviceManagerTest::GetTestDevicesCallback callback_;
};

UsbDeviceManagerTestProxy::UsbDeviceManagerTestProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void UsbDeviceManagerTestProxy::AddDeviceForTesting(
    const std::string& in_name, const std::string& in_serial_number, const std::string& in_landing_page, AddDeviceForTestingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::UsbDeviceManagerTest::AddDeviceForTesting", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("name"), in_name,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("serial_number"), in_serial_number,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("landing_page"), in_landing_page,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UsbDeviceManagerTest::kAddDeviceForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::UsbDeviceManagerTest_AddDeviceForTesting_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->name)::BaseType> name_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_name,
    name_fragment);

  params->name.Set(
      name_fragment.is_null() ? nullptr : name_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->name.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null name in UsbDeviceManagerTest.AddDeviceForTesting request");
  mojo::internal::MessageFragment<
      typename decltype(params->serial_number)::BaseType> serial_number_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_serial_number,
    serial_number_fragment);

  params->serial_number.Set(
      serial_number_fragment.is_null() ? nullptr : serial_number_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->serial_number.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null serial_number in UsbDeviceManagerTest.AddDeviceForTesting request");
  mojo::internal::MessageFragment<
      typename decltype(params->landing_page)::BaseType> landing_page_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_landing_page,
    landing_page_fragment);

  params->landing_page.Set(
      landing_page_fragment.is_null() ? nullptr : landing_page_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->landing_page.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null landing_page in UsbDeviceManagerTest.AddDeviceForTesting request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UsbDeviceManagerTest::Name_);
  message.set_method_name("AddDeviceForTesting");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new UsbDeviceManagerTest_AddDeviceForTesting_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void UsbDeviceManagerTestProxy::RemoveDeviceForTesting(
    const std::string& in_guid, RemoveDeviceForTestingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::UsbDeviceManagerTest::RemoveDeviceForTesting", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("guid"), in_guid,
                        "<value of type const std::string&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UsbDeviceManagerTest::kRemoveDeviceForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::UsbDeviceManagerTest_RemoveDeviceForTesting_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->guid)::BaseType> guid_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_guid,
    guid_fragment);

  params->guid.Set(
      guid_fragment.is_null() ? nullptr : guid_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->guid.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null guid in UsbDeviceManagerTest.RemoveDeviceForTesting request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UsbDeviceManagerTest::Name_);
  message.set_method_name("RemoveDeviceForTesting");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new UsbDeviceManagerTest_RemoveDeviceForTesting_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void UsbDeviceManagerTestProxy::GetTestDevices(
    GetTestDevicesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send device::mojom::UsbDeviceManagerTest::GetTestDevices");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UsbDeviceManagerTest::kGetTestDevices), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::UsbDeviceManagerTest_GetTestDevices_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UsbDeviceManagerTest::Name_);
  message.set_method_name("GetTestDevices");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new UsbDeviceManagerTest_GetTestDevices_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class UsbDeviceManagerTest_AddDeviceForTesting_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static UsbDeviceManagerTest::AddDeviceForTestingCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<UsbDeviceManagerTest_AddDeviceForTesting_ProxyToResponder> proxy(
        new UsbDeviceManagerTest_AddDeviceForTesting_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&UsbDeviceManagerTest_AddDeviceForTesting_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~UsbDeviceManagerTest_AddDeviceForTesting_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  UsbDeviceManagerTest_AddDeviceForTesting_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "UsbDeviceManagerTest::AddDeviceForTestingCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success, const std::string& in_message);
};

bool UsbDeviceManagerTest_AddDeviceForTesting_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::UsbDeviceManagerTest_AddDeviceForTesting_ResponseParams_Data* params =
      reinterpret_cast<
          internal::UsbDeviceManagerTest_AddDeviceForTesting_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for UsbDeviceManagerTest.0
  bool success = true;
  bool p_success{};
  std::string p_message{};
  UsbDeviceManagerTest_AddDeviceForTesting_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (success && !input_data_view.ReadMessage(&p_message))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        UsbDeviceManagerTest::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success), 
std::move(p_message));
  }
  return true;
}

void UsbDeviceManagerTest_AddDeviceForTesting_ProxyToResponder::Run(
    bool in_success, const std::string& in_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::UsbDeviceManagerTest::AddDeviceForTesting", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("message"), in_message,
                        "<value of type const std::string&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UsbDeviceManagerTest::kAddDeviceForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::UsbDeviceManagerTest_AddDeviceForTesting_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;
  mojo::internal::MessageFragment<
      typename decltype(params->message)::BaseType> message_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_message,
    message_fragment);

  params->message.Set(
      message_fragment.is_null() ? nullptr : message_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->message.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null message in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UsbDeviceManagerTest::Name_);
  message.set_method_name("AddDeviceForTesting");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class UsbDeviceManagerTest_RemoveDeviceForTesting_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static UsbDeviceManagerTest::RemoveDeviceForTestingCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<UsbDeviceManagerTest_RemoveDeviceForTesting_ProxyToResponder> proxy(
        new UsbDeviceManagerTest_RemoveDeviceForTesting_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&UsbDeviceManagerTest_RemoveDeviceForTesting_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~UsbDeviceManagerTest_RemoveDeviceForTesting_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  UsbDeviceManagerTest_RemoveDeviceForTesting_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "UsbDeviceManagerTest::RemoveDeviceForTestingCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool UsbDeviceManagerTest_RemoveDeviceForTesting_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::UsbDeviceManagerTest_RemoveDeviceForTesting_ResponseParams_Data* params =
      reinterpret_cast<
          internal::UsbDeviceManagerTest_RemoveDeviceForTesting_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for UsbDeviceManagerTest.1
  bool success = true;
  UsbDeviceManagerTest_RemoveDeviceForTesting_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        UsbDeviceManagerTest::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void UsbDeviceManagerTest_RemoveDeviceForTesting_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply device::mojom::UsbDeviceManagerTest::RemoveDeviceForTesting");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UsbDeviceManagerTest::kRemoveDeviceForTesting), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::UsbDeviceManagerTest_RemoveDeviceForTesting_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UsbDeviceManagerTest::Name_);
  message.set_method_name("RemoveDeviceForTesting");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class UsbDeviceManagerTest_GetTestDevices_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static UsbDeviceManagerTest::GetTestDevicesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<UsbDeviceManagerTest_GetTestDevices_ProxyToResponder> proxy(
        new UsbDeviceManagerTest_GetTestDevices_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&UsbDeviceManagerTest_GetTestDevices_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~UsbDeviceManagerTest_GetTestDevices_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  UsbDeviceManagerTest_GetTestDevices_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "UsbDeviceManagerTest::GetTestDevicesCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<TestDeviceInfoPtr> in_devices);
};

bool UsbDeviceManagerTest_GetTestDevices_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::UsbDeviceManagerTest_GetTestDevices_ResponseParams_Data* params =
      reinterpret_cast<
          internal::UsbDeviceManagerTest_GetTestDevices_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for UsbDeviceManagerTest.2
  bool success = true;
  std::vector<TestDeviceInfoPtr> p_devices{};
  UsbDeviceManagerTest_GetTestDevices_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadDevices(&p_devices))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        UsbDeviceManagerTest::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_devices));
  }
  return true;
}

void UsbDeviceManagerTest_GetTestDevices_ProxyToResponder::Run(
    std::vector<TestDeviceInfoPtr> in_devices) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::UsbDeviceManagerTest::GetTestDevices", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("devices"), in_devices,
                        "<value of type std::vector<TestDeviceInfoPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::UsbDeviceManagerTest::kGetTestDevices), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::UsbDeviceManagerTest_GetTestDevices_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->devices)::BaseType>
      devices_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& devices_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::TestDeviceInfoDataView>>(
    in_devices,
    devices_fragment,
    &devices_validate_params);

  params->devices.Set(
      devices_fragment.is_null() ? nullptr : devices_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->devices.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null devices in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(UsbDeviceManagerTest::Name_);
  message.set_method_name("GetTestDevices");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool UsbDeviceManagerTestStubDispatch::Accept(
    UsbDeviceManagerTest* impl,
    mojo::Message* message) {
  switch (static_cast<messages::UsbDeviceManagerTest>(message->header()->name)) {
    case messages::UsbDeviceManagerTest::kAddDeviceForTesting: {
      break;
    }
    case messages::UsbDeviceManagerTest::kRemoveDeviceForTesting: {
      break;
    }
    case messages::UsbDeviceManagerTest::kGetTestDevices: {
      break;
    }
  }
  return false;
}

// static
bool UsbDeviceManagerTestStubDispatch::AcceptWithResponder(
    UsbDeviceManagerTest* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::UsbDeviceManagerTest>(message->header()->name)) {
    case messages::UsbDeviceManagerTest::kAddDeviceForTesting: {
      internal::UsbDeviceManagerTest_AddDeviceForTesting_Params_Data* params =
          reinterpret_cast<
              internal::UsbDeviceManagerTest_AddDeviceForTesting_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for UsbDeviceManagerTest.0
      bool success = true;
      std::string p_name{};
      std::string p_serial_number{};
      std::string p_landing_page{};
      UsbDeviceManagerTest_AddDeviceForTesting_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadName(&p_name))
        success = false;
      if (success && !input_data_view.ReadSerialNumber(&p_serial_number))
        success = false;
      if (success && !input_data_view.ReadLandingPage(&p_landing_page))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UsbDeviceManagerTest::Name_, 0, false);
        return false;
      }
      auto callback =
          UsbDeviceManagerTest_AddDeviceForTesting_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddDeviceForTesting(        
        std::move(p_name), 
        std::move(p_serial_number), 
        std::move(p_landing_page), std::move(callback));
      return true;
    }
    case messages::UsbDeviceManagerTest::kRemoveDeviceForTesting: {
      internal::UsbDeviceManagerTest_RemoveDeviceForTesting_Params_Data* params =
          reinterpret_cast<
              internal::UsbDeviceManagerTest_RemoveDeviceForTesting_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for UsbDeviceManagerTest.1
      bool success = true;
      std::string p_guid{};
      UsbDeviceManagerTest_RemoveDeviceForTesting_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadGuid(&p_guid))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UsbDeviceManagerTest::Name_, 1, false);
        return false;
      }
      auto callback =
          UsbDeviceManagerTest_RemoveDeviceForTesting_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoveDeviceForTesting(        
        std::move(p_guid), std::move(callback));
      return true;
    }
    case messages::UsbDeviceManagerTest::kGetTestDevices: {
      internal::UsbDeviceManagerTest_GetTestDevices_Params_Data* params =
          reinterpret_cast<
              internal::UsbDeviceManagerTest_GetTestDevices_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for UsbDeviceManagerTest.2
      bool success = true;
      UsbDeviceManagerTest_GetTestDevices_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            UsbDeviceManagerTest::Name_, 2, false);
        return false;
      }
      auto callback =
          UsbDeviceManagerTest_GetTestDevices_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetTestDevices(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kUsbDeviceManagerTestValidationInfo[] = {
    { &internal::UsbDeviceManagerTest_AddDeviceForTesting_Params_Data::Validate,
     &internal::UsbDeviceManagerTest_AddDeviceForTesting_ResponseParams_Data::Validate},
    { &internal::UsbDeviceManagerTest_RemoveDeviceForTesting_Params_Data::Validate,
     &internal::UsbDeviceManagerTest_RemoveDeviceForTesting_ResponseParams_Data::Validate},
    { &internal::UsbDeviceManagerTest_GetTestDevices_Params_Data::Validate,
     &internal::UsbDeviceManagerTest_GetTestDevices_ResponseParams_Data::Validate},
};

bool UsbDeviceManagerTestRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::device::mojom::UsbDeviceManagerTest::Name_,
    kUsbDeviceManagerTestValidationInfo);
}

bool UsbDeviceManagerTestResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::device::mojom::UsbDeviceManagerTest::Name_,
    kUsbDeviceManagerTestValidationInfo);
}


}  // device::mojom


namespace mojo {


// static
bool StructTraits<::device::mojom::TestDeviceInfo::DataView, ::device::mojom::TestDeviceInfoPtr>::Read(
    ::device::mojom::TestDeviceInfo::DataView input,
    ::device::mojom::TestDeviceInfoPtr* output) {
  bool success = true;
  ::device::mojom::TestDeviceInfoPtr result(::device::mojom::TestDeviceInfo::New());
  
      if (success && !input.ReadGuid(&result->guid))
        success = false;
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadSerialNumber(&result->serial_number))
        success = false;
      if (success && !input.ReadLandingPage(&result->landing_page))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace device::mojom {


void UsbDeviceManagerTestInterceptorForTesting::AddDeviceForTesting(const std::string& name, const std::string& serial_number, const std::string& landing_page, AddDeviceForTestingCallback callback) {
  GetForwardingInterface()->AddDeviceForTesting(
    std::move(name)
    , 
    std::move(serial_number)
    , 
    std::move(landing_page)
    , std::move(callback));
}
void UsbDeviceManagerTestInterceptorForTesting::RemoveDeviceForTesting(const std::string& guid, RemoveDeviceForTestingCallback callback) {
  GetForwardingInterface()->RemoveDeviceForTesting(
    std::move(guid)
    , std::move(callback));
}
void UsbDeviceManagerTestInterceptorForTesting::GetTestDevices(GetTestDevicesCallback callback) {
  GetForwardingInterface()->GetTestDevices(std::move(callback));
}
UsbDeviceManagerTestAsyncWaiter::UsbDeviceManagerTestAsyncWaiter(
    UsbDeviceManagerTest* proxy) : proxy_(proxy) {}

UsbDeviceManagerTestAsyncWaiter::~UsbDeviceManagerTestAsyncWaiter() = default;


void UsbDeviceManagerTestAsyncWaiter::AddDeviceForTesting(
    const std::string& name, const std::string& serial_number, const std::string& landing_page, bool* out_success, std::string* out_message) {
  base::RunLoop loop;
  proxy_->AddDeviceForTesting(
      std::move(name),
      std::move(serial_number),
      std::move(landing_page),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             std::string* out_message
,
             bool success,
             const std::string& message) {*out_success = std::move(success);*out_message = std::move(message);
            loop->Quit();
          },
          &loop,
          out_success,
          out_message));
  loop.Run();
}



void UsbDeviceManagerTestAsyncWaiter::RemoveDeviceForTesting(
    const std::string& guid) {
  base::RunLoop loop;
  proxy_->RemoveDeviceForTesting(
      std::move(guid),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}



void UsbDeviceManagerTestAsyncWaiter::GetTestDevices(
    std::vector<TestDeviceInfoPtr>* out_devices) {
  base::RunLoop loop;
  proxy_->GetTestDevices(
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<TestDeviceInfoPtr>* out_devices
,
             std::vector<TestDeviceInfoPtr> devices) {*out_devices = std::move(devices);
            loop->Quit();
          },
          &loop,
          out_devices));
  loop.Run();
}

std::vector<TestDeviceInfoPtr> UsbDeviceManagerTestAsyncWaiter::GetTestDevices(
    ) {
  std::vector<TestDeviceInfoPtr> async_wait_result;
  GetTestDevices(&async_wait_result);
  return async_wait_result;
}






}  // device::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif