// services/device/public/mojom/usb_manager_test.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  UrlSpec as url_mojom_UrlSpec,
  Url as url_mojom_Url
} from '//resources/mojo/url/mojom/url.mojom-webui.js';







export type UsbDeviceManagerTestPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<UsbDeviceManagerTestPendingReceiver>;

export class UsbDeviceManagerTestPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<UsbDeviceManagerTest> {

  handle: mojo.internal.interfaceSupport.Endpoint<UsbDeviceManagerTestPendingReceiver>;
  constructor(handle: MojoHandle|UsbDeviceManagerTestPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'device.mojom.UsbDeviceManagerTest',
        scope);
  }
}

export interface UsbDeviceManagerTestInterface {
  addDeviceForTesting(name: string, serialNumber: string, landingPage: string): Promise<{
        success: boolean,
        message: string, }>;
  removeDeviceForTesting(guid: string): Promise<void>;
  getTestDevices(): Promise<{
        devices: TestDeviceInfo[], }>;
}

export class UsbDeviceManagerTestRemote implements UsbDeviceManagerTestInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<UsbDeviceManagerTestPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<UsbDeviceManagerTestPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|UsbDeviceManagerTestPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          UsbDeviceManagerTestPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  addDeviceForTesting(
      name: string,
      serialNumber: string,
      landingPage: string): Promise<{
        success: boolean,
        message: string, }> {
    return this.proxy.sendMessage(
        0,
        UsbDeviceManagerTest_AddDeviceForTesting_ParamsSpec.$,
        UsbDeviceManagerTest_AddDeviceForTesting_ResponseParamsSpec.$,
        [
          name,
          serialNumber,
          landingPage
        ],
        false);
  }

  removeDeviceForTesting(
      guid: string): Promise<void> {
    return this.proxy.sendMessage(
        1,
        UsbDeviceManagerTest_RemoveDeviceForTesting_ParamsSpec.$,
        UsbDeviceManagerTest_RemoveDeviceForTesting_ResponseParamsSpec.$,
        [
          guid
        ],
        false);
  }

  getTestDevices(): Promise<{
        devices: TestDeviceInfo[], }> {
    return this.proxy.sendMessage(
        2,
        UsbDeviceManagerTest_GetTestDevices_ParamsSpec.$,
        UsbDeviceManagerTest_GetTestDevices_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the UsbDeviceManagerTest
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class UsbDeviceManagerTestReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    UsbDeviceManagerTestRemote, UsbDeviceManagerTestPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    UsbDeviceManagerTestRemote, UsbDeviceManagerTestPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: UsbDeviceManagerTestInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        UsbDeviceManagerTestRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        UsbDeviceManagerTest_AddDeviceForTesting_ParamsSpec.$,
        UsbDeviceManagerTest_AddDeviceForTesting_ResponseParamsSpec.$,
        impl.addDeviceForTesting.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        UsbDeviceManagerTest_RemoveDeviceForTesting_ParamsSpec.$,
        UsbDeviceManagerTest_RemoveDeviceForTesting_ResponseParamsSpec.$,
        impl.removeDeviceForTesting.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        UsbDeviceManagerTest_GetTestDevices_ParamsSpec.$,
        UsbDeviceManagerTest_GetTestDevices_ResponseParamsSpec.$,
        impl.getTestDevices.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class UsbDeviceManagerTest {
  static get $interfaceName(): string {
    return "device.mojom.UsbDeviceManagerTest";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): UsbDeviceManagerTestRemote {
    let remote = new UsbDeviceManagerTestRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the UsbDeviceManagerTest
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class UsbDeviceManagerTestCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    UsbDeviceManagerTestRemote, UsbDeviceManagerTestPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    UsbDeviceManagerTestRemote, UsbDeviceManagerTestPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  addDeviceForTesting: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  removeDeviceForTesting: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getTestDevices: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      UsbDeviceManagerTestRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.addDeviceForTesting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        UsbDeviceManagerTest_AddDeviceForTesting_ParamsSpec.$,
        UsbDeviceManagerTest_AddDeviceForTesting_ResponseParamsSpec.$,
        this.addDeviceForTesting.createReceiverHandler(true /* expectsResponse */),
        false);
    this.removeDeviceForTesting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        UsbDeviceManagerTest_RemoveDeviceForTesting_ParamsSpec.$,
        UsbDeviceManagerTest_RemoveDeviceForTesting_ResponseParamsSpec.$,
        this.removeDeviceForTesting.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getTestDevices =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        UsbDeviceManagerTest_GetTestDevices_ParamsSpec.$,
        UsbDeviceManagerTest_GetTestDevices_ResponseParamsSpec.$,
        this.getTestDevices.createReceiverHandler(true /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const TestDeviceInfoSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UsbDeviceManagerTest_AddDeviceForTesting_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UsbDeviceManagerTest_AddDeviceForTesting_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UsbDeviceManagerTest_RemoveDeviceForTesting_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UsbDeviceManagerTest_RemoveDeviceForTesting_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UsbDeviceManagerTest_GetTestDevices_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UsbDeviceManagerTest_GetTestDevices_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface TestDeviceInfoMojoType {
  guid: string;
  name: string;
  serialNumber: string;
  landingPage: url_mojom_Url;
}


export type TestDeviceInfo = TestDeviceInfoMojoType;
mojo.internal.Struct<TestDeviceInfoMojoType>(
    TestDeviceInfoSpec.$,
    'TestDeviceInfo',
    [
      mojo.internal.StructField<TestDeviceInfoMojoType, string>(
        'guid', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TestDeviceInfoMojoType, string>(
        'name', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TestDeviceInfoMojoType, string>(
        'serialNumber', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<TestDeviceInfoMojoType, url_mojom_Url>(
        'landingPage', 24,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 40],]);





export interface UsbDeviceManagerTest_AddDeviceForTesting_ParamsMojoType {
  name: string;
  serialNumber: string;
  landingPage: string;
}


export type UsbDeviceManagerTest_AddDeviceForTesting_Params = UsbDeviceManagerTest_AddDeviceForTesting_ParamsMojoType;
mojo.internal.Struct<UsbDeviceManagerTest_AddDeviceForTesting_ParamsMojoType>(
    UsbDeviceManagerTest_AddDeviceForTesting_ParamsSpec.$,
    'UsbDeviceManagerTest_AddDeviceForTesting_Params',
    [
      mojo.internal.StructField<UsbDeviceManagerTest_AddDeviceForTesting_ParamsMojoType, string>(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbDeviceManagerTest_AddDeviceForTesting_ParamsMojoType, string>(
        'serialNumber', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbDeviceManagerTest_AddDeviceForTesting_ParamsMojoType, string>(
        'landingPage', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface UsbDeviceManagerTest_AddDeviceForTesting_ResponseParamsMojoType {
  success: boolean;
  message: string;
}


export type UsbDeviceManagerTest_AddDeviceForTesting_ResponseParams = UsbDeviceManagerTest_AddDeviceForTesting_ResponseParamsMojoType;
mojo.internal.Struct<UsbDeviceManagerTest_AddDeviceForTesting_ResponseParamsMojoType>(
    UsbDeviceManagerTest_AddDeviceForTesting_ResponseParamsSpec.$,
    'UsbDeviceManagerTest_AddDeviceForTesting_ResponseParams',
    [
      mojo.internal.StructField<UsbDeviceManagerTest_AddDeviceForTesting_ResponseParamsMojoType, boolean>(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UsbDeviceManagerTest_AddDeviceForTesting_ResponseParamsMojoType, string>(
        'message', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface UsbDeviceManagerTest_RemoveDeviceForTesting_ParamsMojoType {
  guid: string;
}


export type UsbDeviceManagerTest_RemoveDeviceForTesting_Params = UsbDeviceManagerTest_RemoveDeviceForTesting_ParamsMojoType;
mojo.internal.Struct<UsbDeviceManagerTest_RemoveDeviceForTesting_ParamsMojoType>(
    UsbDeviceManagerTest_RemoveDeviceForTesting_ParamsSpec.$,
    'UsbDeviceManagerTest_RemoveDeviceForTesting_Params',
    [
      mojo.internal.StructField<UsbDeviceManagerTest_RemoveDeviceForTesting_ParamsMojoType, string>(
        'guid', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface UsbDeviceManagerTest_RemoveDeviceForTesting_ResponseParamsMojoType {
}


export type UsbDeviceManagerTest_RemoveDeviceForTesting_ResponseParams = UsbDeviceManagerTest_RemoveDeviceForTesting_ResponseParamsMojoType;
mojo.internal.Struct<UsbDeviceManagerTest_RemoveDeviceForTesting_ResponseParamsMojoType>(
    UsbDeviceManagerTest_RemoveDeviceForTesting_ResponseParamsSpec.$,
    'UsbDeviceManagerTest_RemoveDeviceForTesting_ResponseParams',
    [
    ],
    [[0, 8],]);





export interface UsbDeviceManagerTest_GetTestDevices_ParamsMojoType {
}


export type UsbDeviceManagerTest_GetTestDevices_Params = UsbDeviceManagerTest_GetTestDevices_ParamsMojoType;
mojo.internal.Struct<UsbDeviceManagerTest_GetTestDevices_ParamsMojoType>(
    UsbDeviceManagerTest_GetTestDevices_ParamsSpec.$,
    'UsbDeviceManagerTest_GetTestDevices_Params',
    [
    ],
    [[0, 8],]);





export interface UsbDeviceManagerTest_GetTestDevices_ResponseParamsMojoType {
  devices: TestDeviceInfo[];
}


export type UsbDeviceManagerTest_GetTestDevices_ResponseParams = UsbDeviceManagerTest_GetTestDevices_ResponseParamsMojoType;
mojo.internal.Struct<UsbDeviceManagerTest_GetTestDevices_ResponseParamsMojoType>(
    UsbDeviceManagerTest_GetTestDevices_ResponseParamsSpec.$,
    'UsbDeviceManagerTest_GetTestDevices_ResponseParams',
    [
      mojo.internal.StructField<UsbDeviceManagerTest_GetTestDevices_ResponseParamsMojoType, TestDeviceInfo[]>(
        'devices', 0,
        0,
        mojo.internal.Array(TestDeviceInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);



