// services/device/public/mojom/usb_manager_test.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_USB_MANAGER_TEST_MOJOM_SHARED_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_USB_MANAGER_TEST_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/device/public/mojom/usb_manager_test.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "services/device/public/mojom/usb_manager_test.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::device::mojom::TestDeviceInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::TestDeviceInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::TestDeviceInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::guid(input)) in_guid = Traits::guid(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->guid)::BaseType> guid_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_guid,
      guid_fragment);

    fragment->guid.Set(
        guid_fragment.is_null() ? nullptr : guid_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->guid.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null guid in TestDeviceInfo struct");

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in TestDeviceInfo struct");

    decltype(Traits::serial_number(input)) in_serial_number = Traits::serial_number(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->serial_number)::BaseType> serial_number_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_serial_number,
      serial_number_fragment);

    fragment->serial_number.Set(
        serial_number_fragment.is_null() ? nullptr : serial_number_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->serial_number.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null serial_number in TestDeviceInfo struct");

    decltype(Traits::landing_page(input)) in_landing_page = Traits::landing_page(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->landing_page)::BaseType> landing_page_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_landing_page,
      landing_page_fragment);

    fragment->landing_page.Set(
        landing_page_fragment.is_null() ? nullptr : landing_page_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->landing_page.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null landing_page in TestDeviceInfo struct");
  }

  static bool Deserialize(::device::mojom::internal::TestDeviceInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::device::mojom::TestDeviceInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace device::mojom {

inline void TestDeviceInfoDataView::GetGuidDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->guid.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void TestDeviceInfoDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void TestDeviceInfoDataView::GetSerialNumberDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->serial_number.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void TestDeviceInfoDataView::GetLandingPageDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->landing_page.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}



}  // device::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_DEVICE_PUBLIC_MOJOM_USB_MANAGER_TEST_MOJOM_SHARED_H_