// services/device/public/mojom/usb_enumeration_options.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_USB_ENUMERATION_OPTIONS_MOJOM_DATA_VIEW_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_USB_ENUMERATION_OPTIONS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "services/device/public/mojom/usb_enumeration_options.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"


namespace device::mojom {
class UsbDeviceFilterDataView;

class UsbEnumerationOptionsDataView;



}  // device::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::device::mojom::UsbDeviceFilterDataView> {
  using Data = ::device::mojom::internal::UsbDeviceFilter_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::UsbEnumerationOptionsDataView> {
  using Data = ::device::mojom::internal::UsbEnumerationOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace device::mojom {


class UsbDeviceFilterDataView {
 public:
  UsbDeviceFilterDataView() = default;

  UsbDeviceFilterDataView(
      internal::UsbDeviceFilter_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool has_vendor_id() const {
    return data_->has_vendor_id;
  }
  uint16_t vendor_id() const {
    return data_->vendor_id;
  }
  bool has_product_id() const {
    return data_->has_product_id;
  }
  uint16_t product_id() const {
    return data_->product_id;
  }
  bool has_class_code() const {
    return data_->has_class_code;
  }
  uint8_t class_code() const {
    return data_->class_code;
  }
  bool has_subclass_code() const {
    return data_->has_subclass_code;
  }
  uint8_t subclass_code() const {
    return data_->subclass_code;
  }
  bool has_protocol_code() const {
    return data_->has_protocol_code;
  }
  uint8_t protocol_code() const {
    return data_->protocol_code;
  }
  inline void GetSerialNumberDataView(
      ::mojo_base::mojom::String16DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSerialNumber(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::String16DataView, UserType>(),
    "Attempting to read the optional `serial_number` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSerialNumber` instead "
    "of `ReadSerialNumber if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->serial_number.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::String16DataView>(
        pointer, output, message_);
  }
 private:
  internal::UsbDeviceFilter_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class UsbEnumerationOptionsDataView {
 public:
  UsbEnumerationOptionsDataView() = default;

  UsbEnumerationOptionsDataView(
      internal::UsbEnumerationOptions_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFiltersDataView(
      mojo::ArrayDataView<UsbDeviceFilterDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFilters(UserType* output) {
    
    auto* pointer = data_->filters.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::UsbDeviceFilterDataView>>(
        pointer, output, message_);
  }
 private:
  internal::UsbEnumerationOptions_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // device::mojom

#endif  // SERVICES_DEVICE_PUBLIC_MOJOM_USB_ENUMERATION_OPTIONS_MOJOM_DATA_VIEW_H_